/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4Iterator;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.types.Unversioned;

public class Collection4
implements Iterable4,
DeepClone,
Unversioned {
    public List4 _first;
    public List4 _last;
    public int _size;
    public int _version;
    private static final Object NOT_FOUND = new Object();

    public Collection4() {
    }

    public Collection4(Iterable4 iterable4) {
        this.addAll(iterable4);
    }

    public Collection4(Iterator4 iterator4) {
        this.addAll(iterator4);
    }

    public Object singleElement() {
        if (this.size() != 1) {
            throw new IllegalStateException();
        }
        return this._first._element;
    }

    public final void add(Object object) {
        this.doAdd(object);
        this.changed();
    }

    public final void prepend(Object object) {
        this.doPrepend(object);
        this.changed();
    }

    private void doPrepend(Object object) {
        if (this._first == null) {
            this.doAdd(object);
        } else {
            this._first = new List4(this._first, object);
            ++this._size;
        }
    }

    private void doAdd(Object object) {
        this._last = this._last == null ? (this._first = new List4(object)) : (this._last._next = new List4(object));
        ++this._size;
    }

    public final void addAll(Object[] objectArray) {
        this.assertNotNull(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    public final void addAll(Iterable4 iterable4) {
        this.assertNotNull(iterable4);
        this.addAll(iterable4.iterator());
    }

    public final void addAll(Iterator4 iterator4) {
        this.assertNotNull(iterator4);
        while (iterator4.moveNext()) {
            this.add(iterator4.current());
        }
    }

    public final void clear() {
        this._first = null;
        this._last = null;
        this._size = 0;
        this.changed();
    }

    public final boolean contains(Object object) {
        return this.getInternal(object) != NOT_FOUND;
    }

    public boolean containsAll(Iterator4 iterator4) {
        this.assertNotNull(iterator4);
        while (iterator4.moveNext()) {
            if (this.contains(iterator4.current())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsByIdentity(Object object) {
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            Object object2 = iterator4.current();
            if (object2 != object) continue;
            return true;
        }
        return false;
    }

    public final Object get(Object object) {
        Object object2 = this.getInternal(object);
        if (object2 == NOT_FOUND) {
            return null;
        }
        return object2;
    }

    private final Object getInternal(Object object) {
        if (object == null) {
            return this.containsNull() ? null : NOT_FOUND;
        }
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            Object object2 = iterator4.current();
            if (!object.equals(object2)) continue;
            return object2;
        }
        return NOT_FOUND;
    }

    private final boolean containsNull() {
        return this.containsByIdentity(null);
    }

    public Object deepClone(Object object) {
        Collection4 collection4 = new Collection4();
        Object object2 = null;
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            object2 = iterator4.current();
            if (object2 instanceof DeepClone) {
                collection4.add(((DeepClone)object2).deepClone(object));
                continue;
            }
            collection4.add(object2);
        }
        return collection4;
    }

    public final Object ensure(Object object) {
        Object object2 = this.getInternal(object);
        if (object2 == NOT_FOUND) {
            this.add(object);
            return object;
        }
        return object2;
    }

    public final Iterator4 iterator() {
        return this._first == null ? Iterator4Impl.EMPTY : new Collection4Iterator(this, this._first);
    }

    public Object remove(Object object) {
        List4 list4 = null;
        List4 list42 = this._first;
        while (list42 != null) {
            if (list42.holds(object)) {
                --this._size;
                this.adjustOnRemoval(list4, list42);
                this.changed();
                return list42._element;
            }
            list4 = list42;
            list42 = list42._next;
        }
        return null;
    }

    private void adjustOnRemoval(List4 list4, List4 list42) {
        if (list42 == this._first) {
            this._first = list42._next;
        } else {
            list4._next = list42._next;
        }
        if (list42 == this._last) {
            this._last = list4;
        }
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final Object[] toArray(Object[] objectArray) {
        int n = 0;
        Iterator4 iterator4 = this.internalIterator();
        while (iterator4.moveNext()) {
            objectArray[n++] = iterator4.current();
        }
        return objectArray;
    }

    public final Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        this.toArray(objectArray);
        return objectArray;
    }

    public String toString() {
        if (this._size == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator4 iterator4 = this.internalIterator();
        iterator4.moveNext();
        stringBuffer.append(iterator4.current());
        while (iterator4.moveNext()) {
            stringBuffer.append(", ");
            stringBuffer.append(iterator4.current());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void changed() {
        ++this._version;
    }

    int version() {
        return this._version;
    }

    private void assertNotNull(Object object) {
        if (object == null) {
            throw new ArgumentNullException();
        }
    }

    private Iterator4 internalIterator() {
        return new Iterator4Impl(this._first);
    }
}

