/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.osgi.service.condpermadmin.Condition;

public class FrameworkSecurityManager
extends SecurityManager {
    ThreadLocal localCheckContext = new ThreadLocal();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager$CheckPermissionAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class c = clazz;
        Class clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager$CheckContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        c = clazz2;
        c.getName();
    }

    boolean addConditionsForDomain(Condition[][] condSet) {
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc == null) {
            return false;
        }
        Vector<Condition[][]> condSets = (Vector<Condition[][]>)cc.depthCondSets.get(cc.getDepth());
        if (condSets == null) {
            condSets = new Vector<Condition[][]>(2);
            cc.depthCondSets.set(cc.getDepth(), condSets);
        }
        condSets.add(condSet);
        return true;
    }

    public void checkPermission(Permission perm, Object context) {
        AccessController.doPrivileged(new CheckPermissionAction(this, perm, context));
    }

    public AccessControlContext getContextToBeChecked() {
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc != null && cc.accs != null && !cc.accs.isEmpty()) {
            return (AccessControlContext)cc.accs.get(cc.accs.size() - 1);
        }
        return null;
    }

    public void internalCheckPermission(Permission perm, Object context) {
        AccessControlContext acc = (AccessControlContext)context;
        CheckContext cc = (CheckContext)this.localCheckContext.get();
        if (cc == null) {
            cc = new CheckContext();
            this.localCheckContext.set(cc);
        }
        cc.depthCondSets.add(null);
        cc.accs.add(acc);
        try {
            acc.checkPermission(perm);
            Vector remainingSets = (Vector)cc.depthCondSets.get(cc.getDepth());
            if (remainingSets != null) {
                Hashtable condContextDict = new Hashtable(2);
                Condition[][] conds = (Condition[][])remainingSets.remove(0);
                int i = 0;
                while (i < conds.length) {
                    if (this.recursiveCheck(remainingSets, conds[i], null, condContextDict, cc)) {
                        return;
                    }
                    ++i;
                }
                throw new SecurityException("Conditions not satisfied");
            }
        }
        finally {
            cc.depthCondSets.remove(cc.getDepth());
            cc.accs.remove(cc.accs.size() - 1);
        }
    }

    private boolean recursiveCheck(Vector remainingSets, Condition[] conditions, Hashtable condDict, Hashtable condContextDict, CheckContext cc) {
        if (condDict == null) {
            condDict = new Hashtable(2);
        } else {
            Hashtable copyCondDict = new Hashtable(2);
            Enumeration keys = condDict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                copyCondDict.put(key, ((Vector)condDict.get(key)).clone());
            }
            condDict = copyCondDict;
        }
        int i = 0;
        while (i < conditions.length) {
            if (conditions[i] != null) {
                Vector<Condition> condList = (Vector<Condition>)condDict.get(conditions[i].getClass());
                if (condList == null) {
                    condList = new Vector<Condition>();
                    condDict.put(conditions[i].getClass(), condList);
                }
                condList.add(conditions[i]);
            }
            ++i;
        }
        if (remainingSets.size() > 0) {
            Condition[][] conds = (Condition[][])remainingSets.get(0);
            Vector newSets = (Vector)remainingSets.clone();
            newSets.remove(0);
            int i2 = 0;
            while (i2 < conds.length) {
                if (this.recursiveCheck(newSets, conds[i2], condDict, condContextDict, cc)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        Enumeration keys = condDict.keys();
        while (keys.hasMoreElements()) {
            Class key = (Class)keys.nextElement();
            Vector conds = (Vector)condDict.get(key);
            if (conds.size() == 0) continue;
            Condition[] condArray = conds.toArray(new Condition[conds.size()]);
            Hashtable context = (Hashtable)condContextDict.get(key);
            if (context == null) {
                context = new Hashtable(2);
                condContextDict.put(key, context);
            }
            if (cc.CondClassSet == null) {
                cc.CondClassSet = new ArrayList(2);
            }
            if (cc.CondClassSet.contains(condArray[0].getClass())) {
                return false;
            }
            cc.CondClassSet.add(condArray[0].getClass());
            try {
                if (condArray[0].isSatisfied(condArray, context)) continue;
                return false;
            }
            finally {
                ((AbstractCollection)cc.CondClassSet).remove(condArray[0].getClass());
            }
        }
        return true;
    }

    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    static class CheckContext {
        ArrayList depthCondSets = new ArrayList(2);
        ArrayList accs = new ArrayList(2);
        ArrayList CondClassSet;

        CheckContext() {
        }

        public int getDepth() {
            return this.depthCondSets.size() - 1;
        }
    }

    static class CheckPermissionAction
    implements PrivilegedAction {
        Permission perm;
        Object context;
        FrameworkSecurityManager fsm;

        CheckPermissionAction(FrameworkSecurityManager fsm, Permission perm, Object context) {
            this.fsm = fsm;
            this.perm = perm;
            this.context = context;
        }

        public Object run() {
            this.fsm.internalCheckPermission(this.perm, this.context);
            return null;
        }
    }
}

