/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import com.db4o.ObjectContainer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.NewsCounter;
import org.rssowl.core.persist.NewsCounterItem;
import org.rssowl.core.persist.dao.INewsCounterDAO;
import org.rssowl.core.persist.event.FeedEvent;
import org.rssowl.core.persist.event.NewsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewsCounterService {
    private final ObjectContainer fDb;
    private final NewsCounter fNewsCounter;

    public NewsCounterService(INewsCounterDAO newsCounterDAO, ObjectContainer db) {
        this.fDb = db;
        this.fNewsCounter = newsCounterDAO.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewsAdded(Collection<NewsEvent> newsEvents) {
        if (newsEvents.isEmpty()) {
            return;
        }
        boolean newsCounterUpdated = false;
        HashMap<String, NewsCounterItem> updatedCounterItems = new HashMap<String, NewsCounterItem>();
        NewsCounter newsCounter = this.fNewsCounter;
        synchronized (newsCounter) {
            for (NewsEvent newsEvent : newsEvents) {
                INews news = newsEvent.getEntity();
                if (news.getParentId() != 0L || news.getState() == INews.State.DELETED) continue;
                NewsCounterItem newsCounterItem = this.fNewsCounter.get(news.getFeedLinkAsText());
                if (newsCounterItem == null) {
                    newsCounterItem = new NewsCounterItem();
                    this.fNewsCounter.put(news.getFeedLinkAsText(), newsCounterItem);
                    newsCounterUpdated = true;
                }
                if (news.getState() == INews.State.NEW) {
                    newsCounterItem.incrementNewCounter();
                }
                if (NewsCounterService.isUnread(news.getState())) {
                    newsCounterItem.incrementUnreadCounter();
                }
                if (news.isFlagged()) {
                    newsCounterItem.incrementStickyCounter();
                }
                if (newsCounterUpdated) continue;
                updatedCounterItems.put(news.getFeedLinkAsText(), newsCounterItem);
            }
            if (newsCounterUpdated) {
                this.fDb.ext().set((Object)this.fNewsCounter, Integer.MAX_VALUE);
            } else {
                for (NewsCounterItem item : updatedCounterItems.values()) {
                    this.fDb.set((Object)item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewsUpdated(Collection<NewsEvent> newsEvents) {
        HashMap<String, NewsCounterItem> updatedCounterItems = new HashMap<String, NewsCounterItem>();
        NewsCounter newsCounter = this.fNewsCounter;
        synchronized (newsCounter) {
            for (NewsEvent event : newsEvents) {
                boolean newStateSticky;
                INews currentNews = event.getEntity();
                if (currentNews.getParentId() != 0L) continue;
                INews oldNews = event.getOldNews();
                Assert.isNotNull((Object)oldNews, (String)"oldNews cannot be null on newsUpdated");
                boolean oldStateUnread = NewsCounterService.isUnread(oldNews.getState());
                boolean currentStateUnread = NewsCounterService.isUnread(currentNews.getState());
                boolean oldStateNew = INews.State.NEW.equals((Object)oldNews.getState());
                boolean currentStateNew = INews.State.NEW.equals((Object)currentNews.getState());
                boolean oldStateSticky = oldNews.isFlagged() && oldNews.isVisible();
                boolean bl = newStateSticky = currentNews.isFlagged() && currentNews.isVisible();
                if (oldStateUnread == currentStateUnread && oldStateNew == currentStateNew && oldStateSticky == newStateSticky) continue;
                NewsCounterItem counterItem = this.fNewsCounter.get(currentNews.getFeedLinkAsText());
                if (oldStateUnread && !currentStateUnread) {
                    counterItem.decrementUnreadCounter();
                } else if (!oldStateUnread && currentStateUnread) {
                    counterItem.incrementUnreadCounter();
                }
                if (oldStateNew && !currentStateNew) {
                    counterItem.decrementNewCounter();
                } else if (!oldStateNew && currentStateNew) {
                    counterItem.incrementNewCounter();
                }
                if (oldStateSticky && !newStateSticky) {
                    counterItem.decrementStickyCounter();
                } else if (!oldStateSticky && newStateSticky) {
                    counterItem.incrementStickyCounter();
                }
                updatedCounterItems.put(currentNews.getFeedLinkAsText(), counterItem);
            }
            for (NewsCounterItem counterItem : updatedCounterItems.values()) {
                this.fDb.set((Object)counterItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewsRemoved(Collection<NewsEvent> newsEvents) {
        HashMap<String, NewsCounterItem> updatedCounterItems = new HashMap<String, NewsCounterItem>();
        NewsCounter newsCounter = this.fNewsCounter;
        synchronized (newsCounter) {
            for (NewsEvent newsEvent : newsEvents) {
                INews news = newsEvent.getEntity();
                if (news.getParentId() != 0L) continue;
                NewsCounterItem counterItem = this.fNewsCounter.get(news.getFeedLinkAsText());
                if (news.getState() == INews.State.NEW) {
                    counterItem.decrementNewCounter();
                }
                if (NewsCounterService.isUnread(news.getState())) {
                    counterItem.decrementUnreadCounter();
                }
                if (news.isFlagged() && !EnumSet.of(INews.State.DELETED, INews.State.HIDDEN).contains((Object)news.getState())) {
                    counterItem.decrementStickyCounter();
                }
                updatedCounterItems.put(news.getFeedLinkAsText(), counterItem);
            }
            for (NewsCounterItem counterItem : updatedCounterItems.values()) {
                this.fDb.set((Object)counterItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFeedRemoved(Collection<FeedEvent> feedEvents) {
        if (feedEvents.isEmpty()) {
            return;
        }
        NewsCounter newsCounter = this.fNewsCounter;
        synchronized (newsCounter) {
            for (FeedEvent feedEvent : feedEvents) {
                IFeed feed = feedEvent.getEntity();
                this.fNewsCounter.remove(feed.getLink().toString());
            }
            this.fDb.ext().set((Object)this.fNewsCounter, Integer.MAX_VALUE);
        }
    }

    private static boolean isUnread(INews.State state) {
        return state == INews.State.NEW || state == INews.State.UPDATED || state == INews.State.UNREAD;
    }
}

