/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.pref;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.dao.IPreferenceDAO;
import org.rssowl.core.persist.event.PreferenceEvent;
import org.rssowl.core.persist.event.PreferenceListener;
import org.rssowl.core.persist.pref.IPreferenceScope;

public class GlobalScope
implements IPreferenceScope {
    private final Map<String, IPreference> fCache;
    private final IPreferenceScope fParent;
    private final IPreferenceDAO fPreferenceDAO;

    public GlobalScope(IPreferenceScope parent) {
        this.fParent = parent;
        this.fCache = new HashMap<String, IPreference>();
        this.fPreferenceDAO = InternalOwl.getDefault().getPersistenceService().getDAOService().getPreferencesDAO();
        this.registerListeners();
    }

    private void registerListeners() {
        this.fPreferenceDAO.addEntityListener(new PreferenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void entitiesAdded(Set<PreferenceEvent> events) {
                Map map = GlobalScope.this.fCache;
                synchronized (map) {
                    for (PreferenceEvent event : events) {
                        GlobalScope.this.fCache.put(event.getEntity().getKey(), event.getEntity());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void entitiesDeleted(Set<PreferenceEvent> events) {
                Map map = GlobalScope.this.fCache;
                synchronized (map) {
                    for (PreferenceEvent event : events) {
                        GlobalScope.this.fCache.remove(event.getEntity().getKey());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void entitiesUpdated(Set<PreferenceEvent> events) {
                Map map = GlobalScope.this.fCache;
                synchronized (map) {
                    for (PreferenceEvent event : events) {
                        GlobalScope.this.fCache.put(event.getEntity().getKey(), event.getEntity());
                    }
                }
            }
        });
    }

    public IPreferenceScope getParent() {
        return this.fParent;
    }

    public void flush() {
    }

    public void delete(String key) {
        this.fPreferenceDAO.delete(key);
    }

    public boolean hasKey(String key) {
        return this.fPreferenceDAO.load(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getBoolean() != null) {
                return cachedPref.getBoolean();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getBoolean() != null) {
                this.fCache.put(key, pref);
                return pref.getBoolean();
            }
            boolean parentValue = this.fParent.getBoolean(key);
            pref = Owl.getModelFactory().createPreference(key);
            pref.putBooleans(parentValue);
            this.fCache.put(key, pref);
            return parentValue;
        }
    }

    private IPreference load(String key) {
        return this.fPreferenceDAO.load(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInteger(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getInteger() != null) {
                return cachedPref.getInteger();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getInteger() != null) {
                this.fCache.put(key, pref);
                return pref.getInteger();
            }
            int parentValue = this.fParent.getInteger(key);
            pref = Owl.getModelFactory().createPreference(key);
            pref.putIntegers(parentValue);
            this.fCache.put(key, pref);
            return parentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getIntegers(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getIntegers() != null) {
                return cachedPref.getIntegers();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getIntegers() != null) {
                this.fCache.put(key, pref);
                return pref.getIntegers();
            }
            int[] parentValue = this.fParent.getIntegers(key);
            if (parentValue != null) {
                pref = Owl.getModelFactory().createPreference(key);
                pref.putIntegers(parentValue);
                this.fCache.put(key, pref);
            }
            return parentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getLong() != null) {
                return cachedPref.getLong();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getLong() != null) {
                this.fCache.put(key, pref);
                return pref.getLong();
            }
            long parentValue = this.fParent.getLong(key);
            pref = Owl.getModelFactory().createPreference(key);
            pref.putLongs(parentValue);
            this.fCache.put(key, pref);
            return parentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLongs(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getLongs() != null) {
                return cachedPref.getLongs();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getLongs() != null) {
                this.fCache.put(key, pref);
                return pref.getLongs();
            }
            long[] parentValue = this.fParent.getLongs(key);
            if (parentValue != null) {
                pref = Owl.getModelFactory().createPreference(key);
                pref.putLongs(parentValue);
                this.fCache.put(key, pref);
            }
            return parentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getString() != null) {
                return cachedPref.getString();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getString() != null) {
                this.fCache.put(key, pref);
                return pref.getString();
            }
            String parentValue = this.fParent.getString(key);
            if (parentValue != null) {
                pref = Owl.getModelFactory().createPreference(key);
                pref.putStrings(parentValue);
                this.fCache.put(key, pref);
            }
            return parentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStrings(String key) {
        Map<String, IPreference> map = this.fCache;
        synchronized (map) {
            IPreference cachedPref = this.fCache.get(key);
            if (cachedPref != null && cachedPref.getStrings() != null) {
                return cachedPref.getStrings();
            }
            IPreference pref = this.load(key);
            if (pref != null && pref.getStrings() != null) {
                this.fCache.put(key, pref);
                return pref.getStrings();
            }
            String[] parentValue = this.fParent.getStrings(key);
            if (parentValue != null) {
                pref = Owl.getModelFactory().createPreference(key);
                pref.putStrings(parentValue);
                this.fCache.put(key, pref);
            }
            return parentValue;
        }
    }

    public void putBoolean(String key, boolean value) {
        if (this.cached(key, value)) {
            return;
        }
        if (value == this.fParent.getBoolean(key)) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putBooleans(value);
        this.fPreferenceDAO.save(pref);
    }

    public void putInteger(String key, int value) {
        if (this.cached(key, value)) {
            return;
        }
        if (value == this.fParent.getInteger(key)) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putIntegers(value);
        this.fPreferenceDAO.save(pref);
    }

    public void putIntegers(String key, int[] values) {
        Assert.isNotNull((Object)values);
        if (this.cached(key, values)) {
            return;
        }
        if (Arrays.equals(values, this.fParent.getIntegers(key))) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putIntegers(values);
        this.fPreferenceDAO.save(pref);
    }

    public void putLong(String key, long value) {
        if (this.cached(key, value)) {
            return;
        }
        if (value == this.fParent.getLong(key)) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putLongs(value);
        this.fPreferenceDAO.save(pref);
    }

    public void putLongs(String key, long[] values) {
        Assert.isNotNull((Object)values);
        if (this.cached(key, values)) {
            return;
        }
        if (Arrays.equals(values, this.fParent.getLongs(key))) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putLongs(values);
        this.fPreferenceDAO.save(pref);
    }

    public void putString(String key, String value) {
        Assert.isNotNull((Object)value);
        if (this.cached(key, value)) {
            return;
        }
        if (value.equals(this.fParent.getString(key))) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putStrings(value);
        this.fPreferenceDAO.save(pref);
    }

    public void putStrings(String key, String[] values) {
        Assert.isNotNull((Object)values);
        if (this.cached(key, values)) {
            return;
        }
        if (Arrays.equals(values, this.fParent.getStrings(key))) {
            this.delete(key);
            return;
        }
        IPreference pref = this.fPreferenceDAO.loadOrCreate(key);
        pref.putStrings(values);
        this.fPreferenceDAO.save(pref);
    }

    public void clearCache() {
        this.fCache.clear();
    }

    private boolean cached(String key, Object value) {
        return false;
    }
}

