/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.interpreter.Messages;
import org.rssowl.core.internal.interpreter.OPMLConstants;
import org.rssowl.core.interpreter.ITypeImporter;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.pref.IPreferenceType;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPMLImporter
implements ITypeImporter {
    @Override
    public List<IEntity> importFrom(Document document) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Element root = document.getRootElement();
        List feedChildren = root.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (!OPMLConstants.Tag.BODY.get().equals(name)) continue;
            return this.processBody(child, dateFormat);
        }
        return null;
    }

    private List<IEntity> processBody(Element body, DateFormat dateFormat) {
        IFolder defaultRootFolder = Owl.getModelFactory().createFolder(null, null, Messages.OPMLImporter_BOOKMARKS);
        defaultRootFolder.setProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder", Boolean.valueOf(true));
        ArrayList<IEntity> importedEntities = new ArrayList<IEntity>();
        List feedChildren = body.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (OPMLConstants.Tag.OUTLINE.get().equals(name)) {
                this.processOutline(child, defaultRootFolder, importedEntities, dateFormat);
                continue;
            }
            if (OPMLConstants.Tag.SAVED_SEARCH.get().equals(name)) {
                this.processSavedSearch(child, defaultRootFolder, dateFormat);
                continue;
            }
            if (OPMLConstants.Tag.BIN.get().equals(name)) {
                this.processNewsBin(child, defaultRootFolder);
                continue;
            }
            if (OPMLConstants.Tag.LABEL.get().equals(name)) {
                this.processLabel(child, importedEntities);
                continue;
            }
            if (OPMLConstants.Tag.FILTER.get().equals(name)) {
                this.processFilter(child, importedEntities, dateFormat);
                continue;
            }
            if (!OPMLConstants.Tag.PREFERENCE.get().equals(name)) continue;
            this.processPreference(child, importedEntities);
        }
        if (!defaultRootFolder.getChildren().isEmpty()) {
            importedEntities.add(defaultRootFolder);
        }
        return importedEntities;
    }

    private void processFilter(Element filterElement, List<IEntity> importedEntities, DateFormat dateFormat) {
        IModelFactory factory = Owl.getModelFactory();
        String name = filterElement.getAttributeValue(OPMLConstants.Attributes.NAME.get());
        int order = Integer.parseInt(filterElement.getAttributeValue(OPMLConstants.Attributes.ORDER.get()));
        boolean isEnabled = Boolean.parseBoolean(filterElement.getAttributeValue(OPMLConstants.Attributes.ENABLED.get()));
        boolean matchAllNews = Boolean.parseBoolean(filterElement.getAttributeValue(OPMLConstants.Attributes.MATCH_ALL_NEWS.get()));
        ISearch search = null;
        Element searchElement = filterElement.getChild(OPMLConstants.Tag.SEARCH.get(), OPMLConstants.RSSOWL_NS);
        if (searchElement != null) {
            search = factory.createSearch(null);
            search.setMatchAllConditions(Boolean.parseBoolean(searchElement.getAttributeValue(OPMLConstants.Attributes.MATCH_ALL_CONDITIONS.get())));
            List conditions = searchElement.getChildren(OPMLConstants.Tag.SEARCH_CONDITION.get(), OPMLConstants.RSSOWL_NS);
            int i = 0;
            while (i < conditions.size()) {
                try {
                    Element condition = (Element)conditions.get(i);
                    ISearchCondition searchCondition = this.processSearchCondition(condition, dateFormat);
                    if (searchCondition != null) {
                        search.addSearchCondition(searchCondition);
                    }
                }
                catch (NumberFormatException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                catch (ParseException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                ++i;
            }
        }
        ISearchFilter filter = factory.createSearchFilter(null, search, name);
        filter.setEnabled(isEnabled);
        filter.setMatchAllNews(matchAllNews);
        filter.setOrder(order);
        List actions = filterElement.getChildren(OPMLConstants.Tag.ACTION.get(), OPMLConstants.RSSOWL_NS);
        int i = 0;
        while (i < actions.size()) {
            Element action = (Element)actions.get(i);
            String id = action.getAttributeValue(OPMLConstants.Attributes.ID.get());
            String data = action.getAttributeValue(OPMLConstants.Attributes.DATA.get());
            IFilterAction filterAction = factory.createFilterAction(id);
            if (data != null) {
                if ("org.rssowl.core.LabelNewsAction".equals(id)) {
                    Long labelId = Long.parseLong(data);
                    filterAction.setData(labelId);
                } else if ("org.rssowl.core.MoveNewsAction".equals(id) || "org.rssowl.core.CopyNewsAction".equals(id)) {
                    String[] binIds = data.split(",");
                    Long[] binIdsLong = new Long[binIds.length];
                    int j = 0;
                    while (j < binIds.length) {
                        binIdsLong[j] = Long.parseLong(binIds[j]);
                        ++j;
                    }
                    filterAction.setData(binIdsLong);
                } else {
                    filterAction.setData(data);
                }
            } else {
                List actionProperties = action.getChildren(OPMLConstants.Tag.ACTION_PROPERTY.get(), OPMLConstants.RSSOWL_NS);
                if (!actionProperties.isEmpty()) {
                    Properties properties = new Properties();
                    for (Object actionProperty : actionProperties) {
                        Element actionPropertyElement = (Element)actionProperty;
                        String key = actionPropertyElement.getAttributeValue(OPMLConstants.Attributes.ID.get());
                        String value = actionPropertyElement.getAttributeValue(OPMLConstants.Attributes.VALUE.get());
                        properties.setProperty(key, value);
                    }
                    filterAction.setData(properties);
                }
            }
            filter.addAction(filterAction);
            ++i;
        }
        importedEntities.add(filter);
    }

    private void processSavedSearch(Element savedSearchElement, IFolder folder, DateFormat dateFormat) {
        String name = savedSearchElement.getAttributeValue(OPMLConstants.Attributes.NAME.get());
        boolean matchAllConditions = Boolean.parseBoolean(savedSearchElement.getAttributeValue(OPMLConstants.Attributes.MATCH_ALL_CONDITIONS.get()));
        ISearchMark searchmark = Owl.getModelFactory().createSearchMark(null, folder, name);
        searchmark.setMatchAllConditions(matchAllConditions);
        List children = savedSearchElement.getChildren();
        for (Element child : children) {
            String childName = child.getName().toLowerCase();
            if (OPMLConstants.Tag.SEARCH_CONDITION.get().equals(childName)) {
                try {
                    ISearchCondition searchCondition = this.processSearchCondition(child, dateFormat);
                    if (searchCondition == null) continue;
                    searchmark.addSearchCondition(searchCondition);
                }
                catch (NumberFormatException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                catch (ParseException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                continue;
            }
            if (!OPMLConstants.Tag.PREFERENCE.get().equals(childName)) continue;
            this.processPreference(searchmark, child);
        }
    }

    private ISearchCondition processSearchCondition(Element conditionElement, DateFormat dateFormat) throws ParseException {
        Element specifierElement = conditionElement.getChild(OPMLConstants.Tag.SPECIFIER.get(), OPMLConstants.RSSOWL_NS);
        if (specifierElement == null) {
            return null;
        }
        SearchSpecifier searchSpecifier = SearchSpecifier.values()[Integer.parseInt(specifierElement.getAttributeValue(OPMLConstants.Attributes.ID.get()))];
        Element valueElement = conditionElement.getChild(OPMLConstants.Tag.SEARCH_VALUE.get(), OPMLConstants.RSSOWL_NS);
        if (valueElement == null) {
            return null;
        }
        Object value = this.getValue(valueElement, OPMLConstants.RSSOWL_NS, dateFormat);
        if (value == null) {
            return null;
        }
        Element fieldElement = conditionElement.getChild(OPMLConstants.Tag.SEARCH_FIELD.get(), OPMLConstants.RSSOWL_NS);
        if (fieldElement == null) {
            return null;
        }
        String entityName = fieldElement.getAttributeValue(OPMLConstants.Attributes.ENTITY.get());
        String fieldName = fieldElement.getAttributeValue(OPMLConstants.Attributes.NAME.get());
        String fieldId = fieldElement.getAttributeValue(OPMLConstants.Attributes.ID.get());
        ISearchField searchField = StringUtils.isSet(fieldName) ? Owl.getModelFactory().createSearchField(this.getFieldID(fieldName), entityName) : Owl.getModelFactory().createSearchField(Integer.parseInt(fieldId), entityName);
        return Owl.getModelFactory().createSearchCondition(searchField, searchSpecifier, value);
    }

    private int getFieldID(String fieldName) {
        if ("allFields".equals(fieldName)) {
            return -1;
        }
        if ("title".equals(fieldName)) {
            return 0;
        }
        if ("link".equals(fieldName)) {
            return 1;
        }
        if ("description".equals(fieldName)) {
            return 2;
        }
        if ("publishDate".equals(fieldName)) {
            return 6;
        }
        if ("modifiedDate".equals(fieldName)) {
            return 7;
        }
        if ("receiveDate".equals(fieldName)) {
            return 8;
        }
        if ("author".equals(fieldName)) {
            return 3;
        }
        if ("comments".equals(fieldName)) {
            return 4;
        }
        if ("guid".equals(fieldName)) {
            return 5;
        }
        if ("source".equals(fieldName)) {
            return 9;
        }
        if ("hasAttachments".equals(fieldName)) {
            return 10;
        }
        if ("attachments".equals(fieldName)) {
            return 11;
        }
        if ("categories".equals(fieldName)) {
            return 12;
        }
        if ("isFlagged".equals(fieldName)) {
            return 13;
        }
        if ("state".equals(fieldName)) {
            return 14;
        }
        if ("label".equals(fieldName)) {
            return 15;
        }
        if ("rating".equals(fieldName)) {
            return 16;
        }
        if ("feed".equals(fieldName)) {
            return 17;
        }
        if ("ageInDays".equals(fieldName)) {
            return 18;
        }
        if ("location".equals(fieldName)) {
            return 19;
        }
        return -1;
    }

    private Object getValue(Element valueElement, Namespace namespace, DateFormat dateFormat) throws ParseException {
        EnumSet value = null;
        int valueType = Integer.parseInt(valueElement.getAttributeValue(OPMLConstants.Attributes.TYPE.get()));
        List locationElements = valueElement.getChildren(OPMLConstants.Tag.LOCATION.get(), namespace);
        List newsStateElements = valueElement.getChildren(OPMLConstants.Tag.STATE.get(), namespace);
        if (locationElements.size() > 0) {
            ArrayList<Long> folderIds = new ArrayList<Long>(locationElements.size());
            ArrayList<Long> bookmarkIds = new ArrayList<Long>(locationElements.size());
            ArrayList<Long> newsbinIds = new ArrayList<Long>(locationElements.size());
            int i = 0;
            while (i < locationElements.size()) {
                Element locationElement = (Element)locationElements.get(i);
                Long id = Long.parseLong(locationElement.getAttributeValue(OPMLConstants.Attributes.VALUE.get()));
                boolean isFolder = Boolean.parseBoolean(locationElement.getAttributeValue(OPMLConstants.Attributes.IS_FOLDER.get()));
                boolean isBin = Boolean.parseBoolean(locationElement.getAttributeValue(OPMLConstants.Attributes.IS_BIN.get()));
                if (isFolder) {
                    folderIds.add(id);
                } else if (isBin) {
                    newsbinIds.add(id);
                } else {
                    bookmarkIds.add(id);
                }
                ++i;
            }
            Long[][] result = new Long[][]{folderIds.toArray(new Long[folderIds.size()]), bookmarkIds.toArray(new Long[bookmarkIds.size()]), newsbinIds.toArray(new Long[bookmarkIds.size()])};
            return result;
        }
        if (newsStateElements.size() > 0) {
            ArrayList<INews.State> states = new ArrayList<INews.State>(newsStateElements.size());
            int i = 0;
            while (i < newsStateElements.size()) {
                Element newsStateElement = (Element)newsStateElements.get(i);
                int ordinal = Integer.parseInt(newsStateElement.getAttributeValue(OPMLConstants.Attributes.VALUE.get()));
                states.add(INews.State.values()[ordinal]);
                ++i;
            }
            value = EnumSet.copyOf(states);
        } else {
            String valueAsString = valueElement.getAttributeValue(OPMLConstants.Attributes.VALUE.get());
            switch (valueType) {
                case 6: {
                    value = Boolean.parseBoolean(valueAsString);
                    break;
                }
                case 0: {
                    value = valueAsString;
                    break;
                }
                case 8: {
                    value = valueAsString;
                    break;
                }
                case 4: {
                    value = Integer.parseInt(valueAsString);
                    break;
                }
                case 5: {
                    value = Integer.parseInt(valueAsString);
                    break;
                }
                case 1: {
                    value = dateFormat.parse(valueAsString);
                    break;
                }
                case 3: {
                    value = dateFormat.parse(valueAsString);
                    break;
                }
                case 2: {
                    value = dateFormat.parse(valueAsString);
                    break;
                }
                case 7: {
                    value = valueAsString;
                }
            }
        }
        return value;
    }

    private void processOutline(Element outline, IPersistable parent, List<IEntity> importedEntities, DateFormat dateFormat) {
        IFolderChild type = null;
        Long id = null;
        String title = null;
        String link = null;
        String homepage = null;
        String description = null;
        List attributes = outline.getAttributes();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if (name.toLowerCase().equals(OPMLConstants.Attributes.XML_URL.get().toLowerCase())) {
                link = attribute.getValue();
                continue;
            }
            if (name.toLowerCase().equals(OPMLConstants.Attributes.TITLE.get())) {
                title = attribute.getValue();
                continue;
            }
            if (title == null && name.toLowerCase().equals(OPMLConstants.Attributes.TEXT.get())) {
                title = attribute.getValue();
                continue;
            }
            if (name.toLowerCase().equals(OPMLConstants.Attributes.HTML_URL.get().toLowerCase())) {
                homepage = attribute.getValue();
                continue;
            }
            if (!name.toLowerCase().equals(OPMLConstants.Attributes.DESCRIPTION.get())) continue;
            description = attribute.getValue();
        }
        Attribute idAttribute = outline.getAttribute(OPMLConstants.Attributes.ID.get(), OPMLConstants.RSSOWL_NS);
        if (idAttribute != null) {
            id = Long.valueOf(idAttribute.getValue());
        }
        boolean isSet = Boolean.parseBoolean(outline.getAttributeValue(OPMLConstants.Attributes.IS_SET.get(), OPMLConstants.RSSOWL_NS));
        if (link == null && title != null) {
            type = Owl.getModelFactory().createFolder(null, isSet ? null : (IFolder)parent, title);
            if (id != null) {
                type.setProperty("org.rssowl.core.interpreter.typeimporter.EntityId", id);
            }
            if (isSet) {
                importedEntities.add(type);
            }
        } else {
            URI uri;
            URI uRI = uri = link != null ? URIUtils.createURI(link) : null;
            if (uri != null) {
                if (uri.getScheme() == null) {
                    uri = URIUtils.createURI("http://" + link);
                }
                FeedLinkReference feedLinkRef = new FeedLinkReference(uri);
                type = Owl.getModelFactory().createBookMark(null, (IFolder)parent, feedLinkRef, title != null ? title : link);
                if (id != null) {
                    type.setProperty("org.rssowl.core.interpreter.typeimporter.EntityId", id);
                }
                if (StringUtils.isSet(description)) {
                    type.setProperty("org.rssowl.core.interpreter.typeimporter.Description", (Serializable)((Object)description));
                }
                if (StringUtils.isSet(homepage)) {
                    type.setProperty("org.rssowl.core.interpreter.typeimporter.Homepage", (Serializable)((Object)homepage));
                }
            }
        }
        if (type == null) {
            return;
        }
        List children = outline.getChildren();
        for (Element child : children) {
            String name = child.getName().toLowerCase();
            if (OPMLConstants.Tag.OUTLINE.get().equals(name)) {
                this.processOutline(child, type, importedEntities, dateFormat);
                continue;
            }
            if (OPMLConstants.Tag.SAVED_SEARCH.get().equals(name)) {
                this.processSavedSearch(child, (IFolder)type, dateFormat);
                continue;
            }
            if (OPMLConstants.Tag.BIN.get().equals(name)) {
                this.processNewsBin(child, (IFolder)type);
                continue;
            }
            if (!OPMLConstants.Tag.PREFERENCE.get().equals(name)) continue;
            this.processPreference(type, child);
        }
    }

    private void processLabel(Element labelElement, List<IEntity> importedEntities) {
        String id = labelElement.getAttributeValue(OPMLConstants.Attributes.ID.get());
        String name = labelElement.getAttributeValue(OPMLConstants.Attributes.NAME.get());
        String order = labelElement.getAttributeValue(OPMLConstants.Attributes.ORDER.get());
        String color = labelElement.getAttributeValue(OPMLConstants.Attributes.COLOR.get());
        ILabel label = Owl.getModelFactory().createLabel(null, name);
        label.setColor(color);
        label.setOrder(Integer.parseInt(order));
        label.setProperty("org.rssowl.core.interpreter.typeimporter.EntityId", Long.valueOf(id));
        importedEntities.add(label);
    }

    private void processNewsBin(Element newsBinElement, IFolder folder) {
        String name = newsBinElement.getAttributeValue(OPMLConstants.Attributes.NAME.get());
        Long id = null;
        Attribute idAttribute = newsBinElement.getAttribute(OPMLConstants.Attributes.ID.get(), OPMLConstants.RSSOWL_NS);
        if (idAttribute != null) {
            id = Long.valueOf(idAttribute.getValue());
        }
        INewsBin newsbin = Owl.getModelFactory().createNewsBin(null, folder, name);
        if (id != null) {
            newsbin.setProperty("org.rssowl.core.interpreter.typeimporter.EntityId", id);
        }
        List children = newsBinElement.getChildren();
        for (Element child : children) {
            String childName = child.getName().toLowerCase();
            if (!OPMLConstants.Tag.PREFERENCE.get().equals(childName)) continue;
            this.processPreference(newsbin, child);
        }
    }

    private void processPreference(IEntity entity, Element element) {
        String key = element.getAttributeValue(OPMLConstants.Attributes.ID.get());
        String value = element.getAttributeValue(OPMLConstants.Attributes.VALUE.get());
        String type = element.getAttributeValue(OPMLConstants.Attributes.TYPE.get());
        if (StringUtils.isSet(key) && value != null && type != null) {
            entity.setProperty(key, this.getPropertyValue(value, IPreferenceType.values()[Integer.parseInt(type)]));
        }
    }

    private Serializable getPropertyValue(String value, IPreferenceType type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case INTEGERS: {
                String[] values = value.split(",");
                int[] intValues = new int[values.length];
                int i = 0;
                while (i < values.length) {
                    intValues[i] = Integer.parseInt(values[i]);
                    ++i;
                }
                return intValues;
            }
            case LONG: {
                return Long.valueOf(value);
            }
            case LONGS: {
                String[] values = value.split(",");
                long[] longValues = new long[values.length];
                int i = 0;
                while (i < values.length) {
                    longValues[i] = Long.parseLong(values[i]);
                    ++i;
                }
                return longValues;
            }
            case STRING: {
                return value;
            }
            case STRINGS: {
                return value.split(",");
            }
        }
        return value;
    }

    private void processPreference(Element element, List<IEntity> importedEntities) {
        String key = element.getAttributeValue(OPMLConstants.Attributes.ID.get());
        String value = element.getAttributeValue(OPMLConstants.Attributes.VALUE.get());
        String typeVal = element.getAttributeValue(OPMLConstants.Attributes.TYPE.get());
        String kindVal = element.getAttributeValue(OPMLConstants.Attributes.KIND.get());
        if (StringUtils.isSet(key) && value != null && typeVal != null && kindVal != null) {
            IPreferenceScope.Kind kind = IPreferenceScope.Kind.values()[Integer.parseInt(kindVal)];
            IPreferenceType type = IPreferenceType.values()[Integer.parseInt(typeVal)];
            IPreference preference = Owl.getModelFactory().createPreference(key);
            preference.setProperty("org.rssowl.core.interpreter.typeimporter.DataId", (Serializable)new Object[]{kind, type});
            switch (type) {
                case BOOLEAN: {
                    preference.putBooleans(Boolean.parseBoolean(value));
                    break;
                }
                case INTEGER: {
                    preference.putIntegers(Integer.parseInt(value));
                    break;
                }
                case INTEGERS: {
                    preference.putIntegers((int[])this.getPropertyValue(value, type));
                    break;
                }
                case LONG: {
                    preference.putLongs(Long.parseLong(value));
                    break;
                }
                case LONGS: {
                    preference.putLongs((long[])this.getPropertyValue(value, type));
                    break;
                }
                case STRING: {
                    preference.putStrings(value);
                    break;
                }
                case STRINGS: {
                    preference.putStrings((String[])this.getPropertyValue(value, type));
                }
            }
            importedEntities.add(preference);
        }
    }
}

