/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.RetentionStrategy;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkTypesReadAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection fSelection;
    private INewsDAO fNewsDao;

    public MarkTypesReadAction() {
        this((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public MarkTypesReadAction(IStructuredSelection selection) {
        this.fSelection = selection;
        this.fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
    }

    public void run(IAction action) {
        JobRunner.runInBackgroundWithBusyIndicator(new Runnable(){

            public void run() {
                MarkTypesReadAction.this.internalRun();
            }
        });
    }

    public void run() {
        JobRunner.runInBackgroundWithBusyIndicator(new Runnable(){

            public void run() {
                MarkTypesReadAction.this.internalRun();
            }
        });
    }

    private void internalRun() {
        boolean affectEquivalentNews;
        List<IEntity> entities;
        FeedView feedView = null;
        if (this.fSelection.size() == 1 && this.fSelection.getFirstElement() instanceof FeedView) {
            feedView = (FeedView)((Object)this.fSelection.getFirstElement());
            FeedViewInput input = (FeedViewInput)feedView.getEditorInput();
            entities = ModelUtils.getEntities((IStructuredSelection)new StructuredSelection((Object)input.getMark()));
        } else {
            entities = ModelUtils.getEntities(this.fSelection);
        }
        HashSet<IFolder> folders = null;
        for (IEntity element : entities) {
            if (!(element instanceof IFolder)) continue;
            if (folders == null) {
                folders = new HashSet<IFolder>();
            }
            folders.add((IFolder)element);
        }
        if (folders != null) {
            for (IFolder folder : folders) {
                CoreUtils.normalize((IFolder)folder, entities);
            }
        }
        HashMap<IBookMark, Collection<INews>> retentionHelperMap = new HashMap<IBookMark, Collection<INews>>();
        Collection<INews> news = feedView != null ? this.getNews(feedView) : this.resolveNews(entities, retentionHelperMap);
        boolean bl = affectEquivalentNews = OwlUI.markReadDuplicates() && !this.equalsRootFolders(folders);
        if (!news.isEmpty()) {
            UndoStack.getInstance().addOperation(new NewsStateOperation(news, INews.State.READ, affectEquivalentNews));
        }
        for (INews newsItem : news) {
            newsItem.setState(INews.State.READ);
        }
        INewsMark activeFeedViewNewsMark = OwlUI.getActiveFeedViewNewsMark();
        Set entries = retentionHelperMap.entrySet();
        for (Map.Entry entry : entries) {
            IBookMark bookmark = (IBookMark)entry.getKey();
            if (activeFeedViewNewsMark != null && (activeFeedViewNewsMark.equals(bookmark) || activeFeedViewNewsMark instanceof FolderNewsMark && ((FolderNewsMark)activeFeedViewNewsMark).contains((INewsMark)bookmark))) continue;
            List deletedNews = RetentionStrategy.process((IBookMark)bookmark, (Collection)((Collection)entry.getValue()));
            news.removeAll(deletedNews);
        }
        if (news.size() > 0 && !Controller.getDefault().isShuttingDown()) {
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            Owl.getPersistenceService().getDAOService().getNewsDAO().setState(news, INews.State.READ, affectEquivalentNews, true);
        }
    }

    private Collection<INews> getNews(FeedView feedView) {
        EnumSet<INews.State> enumSet = EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED);
        Collection<INews> newsCache = feedView.getCachedNewsCopy();
        HashSet<INews> news = new HashSet<INews>();
        for (INews item : newsCache) {
            if (item == null || !enumSet.contains(item.getState()) || feedView.isHidden(item)) continue;
            news.add(item);
        }
        return news;
    }

    private Set<INews> resolveNews(List<IEntity> entities, Map<IBookMark, Collection<INews>> retentionHelperMap) {
        EnumSet<INews.State> enumSet = EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED);
        HashSet<INews> news = new HashSet<INews>();
        for (IEntity element : entities) {
            if (element instanceof IFolder) {
                this.fillNews((IFolder)element, news, retentionHelperMap);
                continue;
            }
            if (element instanceof IBookMark) {
                this.fillNews((IBookMark)element, news, retentionHelperMap);
                continue;
            }
            if (element instanceof FolderNewsMark) {
                this.fillNews(((FolderNewsMark)element).getFolder(), news, retentionHelperMap);
                continue;
            }
            if (element instanceof INewsMark) {
                this.fillNews((INewsMark)element, news);
                continue;
            }
            if (!(element instanceof INews) || !enumSet.contains(((INews)element).getState())) continue;
            news.add((INews)element);
        }
        return news;
    }

    private boolean equalsRootFolders(Collection<IFolder> folders) {
        Collection rootFolders = ((IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class)).loadRoots();
        return folders != null && folders.size() == rootFolders.size() && rootFolders.containsAll(folders);
    }

    private void fillNews(IFolder folder, Collection<INews> news, Map<IBookMark, Collection<INews>> bookMarkNewsMap) {
        boolean requiresRetention = false;
        HashSet bookmarks = new HashSet();
        CoreUtils.fillBookMarks(bookmarks, Collections.singleton(folder));
        for (IBookMark bookmark : bookmarks) {
            if (!Owl.getPreferenceService().getEntityScope((IEntity)bookmark).getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE)) continue;
            requiresRetention = true;
            break;
        }
        if (requiresRetention) {
            this.fillNewsByResolve(folder, news, bookMarkNewsMap);
        } else {
            this.fillNewsBySearch(folder, news);
        }
    }

    private void fillNewsBySearch(IFolder folder, Collection<INews> news) {
        FolderNewsMark folderNewsMark = new FolderNewsMark(folder);
        folderNewsMark.resolve(NewsFilter.Type.SHOW_UNREAD, (IProgressMonitor)new NullProgressMonitor());
        List<NewsReference> newsRefs = folderNewsMark.getNewsRefs();
        for (NewsReference reference : newsRefs) {
            INews item = reference.resolve();
            if (item != null) {
                news.add(item);
                continue;
            }
            CoreUtils.reportIndexIssue();
        }
    }

    private void fillNewsByResolve(IFolder folder, Collection<INews> news, Map<IBookMark, Collection<INews>> bookMarkNewsMap) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IBookMark) {
                this.fillNews((IBookMark)child, news, bookMarkNewsMap);
                continue;
            }
            if (child instanceof INewsMark) {
                this.fillNews((INewsMark)child, news);
                continue;
            }
            if (!(child instanceof IFolder)) continue;
            this.fillNewsByResolve((IFolder)child, news, bookMarkNewsMap);
        }
    }

    private void fillNews(IBookMark bookmark, Collection<INews> news, Map<IBookMark, Collection<INews>> bookMarkNewsMap) {
        IPreferenceScope bookMarkPrefs = Owl.getPreferenceService().getEntityScope((IEntity)bookmark);
        boolean requiresRetention = bookMarkPrefs.getBoolean(DefaultPreferences.DEL_READ_NEWS_STATE);
        EnumSet<INews.State> enumSet = EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED);
        if (requiresRetention) {
            Collection feedsNews = this.fNewsDao.loadAll(bookmark.getFeedLinkReference(), INews.State.getVisible());
            for (INews item : feedsNews) {
                if (!enumSet.contains(item.getState())) continue;
                news.add(item);
            }
            bookMarkNewsMap.put(bookmark, feedsNews);
        } else if (bookmark.getNewsCount(enumSet) > 0) {
            news.addAll(this.fNewsDao.loadAll(bookmark.getFeedLinkReference(), enumSet));
        }
    }

    private void fillNews(INewsMark newsmark, Collection<INews> news) {
        news.addAll(newsmark.getNews(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

