/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.dialogs.ConfirmDialog;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTypesAction
extends Action
implements IObjectActionDelegate {
    private static final int RUN_IN_BACKGROUND_CAP = 200;
    private IStructuredSelection fSelection;
    private INewsDAO fNewsDAO;
    private Shell fShell;
    private boolean fConfirmed;

    public DeleteTypesAction() {
        this(null, (IStructuredSelection)StructuredSelection.EMPTY);
    }

    public DeleteTypesAction(Shell shell, IStructuredSelection selection) {
        this.fShell = shell;
        this.fSelection = selection;
        this.fNewsDAO = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
    }

    public void run(IAction action) {
        if (!this.fSelection.isEmpty() && this.confirmed()) {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DeleteTypesAction.this.internalRun();
                }
            });
        }
    }

    public void run() {
        if (!this.fSelection.isEmpty() && this.confirmed()) {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DeleteTypesAction.this.internalRun();
                }
            });
        }
    }

    private boolean confirmed() {
        List elements = this.fSelection.toList();
        for (Object element : elements) {
            EntityGroup group;
            if (element instanceof INews) {
                return true;
            }
            if (!(element instanceof EntityGroup) || !"org.rssowl.ui.internal.editors.feed.NewsGrouping".equals((group = (EntityGroup)element).getCategory())) continue;
            return true;
        }
        boolean includesArchive = this.includesArchive(this.fSelection);
        ConfirmDialog dialog = new ConfirmDialog(this.fShell, Messages.DeleteTypesAction_CONFIRM_DELETE, Messages.DeleteTypesAction_NO_UNDO, this.getMessage(elements, includesArchive), null);
        return dialog.open() == 0;
    }

    private String getMessage(List<?> elements, boolean includesArchive) {
        int archiveNewsCount;
        INewsBin archive = CoreUtils.findArchive();
        int n = archiveNewsCount = archive != null ? archive.getNewsCount(INews.State.getVisible()) : 0;
        if (archive == null) {
            includesArchive = false;
        }
        if (elements.size() == 1) {
            Object element = elements.get(0);
            if (includesArchive && element instanceof INewsBin) {
                if (archiveNewsCount != 0) {
                    return NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_ARCHIVE_N, (Object)archiveNewsCount);
                }
                return Messages.DeleteTypesAction_CONFIRM_DELETE_ARCHIVE;
            }
            if (element instanceof IFolder) {
                if (includesArchive && archiveNewsCount != 0) {
                    String msg = NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_FOLDER, (Object)((IFolder)element).getName());
                    msg = String.valueOf(msg) + "\n\n";
                    msg = String.valueOf(msg) + NLS.bind((String)Messages.DeleteTypesAction_NOTE_FOLDER_ARCHIVE, (Object)archiveNewsCount);
                    return msg;
                }
                return NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_FOLDER, (Object)((IFolder)element).getName());
            }
            if (element instanceof IBookMark) {
                return NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_BOOKMARK, (Object)((IMark)element).getName());
            }
            if (element instanceof INewsBin) {
                return NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_NEWSBIN, (Object)((IMark)element).getName());
            }
            if (element instanceof ISearchMark) {
                return NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_SEARCH, (Object)((IMark)element).getName());
            }
            if (element instanceof INews) {
                return Messages.DeleteTypesAction_CONFIRM_DELETE_NEWS;
            }
            if (element instanceof EntityGroup) {
                if (includesArchive && archiveNewsCount != 0) {
                    String msg = NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_GROUP, (Object)((EntityGroup)element).getName());
                    msg = String.valueOf(msg) + "\n\n";
                    msg = String.valueOf(msg) + NLS.bind((String)Messages.DeleteTypesAction_NOTE_GROUP_ARCHIVE, (Object)archiveNewsCount);
                    return msg;
                }
                return NLS.bind((String)Messages.DeleteTypesAction_CONFIRM_DELETE_GROUP, (Object)((EntityGroup)element).getName());
            }
        }
        if (includesArchive && archiveNewsCount != 0) {
            String msg = Messages.DeleteTypesAction_CONFIRM_DELETE_ELEMENTS;
            msg = String.valueOf(msg) + "\n\n";
            msg = String.valueOf(msg) + NLS.bind((String)Messages.DeleteTypesAction_NOTE_SELECTION_ARCHIVE, (Object)archiveNewsCount);
            return msg;
        }
        return Messages.DeleteTypesAction_CONFIRM_DELETE_ELEMENTS;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShell = targetPart.getSite().getShell();
    }

    private void internalRun() {
        this.fConfirmed = true;
        final List<IEntity> entities = ModelUtils.getEntities(this.fSelection);
        CoreUtils.normalize(entities);
        this.restoreEditorsIfNecessary(entities);
        final ArrayList<INews> newsToDelete = new ArrayList<INews>();
        Iterator<IEntity> it = entities.iterator();
        while (it.hasNext()) {
            IEntity element = it.next();
            if (!(element instanceof INews)) continue;
            it.remove();
            newsToDelete.add((INews)element);
        }
        Runnable deleteRunnable = new Runnable(){

            public void run() {
                Controller.getDefault().getSavedSearchService().forceQuickUpdate();
                DynamicDAO.deleteAll((Collection)entities);
                if (!newsToDelete.isEmpty()) {
                    UndoStack.getInstance().addOperation(new NewsStateOperation(newsToDelete, INews.State.HIDDEN, false));
                    DeleteTypesAction.this.fNewsDAO.setState((Collection)newsToDelete, INews.State.HIDDEN, false, false);
                }
            }
        };
        if (this.shouldRunInBackground(entities, newsToDelete)) {
            this.deleteInBackground(deleteRunnable);
        } else {
            deleteRunnable.run();
        }
    }

    private boolean includesArchive(IStructuredSelection selection) {
        INewsBin archive = CoreUtils.findArchive();
        if (archive == null) {
            return false;
        }
        List<IEntity> entities = ModelUtils.getEntities(selection);
        CoreUtils.normalize(entities);
        for (IEntity entity : entities) {
            if (entity.equals(archive)) {
                return true;
            }
            if (!(entity instanceof IFolder) || !this.includesArchive((IFolder)entity, archive)) continue;
            return true;
        }
        return false;
    }

    private boolean includesArchive(IFolder folder, INewsBin archive) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child.equals(archive)) {
                return true;
            }
            if (!(child instanceof IFolder) || !this.includesArchive((IFolder)child, archive)) continue;
            return true;
        }
        return false;
    }

    private void restoreEditorsIfNecessary(List<IEntity> entitiesToDelete) {
        boolean restore = false;
        for (IEntity entity : entitiesToDelete) {
            if (!(entity instanceof IFolderChild)) continue;
            restore = true;
            break;
        }
        if (restore) {
            OwlUI.getFeedViews();
        }
    }

    private boolean shouldRunInBackground(List<IEntity> entities, List<INews> newsToDelete) {
        AtomicInteger newsCount = new AtomicInteger();
        newsCount.addAndGet(newsToDelete.size());
        for (IEntity entity : entities) {
            this.countNewsWithLimit(entity, newsCount, 200);
        }
        return newsCount.get() > 200;
    }

    private void countNewsWithLimit(IEntity entity, AtomicInteger count, int limit) {
        if (count.get() > limit) {
            return;
        }
        if (entity instanceof IBookMark) {
            count.addAndGet(ModelUtils.countNews((IBookMark)entity));
        } else if (entity instanceof INewsBin) {
            count.addAndGet(((INewsBin)entity).getNewsCount(INews.State.getVisible()));
        } else if (entity instanceof IFolder) {
            IFolder folder = (IFolder)entity;
            List children = folder.getChildren();
            for (IFolderChild child : children) {
                if (count.get() > limit) {
                    return;
                }
                this.countNewsWithLimit((IEntity)child, count, limit);
            }
        }
    }

    private void deleteInBackground(final Runnable deleteRunnable) {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.DeleteTypesAction_WAIT_DELETE, -1);
                try {
                    deleteRunnable.run();
                }
                finally {
                    monitor.done();
                }
            }
        };
        Shell shell = this.fShell;
        if (shell == null) {
            shell = OwlUI.getActiveShell();
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

            protected void initializeBounds() {
                super.initializeBounds();
                Shell shell = this.getShell();
                int width = this.convertHorizontalDLUsToPixels(320);
                shell.setSize(width, shell.getSize().y);
                Rectangle containerBounds = shell.getParent().getBounds();
                int x = Math.max(0, containerBounds.x + (containerBounds.width - width) / 2);
                shell.setLocation(x, shell.getLocation().y);
            }
        };
        try {
            dialog.run(true, false, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
    }

    public boolean isConfirmed() {
        return this.fConfirmed;
    }
}

