/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.dialogs.AggregateNewsDialog;
import org.rssowl.ui.internal.dialogs.SearchMarkDialog;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateFolderAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    private IWorkbenchPart fTargetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        Object firstElem;
        if (!this.fSelection.isEmpty() && this.fSelection instanceof IStructuredSelection && (firstElem = ((IStructuredSelection)this.fSelection).getFirstElement()) instanceof IFolder) {
            boolean askUserForAggregationOption;
            IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
            boolean aggregateAsSearch = preferences.getBoolean(DefaultPreferences.AGGREGATE_NEWS_AS_SEARCH);
            boolean bl = askUserForAggregationOption = !preferences.getBoolean(DefaultPreferences.REMEMBER_AGGREGATE_NEWS_OPTION);
            if (askUserForAggregationOption) {
                AggregateNewsDialog dialog = new AggregateNewsDialog(this.fTargetPart.getSite().getShell(), ((IFolder)firstElem).getName());
                int res = dialog.open();
                if (res == 1) {
                    return;
                }
                boolean bl2 = aggregateAsSearch = res == 2;
            }
            if (aggregateAsSearch) {
                this.createAndOpenSearch((IFolder)firstElem);
            } else {
                this.aggregateFolder((IFolder)firstElem);
            }
        }
    }

    private void createAndOpenSearch(IFolder folder) {
        ISearchMark locationSearch = this.findSearch((IFolderChild)folder);
        if (locationSearch == null) {
            IModelFactory factory = Owl.getModelFactory();
            ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>();
            ISearchField locationField = factory.createSearchField(19, INews.class.getName());
            conditions.add(factory.createSearchCondition(locationField, SearchSpecifier.IS, (Object)ModelUtils.toPrimitive(Collections.singletonList(folder))));
            SearchMarkDialog dialog = new SearchMarkDialog(this.fTargetPart.getSite().getShell(), folder.getParent(), (IFolderChild)folder, conditions, true, folder.getProperties());
            if (dialog.open() == 0) {
                locationSearch = dialog.getSearchMark();
            } else {
                return;
            }
        }
        if (locationSearch != null) {
            StructuredSelection selection = new StructuredSelection((Object)locationSearch);
            BookMarkExplorer explorer = OwlUI.getOpenedBookMarkExplorer();
            if (explorer != null) {
                explorer.getViewSite().getSelectionProvider().setSelection((ISelection)selection);
            }
            OwlUI.openInFeedView(this.fTargetPart.getSite().getPage(), (IStructuredSelection)selection);
            ArrayList<IBookMark> bookMarksToReload = new ArrayList<IBookMark>();
            this.fillBookMarksToReload(bookMarksToReload, folder);
            if (!bookMarksToReload.isEmpty()) {
                new ReloadTypesAction((IStructuredSelection)new StructuredSelection(bookMarksToReload.toArray()), this.fTargetPart.getSite().getShell()).run();
            }
        }
    }

    private void fillBookMarksToReload(List<IBookMark> bookMarksToReload, IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark) || ((IBookMark)mark).getMostRecentNewsDate() != null) continue;
            bookMarksToReload.add((IBookMark)mark);
        }
        List childs = folder.getFolders();
        for (IFolder child : childs) {
            this.fillBookMarksToReload(bookMarksToReload, child);
        }
    }

    private ISearchMark findSearch(IFolderChild folder) {
        Collection existingSearches = DynamicDAO.loadAll(ISearchMark.class);
        for (ISearchMark search : existingSearches) {
            Long[][] valueLong;
            Object value;
            SearchSpecifier specifier;
            ISearchCondition condition;
            ISearchField field;
            List conditions = search.getSearchConditions();
            if (conditions.size() != 1 || (field = (condition = (ISearchCondition)conditions.get(0)).getField()).getId() != 19 || (specifier = condition.getSpecifier()) != SearchSpecifier.IS || !((value = condition.getValue()) instanceof Long[][]) || (valueLong = (Long[][])value).length == 0 || valueLong[0].length != 1 || valueLong[0][0] == null || !valueLong[0][0].equals(folder.getId())) continue;
            return search;
        }
        return null;
    }

    private void aggregateFolder(final IFolder folder) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                FolderNewsMark folderNewsMark = new FolderNewsMark(folder);
                StructuredSelection newSelection = new StructuredSelection((Object)folderNewsMark);
                OwlUI.openInFeedView(AggregateFolderAction.this.fTargetPart.getSite().getPage(), (IStructuredSelection)newSelection);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

