/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.event.InstrumentsDbEvent;
import org.linuxsampler.lscp.event.InstrumentsDbListener;

public class DbDirectoryTreeNode
implements TreeNode {
    private DbDirectoryTreeNode parent = null;
    private DbDirectoryInfo info;
    private Vector<DbDirectoryTreeNode> dirs = new Vector();
    private Vector<DbInstrumentInfo> instrs = new Vector();
    private boolean connected = false;
    private boolean detachedNode = false;
    private final Vector<InstrumentsDbListener> listeners = new Vector();

    public DbDirectoryTreeNode(DbDirectoryInfo dbDirectoryInfo) {
        this.info = dbDirectoryInfo;
    }

    public void addInstrumentsDbListener(InstrumentsDbListener instrumentsDbListener) {
        this.listeners.add(instrumentsDbListener);
    }

    public void removeInstrumentsDbListener(InstrumentsDbListener instrumentsDbListener) {
        this.listeners.remove(instrumentsDbListener);
    }

    public DbDirectoryInfo getInfo() {
        return this.info;
    }

    public void setInfo(DbDirectoryInfo dbDirectoryInfo) {
        this.info = dbDirectoryInfo;
    }

    protected void setName(String string) {
        this.getInfo().setName(string);
        for (DbInstrumentInfo object : this.instrs) {
            object.setDirectoryPath(this.getInfo().getDirectoryPath());
        }
        for (DbDirectoryTreeNode dbDirectoryTreeNode : this.dirs) {
            dbDirectoryTreeNode.updateDirectoryPaths();
        }
    }

    protected void updateDirectoryPaths() {
        this.getInfo().setParentDirectoryPath(this.parent.getInfo().getDirectoryPath());
        for (DbInstrumentInfo object : this.instrs) {
            object.setDirectoryPath(this.getInfo().getDirectoryPath());
        }
        for (DbDirectoryTreeNode dbDirectoryTreeNode : this.dirs) {
            dbDirectoryTreeNode.updateDirectoryPaths();
        }
    }

    @Override
    public DbDirectoryTreeNode getChildAt(int n) {
        return this.dirs.get(n);
    }

    @Override
    public int getChildCount() {
        return this.dirs.size();
    }

    @Override
    public DbDirectoryTreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.dirs.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return this.dirs.elements();
    }

    public void setParent(DbDirectoryTreeNode dbDirectoryTreeNode) {
        this.parent = dbDirectoryTreeNode;
    }

    public void addDirectory(DbDirectoryTreeNode dbDirectoryTreeNode) {
        this.addDirectory(dbDirectoryTreeNode, true);
    }

    private void addDirectory(DbDirectoryTreeNode dbDirectoryTreeNode, boolean bl) {
        for (int i = 0; i < this.dirs.size(); ++i) {
            String string = this.dirs.get(i).getInfo().toString();
            if (string.compareToIgnoreCase(dbDirectoryTreeNode.getInfo().toString()) < 0) continue;
            this.dirs.insertElementAt(dbDirectoryTreeNode, i);
            dbDirectoryTreeNode.setParent(this);
            this.fireDirectoryCountChanged();
            return;
        }
        this.dirs.add(dbDirectoryTreeNode);
        dbDirectoryTreeNode.setParent(this);
        if (bl) {
            this.fireDirectoryCountChanged();
        }
    }

    public void addDirectories(DbDirectoryTreeNode[] dbDirectoryTreeNodeArray) {
        if (dbDirectoryTreeNodeArray == null || dbDirectoryTreeNodeArray.length == 0) {
            return;
        }
        for (DbDirectoryTreeNode dbDirectoryTreeNode : dbDirectoryTreeNodeArray) {
            this.addDirectory(dbDirectoryTreeNode, false);
        }
        this.fireDirectoryCountChanged();
    }

    public void removeDirectory(int n) {
        DbDirectoryTreeNode dbDirectoryTreeNode = this.dirs.remove(n);
        dbDirectoryTreeNode.setParent(null);
        this.fireDirectoryCountChanged();
    }

    public void removeDirectoryByPathName(String string) {
        if (string == null) {
            return;
        }
        for (DbDirectoryTreeNode dbDirectoryTreeNode : this.dirs) {
            if (!string.equals(dbDirectoryTreeNode.getInfo().getDirectoryPath())) continue;
            this.dirs.removeElement(dbDirectoryTreeNode);
            return;
        }
    }

    public void removeInstrumentByPathName(String string) {
        if (string == null) {
            return;
        }
        for (DbInstrumentInfo dbInstrumentInfo : this.instrs) {
            if (!string.equals(dbInstrumentInfo.getInstrumentPath())) continue;
            this.instrs.removeElement(dbInstrumentInfo);
            return;
        }
    }

    public void removeAllDirectories() {
        this.dirs.removeAllElements();
        this.fireDirectoryCountChanged();
    }

    public void updateDirectory(DbDirectoryInfo dbDirectoryInfo) {
        for (int i = 0; i < this.dirs.size(); ++i) {
            if (!this.dirs.get(i).getInfo().getName().equals(dbDirectoryInfo.getName())) continue;
            this.dirs.get(i).setInfo(dbDirectoryInfo);
            this.fireDirectoryInfoChanged(dbDirectoryInfo.getDirectoryPath());
            return;
        }
    }

    public void addInstrument(DbInstrumentInfo dbInstrumentInfo) {
        this.instrs.add(dbInstrumentInfo);
        this.fireInstrumentCountChanged();
    }

    public void addInstruments(DbInstrumentInfo[] dbInstrumentInfoArray) {
        if (dbInstrumentInfoArray == null || dbInstrumentInfoArray.length == 0) {
            return;
        }
        for (DbInstrumentInfo dbInstrumentInfo : dbInstrumentInfoArray) {
            this.instrs.add(dbInstrumentInfo);
        }
        this.fireInstrumentCountChanged();
    }

    public void removeAllInstruments() {
        this.instrs.removeAllElements();
        this.fireInstrumentCountChanged();
    }

    public void updateInstrument(DbInstrumentInfo dbInstrumentInfo) {
        for (int i = 0; i < this.instrs.size(); ++i) {
            if (!this.instrs.get(i).getName().equals(dbInstrumentInfo.getName())) continue;
            this.instrs.setElementAt(dbInstrumentInfo, i);
            this.fireInstrumentInfoChanged(dbInstrumentInfo.getInstrumentPath());
            return;
        }
    }

    public DbInstrumentInfo getInstrumentAt(int n) {
        return this.instrs.get(n);
    }

    public int getInstrumentCount() {
        return this.instrs.size();
    }

    public int getInstrumentIndex(DbInstrumentInfo dbInstrumentInfo) {
        return this.instrs.indexOf(dbInstrumentInfo);
    }

    public void removeInstrument(int n) {
        this.instrs.remove(n);
        this.fireInstrumentCountChanged();
    }

    public DbInstrumentInfo getInstrument(String string) {
        for (int i = 0; i < this.getInstrumentCount(); ++i) {
            if (!string.equals(this.getInstrumentAt(i).getName())) continue;
            return this.getInstrumentAt(i);
        }
        return null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isDetached() {
        return this.detachedNode;
    }

    public void setDetached(boolean bl) {
        this.detachedNode = bl;
    }

    public String toString() {
        return this.info.getName();
    }

    private void fireDirectoryCountChanged() {
        String string = this.getInfo() == null ? null : this.getInfo().getDirectoryPath();
        InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
        for (InstrumentsDbListener instrumentsDbListener : this.listeners) {
            instrumentsDbListener.directoryCountChanged(instrumentsDbEvent);
        }
    }

    private void fireDirectoryInfoChanged(String string) {
        InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
        for (InstrumentsDbListener instrumentsDbListener : this.listeners) {
            instrumentsDbListener.directoryInfoChanged(instrumentsDbEvent);
        }
    }

    private void fireInstrumentCountChanged() {
        String string = this.getInfo() == null ? null : this.getInfo().getDirectoryPath();
        InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
        for (InstrumentsDbListener instrumentsDbListener : this.listeners) {
            instrumentsDbListener.instrumentCountChanged(instrumentsDbEvent);
        }
    }

    private void fireInstrumentInfoChanged(String string) {
        InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
        for (InstrumentsDbListener instrumentsDbListener : this.listeners) {
            instrumentsDbListener.instrumentInfoChanged(instrumentsDbEvent);
        }
    }
}

