/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.Controller;
import freemind.controller.MenuItemEnabledListener;
import freemind.controller.actions.generated.instance.CloudColorXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class CloudColorAction
extends FreemindAction
implements ActorXml,
MenuItemEnabledListener {
    private final MindMapController controller;

    public CloudColorAction(MindMapController controller) {
        super("cloud_color", "images/Colors24.gif", controller);
        this.controller = controller;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        Color color;
        Color selectedColor = null;
        if (this.controller.getSelected().getCloud() != null) {
            selectedColor = this.controller.getSelected().getCloud().getColor();
        }
        if ((color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_cloud_color"), selectedColor)) == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setCloudColor(selected, color);
        }
    }

    public void setCloudColor(MindMapNode node, Color color) {
        CloudColorXmlAction doAction = this.createCloudColorXmlAction(node, color);
        CloudColorXmlAction undoAction = this.createCloudColorXmlAction(node, node.getCloud() == null ? null : node.getCloud().getColor());
        this.controller.getActionFactory().startTransaction(this.getClass().getName());
        this.controller.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.controller.getActionFactory().endTransaction(this.getClass().getName());
    }

    public CloudColorXmlAction createCloudColorXmlAction(MindMapNode node, Color color) {
        CloudColorXmlAction nodeAction = new CloudColorXmlAction();
        nodeAction.setNode(node.getObjectId(this.controller));
        nodeAction.setColor(Tools.colorToXml(color));
        return nodeAction;
    }

    public void act(XmlAction action) {
        if (action instanceof CloudColorXmlAction) {
            CloudColorXmlAction nodeColorAction = (CloudColorXmlAction)action;
            Color color = Tools.xmlToColor(nodeColorAction.getColor());
            NodeAdapter node = this.controller.getNodeFromID(nodeColorAction.getNode());
            if (node.getCloud() == null) {
                this.controller.setCloud(node, true);
            }
            Color selectedColor = null;
            if (node.getCloud() != null) {
                selectedColor = node.getCloud().getColor();
            }
            if (!Tools.safeEquals(color, selectedColor)) {
                ((LineAdapter)((Object)node.getCloud())).setColor(color);
                this.controller.nodeChanged(node);
            }
        }
    }

    public Class getDoActionClass() {
        return CloudColorXmlAction.class;
    }

    public boolean isEnabled(JMenuItem item, Action action) {
        return this.controller != null && this.controller.getSelected() != null && this.controller.getSelected().getCloud() != null;
    }
}

