/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.exports.ExportMessages;
import org.xmind.ui.internal.exports.ExportPlugin;
import org.xmind.ui.internal.exports.MindManagerExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class MindManagerExportWizard
extends AbstractMindMapExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.mindmanagerExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.mindmanager";
    private static final String FILE_EXT = ".mmap";
    private MindManagerExportPage page;

    public MindManagerExportWizard() {
        this.setWindowTitle(ExportMessages.MindManagerWizard_windowTitle);
        this.setDialogSettings(ExportPlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToMindManager", ExportMessages.MindManagerExportJob_Name));
        this.page = new MindManagerExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        IMindMap mindMap = this.getSourceMindMap();
        MindManagerExporter exporter = new MindManagerExporter(mindMap.getSheet(), mindMap.getCentralTopic(), this.getTargetPath());
        monitor.beginTask(null, 100);
        exporter.setMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 99));
        exporter.build();
        this.launchTargetFile(true, monitor, display, parentShell);
    }

    protected String getFormatName() {
        return ExportMessages.MindManagerWizard_FormatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && FILE_EXT.equalsIgnoreCase(extension);
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + FILE_EXT;
    }

    protected boolean doExport() {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToMindManagerCount");
        return super.doExport();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MindManagerExportPage
    extends AbstractMindMapExportPage {
        public MindManagerExportPage() {
            super(MindManagerExportWizard.PAGE_NAME, ExportMessages.MindManagerPage_title);
            this.setDescription(ExportMessages.MindManagerPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.MindManagerPage_FilterName);
            filterExtensions.add(0, "*.mmap");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

