/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeSupport;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class TaskBar {
    public final ITopic task;
    private DateInfo start;
    private DateInfo end;
    private int progress;
    private boolean checkpoint;
    private String priority;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public TaskBar(ITopic task) {
        this.task = task;
        this.updateStartDate();
        this.updateEndDate();
        this.updateProgress();
        this.updateCheckpoint();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.support;
    }

    public DateInfo getStartDate() {
        return this.start;
    }

    public DateInfo getEndDate() {
        return this.end;
    }

    public boolean hasDates() {
        return this.start != null || this.end != null;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isCheckpoint() {
        return this.checkpoint;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setCheckpoint(boolean checkpoint) {
        boolean oldValue = this.isCheckpoint();
        this.checkpoint = checkpoint;
        this.support.firePropertyChange("check-point", oldValue, this.isCheckpoint());
    }

    public void setStartDate(DateInfo date) {
        DateInfo oldDate = this.getStartDate();
        this.start = date;
        this.support.firePropertyChange("start-date", oldDate, this.getStartDate());
    }

    public void setEndDate(DateInfo date) {
        DateInfo oldDate = this.getEndDate();
        this.end = date;
        this.support.firePropertyChange("end-date", oldDate, this.getEndDate());
    }

    public void setProgress(int progress) {
        int oldProgress = this.getProgress();
        this.progress = progress;
        this.support.firePropertyChange("progress", oldProgress, this.getProgress());
    }

    public void setPriority(String priority) {
        String oldPriority = this.getPriority();
        this.priority = priority;
        this.support.firePropertyChange("priorityMarkers", oldPriority, this.getPriority());
    }

    public void updateStartDate() {
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo((ITopic)this.task);
        this.setStartDate(startDate);
    }

    public void updateEndDate() {
        DateInfo date = TaskInfoUtils.calculateEndDateInfo((ITopic)this.task);
        this.setEndDate(date);
    }

    public void updateProgress() {
        this.setProgress(TaskInfoUtils.calculateProgress((ITopic)this.task));
    }

    public void updateCheckpoint() {
        this.setCheckpoint(TaskInfoUtils.getCheckPoint((ITopic)this.task));
    }

    public void updatePriority() {
        IMarker marker = TaskInfoUtils.findMarker((ITopic)this.task, (String)"priorityMarkers");
        this.setPriority(marker == null ? null : marker.getId());
    }
}

