/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseInfoDialog
extends Dialog {
    private static final String DEFAULT_COLOR_KEY = "net.xmind.verify.ActivateProDialog.defaultColor";
    private static final String ICON_VALID = "icons/valid.png";
    private String actionName;
    private int requiredStatus;
    private int currentStatus;
    private boolean startup;
    private boolean update;
    private int targetStatus = 0;
    private String licensedTo;
    private Map<Integer, Control> licenseGroups = new HashMap<Integer, Control>();

    public LicenseInfoDialog(Shell parentShell, String actionName, int requiredStatus, int currentStatus, boolean startup, boolean update, String licensedTo) {
        super(parentShell);
        this.actionName = actionName;
        this.requiredStatus = requiredStatus;
        this.currentStatus = currentStatus;
        this.startup = startup;
        this.update = update;
        this.licensedTo = licensedTo;
        this.setBlockOnOpen(true);
        this.setReturnCode(1);
    }

    private String getMessage() {
        if (this.startup) {
            return Messages.LicenseInputDialog_StartupMessage;
        }
        if (this.update) {
            String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
            String licenseName = (this.currentStatus & 2) != 0 ? NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindProLicense, (Object)brandingVersion) : ((this.currentStatus & 1) != 0 ? Messages.LicenseInputDialog_LicenseName_XMindProSubscription : ((this.currentStatus & 4) != 0 ? NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindPlusLicense, (Object)brandingVersion) : null));
            if (licenseName == null) {
                return Messages.LicenseInputDialog_UpdateMessage;
            }
            return NLS.bind((String)Messages.LicenseInputDialog_LicensedMessage, (Object)licenseName, (Object)(this.licensedTo == null ? Messages.LicenseInputDialog_UnknownLicensee : this.licensedTo));
        }
        if (this.actionName != null && !"".equals(this.actionName)) {
            this.actionName = String.valueOf(this.actionName.substring(0, 1).toUpperCase()) + this.actionName.substring(1);
            if ((this.requiredStatus & 4) == 0) {
                return NLS.bind((String)Messages.LicenseInputDialog_OnDemandProActionMessage, (Object)this.actionName);
            }
            return NLS.bind((String)Messages.LicenseInputDialog_OnDemandActionMessage, (Object)this.actionName);
        }
        if ((this.requiredStatus & 4) == 0) {
            return Messages.LicenseInputDialog_OnDemandProMessage;
        }
        return Messages.LicenseInputDialog_OnDemandMessage;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LicenseInputDialog_windowTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createLicenseChoiceArea(composite);
        this.createLicenseInfoArea(composite);
        this.createSubscriptionArea(composite);
        return composite;
    }

    private void createMessageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 15;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gridData);
        if ((this.currentStatus & 7) != 0 && (this.requiredStatus & this.currentStatus) != 0) {
            composite.setBackground(parent.getDisplay().getSystemColor(29));
        } else {
            composite.setBackground(parent.getDisplay().getSystemColor(25));
        }
        Label imageLabel = new Label(composite, 0);
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.setImage(imageLabel, parent);
        imageLabel.setBackground(composite.getBackground());
        Label messageLabel = new Label(composite, 64);
        messageLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ((GridData)messageLabel.getLayoutData()).widthHint = 400;
        messageLabel.setText(this.getMessage());
        messageLabel.setBackground(composite.getBackground());
        messageLabel.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
    }

    protected void createLicenseChoiceArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList<Control> featureGroups = new ArrayList<Control>();
        String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        this.createLicenseChoice(composite, 4, NLS.bind((String)Messages.LicenseInputDialog_PlusFeatureTitle, (Object)brandingVersion), false, Messages.LicenseInputDialog_PlusFeatureList, featureGroups, Messages.LicenseInputDialog_BuyButton_text, new Runnable(){

            public void run() {
                LicenseInfoDialog.this.buyPlusLicense();
            }
        });
        this.createLicenseSeparator(composite);
        this.createLicenseChoice(composite, 2, NLS.bind((String)Messages.LicenseInputDialog_ProFeatureTitle, (Object)brandingVersion), true, Messages.LicenseInputDialog_ProFeatureList, featureGroups, Messages.LicenseInputDialog_BuyButton_text, new Runnable(){

            public void run() {
                LicenseInfoDialog.this.buyProLicense();
            }
        });
        int featureGroupWidth = 0;
        int featureGroupHeight = 0;
        for (Control featureGroup : featureGroups) {
            Point featureGroupSize = featureGroup.computeSize(-1, -1);
            featureGroupWidth = Math.max(featureGroupWidth, featureGroupSize.x);
            featureGroupHeight = Math.max(featureGroupHeight, featureGroupSize.y);
        }
        for (Control featureGroup : featureGroups) {
            GridData featureGridData = (GridData)featureGroup.getLayoutData();
            featureGridData.widthHint = featureGroupWidth;
            featureGridData.minimumWidth = featureGroupWidth;
            featureGridData.heightHint = featureGroupHeight;
            featureGridData.minimumHeight = featureGroupHeight;
        }
        this.updateLicenseGroups(this.requiredStatus);
    }

    private Control createLicenseChoice(Composite parent, int targetStatus, String title, boolean highlighted, String features, List<Control> featureGroups, String buyText, final Runnable buyAction) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 40;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite titleBar = new Composite(composite, 0);
        GridLayout titleLayout = new GridLayout(1, false);
        titleLayout.marginWidth = 0;
        titleLayout.marginHeight = 0;
        titleLayout.verticalSpacing = 2;
        titleLayout.horizontalSpacing = 0;
        titleBar.setLayout((Layout)titleLayout);
        titleBar.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] titles = title.split("\n");
        Label titleLabel = new Label(titleBar, 0x1000000);
        titleLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        titleLabel.setText(titles[0]);
        titleLabel.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)1));
        if (highlighted) {
            Color color = titleLabel.getDisplay().getSystemColor(3);
            titleLabel.setForeground(color);
            titleLabel.setData(DEFAULT_COLOR_KEY, (Object)color);
        }
        if (titles.length > 1) {
            Label subTitleLabel = new Label(titleBar, 0x1000000);
            subTitleLabel.setText(titles[1]);
            subTitleLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
            subTitleLabel.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
            if (highlighted) {
                Color color = subTitleLabel.getDisplay().getSystemColor(3);
                subTitleLabel.setForeground(color);
                subTitleLabel.setData(DEFAULT_COLOR_KEY, (Object)color);
            }
        }
        Composite featureGroup = new Composite(composite, 0);
        featureGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout featureLayout = new GridLayout(1, false);
        featureLayout.marginWidth = 0;
        featureLayout.marginHeight = 15;
        featureLayout.marginBottom = 5;
        featureLayout.verticalSpacing = 5;
        featureLayout.horizontalSpacing = 5;
        featureGroup.setLayout((Layout)featureLayout);
        featureGroups.add((Control)featureGroup);
        Font featureFont = FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2);
        String[] featureNames = features.split("\n");
        int i = 0;
        while (i < featureNames.length) {
            String featureName = featureNames[i];
            Label featureLabel = new Label(featureGroup, 0x1000000);
            featureLabel.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
            featureLabel.setText(featureName);
            featureLabel.setFont(featureFont);
            ++i;
        }
        Composite buttonBar = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginWidth = 5;
        buttonLayout.marginHeight = 0;
        buttonLayout.verticalSpacing = 0;
        buttonLayout.horizontalSpacing = 0;
        buttonBar.setLayout((Layout)buttonLayout);
        buttonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        Button buyButton = new Button(buttonBar, 8);
        buyButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)buyButton.getLayoutData()).minimumWidth = 120;
        ((GridData)buyButton.getLayoutData()).widthHint = 120;
        buyButton.setText(buyText);
        buyButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                buyAction.run();
            }
        });
        this.licenseGroups.put(targetStatus, (Control)composite);
        return composite;
    }

    private void createLicenseSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 20;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 514);
        label.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
    }

    private void targetSelected(int targetStatus) {
        this.targetStatus = targetStatus;
        this.setReturnCode(0);
        this.close();
    }

    public int getTargetStatus() {
        return this.targetStatus;
    }

    private void createMoreInfoArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 15;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        label.setText("*");
        label.setForeground(label.getDisplay().getSystemColor(16));
        label.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        Hyperlink link = new Hyperlink(composite, 0);
        link.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        link.setText(Messages.LicenseInputDialog_MoreInfoLink_text);
        link.setForeground(link.getDisplay().getSystemColor(16));
        link.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        link.setUnderlined(true);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                XMindNet.gotoURL((boolean)true, (String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/buy/moreinfo/"), (Object[])new Object[0]);
            }
        });
    }

    private void createLicenseInfoArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Hyperlink link = new Hyperlink(composite, 0);
        try {
            Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
            fPaintFocus.setAccessible(true);
            fPaintFocus.set(link, false);
        }
        catch (Throwable throwable) {}
        link.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        if ((this.currentStatus & 4) != 0 || (this.currentStatus & 2) != 0) {
            link.setText(Messages.LicenseInfoDialog_ViewChangeLink_Text);
        } else {
            link.setText(Messages.LicenseInfoDialog_EnterLicenseLink_Text);
        }
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        link.setUnderlined(true);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LicenseInfoDialog.this.targetSelected(6);
            }
        });
    }

    private void createSubscriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 30;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Hyperlink link = new Hyperlink(composite, 0);
        link.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        link.setText(Messages.LicenseInfoDialog_SubscriptionLink_Text);
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        link.setUnderlined(true);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LicenseInfoDialog.this.targetSelected(1);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button cancelButton = this.createButton(parent, 1, this.update || this.startup || (this.currentStatus & 7) != 0 ? IDialogConstants.CLOSE_LABEL : IDialogConstants.CANCEL_LABEL, false);
        cancelButton.setFocus();
    }

    private void updateLicenseGroups(int enabledStatuses) {
        for (Integer status : this.licenseGroups.keySet()) {
            this.updateEnablement(this.licenseGroups.get(status), (enabledStatuses & status) != 0);
        }
    }

    private void updateEnablement(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Label) {
            control.setForeground(enabled ? this.getDefaultColor(control) : control.getDisplay().getSystemColor(15));
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.updateEnablement(children[i], enabled);
                ++i;
            }
        }
    }

    private Color getDefaultColor(Control control) {
        Object color = control.getData(DEFAULT_COLOR_KEY);
        if (color != null && color instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    private void buyProLicense() {
        XMindNet.gotoURL((boolean)true, (String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/buy/pro/"), (Object[])new Object[0]);
    }

    private void buyPlusLicense() {
        XMindNet.gotoURL((boolean)true, (String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/buy/plus/"), (Object[])new Object[0]);
    }

    private void buyProSubscription() {
        XMindNet.gotoURL((boolean)true, (String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/buy/subscription/"), (Object[])new Object[0]);
    }

    private void setImage(Label imageLabel, Composite parent) {
        URL url;
        if ((this.currentStatus & 7) != 0 && (this.requiredStatus & this.currentStatus) != 0 && (url = Platform.getBundle((String)"net.xmind.verify").getEntry(ICON_VALID)) != null) {
            try {
                imageLabel.setImage(new Image(null, url.openStream()));
                return;
            }
            catch (IOException iOException) {}
        }
        imageLabel.setImage(parent.getDisplay().getSystemImage(2));
    }
}

