/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mapshot;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.image.ImageWriter;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IRectangleProvider;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.IDraggingTool;
import org.xmind.gef.tool.IGraphicalTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.GEFUtils;
import org.xmind.ui.dialogs.Notification;
import org.xmind.ui.internal.layers.FeedbackLayer;
import org.xmind.ui.internal.mapshot.Button;
import org.xmind.ui.internal.mapshot.CopyAreaFeedback;
import org.xmind.ui.internal.mapshot.MapShot;
import org.xmind.ui.internal.mapshot.MapShotAreaCreateTool;
import org.xmind.ui.internal.mapshot.MapShotAreaMoveTool;
import org.xmind.ui.internal.mapshot.MapShotAreaResizeTool;
import org.xmind.ui.internal.mapshot.MapShotTemporaryStorage;
import org.xmind.ui.internal.mapshot.Messages;
import org.xmind.ui.internal.mapshot.TargetFolderDialog;
import org.xmind.ui.internal.mapshot.TransparentCornerLabel;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.SWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapShotTool
extends GraphicalTool
implements PropertyChangeListener {
    private static final String SLIDE_BASE_MODE = "isSlideBaseMode";
    private Rectangle copyArea;
    private CopyAreaFeedback feedback;
    private IFeedbackService feedbackService;
    private boolean depressDrag = false;
    private Menu oldContextMenu = null;
    private Menu contextMenu = null;
    private TransparentCornerLabel tooltipLabel;
    private boolean isOnlyCopy = false;
    private MapShotTemporaryStorage mapshotStore;

    public MapShotTool() {
        this.setContextId("org.xmind.ui.context.mapShot");
        this.mapshotStore = new MapShotTemporaryStorage();
    }

    MapShotTemporaryStorage getTemporaryStorage() {
        return this.mapshotStore;
    }

    public String getType() {
        return "org.xmind.ui.tool.mapShot";
    }

    public Rectangle getCopyArea() {
        return this.copyArea;
    }

    public CopyAreaFeedback getFeedback() {
        return this.feedback;
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        if (prevTool != null) {
            if (prevTool instanceof MapShotAreaCreateTool) {
                this.getCopyArea((MapShotAreaCreateTool)prevTool);
            } else if (prevTool instanceof MapShotAreaResizeTool) {
                this.getResizedCopyArea((MapShotAreaResizeTool)prevTool);
            } else if (!(prevTool instanceof MapShotAreaMoveTool)) {
                this.copyArea = null;
                this.oldContextMenu = this.getTargetViewer().getControl().getMenu();
                this.createContextMenu();
                this.getTargetViewer().getControl().setMenu(this.contextMenu);
                this.addTooltipLabel();
            }
        }
    }

    private void addTooltipLabel() {
        if (this.tooltipLabel != null) {
            return;
        }
        Layer feedbackLayer = this.getLayer(GEF.LAYER_FEEDBACK);
        if (feedbackLayer != null) {
            this.tooltipLabel = new TransparentCornerLabel();
            this.tooltipLabel.setSize(300, 30);
            this.tooltipLabel.setLocation(this.getTooltipLocation());
            this.tooltipLabel.setLabelAlignment(2);
            this.tooltipLabel.setOpaque(true);
            this.tooltipLabel.setBackgroundColor(ColorUtils.getColor((String)"#e4e4e4"));
            this.tooltipLabel.setAlpha(242);
            this.tooltipLabel.setCornerDimensions(4);
            this.tooltipLabel.setBorder((Border)new RoundedRectBorder(ColorUtils.getColor((String)"#b1b1b1"), 1, 4));
            this.tooltipLabel.setText(Messages.MapShotTool_tooltip);
            feedbackLayer.add((IFigure)this.tooltipLabel);
            Viewport viewport = this.getTargetViewer().getCanvas().getViewport();
            if (viewport != null) {
                viewport.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.getTargetViewer().getCanvas().addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    MapShotTool.this.updateTooltipLabelLocation();
                }
            });
        }
    }

    private Point getTooltipLocation() {
        Rectangle clientArea = this.getTargetViewer().getClientArea();
        boolean isSlideBaseMode = false;
        Object slideBaseData = this.getTargetViewer().getControl().getShell().getData(SLIDE_BASE_MODE);
        if (slideBaseData != null) {
            isSlideBaseMode = (Boolean)slideBaseData;
        }
        Point location = null;
        if (!isSlideBaseMode) {
            location = new Point(clientArea.getTopLeft().x + clientArea.width / 2 - this.tooltipLabel.getSize().width / 2, clientArea.getTopLeft().y + 15);
        } else {
            location = new Point(clientArea.getTopLeft().x + clientArea.width / 2 - this.tooltipLabel.getSize().width / 2, clientArea.getTopLeft().y + 61);
            ScrollBar verticalBar = this.getTargetViewer().getCanvas().getVerticalBar();
            if (verticalBar != null && verticalBar.isVisible()) {
                location.x = clientArea.getTopLeft().x + (clientArea.width + verticalBar.getSize().x) / 2 - this.tooltipLabel.getSize().width / 2;
            }
        }
        return location;
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new CopyAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new CancelAction());
        Control control = this.getTargetViewer().getControl();
        this.contextMenu = menuManager.createContextMenu(control);
        control.setMenu(this.contextMenu);
    }

    private void getResizedCopyArea(MapShotAreaResizeTool tool) {
        if (this.copyArea != null) {
            this.copyArea.setBounds(tool.getResultArea());
        }
        if (this.feedback != null) {
            this.feedback.update();
        }
    }

    private void getCopyArea(MapShotAreaCreateTool tool) {
        IHighlightService highlightService;
        this.copyArea = tool.getResult();
        this.feedback = new CopyAreaFeedback(this.getTemporaryStorage());
        this.feedback.setBoundsProvider(new IRectangleProvider(){

            public Rectangle getRectangle() {
                return MapShotTool.this.getCopyArea();
            }
        });
        this.feedbackService = (IFeedbackService)this.getTargetViewer().getService(IFeedbackService.class);
        if (this.feedbackService != null) {
            this.feedbackService.addFeedback((IFeedback)this.feedback);
        }
        if ((highlightService = (IHighlightService)this.getTargetViewer().getService(IHighlightService.class)) != null) {
            this.feedback.setHighlightService(highlightService);
        }
    }

    protected void onDeactivated(ITool nextTool) {
        super.onDeactivated(nextTool);
        if (nextTool == this.getDomain().getDefaultTool()) {
            this.getTargetViewer().getControl().setMenu(this.oldContextMenu);
            if (this.contextMenu != null) {
                this.contextMenu.dispose();
                this.contextMenu = null;
            }
            return;
        }
        if (nextTool instanceof IGraphicalTool) {
            ((IGraphicalTool)nextTool).setCursorPosition(this.getCursorPosition());
        }
        if (nextTool instanceof IDraggingTool) {
            ((IDraggingTool)nextTool).setStartingPosition(this.getCursorPosition());
        }
    }

    protected boolean handleMouseDown(MouseEvent me) {
        this.depressDrag = false;
        return super.handleMouseDown(me);
    }

    protected boolean handleMouseMove(MouseEvent me) {
        Button mouseTarget = null;
        Button btnSave = this.mapshotStore.getMaps().get("Save");
        Button btnCancel = this.mapshotStore.getMaps().get("Cancel");
        Button btnCopy = this.mapshotStore.getMaps().get("Copy");
        Point p = this.getTargetViewer().getZoomManager().getScaled(me.cursorLocation);
        if (btnSave != null) {
            btnSave.setHover(false);
            if (btnSave.containsPoint(p)) {
                mouseTarget = btnSave;
            }
        }
        if (btnCancel != null) {
            btnCancel.setHover(false);
            if (btnCancel.containsPoint(p)) {
                mouseTarget = btnCancel;
            }
        }
        if (btnCopy != null) {
            btnCopy.setHover(false);
            if (btnCopy.containsPoint(p)) {
                mouseTarget = btnCopy;
            }
        }
        if (mouseTarget != null) {
            mouseTarget.setHover(true);
        }
        return super.handleMouseHover(me);
    }

    protected boolean handleMouseUp(MouseEvent me) {
        Button btnSave = this.mapshotStore.getEnsureButton("Save");
        Button btnCancel = this.mapshotStore.getEnsureButton("Cancel");
        Button btnCopy = this.mapshotStore.getEnsureButton("Copy");
        Point p = this.getTargetViewer().getZoomManager().getScaled(me.cursorLocation);
        if (btnSave != null && btnSave.containsPoint(p)) {
            this.setOnlyCopy(false);
            this.finish();
            VerifyUI20141031.getUsageDataCollector().increase("SaveMapshotCount");
        } else if (btnCancel != null && btnCancel.containsPoint(p)) {
            this.cancel();
        } else if (btnCopy != null && btnCopy.containsPoint(p)) {
            this.setOnlyCopy(true);
            this.finish();
            VerifyUI20141031.getUsageDataCollector().increase("CopyMapShotCount");
        }
        this.depressDrag = false;
        return super.handleMouseUp(me);
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        if (this.depressDrag) {
            return false;
        }
        if (this.copyArea == null) {
            this.changeActiveTool("org.xmind.ui.tool.mapShot.createArea");
            return true;
        }
        if (this.feedback != null) {
            int orientation = this.feedback.getOrientation(me.cursorLocation);
            if (orientation != 0) {
                this.removeAreaButtons();
                this.changeActiveTool("org.xmind.ui.tool.mapShot.resizeArea");
                return true;
            }
            if (this.copyArea.contains(me.startingLocation)) {
                this.removeAreaButtons();
                this.changeActiveTool("org.xmind.ui.tool.mapShot.moveArea");
                return true;
            }
        }
        this.depressDrag = true;
        return super.handleMouseDrag(me);
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        int orientation;
        if (this.feedback != null && (orientation = this.feedback.getOrientation(pos)) != 0) {
            return GEFUtils.getPositionCursor((int)orientation);
        }
        if (this.copyArea != null && this.copyArea.contains(this.getTargetViewer().getZoomManager().getScaled(pos))) {
            return Cursors.HAND;
        }
        if (this.copyArea == null) {
            return Cursors.CROSS;
        }
        return super.getCurrentCursor(pos, host);
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        if (this.copyArea != null && this.copyArea.contains(me.cursorLocation)) {
            this.finish();
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        if (SWTUtils.matchKey((int)0, (int)27, (int)ke.getState(), (int)ke.keyCode)) {
            this.cancel();
            return true;
        }
        if (SWTUtils.matchKey((int)0, (int)13, (int)ke.getState(), (int)ke.keyCode)) {
            this.finish();
            return true;
        }
        return super.handleKeyDown(ke);
    }

    private void finish() {
        this.recover();
        this.copy();
        this.cancel();
        this.copyArea = null;
    }

    private void cancel() {
        this.recover();
        this.copyArea = null;
        this.removeTooltipLabel();
        this.changeActiveTool("default tool");
    }

    private void removeTooltipLabel() {
        Viewport viewport;
        Layer feedbackLayer = this.getLayer(GEF.LAYER_FEEDBACK);
        if (feedbackLayer != null && this.tooltipLabel != null && this.tooltipLabel.getParent() == feedbackLayer) {
            feedbackLayer.remove((IFigure)this.tooltipLabel);
        }
        if ((viewport = this.getTargetViewer().getCanvas().getViewport()) != null) {
            viewport.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.tooltipLabel = null;
    }

    private void recover() {
        this.removeAreaSizeLabel();
        this.removeAreaButtons();
        if (this.feedback != null) {
            if (this.feedbackService != null) {
                this.feedbackService.removeFeedback((IFeedback)this.feedback);
            }
            this.feedback = null;
        }
    }

    private void removeAreaSizeLabel() {
        if (this.feedback != null) {
            TransparentCornerLabel sizeLabel;
            Layer feedbackLayer = this.getLayer(MindMapUI.LAYER_SKYLIGHT);
            if (feedbackLayer != null && (sizeLabel = this.mapshotStore.getSizeLabel()) != null) {
                feedbackLayer.remove((IFigure)sizeLabel);
            }
            this.mapshotStore.setSizeLabel(null);
        }
    }

    private void removeAreaButtons() {
        Button btnCopy;
        Button btnCancel;
        Layer feedbacklayer = this.getLayer(MindMapUI.LAYER_SKYLIGHT);
        Button btnSave = this.mapshotStore.getEnsureButton("Save");
        if (btnSave != null) {
            feedbacklayer.remove((IFigure)btnSave);
            this.mapshotStore.putButton("Save", null);
        }
        if ((btnCancel = this.mapshotStore.getEnsureButton("Cancel")) != null) {
            feedbacklayer.remove((IFigure)btnCancel);
            this.mapshotStore.putButton("Cancel", null);
        }
        if ((btnCopy = this.mapshotStore.getEnsureButton("Copy")) != null) {
            feedbacklayer.remove((IFigure)btnCopy);
            this.mapshotStore.putButton("Copy", null);
        }
    }

    private void copy() {
        Rectangle area = this.copyArea;
        if (area == null) {
            return;
        }
        this.copy(Display.getCurrent(), this.getTargetViewer().getZoomManager().getScaled(area), this.getTargetViewer());
    }

    private void copy(final Display display, final Rectangle copyArea, final IGraphicalViewer viewer) {
        display.asyncExec(new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        MapShotTool.this.doCopy(display, copyArea, viewer);
                    }
                });
            }
        });
    }

    protected void doCopy(Display display, Rectangle copyArea, IGraphicalViewer viewer) throws Exception {
        ImageData[] imageData = this.getImageData(display, copyArea, viewer);
        this.copyToClipboard(display, imageData);
        if (!this.isOnlyCopy()) {
            this.copyToLocalFile(display, imageData);
        }
    }

    private void copyToLocalFile(Display display, ImageData[] imageData) throws IOException {
        File targetFile = this.getTargetFile();
        if (targetFile == null) {
            return;
        }
        OutputStream output = this.createOutputStream(targetFile);
        if (output != null) {
            ImageWriter writer = ImageExportUtils.createImageWriter((ImageData[])imageData, (int)5, (OutputStream)output);
            try {
                writer.write();
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        this.postCopy(display, targetFile);
    }

    private void copyToClipboard(Display display, ImageData[] imageData) {
        Clipboard clipboard = new Clipboard(display);
        try {
            clipboard.setContents((Object[])imageData, new Transfer[]{ImageTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    private ImageData[] getImageData(Display display, Rectangle copyArea, IGraphicalViewer viewer) {
        Image image = new Image((Device)display, copyArea.width, copyArea.height);
        try {
            GC gc = new GC((Drawable)image);
            try {
                SWTGraphics graphics = new SWTGraphics(gc);
                try {
                    this.paintCopyArea((Graphics)graphics, copyArea, viewer);
                }
                finally {
                    graphics.dispose();
                }
            }
            finally {
                gc.dispose();
            }
            ImageData[] imageDataArray = new ImageData[]{image.getImageData()};
            return imageDataArray;
        }
        finally {
            image.dispose();
        }
    }

    private void paintCopyArea(Graphics graphics, Rectangle copyArea, IGraphicalViewer viewer) {
        ISheetPart sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class);
        Point origin = sheet.getFigure() instanceof IReferencedFigure ? ((IReferencedFigure)sheet.getFigure()).getOrigin() : new Point(0, 0);
        graphics.translate(origin.x - copyArea.x, origin.y - copyArea.y);
        List<IFigure> figures = this.getContents();
        for (IFigure child : figures) {
            child.paint(graphics);
        }
    }

    private List<IFigure> getContents() {
        ArrayList<IFigure> figures = new ArrayList<IFigure>();
        IFigure layeredPane = this.getTargetViewer().getCanvas().getViewport().getContents();
        List children = layeredPane.getChildren();
        for (Object obj : children) {
            if (!(obj instanceof IFigure) || obj instanceof FeedbackLayer) continue;
            figures.add((IFigure)obj);
        }
        return figures;
    }

    private File getTargetFile() {
        File targetFolder = this.getTargetFolder();
        if (targetFolder == null) {
            return null;
        }
        return FileUtils.ensureFileParent((File)this.createFile(targetFolder, Messages.MapShotFile_prefix, ".png"));
    }

    private File getTargetFolder() {
        if (!this.savesToLocalFile()) {
            return null;
        }
        String targetFolderPath = MapShot.getDefault().getPreferenceStore().getString("TARGET_FOLDER");
        if (!(targetFolderPath != null && !"".equals(targetFolderPath) && new File(targetFolderPath).exists() && new File(targetFolderPath).isDirectory() || (targetFolderPath = this.getTargetFolderFromDialog(targetFolderPath)) != null)) {
            return null;
        }
        return new File(targetFolderPath);
    }

    private String getTargetFolderFromDialog(String initPath) {
        TargetFolderDialog dialog = new TargetFolderDialog(this.getTargetViewer().getControl().getShell());
        dialog.setTargetFolderPath(initPath);
        int retCode = dialog.open();
        if (retCode == 0) {
            return dialog.getTargetFolderPath();
        }
        return null;
    }

    private boolean savesToLocalFile() {
        return MapShot.getDefault().getPreferenceStore().getBoolean("SAVE_TO_LOCAL_FILE");
    }

    private File createFile(File dir, String prefix, String suffix) {
        int i = 1;
        File file = new File(dir, String.valueOf(prefix) + " " + i + suffix);
        while (file.exists()) {
            file = new File(dir, String.valueOf(prefix) + " " + ++i + suffix);
        }
        return file;
    }

    private OutputStream createOutputStream(File targetFile) {
        try {
            return new FileOutputStream(targetFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private void postCopy(Display display, File targetFile) {
        String info = this.getPostCopyMessage(targetFile);
        if (info != null) {
            String destPath = targetFile.getAbsolutePath();
            OpenAction openAction = new OpenAction(Messages.MapShotTool_Notification_leftAction_text, destPath);
            org.eclipse.swt.graphics.Rectangle bounds = null;
            Control control = this.getTargetViewer().getControl();
            if (control != null && !control.isDisposed()) {
                org.eclipse.swt.graphics.Rectangle bounds2 = control.getBounds();
                org.eclipse.swt.graphics.Point toDisplay = control.getParent().toDisplay(bounds2.x, bounds2.y);
                bounds = new org.eclipse.swt.graphics.Rectangle(toDisplay.x, toDisplay.y, bounds2.width, bounds2.height);
            }
            Notification popup = new Notification(control.getShell(), info, (IAction)openAction, bounds, true, false, true, null);
            popup.setDuration(5000);
            popup.open();
        }
    }

    private String getPostCopyMessage(File targetFile) {
        return Messages.MapShotTool_Post_Copy_Message;
    }

    private Layer getLayer(Object key) {
        IGraphicalViewer viewer = this.getTargetViewer();
        return viewer == null ? null : viewer.getLayer(key);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateTooltipLabelLocation();
    }

    private void updateTooltipLabelLocation() {
        if (this.tooltipLabel != null) {
            this.tooltipLabel.setLocation(this.getTooltipLocation());
        }
    }

    public boolean isOnlyCopy() {
        return this.isOnlyCopy;
    }

    public void setOnlyCopy(boolean isOnlyCopy) {
        this.isOnlyCopy = isOnlyCopy;
    }

    private class CancelAction
    extends Action {
        public CancelAction() {
            super(Messages.Cancel_text);
        }

        public void run() {
            MapShotTool.this.cancel();
        }
    }

    private class CopyAction
    extends Action {
        public CopyAction() {
            super(Messages.Copy_text);
        }

        public void run() {
            MapShotTool.this.finish();
        }
    }

    private class OpenAction
    extends Action {
        private String path;

        public OpenAction(String text, String path) {
            super(text);
            this.path = path;
        }

        public void run() {
            Program.launch((String)this.path);
        }
    }

    private static class RoundedRectBorder
    extends LineBorder {
        private int arc = 0;

        public RoundedRectBorder(Color color, int width, int arc) {
            super(color, width);
            this.arc = arc;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(RoundedRectBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            if (this.getWidth() % 2 == 1) {
                --RoundedRectBorder.tempRect.width;
                --RoundedRectBorder.tempRect.height;
            }
            tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
            graphics.setLineWidth(this.getWidth());
            graphics.setLineStyle(this.getStyle());
            if (this.getColor() != null) {
                graphics.setForegroundColor(this.getColor());
            }
            graphics.drawRoundRectangle(tempRect, this.arc, this.arc);
        }
    }
}

