/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.color;

import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.color.IColorSelection;

public class ColorSelection
implements IColorSelection {
    public static final ColorSelection EMPTY = new ColorSelection(0);
    private int type;
    private RGB color;

    public ColorSelection(RGB color) {
        this(3, color);
    }

    public ColorSelection(int type) {
        this(type, null);
    }

    public ColorSelection(int type, RGB color) {
        this.type = type;
        this.color = color;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public RGB getColor() {
        return this.color;
    }

    @Override
    public boolean isAutomatic() {
        return this.type == 1;
    }

    @Override
    public boolean isNone() {
        return this.type == 2;
    }

    @Override
    public boolean isCustom() {
        return this.type == 3;
    }

    public boolean isEmpty() {
        return this.type != 1 && this.type != 2 && this.type != 3;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColorSelection)) {
            return false;
        }
        ColorSelection that = (ColorSelection)obj;
        return this.type == that.type && (this.color == that.color || this.color != null && this.color.equals((Object)that.color));
    }

    public int hashCode() {
        if (this.color == null) {
            return this.type;
        }
        return this.type ^ this.color.hashCode();
    }

    public String toString() {
        String t = this.isAutomatic() ? "Automatic" : (this.isNone() ? "None" : (this.isCustom() ? "Custom" : "Unknown"));
        return "[type=" + t + (this.color != null ? ", color=" + this.color : "") + "]";
    }
}

