/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.handlers.MoveToDialog;

public class MoveCloudFolderHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList<SeawindFolder> folders = new ArrayList<SeawindFolder>();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof SeawindFolder)) continue;
                folders.add((SeawindFolder)element);
            }
            if (!folders.isEmpty()) {
                this.moveCloudFolder(folders, shell);
            }
        }
        return null;
    }

    private void moveCloudFolder(List<SeawindFolder> sources, Shell shell) {
        MoveToDialog dialog = new MoveToDialog(shell, sources);
        if (dialog.open() == 0) {
            String targetPath = dialog.getPath();
            if (sources.get(0).getOwnedParent().getPath().equals(targetPath)) {
                return;
            }
            for (SeawindFolder source : sources) {
                SeawindUIPlugin.getSeawindLibrary().moveFolder(source, targetPath);
            }
        }
    }
}

