/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.richtext.AutoHyperlink;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.RichTextUtils;

public class RichTextScanner
implements ITokenScanner {
    private static final String regex = "\\b(https?|ftp|mailto|svn|irc|gopher|telnet|nntp|worldwind|news):(?:/{1,3})([\\w-]+\\.)+[\\w-]+[\\w-._/\\~%-+&#?!=()@:]*";
    private IRichDocument document;
    private int offset;
    private int length;
    private StyleRange[] textStyles;
    private int styleIndex;
    private Hyperlink[] hyperlinks;
    private int hyperlinkIndex;
    private int lastOffset;
    private int lastLength;
    private List<AutoHyperlink> autoHyperRanges;
    private int autoIndex;

    public void setRange(IDocument document, int offset, int length) {
        if (!(document instanceof IRichDocument)) {
            return;
        }
        this.document = (IRichDocument)document;
        this.offset = offset;
        this.length = length;
        this.textStyles = this.document.getTextStyles();
        this.styleIndex = 0;
        this.hyperlinks = this.document.getHyperlinks();
        this.hyperlinkIndex = 0;
        this.lastOffset = offset;
        this.lastLength = 0;
        this.getHyperlinkAt(offset);
        this.refreshAutoHyperlinks();
        this.autoIndex = 0;
    }

    public int getTokenLength() {
        return this.lastLength;
    }

    public int getTokenOffset() {
        return this.lastOffset;
    }

    public IToken nextToken() {
        int current = this.lastOffset + this.lastLength;
        if (current >= this.offset + this.length) {
            return Token.EOF;
        }
        int next = this.offset + this.length;
        Hyperlink h = this.getHyperlinkAt(current);
        AutoHyperlink a = this.getAutoHyperlinkAt(current);
        int hyperNext = 0;
        if (h != null) {
            hyperNext = current >= h.start ? Math.min(next, h.start + h.length) : Math.min(next, h.start);
        }
        int autoNext = 0;
        if (a != null) {
            autoNext = current >= a.start ? Math.min(next, a.start + a.length) : Math.min(next, a.start);
        }
        int tempStart = 0;
        int tempLength = 0;
        if (h != null && a != null) {
            if (h.start < a.start) {
                next = hyperNext;
                tempStart = h.start;
                tempLength = h.length;
            } else {
                next = autoNext;
                tempStart = a.start;
                tempLength = a.length;
            }
        } else if (h != null && a == null) {
            next = hyperNext;
            tempStart = h.start;
            tempLength = h.length;
        } else if (a != null && h == null) {
            next = autoNext;
            tempStart = a.start;
            tempLength = a.length;
        }
        StyleRange style = this.getTextStyleAt(current);
        if (style != null) {
            next = current >= style.start ? Math.min(next, style.start + style.length) : Math.min(next, style.start);
        }
        this.lastOffset = current;
        this.lastLength = next - current;
        if (this.lastLength <= 0) {
            return Token.EOF;
        }
        if (style == null || current < style.start || next > style.start + style.length) {
            style = null;
        }
        if ((h != null || a != null) && current >= tempStart && next <= tempStart + tempLength) {
            if (style == null) {
                style = RichTextUtils.DEFAULT_STYLE;
            }
            style = (StyleRange)style.clone();
            if (style.foreground == null || style.foreground == RichTextUtils.DEFAULT_FOREGROUND || style.foreground.equals((Object)RichTextUtils.DEFAULT_FOREGROUND)) {
                style.foreground = Display.getCurrent().getSystemColor(9);
            }
            style.underline = true;
        }
        return new Token((Object)style);
    }

    public IToken nextToken1() {
        StyleRange style;
        int current = this.lastOffset + this.lastLength;
        if (current >= this.offset + this.length) {
            return Token.EOF;
        }
        int next = this.offset + this.length;
        Hyperlink h = this.getHyperlinkAt(current);
        if (h != null) {
            next = current >= h.start ? Math.min(next, h.start + h.length) : Math.min(next, h.start);
        }
        if ((style = this.getTextStyleAt(current)) != null) {
            next = current >= style.start ? Math.min(next, style.start + style.length) : Math.min(next, style.start);
        }
        this.lastOffset = current;
        this.lastLength = next - current;
        if (this.lastLength <= 0) {
            return Token.EOF;
        }
        if (style == null || current < style.start || next > style.start + style.length) {
            style = null;
        }
        if (h != null && current >= h.start && next <= h.start + h.length) {
            if (style == null) {
                style = RichTextUtils.DEFAULT_STYLE;
            }
            style = (StyleRange)style.clone();
            if (style.foreground == null || style.foreground == RichTextUtils.DEFAULT_FOREGROUND || style.foreground.equals((Object)RichTextUtils.DEFAULT_FOREGROUND)) {
                style.foreground = Display.getCurrent().getSystemColor(9);
            }
            style.underline = true;
        }
        return new Token((Object)style);
    }

    private Hyperlink getHyperlinkAt(int position) {
        while (this.hyperlinkIndex < this.hyperlinks.length) {
            Hyperlink h = this.hyperlinks[this.hyperlinkIndex];
            if (position < h.start + h.length) {
                return h;
            }
            ++this.hyperlinkIndex;
        }
        return null;
    }

    private AutoHyperlink getAutoHyperlinkAt(int position) {
        if (this.autoHyperRanges == null) {
            return null;
        }
        AutoHyperlink[] autoArray = this.autoHyperRanges.toArray(new AutoHyperlink[0]);
        while (this.autoIndex < autoArray.length) {
            AutoHyperlink autoHyperRange = autoArray[this.autoIndex];
            if (position < autoHyperRange.start + autoHyperRange.length) {
                return autoHyperRange;
            }
            ++this.autoIndex;
        }
        return null;
    }

    private StyleRange getTextStyleAt(int position) {
        while (this.styleIndex < this.textStyles.length) {
            StyleRange style = this.textStyles[this.styleIndex];
            if (position < style.start + style.length) {
                return style;
            }
            ++this.styleIndex;
        }
        return null;
    }

    private void refreshAutoHyperlinks() {
        if (this.autoHyperRanges != null) {
            this.autoHyperRanges = null;
        }
        String content = this.document.get();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int start = matcher.start();
            int length = matcher.end() - start;
            if (this.autoHyperRanges == null) {
                this.autoHyperRanges = new ArrayList<AutoHyperlink>();
            }
            this.autoHyperRanges.add(new AutoHyperlink(start, length));
        }
    }
}

