/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.xmind.core.IAccount;
import net.xmind.core.IAuthenticationListener;
import net.xmind.signin.internal.Activator;
import net.xmind.ui.internal.auth.AccountInfoDialog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.CoreException;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.http.IResponseHandler;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.seawind.ISeawindLibraryListener;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindLibraryEvent;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.internal.seawind.dashboard.CloudMapFolderPage;
import org.xmind.ui.internal.seawind.dashboard.WelcomePage;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.SWTUtils;
import org.xmind.ui.views.IPage;
import org.xmind.ui.views.Page;
import org.xmind.ui.views.PageStack;

public class CloudDashboardContentPage
extends Page
implements IAuthenticationListener {
    public static final String KEY_DASHBOARD_CLOUD_VIEW_MODE = "org.xmind.ui.part.dashboard.cloudPage.viewMode";
    public static final String VIEW_MODE_VALUE_GRID = "gridViewMode";
    public static final String VIEW_MODE_VALUE_LIST = "listViewMode";
    public static final String SORT_BY_NAME = "sort_by_name";
    public static final String SORT_BY_TIME = "sort_by_time";
    public static final String SORT_TYPE = "sort_type";
    private static final String COLOR_TITLE_BAR_FILL = "#ECECEC";
    private static final String COLOR_TITLE_BAR_TEXT = "#000000";
    private static final String COLOR_AVATAR_OUTLINE = "#A0A0A0";
    private static final int AVATAR_WIDTH = 24;
    private static final int AVATAR_HEIGHT = 24;
    private static final String AVATAR_URL = "https://www.gravatar.com/avatar/%s?s=%s&d=404";
    private static final SeawindFolder EMPTY_FOLDER = new SeawindFolder("");
    public static final int BY_NAME = 1;
    public static final int BY_TIME = 2;
    private boolean sortNameAsAsc = false;
    private boolean sortModiTimeAsAsc = false;
    private static IPath avatarStorageLocation = null;
    private IDashboardContext context;
    private SeawindLibrary library;
    private IAccount account;
    private CloudMapFolderPage collectionPage;
    private IPage welcomePage;
    private ResourceManager resources;
    private Composite titleBar;
    private PageStack bodyStack;
    private Composite pathComposite;
    private Label backLabel;
    private Label contentSummaryLabel;
    private Label syncErrorLabel;
    private Label syncButton;
    private Control accountItem;
    private Timer timer;
    private int count;
    private Canvas avatarLabel;
    private Image[] avatarImage;
    private Label newFolderButton;
    private Label sortByNameButton;
    private Label sortByTimeButton;
    private ISeawindLibraryListener libraryListener = new ISeawindLibraryListener(){

        @Override
        public void handleSeawindLibraryEvent(final SeawindLibraryEvent event) {
            final Control control = CloudDashboardContentPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            final String userName = CloudDashboardContentPage.this.library.getUserName();
            final boolean syncing = CloudDashboardContentPage.this.library.isSyncing();
            final String syncError = CloudDashboardContentPage.this.library.getGlobalSyncError();
            final Object target = event.getTarget();
            if (event.getType() == 1024 || event.getType() == 0x100000) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control.isDisposed()) {
                            return;
                        }
                        CloudDashboardContentPage.this.updateSyncStatus(userName, syncing, syncError);
                    }
                });
            } else if (event.getType() == 4) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control.isDisposed()) {
                            return;
                        }
                        if (CloudDashboardContentPage.this.collectionPage != null && CloudDashboardContentPage.this.collectionPage.getControl() != null && !CloudDashboardContentPage.this.collectionPage.getControl().isDisposed()) {
                            CloudDashboardContentPage.this.collectionPage.refresh();
                        }
                    }
                });
            } else {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control.isDisposed()) {
                            return;
                        }
                        Object target_0 = target;
                        if (event.getType() == 2) {
                            target_0 = null;
                        }
                        CloudDashboardContentPage.this.updateWithContent(userName, syncing, syncError, target_0);
                    }
                });
            }
        }
    };

    public CloudDashboardContentPage(IDashboardContext context, SeawindLibrary library, IAccount account) {
        this.context = context;
        this.library = library;
        this.account = account;
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object obj;
        IPage page = this.bodyStack.getCurrentPage();
        if (page != null && (obj = page.getAdapter(adapter)) != null) {
            return (T)obj;
        }
        return (T)super.getAdapter(adapter);
    }

    public void setFocus() {
        if (this.bodyStack != null && this.bodyStack.getControl() != null && !this.bodyStack.getControl().isDisposed()) {
            this.bodyStack.setFocus();
        } else {
            super.setFocus();
        }
    }

    public Control doCreateControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(1).applyTo(composite);
        this.addDnDSupport(composite);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        Composite titleBar = this.createTitlebar(composite);
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 44).grab(true, false).applyTo((Control)titleBar);
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)separator);
        Control body = this.createBody(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(body);
        this.library.addLibraryListener(this.libraryListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CloudDashboardContentPage.this.handleDispose();
            }
        });
        this.updateWithContent(this.library.getUserName(), this.library.isSyncing(), this.library.getGlobalSyncError(), null);
        if (this.account != null) {
            final CloudDashboardContentPage authListener = this;
            this.account.addAuthenticationListener((IAuthenticationListener)authListener);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CloudDashboardContentPage.this.account.removeAuthenticationListener(authListener);
                }
            });
        }
        return composite;
    }

    private void addDnDSupport(Composite composite) {
        final DropTarget dropTarget = new DropTarget((Control)composite, 18);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dropTarget.dispose();
            }
        });
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    String[] stringArray = fileList = (String[])event.data;
                    int n = fileList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        if (path.endsWith(".xmind")) {
                            new File(path);
                            CloudDashboardContentPage.this.importFrom(new File(path).toURI());
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private Composite createTitlebar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_TITLE_BAR_FILL)));
        composite.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_TITLE_BAR_TEXT)));
        this.titleBar = composite;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 50;
        composite.setLayout((Layout)gridLayout);
        Control leftControl = this.createLeftTitleBarControl(this.titleBar);
        GridData gridData = new GridData(4, 4, true, true);
        leftControl.setLayoutData((Object)gridData);
        Control rightControl = this.createRightTitleBarControl(this.titleBar);
        GridData gridData2 = new GridData(131072, 4, false, true);
        rightControl.setLayoutData((Object)gridData2);
        return composite;
    }

    private Control createLeftTitleBarControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getBackground());
        composite2.setForeground(composite.getForeground());
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(5, 0).applyTo(composite2);
        GridData gridData = new GridData(16384, 0x1000000, false, true);
        composite2.setLayoutData((Object)gridData);
        this.pathComposite = new Composite(composite2, 0);
        this.pathComposite.setBackground(composite2.getBackground());
        this.pathComposite.setForeground(composite2.getForeground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        this.pathComposite.setLayout((Layout)layout);
        int hintHeight = DPIUtil.getDeviceZoom() > 100 ? 52 : 26;
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, true).hint(-1, hintHeight).applyTo((Control)this.pathComposite);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CloudDashboardContentPage.this.updateTitleBar();
            }
        });
        return composite;
    }

    private Control createRightTitleBarControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().numColumns(10).spacing(15, 0).applyTo(composite);
        this.createSyncErrorLabel(composite);
        this.createImportButton(composite);
        this.createNewFolderButton(composite);
        this.createSeparator(composite);
        this.createViewModeButton(composite);
        this.sortByNameButton = this.createSortByNameButton(composite);
        this.sortByTimeButton = this.createSortByTimeButton(composite);
        this.createSeparator(composite);
        this.createSyncButton(composite);
        this.createAccountItemButton(composite);
        return composite;
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 14;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Composite separator = new Composite(composite, 0);
        separator.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#acacac")));
        GridData gridData = new GridData(0x1000000, 4, false, true);
        gridData.widthHint = 1;
        separator.setLayoutData((Object)gridData);
        separator.setLayout((Layout)new GridLayout());
    }

    private void createSyncErrorLabel(Composite parent) {
        this.syncErrorLabel = new Label(parent, 0);
        this.syncErrorLabel.setBackground(parent.getBackground());
        this.syncErrorLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("warning.png")));
        this.syncErrorLabel.setVisible(false);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.syncErrorLabel);
    }

    private void createImportButton(Composite parent) {
        final Label importBtton = new Label(parent, 0);
        importBtton.setBackground(parent.getBackground());
        importBtton.setToolTipText(SeawindMessages.CloudDashboardPage_ImportButton_tooltip);
        importBtton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_import.png")));
        importBtton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CloudDashboardContentPage.this.importXMindFiles();
            }
        });
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)importBtton);
        importBtton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                importBtton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_import.png")));
            }

            public void mouseEnter(MouseEvent e) {
                importBtton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_import_hover.png")));
            }
        });
    }

    private void createNewFolderButton(Composite parent) {
        this.newFolderButton = new Label(parent, 0);
        this.newFolderButton.setBackground(parent.getBackground());
        this.newFolderButton.setToolTipText(SeawindMessages.CloudDashboardContentPage_Button_New_Folder);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)this.newFolderButton);
        this.newFolderButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_Folder.png")));
        this.newFolderButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CloudDashboardContentPage.this.newFolderButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_Folder_click.png")));
                SeawindFolder parent = CloudDashboardContentPage.this.library.getSeawindFolderManager().getSeawindFolder(CloudDashboardContentPage.this.library.getSeawindFolderManager().getCurrentFolderPath());
                CloudDashboardContentPage.this.library.newFolder(parent, CloudDashboardContentPage.this.getNewFolderName(parent));
            }
        });
        this.newFolderButton.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                CloudDashboardContentPage.this.newFolderButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_Folder.png")));
            }
        });
        this.newFolderButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                CloudDashboardContentPage.this.newFolderButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_Folder.png")));
            }

            public void mouseEnter(MouseEvent e) {
                CloudDashboardContentPage.this.newFolderButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_Folder_hover.png")));
            }
        });
    }

    private String getNewFolderName(SeawindFolder parent) {
        Set folders = parent.getFolders();
        ArrayList<String> folderNames = new ArrayList<String>();
        for (SeawindFolder folder : folders) {
            folderNames.add(folder.getTitle());
        }
        String name = SeawindMessages.CloudDashboardContentPage_Default_Folder;
        int index = 2;
        while (folderNames.contains(name)) {
            name = String.valueOf(SeawindMessages.CloudDashboardContentPage_Default_Folder) + " " + index;
            ++index;
        }
        return name;
    }

    private void createViewModeButton(Composite parent) {
        final Label viewModeButton = new Label(parent, 0);
        viewModeButton.setBackground(parent.getBackground());
        String viewMode = this.context.getPersistedState(KEY_DASHBOARD_CLOUD_VIEW_MODE);
        if (viewMode == null) {
            viewMode = VIEW_MODE_VALUE_GRID;
            this.context.setPersistedState(KEY_DASHBOARD_CLOUD_VIEW_MODE, viewMode);
        }
        this.showViewModeImage(viewModeButton, viewMode);
        viewModeButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                String viewMode = CloudDashboardContentPage.this.context.getPersistedState(CloudDashboardContentPage.KEY_DASHBOARD_CLOUD_VIEW_MODE);
                String newViewMode = viewMode == null || viewMode.equals(CloudDashboardContentPage.VIEW_MODE_VALUE_GRID) ? CloudDashboardContentPage.VIEW_MODE_VALUE_LIST : CloudDashboardContentPage.VIEW_MODE_VALUE_GRID;
                CloudDashboardContentPage.this.context.setPersistedState(CloudDashboardContentPage.KEY_DASHBOARD_CLOUD_VIEW_MODE, newViewMode);
                CloudDashboardContentPage.this.showViewModeImage(viewModeButton, newViewMode);
                if (CloudDashboardContentPage.this.collectionPage != null) {
                    CloudDashboardContentPage.this.collectionPage.updatePage();
                }
            }
        });
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)viewModeButton);
        this.configViewModeButtonImage(viewModeButton);
    }

    private void configViewModeButtonImage(final Label viewModeButton) {
        viewModeButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                String viewMode = CloudDashboardContentPage.this.context.getPersistedState(CloudDashboardContentPage.KEY_DASHBOARD_CLOUD_VIEW_MODE);
                if (viewMode == null || "".equals(viewMode)) {
                    viewMode = CloudDashboardContentPage.VIEW_MODE_VALUE_GRID;
                }
                CloudDashboardContentPage.this.showViewModeHoverImage(viewModeButton, viewMode);
            }

            public void mouseExit(MouseEvent e) {
                String viewMode = CloudDashboardContentPage.this.context.getPersistedState(CloudDashboardContentPage.KEY_DASHBOARD_CLOUD_VIEW_MODE);
                CloudDashboardContentPage.this.showViewModeImage(viewModeButton, viewMode);
            }
        });
    }

    private void showViewModeImage(Label viewModeButton, String viewMode) {
        if (VIEW_MODE_VALUE_GRID.equals(viewMode)) {
            viewModeButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_List_view.png")));
            viewModeButton.setToolTipText(SeawindMessages.CloudDashboardContentPage_Tooltip_Show_As_Icons);
        } else if (VIEW_MODE_VALUE_LIST.equals(viewMode)) {
            viewModeButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_grid_view.png")));
            viewModeButton.setToolTipText(SeawindMessages.CloudDashboardContentPage_Tooltip_Show_As_List);
        }
    }

    private void showViewModeHoverImage(Label viewModeButton, String viewMode) {
        if (VIEW_MODE_VALUE_GRID.equals(viewMode)) {
            viewModeButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_List_view_hover.png")));
            viewModeButton.setToolTipText(SeawindMessages.CloudDashboardContentPage_Tooltip_Show_As_Icons);
        } else if (VIEW_MODE_VALUE_LIST.equals(viewMode)) {
            viewModeButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_grid_view_hover.png")));
            viewModeButton.setToolTipText(SeawindMessages.CloudDashboardContentPage_Tooltip_Show_As_List);
        }
    }

    private Label createSortByNameButton(Composite parent) {
        Label sortByNameButton = new Label(parent, 0);
        sortByNameButton.setBackground(parent.getBackground());
        this.setSortNameButtonState(sortByNameButton);
        this.configSortButtonStateImage(sortByNameButton);
        this.configSortListener(sortByNameButton);
        PlatformUI.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (CloudDashboardContentPage.SORT_TYPE.equals(event.getProperty())) {
                    String type = event.getNewValue().toString();
                    if (type == null) {
                        return;
                    }
                    if (type.contains("name")) {
                        CloudDashboardContentPage.this.sortAsName();
                    } else if (type.contains("time")) {
                        CloudDashboardContentPage.this.sortAsTime();
                    }
                    IPage page = CloudDashboardContentPage.this.bodyStack.getCurrentPage();
                    if (page == null) {
                        return;
                    }
                    if (page instanceof CloudMapFolderPage) {
                        ((CloudMapFolderPage)page).refresh();
                    }
                }
            }
        });
        return sortByNameButton;
    }

    private Label createSortByTimeButton(Composite parent) {
        Label sortByTimeButton = new Label(parent, 0);
        sortByTimeButton.setBackground(parent.getBackground());
        this.setSortTimeButtonState(sortByTimeButton);
        this.configSortButtonStateImage(sortByTimeButton);
        this.configSortListener(sortByTimeButton);
        return sortByTimeButton;
    }

    private void configSortListener(Label sortByButton) {
        sortByButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.getSource() == CloudDashboardContentPage.this.sortByNameButton) {
                    CloudDashboardContentPage.this.sortAsName();
                } else if (e.getSource() == CloudDashboardContentPage.this.sortByTimeButton) {
                    CloudDashboardContentPage.this.sortAsTime();
                }
                IPage page = CloudDashboardContentPage.this.bodyStack.getCurrentPage();
                if (page == null) {
                    return;
                }
                if (page instanceof CloudMapFolderPage) {
                    ((CloudMapFolderPage)page).refresh();
                }
            }
        });
    }

    private void configSortButtonStateImage(final Label sortByButton) {
        sortByButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (e.getSource() == CloudDashboardContentPage.this.sortByNameButton) {
                    CloudDashboardContentPage.this.setSortNameButtonState(sortByButton);
                } else if (e.getSource() == CloudDashboardContentPage.this.sortByTimeButton) {
                    CloudDashboardContentPage.this.setSortTimeButtonState(sortByButton);
                }
            }

            public void mouseEnter(MouseEvent e) {
                String stateIcon = "";
                String tip = "";
                if (e.getSource() == CloudDashboardContentPage.this.sortByNameButton) {
                    stateIcon = CloudDashboardContentPage.this.sortNameAsAsc ? "ic_sort_by_name_asc_hover.png" : "ic_sort_by_name_desc_hover.png";
                    tip = CloudDashboardContentPage.this.sortNameAsAsc ? SeawindMessages.SortByNameTip_ASC : SeawindMessages.SortByNameTip_DESC;
                } else if (e.getSource() == CloudDashboardContentPage.this.sortByTimeButton) {
                    stateIcon = CloudDashboardContentPage.this.sortModiTimeAsAsc ? "ic_sort_by_time_asc_hover.png" : "ic_sort_by_time_desc_hover.png";
                    tip = CloudDashboardContentPage.this.sortModiTimeAsAsc ? SeawindMessages.SortByTimeTip_ASC : SeawindMessages.SortByTimeTip_DESC;
                }
                sortByButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(stateIcon)));
                sortByButton.setToolTipText(tip);
            }
        });
    }

    private void setSortNameButtonState(Label sortByButton) {
        String sortType = this.context.getPersistedState(SORT_TYPE);
        if (sortType == null) {
            sortType = "by_modification_time_desc";
        }
        String stateIcon = null;
        stateIcon = sortType.equals("by_name_asc") ? "ic_sort_by_name_reverse_highlight.png" : (sortType.equals("by_name_desc") ? "ic_sort_by_name_highlight.png" : (this.sortNameAsAsc ? "ic_sort_by_name_asc.png" : "ic_sort_by_name_desc.png"));
        sortByButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(stateIcon)));
    }

    private void setSortTimeButtonState(Label sortByButton) {
        String sortType = this.context.getPersistedState(SORT_TYPE);
        if (sortType == null) {
            sortType = "by_modification_time_desc";
        }
        String stateIcon = null;
        stateIcon = sortType.equals("by_modification_time_asc") ? "ic_sort_by_time_reverse_highlight.png" : (sortType.equals("by_modification_time_desc") ? "ic_sort_by_time_highlight.png" : (this.sortModiTimeAsAsc ? "ic_sort_by_time_asc.png" : "ic_sort_by_time_desc.png"));
        sortByButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(stateIcon)));
    }

    private void sortAsTime() {
        String stateIcon;
        String sortType = this.context.getPersistedState(SORT_TYPE);
        if (sortType == null) {
            sortType = "by_modification_time_desc";
        }
        if (sortType.equals("by_modification_time_asc") || sortType.equals("by_modification_time_desc")) {
            this.sortModiTimeAsAsc = !this.sortModiTimeAsAsc;
        }
        String string = sortType = this.sortModiTimeAsAsc ? "by_modification_time_asc" : "by_modification_time_desc";
        if (this.context != null) {
            this.context.setPersistedState(SORT_TYPE, sortType);
        }
        String string2 = stateIcon = this.sortModiTimeAsAsc ? "ic_sort_by_time_reverse_highlight.png" : "ic_sort_by_time_highlight.png";
        if (this.sortByTimeButton.isDisposed()) {
            return;
        }
        this.sortByTimeButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(stateIcon)));
        this.setSortNameButtonState(this.sortByNameButton);
    }

    private void sortAsName() {
        String stateIcon;
        String sortType = this.context.getPersistedState(SORT_TYPE);
        if (sortType == null) {
            sortType = "by_modification_time_desc";
        }
        if (sortType.equals("by_name_asc") || sortType.equals("by_name_desc")) {
            this.sortNameAsAsc = !this.sortNameAsAsc;
        }
        String string = sortType = this.sortNameAsAsc ? "by_name_asc" : "by_name_desc";
        if (this.context != null) {
            this.context.setPersistedState(SORT_TYPE, sortType);
        }
        String string2 = stateIcon = this.sortNameAsAsc ? "ic_sort_by_name_reverse_highlight.png" : "ic_sort_by_name_highlight.png";
        if (this.sortByNameButton.isDisposed()) {
            return;
        }
        this.sortByNameButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(stateIcon)));
        this.setSortTimeButtonState(this.sortByTimeButton);
    }

    private void createSyncButton(Composite parent) {
        this.syncButton = new Label(parent, 0);
        this.syncButton.setBackground(parent.getBackground());
        this.syncButton.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_sync.png")));
        this.syncButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!CloudDashboardContentPage.this.library.isSyncing()) {
                    CloudDashboardContentPage.this.library.sync();
                }
            }
        });
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)this.syncButton);
        this.syncButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (!CloudDashboardContentPage.this.library.isSyncing()) {
                    CloudDashboardContentPage.this.syncButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_sync.png")));
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (!CloudDashboardContentPage.this.library.isSyncing()) {
                    CloudDashboardContentPage.this.syncButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_sync_hover.png")));
                }
            }
        });
    }

    private void createAccountItemButton(Composite parent) {
        this.accountItem = this.createAvatarLabel(parent);
        this.accountItem.setBackground(parent.getBackground());
        this.accountItem.setForeground(parent.getForeground());
        GridDataFactory.swtDefaults().align(0x1000008, 4).grab(true, true).applyTo(this.accountItem);
        this.accountItem.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CloudDashboardContentPage.this.openAccountInfo();
            }
        });
    }

    private Control createAvatarLabel(Composite composite) {
        this.avatarLabel = new Canvas(composite, 524288);
        this.avatarLabel.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(24, 24);
            }
        });
        this.avatarLabel.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(24, 24).minSize(24, 24).grab(false, false).applyTo((Control)this.avatarLabel);
        this.avatarImage = new Image[1];
        this.avatarImage[0] = (Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("default_account.png"));
        final Color lineColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_AVATAR_OUTLINE));
        this.avatarLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control c = (Control)e.widget;
                Rectangle r = c.getBounds();
                Image image = CloudDashboardContentPage.this.avatarImage[0];
                if (image == null || image.isDisposed()) {
                    return;
                }
                Rectangle b = image.getBounds();
                CloudDashboardContentPage.this.drawAvatarImage(e.gc, image, b.width, b.height, r.width, r.height, 1.0f, lineColor);
            }
        });
        this.updateAvatarLabel();
        return this.avatarLabel;
    }

    private void updateAvatarLabel() {
        String emailHash;
        this.avatarImage[0] = (Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("default_account.png"));
        if (this.avatarLabel != null && !this.avatarLabel.isDisposed()) {
            this.avatarLabel.redraw();
        }
        if ((emailHash = (String)this.account.getProperty("emailhash")) != null) {
            final Display display = Display.getCurrent();
            final Job job = Activator.getDefault().createJob(SeawindMessages.AccountInfoDialog_downloadAvatar_jobName, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CloudDashboardContentPage.this.doDownloadAvatarImage(monitor, emailHash, display, CloudDashboardContentPage.this.avatarImage, CloudDashboardContentPage.this.avatarLabel);
                }
            });
            job.schedule();
            this.avatarLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    job.cancel();
                }
            });
        }
    }

    private void drawAvatarImage(GC gc, Image image, float imageWidth, float imageHeight, float controlWidth, float controlHeight, float lineWidth, Color lineColor) {
        float widthScale = controlWidth / imageWidth;
        float heightScale = controlHeight / imageHeight;
        float scale = Math.min(widthScale, heightScale);
        Transform t = new Transform(gc.getDevice());
        try {
            t.scale(scale, scale);
            t.translate((controlWidth - scale * imageWidth) / 2.0f, (controlHeight - scale * imageHeight) / 2.0f);
            if (!t.isIdentity()) {
                gc.setTransform(t);
            }
            Path clipPath = new Path(gc.getDevice());
            try {
                clipPath.addArc(lineWidth / 2.0f, lineWidth / 2.0f, imageWidth - lineWidth, imageHeight - lineWidth, 0.0f, 360.0f);
                gc.setClipping(clipPath);
                gc.drawImage(image, 0, 0);
            }
            finally {
                gc.setClipping(null);
                clipPath.dispose();
            }
            gc.setAlpha(208);
            gc.setBackground(lineColor);
            clipPath = new Path(gc.getDevice());
            try {
                clipPath.addArc(0.0f, 0.0f, imageWidth, imageHeight, 0.0f, 360.0f);
                clipPath.addArc(lineWidth, lineWidth, imageWidth - lineWidth - lineWidth, imageHeight - lineWidth - lineWidth, 0.0f, -360.0f);
                gc.setClipping(clipPath);
                gc.fillRectangle(0, 0, (int)imageWidth, (int)imageHeight);
            }
            finally {
                gc.setClipping(null);
                clipPath.dispose();
            }
        }
        finally {
            gc.setTransform(null);
            t.dispose();
        }
    }

    public void doDownloadAvatarImage(IProgressMonitor monitor, final String emailHash, Display display, final Image[] images, final Canvas label) throws InvocationTargetException, InterruptedException {
        URL url;
        try {
            url = new URL(EncodingUtils.format((String)AVATAR_URL, (Object[])new Object[]{emailHash, 24}));
        }
        catch (MalformedURLException e) {
            throw new InvocationTargetException(e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        final File[] avatarFile = new File[]{null};
        HttpRequest request = new HttpRequest(url, "GET", null, null, null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    File file;
                    avatarFile[0] = file = CloudDashboardContentPage.this.createAvatarStorageFile(emailHash, request);
                    entity.writeTo((OutputStream)new FileOutputStream(file));
                }
            }
        });
        try {
            request.execute(monitor);
        }
        catch (HttpException e) {
            if (e.getCode() == 404) {
                return;
            }
            if (e.getCode() < 100) {
                return;
            }
            throw new InvocationTargetException(e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (avatarFile[0] == null) {
            return;
        }
        if (label.isDisposed()) {
            return;
        }
        images[0] = new Image((Device)display, avatarFile[0].getAbsolutePath());
        if (label.isDisposed()) {
            images[0].dispose();
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!label.isDisposed()) {
                    label.redraw();
                } else {
                    Image img = images[0];
                    if (img != null) {
                        img.dispose();
                    }
                }
            }
        });
    }

    private File createAvatarStorageFile(String emailHash, HttpRequest request) throws IOException {
        File file = avatarStorageLocation != null ? avatarStorageLocation.append(emailHash).toFile() : File.createTempFile(emailHash, "");
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        return file;
    }

    private Control createBody(Composite parent) {
        PageStack stack = new PageStack();
        stack.createControl(parent);
        stack.getControl().setBackground(parent.getBackground());
        this.bodyStack = stack;
        return stack.getControl();
    }

    private void openAccountInfo() {
        if (this.account != null) {
            new AccountInfoDialog(this.getControl().getShell(), this.account).open();
        }
    }

    private void handleDispose() {
        this.library.removeLibraryListener(this.libraryListener);
    }

    private void updateAll() {
        this.updateWithContent(this.library.getUserName(), this.library.isSyncing(), this.library.getGlobalSyncError(), null);
        this.updateAvatarLabel();
    }

    private void updateWithContent(String userName, boolean syncing, String syncError, Object selected) {
        ISelectionProvider selectionProvider;
        boolean hadFocus = SWTUtils.isInside((Control)this.getControl(), (Control)Display.getCurrent().getFocusControl());
        this.updateSyncStatus(userName, syncing, syncError);
        this.updateTitleBar();
        this.showPage();
        if (this.collectionPage != null) {
            this.collectionPage.updatePage();
        }
        if (hadFocus) {
            this.setFocus();
        }
        if (selected instanceof SeawindFolder && this.collectionPage != null && (selectionProvider = this.collectionPage.getAdapter(ISelectionProvider.class)) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection(selected));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPage() {
        SeawindFolder rootFolder;
        Object object = this.library.getSeawindFolderLock();
        synchronized (object) {
            rootFolder = this.library.getSeawindFolderManager().getRootSeawindFolder();
        }
        if (rootFolder.isEmpty() || rootFolder.getFolders().size() == 0 && this.library.getWorkingSet().getWorkbooks().size() == 0) {
            if (this.welcomePage == null) {
                this.welcomePage = new WelcomePage();
                this.welcomePage.createControl(this.bodyStack.getStackComposite());
            }
            this.bodyStack.showPage(this.welcomePage);
        } else {
            if (this.collectionPage == null) {
                this.collectionPage = new CloudMapFolderPage(this.context, this.library);
                this.collectionPage.createControl(this.bodyStack.getStackComposite());
            }
            this.bodyStack.showPage((IPage)this.collectionPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTitleBar() {
        SeawindFolder input;
        Object object = this.library.getSeawindFolderLock();
        synchronized (object) {
            SeawindFolderManager manager = this.library.getSeawindFolderManager();
            input = manager.getSeawindFolder(manager.getCurrentFolderPath());
        }
        this.updatePathSection(input);
        this.newFolderButton.setEnabled(input != null && input.getPath().equals(this.library.getSeawindFolderManager().getRootSeawindFolder().getPath()));
        int mapCount = this.getCoundOfMaps(input);
        this.contentSummaryLabel.setText(NLS.bind((String)(mapCount > 1 ? SeawindMessages.CloudDashboardPage_LibrarySummary_withMapCount_items : SeawindMessages.CloudDashboardPage_LibrarySummary_withMapCound_item), (Object)mapCount));
        this.titleBar.layout(true, true);
    }

    private int getCoundOfMaps(SeawindFolder folder) {
        ArrayList<IWorkbookRef> elements = new ArrayList<IWorkbookRef>();
        Set files = folder.getFiles();
        for (SeawindFile sf : files) {
            IWorkbookRef workbookRef = this.findWorkbookRef(sf.getIdentifier());
            if (workbookRef == null) continue;
            elements.add(workbookRef);
        }
        return elements.size();
    }

    private IWorkbookRef findWorkbookRef(String id) {
        Collection<IWorkbookRef> workbooks = this.library.getWorkbookRefs();
        for (IWorkbookRef workbook : workbooks) {
            if (!id.equals(URIUtils.getWorkbookIdFromURI(workbook.getURI()))) continue;
            return workbook;
        }
        return null;
    }

    private void updatePathSection(SeawindFolder input) {
        this.pathComposite.setRedraw(false);
        List<SeawindFolder> folders = new ArrayList<SeawindFolder>();
        SeawindFolder folder = input;
        while (folder != null) {
            folders.add(0, folder);
            folder = folder.getOwnedParent();
        }
        folders = this.ellipsis(folders);
        this.showPath(folders);
        this.pathComposite.setRedraw(true);
    }

    private List<SeawindFolder> ellipsis(List<SeawindFolder> folders) {
        if (folders.size() <= 4) {
            return folders;
        }
        this.showPath(folders);
        if (!this.isOverLength()) {
            return folders;
        }
        folders.add(1, EMPTY_FOLDER);
        folders.remove(2);
        this.showPath(folders);
        while (this.isOverLength() && folders.size() > 4) {
            folders.remove(2);
            this.showPath(folders);
        }
        return folders;
    }

    private void showPath(List<SeawindFolder> folders) {
        Control[] controlArray = this.pathComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (folders.size() == 1) {
            String relatedPath = folders.get(0).getPath();
            boolean tail = folders.size() == 1;
            this.createPathLabel(this.pathComposite, SeawindMessages.CloudDashboardContentPage_XMind_Cloud, relatedPath, false, tail);
            this.createNumberOfMapsLabel(this.pathComposite);
        }
        int i = 1;
        while (i < folders.size()) {
            String backPath = folders.get(i - 1).getPath();
            if (i == 1) {
                this.backLabel = this.createBackLabel(this.pathComposite);
            } else if (i > 1) {
                this.createPathSeparator(this.pathComposite);
            }
            this.setBackPath(backPath, this.backLabel);
            SeawindFolder folder = folders.get(i);
            String relatedPath = folder.getPath();
            boolean ellipsis = folder == EMPTY_FOLDER;
            boolean tail = i == folders.size() - 1;
            this.createPathLabel(this.pathComposite, folder.getTitle(), relatedPath, ellipsis, tail);
            this.createNumberOfMapsLabel(this.pathComposite);
            ++i;
        }
        ((GridLayout)this.pathComposite.getLayout()).numColumns = this.pathComposite.getChildren().length;
    }

    private boolean isOverLength() {
        Composite leftBar = this.pathComposite.getParent().getParent();
        Point size = leftBar.getSize();
        Point size2 = leftBar.computeSize(-1, -1);
        return size.x == 0 ? false : size2.x > size.x;
    }

    private void createNumberOfMapsLabel(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setForeground(parent.getForeground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, Util.isMac() ? 2 : 0, 0).applyTo(container);
        Label label = new Label(container, 0);
        label.setBackground(parent.getBackground());
        label.setForeground((Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#8f8f8f")));
        label.setFont(this.resources.createFont(FontDescriptor.createFrom((FontData[])FontUtils.newHeight((FontData[])label.getFont().getFontData(), (int)(Util.isMac() ? 11 : 9)))));
        this.contentSummaryLabel = label;
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)label);
    }

    private void createPathLabel(Composite parent, String text, final String path, boolean ellipsis, final boolean tail) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setForeground(parent.getForeground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        final Label label = new Label(container, 0);
        label.setBackground(parent.getBackground());
        final Color foreground = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)(tail ? COLOR_TITLE_BAR_TEXT : "#929292")));
        label.setForeground(foreground);
        label.setFont((Font)JFaceResources.getResources().get((DeviceResourceDescriptor)JFaceResources.getHeaderFontDescriptor().increaseHeight(-1)));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)label);
        if (!ellipsis) {
            label.setToolTipText(text);
            text = text.length() <= 15 ? text : String.valueOf(text.substring(0, 11)) + "..." + text.substring(text.length() - 1);
            label.setText(text);
        } else {
            label.setText("...");
        }
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, true).applyTo((Control)label);
        if (!ellipsis) {
            label.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    label.setForeground(foreground);
                }

                public void mouseEnter(MouseEvent e) {
                    label.setForeground((Color)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)(tail ? "#4c4c4c" : "#a7a7a7"))));
                }
            });
            label.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    CloudDashboardContentPage.this.library.setCurrentFolderPath(path);
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }
    }

    private void createPathSeparator(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setForeground(parent.getForeground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        Label separatorlabel = new Label(container, 0);
        separatorlabel.setBackground(parent.getBackground());
        separatorlabel.setForeground(parent.getForeground());
        separatorlabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("path_split.png")));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, true).applyTo((Control)separatorlabel);
    }

    private Label createBackLabel(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        container.setForeground(parent.getForeground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        final Label backLabel = new Label(container, 0);
        backLabel.setBackground(parent.getBackground());
        backLabel.setForeground(parent.getForeground());
        GridData gridData = new GridData(16384, 0x1000000, true, true);
        backLabel.setLayoutData((Object)gridData);
        backLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_back.png")));
        backLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                backLabel.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_back.png")));
            }

            public void mouseEnter(MouseEvent e) {
                backLabel.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_back_hover.png")));
            }
        });
        return backLabel;
    }

    private void setBackPath(final String path, Label backLabel) {
        backLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CloudDashboardContentPage.this.library.setCurrentFolderPath(path);
            }
        });
    }

    private void updateSyncStatus(String userName, boolean syncing, String syncError) {
        this.accountItem.setToolTipText(userName == null ? "" : userName);
        if (syncing) {
            this.startSyncingAnimation();
            this.syncButton.setToolTipText(SeawindMessages.CloudDashboardPage_SyncButton_text_whenSyncing);
        } else {
            this.cancelSyncingAnimation();
            this.syncButton.setToolTipText(SeawindMessages.CloudDashboardPage_SyncButton_text);
        }
        this.syncErrorLabel.setToolTipText(syncError);
        boolean visible = syncError != null;
        this.syncErrorLabel.setVisible(visible);
        this.titleBar.layout(true, true);
    }

    private void startSyncingAnimation() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.count = 0;
            TimerTask task = this.createSyncingAnimationTask(this.syncButton, 10);
            this.timer.schedule(task, 50L, 50L);
        }
    }

    private void cancelSyncingAnimation() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.syncButton != null && !this.syncButton.isDisposed()) {
            this.syncButton.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CloudDashboardContentPage.this.syncButton != null && !CloudDashboardContentPage.this.syncButton.isDisposed()) {
                        CloudDashboardContentPage.this.syncButton.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("ic_sync.png")));
                    }
                }
            });
        }
    }

    private TimerTask createSyncingAnimationTask(final Label imageLabel, final int totalImage) {
        final Display display = imageLabel.getDisplay();
        return new TimerTask(){

            @Override
            public void run() {
                if (display == null) {
                    CloudDashboardContentPage.this.timer.cancel();
                    CloudDashboardContentPage.this.timer = null;
                    return;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (imageLabel == null || imageLabel.isDisposed()) {
                            if (CloudDashboardContentPage.this.timer != null) {
                                CloudDashboardContentPage.this.timer.cancel();
                                CloudDashboardContentPage.this.timer = null;
                            }
                        } else {
                            String imagePath = "sync_" + CloudDashboardContentPage.this.count % totalImage + ".png";
                            imageLabel.setImage((Image)CloudDashboardContentPage.this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("syncing/" + imagePath)));
                            CloudDashboardContentPage cloudDashboardContentPage = CloudDashboardContentPage.this;
                            cloudDashboardContentPage.count = cloudDashboardContentPage.count + 1;
                        }
                    }
                });
            }
        };
    }

    public void onAuthenticated(IAccount account) {
        final Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                CloudDashboardContentPage.this.updateAll();
            }
        });
    }

    public void onUnauthenticated(IAccount account) {
        final Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                CloudDashboardContentPage.this.updateAll();
            }
        });
    }

    private void importFrom(URI sourceURI) {
        final IWorkbookRef sourceWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(sourceURI, null);
        final ProgressMonitorDialog runner = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        runner.setCancelable(true);
        runner.setOpenOnRun(false);
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                try {
                    runner.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            boolean closed = false;
                            try {
                                sourceWorkbookRef.open((IProgressMonitor)subMonitor.newChild(39));
                                String sourceName = sourceWorkbookRef.getName();
                                SeawindLibrary library = SeawindUIPlugin.getSeawindLibrary();
                                URI newWorkbookURI = library.createNewWorkbookRefURI(sourceName, false);
                                IWorkbookRef newWorkbookRef = library.createWorkbookRef(newWorkbookURI, null, false);
                                Assert.isTrue((newWorkbookRef != null ? 1 : 0) != 0);
                                newWorkbookRef.importFrom((IProgressMonitor)subMonitor.newChild(60), sourceWorkbookRef);
                            }
                            finally {
                                if (!closed) {
                                    subMonitor.setWorkRemaining(1);
                                    sourceWorkbookRef.close((IProgressMonitor)subMonitor.newChild(1));
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {}
            }

            public void handleException(Throwable e) {
                CoreException coreEx = CloudDashboardContentPage.this.getCoreException(e);
                if (coreEx != null) {
                    int exType = coreEx.getType();
                    if (exType == 17) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)SeawindMessages.CloudDashboardPage_ImportErrorDialog_title, (String)NLS.bind((String)SeawindMessages.CloudDashboardPage_ImportErrorDialog_WrongPassword_message_withWorkbookName, (Object)sourceWorkbookRef.getName()));
                        return;
                    }
                    if (exType == 100) {
                        return;
                    }
                }
                super.handleException(e);
            }
        });
    }

    private CoreException getCoreException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return this.getCoreException(e.getCause());
    }

    private void importXMindFiles() {
        List sourceFiles = DialogUtils.openXMindFiles((Shell)Display.getCurrent().getActiveShell(), (int)2);
        if (!sourceFiles.isEmpty()) {
            ArrayList<URI> sourceURIs = new ArrayList<URI>(sourceFiles.size());
            for (File file : sourceFiles) {
                sourceURIs.add(file.toURI());
            }
            for (URI sourceURI : sourceURIs) {
                this.importFrom(sourceURI);
            }
        }
    }
}

