/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmind.core.CoreException;
import org.xmind.core.IFileEntry;
import org.xmind.core.IIdentifiable;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.io.IInputSource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.plain.Manifest;
import org.xmind.core.plain.Marker;
import org.xmind.core.plain.MarkerGroup;
import org.xmind.core.plain.WorkbookMarkerResource;
import org.xmind.core.util.ObjectRegistry;

public class MarkerSheet
implements IMarkerSheet,
ICoreEventSource {
    private final ObjectRegistry objectRegistry;
    private final ICoreEventSupport eventSupport;
    private final List<IMarkerGroup> markerGroups;
    private final Manifest manifest;
    private IMarkerSheet parentSheet;

    public MarkerSheet(ObjectRegistry objectRegistry, ICoreEventSupport eventSupport, Manifest manifest) {
        this.objectRegistry = objectRegistry;
        this.eventSupport = eventSupport;
        this.markerGroups = new ArrayList<IMarkerGroup>();
        this.manifest = manifest;
        this.parentSheet = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ObjectRegistry.class.equals(adapter)) {
            return adapter.cast(this.objectRegistry);
        }
        if (ICoreEventSupport.class.equals(adapter)) {
            return adapter.cast(this.eventSupport);
        }
        return null;
    }

    public List<IMarkerGroup> getMarkerGroups() {
        return this.markerGroups;
    }

    public IMarkerGroup createMarkerGroup(boolean singleton) {
        MarkerGroup group = new MarkerGroup(this, this.objectRegistry.createUniqueId());
        group.setSingleton(singleton);
        this.objectRegistry.register(group);
        return group;
    }

    public IMarker createMarker(String resourcePath) {
        Marker marker = new Marker(this, this.objectRegistry.createUniqueId(), resourcePath);
        this.objectRegistry.register(marker);
        return marker;
    }

    public void addMarkerGroup(IMarkerGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("marker group to add is null");
        }
        if (group.getOwnedSheet() != this || !(group instanceof MarkerGroup)) {
            throw new IllegalArgumentException("unrecognized marker group");
        }
        if (!this.markerGroups.add(group)) {
            return;
        }
        ((MarkerGroup)group).onParented();
        int index = this.markerGroups.indexOf(group);
        this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "markerGroupAdd", (Object)group, index);
    }

    public void removeMarkerGroup(IMarkerGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("marker group to add is null");
        }
        if (group.getOwnedSheet() != this || !(group instanceof MarkerGroup)) {
            throw new IllegalArgumentException("unrecognized marker group");
        }
        int index = this.markerGroups.indexOf(group);
        if (index < 0) {
            return;
        }
        if (!this.markerGroups.remove(group)) {
            return;
        }
        ((MarkerGroup)group).onOrphan();
        this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "markerGroupRemove", (Object)group, index);
    }

    public void save(OutputStream out) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void setParentSheet(IMarkerSheet parent) {
        this.parentSheet = parent;
    }

    public IMarkerSheet getParentSheet() {
        return this.parentSheet;
    }

    public IMarkerGroup getMarkerGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        return this.objectRegistry.get(groupId, IMarkerGroup.class);
    }

    public IMarker getMarker(String markerId) {
        if (markerId == null) {
            return null;
        }
        return this.objectRegistry.get(markerId, IMarker.class);
    }

    public IMarkerGroup findMarkerGroup(String groupId) {
        IMarkerGroup group = this.getMarkerGroup(groupId);
        if (group != null) {
            return group;
        }
        if (this.parentSheet != null) {
            return this.parentSheet.findMarkerGroup(groupId);
        }
        return null;
    }

    public IMarker findMarker(String markerId) {
        IMarker marker = this.getMarker(markerId);
        if (marker != null) {
            return marker;
        }
        if (this.parentSheet != null) {
            return this.parentSheet.findMarker(markerId);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.markerGroups.isEmpty();
    }

    public boolean isPermanent() {
        return false;
    }

    public void importFrom(IInputSource source) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void importFrom(IInputSource source, String groupName) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void importFrom(String sourcePath) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    public void importFrom(IMarkerSheet sheet) {
        throw new UnsupportedOperationException();
    }

    public IMarkerGroup importGroup(IMarkerGroup group) {
        throw new UnsupportedOperationException();
    }

    public IMarkerGroup createMarkerGroupById(String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException("group id is null");
        }
        IIdentifiable existingGroup = this.objectRegistry.get(groupId);
        if (existingGroup != null) {
            if (existingGroup instanceof IMarkerGroup) {
                return (IMarkerGroup)existingGroup;
            }
            throw new IllegalArgumentException("this id is already used by another object");
        }
        MarkerGroup group = new MarkerGroup(this, groupId);
        this.objectRegistry.register(group);
        return group;
    }

    public IMarker createMarkerById(String markerId, String resourcePath) {
        if (markerId == null) {
            throw new IllegalArgumentException("marker id is null");
        }
        IIdentifiable existingMarker = this.objectRegistry.get(markerId);
        if (existingMarker != null) {
            if (existingMarker instanceof IMarker) {
                return (IMarker)existingMarker;
            }
            throw new IllegalArgumentException("this id is already used by another object");
        }
        Marker marker = new Marker(this, markerId, resourcePath);
        this.objectRegistry.register(marker);
        return marker;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.eventSupport;
    }

    protected IMarkerResource getMarkerResource(Marker marker) {
        if ("".equals(marker.getResourcePath())) {
            return null;
        }
        return new WorkbookMarkerResource(marker, this.manifest);
    }

    public String allocateMarkerResource(InputStream source, String suggestedPath) throws IOException {
        IFileEntry entry = this.manifest.createAttachmentFromStream(source, suggestedPath);
        return entry.getPath();
    }
}

