/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.plain.Marker;
import org.xmind.core.plain.MarkerSheet;

public class MarkerGroup
implements IMarkerGroup,
ICoreEventSource {
    private final MarkerSheet ownerSheet;
    private final String id;
    private String name;
    private final List<IMarker> markers;
    private boolean singleton;
    private boolean hidden;
    private boolean orphan;

    public MarkerGroup(MarkerSheet ownerSheet, String id) {
        this.ownerSheet = ownerSheet;
        this.id = id;
        this.name = null;
        this.markers = new ArrayList<IMarker>();
        this.singleton = true;
        this.hidden = false;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        if (name == oldName || name != null && name.equals(oldName)) {
            return;
        }
        this.name = name;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "name", (Object)oldName, (Object)name);
    }

    public List<IMarker> getMarkers() {
        return Collections.unmodifiableList(this.markers);
    }

    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    public IMarker getMarker(String markerId) {
        if (markerId == null) {
            return null;
        }
        for (IMarker marker : this.markers) {
            if (!markerId.equals(marker.getId())) continue;
            return marker;
        }
        return null;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public IMarkerSheet getParent() {
        if (this.orphan) {
            return null;
        }
        return this.ownerSheet;
    }

    public IMarkerSheet getOwnedSheet() {
        return this.ownerSheet;
    }

    public void addMarker(IMarker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("marker is null");
        }
        if (!(marker instanceof Marker) || marker.getOwnedSheet() != this.ownerSheet) {
            throw new IllegalArgumentException("unrecognized marker");
        }
        if (this.markers.contains(marker)) {
            return;
        }
        if (!this.markers.add(marker)) {
            return;
        }
        ((Marker)marker).setParent(this);
        if (!this.orphan) {
            int index = this.markers.indexOf(marker);
            this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "markerAdd", (Object)marker, index);
        }
    }

    public void removeMarker(IMarker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("marker is null");
        }
        if (!(marker instanceof Marker) || marker.getOwnedSheet() != this.ownerSheet) {
            throw new IllegalArgumentException("unrecognized marker");
        }
        int index = this.markers.indexOf(marker);
        if (index < 0) {
            return;
        }
        if (!this.markers.remove(marker)) {
            return;
        }
        ((Marker)marker).setParent(null);
        if (!this.orphan) {
            this.getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)this, "markerRemove", (Object)marker, index);
        }
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerSheet.getCoreEventSupport();
    }

    protected void onParented() {
        this.orphan = false;
    }

    protected void onOrphan() {
        this.orphan = true;
    }
}

