/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.Workbook;
import org.xmind.core.plain.WorkbookExtension;

public class WorkbookExtensionManager
implements IWorkbookExtensionManager {
    public static final String WorkbookExtensionAdd = "workbookExtensionAdd";
    public static final String WorkbookExtensionRemove = "workbookExtensionRemove";
    private final Workbook ownedWorkbook;
    private final Map<String, WorkbookExtension> extensions;

    public WorkbookExtensionManager(Workbook ownedWorkbook) {
        this.ownedWorkbook = ownedWorkbook;
        this.extensions = new HashMap<String, WorkbookExtension>();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    public boolean isOrphan() {
        return false;
    }

    public List<IWorkbookExtension> getExtensions() {
        return Collections.unmodifiableList(new ArrayList<WorkbookExtension>(this.extensions.values()));
    }

    public IWorkbookExtension getExtension(String providerName) {
        if (providerName != null) {
            for (IWorkbookExtension e : this.getExtensions()) {
                if (!providerName.equals(e.getProviderName())) continue;
                return e;
            }
        }
        return null;
    }

    public IWorkbookExtension createExtension(String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        WorkbookExtension ext = this.extensions.get(providerName);
        if (ext == null) {
            ext = new WorkbookExtension(this.ownedWorkbook, providerName);
            this.extensions.put(providerName, ext);
            if (!this.isOrphan()) {
                ext.onParented();
            }
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this.ownedWorkbook, WorkbookExtensionAdd, (Object)ext);
        }
        return ext;
    }

    public void deleteExtension(String providerName) {
        if (providerName == null) {
            return;
        }
        Iterator<WorkbookExtension> extIt = this.extensions.values().iterator();
        while (extIt.hasNext()) {
            WorkbookExtension ext = extIt.next();
            if (!providerName.equals(ext.getProviderName())) continue;
            if (!this.isOrphan()) {
                ext.onOrphan();
            }
            extIt.remove();
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this.ownedWorkbook, WorkbookExtensionRemove, (Object)ext);
            break;
        }
    }

    public List<String> getProviders() {
        return new ArrayList<String>(this.extensions.keySet());
    }
}

