/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Iterator;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Style;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleImpl
extends Style
implements ICoreEventSource {
    private Element implementation;
    private StyleSheetImpl ownedSheet;

    public StyleImpl(Element implementation, StyleSheetImpl ownedSheet) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedSheet = ownedSheet;
    }

    @Override
    public String getId() {
        return this.implementation.getAttribute("id");
    }

    @Override
    public String getType() {
        return this.implementation.getAttribute("type");
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StyleImpl)) {
            return false;
        }
        StyleImpl that = (StyleImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "STY#" + this.getId() + "(" + this.getName() + ")";
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.implementation);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IStyleSheet getOwnedStyleSheet() {
        return this.ownedSheet;
    }

    @Override
    public String getName() {
        Properties properties;
        String name = this.implementation.getAttribute("name");
        if (name.startsWith("%") && (properties = this.ownedSheet.getProperties()) != null) {
            String key = name.substring(1);
            name = properties.getProperty(key, name);
        }
        return name;
    }

    @Override
    public String getProperty(String key) {
        Iterator<Element> it = this.propertiesElementIter();
        while (it.hasNext()) {
            String value = DOMUtils.getAttribute(it.next(), key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Iterator<Element> propertiesElementIter() {
        return DOMUtils.childElementIterByTag(this.implementation, this.getPropertiesElementName());
    }

    @Override
    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        String propEleName = this.getPropertiesElementName();
        Element p = DOMUtils.ensureChildElement(this.implementation, propEleName);
        DOMUtils.setAttribute(p, key, value);
        String newValue = this.getProperty(key);
        this.firePropertyChange(key, oldValue, newValue);
    }

    private String getPropertiesElementName() {
        return String.valueOf(this.getType().toLowerCase()) + "-" + "properties";
    }

    @Override
    public int size() {
        Iterator<Element> it = this.propertiesElementIter();
        int size = 0;
        while (it.hasNext()) {
            size += it.next().getAttributes().getLength();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        Iterator<Element> it = this.propertiesElementIter();
        while (it.hasNext()) {
            Element propEle = it.next();
            if (!propEle.hasAttributes() && !propEle.hasChildNodes()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Property> properties() {
        return new PropertyIter();
    }

    @Override
    public void setName(String name) {
        String oldValue = this.implementation.hasAttribute("name") ? this.getName() : null;
        DOMUtils.setAttribute(this.implementation, "name", name);
        String newValue = this.implementation.hasAttribute("name") ? this.getName() : null;
        this.fireValueChange("name", oldValue, newValue);
    }

    @Override
    public Iterator<Property> defaultStyles() {
        return new DefaultStyleIter();
    }

    @Override
    public String getDefaultStyleId(String styleFamily) {
        if (styleFamily == null || "".equals(styleFamily)) {
            return null;
        }
        Iterator<Element> it = this.propertiesElementIter();
        while (it.hasNext()) {
            Iterator<Element> it2 = DOMUtils.childElementIterByTag(it.next(), "default-style");
            while (it2.hasNext()) {
                Element ds = it2.next();
                if (!styleFamily.equals(ds.getAttribute("style-family"))) continue;
                return DOMUtils.getAttribute(ds, "style-id");
            }
        }
        return null;
    }

    @Override
    public void setDefaultStyleId(String styleFamily, String styleId) {
        if (styleFamily == null || "".equals(styleFamily)) {
            return;
        }
        String propEleName = this.getPropertiesElementName();
        if (styleId != null) {
            Element p = DOMUtils.ensureChildElement(this.implementation, propEleName);
            Element ds = this.findDefaultStyleElement(p, styleFamily);
            if (ds == null) {
                ds = DOMUtils.createElement(p, "default-style");
                DOMUtils.setAttribute(ds, "style-family", styleFamily);
            }
            DOMUtils.setAttribute(ds, "style-id", styleId);
        } else {
            Node n;
            Element ds;
            Element p = DOMUtils.getFirstChildElementByTag(this.implementation, propEleName);
            if (p != null && (ds = this.findDefaultStyleElement(p, styleFamily)) != null && (n = p.removeChild(ds)) != null && !p.hasChildNodes()) {
                this.implementation.removeChild(p);
            }
        }
    }

    private Element findDefaultStyleElement(Element propEle, String styleFamily) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(propEle, "default-style");
        while (it.hasNext()) {
            Element ds = it.next();
            if (!styleFamily.equals(ds.getAttribute("style-family"))) continue;
            return ds;
        }
        return null;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    private void fireValueChange(String eventType, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, eventType, oldValue, newValue);
    }

    private void firePropertyChange(String key, String oldValue, String newValue) {
        this.getCoreEventSupport().dispatchTargetValueChange(this, "property", key, oldValue, newValue);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedSheet.getCoreEventSupport();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultStyleIter
    implements Iterator<Property> {
        Iterator<Element> propEleIt;
        Element propEle;
        Iterator<Element> defaultStyleEleIt;
        Property next;

        private DefaultStyleIter() {
            this.propEleIt = StyleImpl.this.propertiesElementIter();
            this.propEle = null;
            this.defaultStyleEleIt = null;
            this.next = this.findNextDefaultStyle();
        }

        private Property findNextDefaultStyle() {
            if (this.defaultStyleEleIt != null) {
                while (this.defaultStyleEleIt.hasNext()) {
                    Element defaultStyleEle = this.defaultStyleEleIt.next();
                    String family = DOMUtils.getAttribute(defaultStyleEle, "style-family");
                    if (family == null) continue;
                    String styleId = DOMUtils.getAttribute(defaultStyleEle, "style-id");
                    return new Property(family, styleId);
                }
            }
            if (this.propEleIt.hasNext()) {
                this.propEle = this.propEleIt.next();
                this.defaultStyleEleIt = DOMUtils.childElementIterByTag(this.propEle, "default-style");
                return this.findNextDefaultStyle();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Property next() {
            if (this.next == null) {
                return this.next;
            }
            Property result = this.next;
            this.next = this.findNextDefaultStyle();
            return result;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PropertyIter
    implements Iterator<Property> {
        Iterator<Element> it;
        Element propEle;
        NamedNodeMap map;
        int index;
        Property next;

        private PropertyIter() {
            this.it = StyleImpl.this.propertiesElementIter();
            this.propEle = this.it.next();
            this.map = this.propEle == null ? null : this.propEle.getAttributes();
            this.index = 0;
            this.next = this.findNextProperty();
        }

        private Property findNextProperty() {
            if (this.map != null) {
                if (this.index < this.map.getLength()) {
                    Attr attr = (Attr)this.map.item(this.index);
                    ++this.index;
                    return new Property(attr.getName(), attr.getValue());
                }
                if (this.it.hasNext()) {
                    this.propEle = this.it.next();
                    this.map = this.propEle == null ? null : this.propEle.getAttributes();
                    this.index = 0;
                    if (this.map != null) {
                        return this.findNextProperty();
                    }
                }
            }
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public Property next() {
            if (this.next == null) {
                return this.next;
            }
            Property result = this.next;
            this.next = this.findNextProperty();
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }
    }
}

