/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.IBoundsProvider;
import org.xmind.gef.draw2d.geometry.IPositionSolver;
import org.xmind.gef.draw2d.geometry.ReferencedFigureBoundsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPositionSolver
implements IPositionSolver {
    private static final IBoundsProvider DEFAULT_BOUNDS_PROVIDER = new ReferencedFigureBoundsProvider();
    private static final Collection<Object> EMPTY_KEYS = Collections.emptySet();
    private Point origin = new Point();
    private Map<String, Set<Object>> keys = new HashMap<String, Set<Object>>();
    private Map<Object, String> categories = new HashMap<Object, String>();
    private Map<Object, Point> initPositions = new HashMap<Object, Point>();
    private Map<Object, Point> solvedPositions = new HashMap<Object, Point>();
    private Map<String, IBoundsProvider> generalBoundsProviders = new HashMap<String, IBoundsProvider>();
    private Map<Object, IBoundsProvider> boundsProvideres = new HashMap<Object, IBoundsProvider>();
    private IBoundsProvider defaultBoundsProvider = DEFAULT_BOUNDS_PROVIDER;

    @Override
    public void clear() {
        this.keys.clear();
        this.categories.clear();
        this.initPositions.clear();
        this.solvedPositions.clear();
        this.boundsProvideres.clear();
    }

    @Override
    public IBoundsProvider getBoundsProvider(Object key) {
        IBoundsProvider boundsProvider = this.boundsProvideres.get(key);
        if (boundsProvider == null) {
            return this.getGeneralBoundsProvider(this.getCategory(key));
        }
        return boundsProvider;
    }

    @Override
    public IBoundsProvider getGeneralBoundsProvider(String category) {
        IBoundsProvider boundsProvider = this.generalBoundsProviders.get(category);
        if (boundsProvider == null) {
            return this.getDefaultBoundsProvider();
        }
        return boundsProvider;
    }

    @Override
    public IBoundsProvider getDefaultBoundsProvider() {
        return this.defaultBoundsProvider;
    }

    @Override
    public String getCategory(Object key) {
        return this.categories.get(key);
    }

    @Override
    public Point getInitPosition(Object key) {
        return this.initPositions.get(key);
    }

    @Override
    public Point getSolvedPosition(Object key) {
        return this.solvedPositions.get(key);
    }

    @Override
    public Collection<String> getCategories() {
        return this.keys.keySet();
    }

    @Override
    public Collection<Object> getKeys() {
        return this.categories.keySet();
    }

    @Override
    public Collection<Object> getKeys(String category) {
        Set<Object> set = this.keys.get(category);
        if (set == null) {
            return EMPTY_KEYS;
        }
        return set;
    }

    @Override
    public void recordInitPosition(Object key, Point position, String category, boolean output) {
        if (output) {
            this.initPositions.put(key, position.getCopy());
            this.solvedPositions.put(key, position);
        } else {
            this.initPositions.put(key, position);
            this.solvedPositions.put(key, position.getCopy());
        }
        this.categories.put(key, category);
        Set<Object> set = this.keys.get(category);
        if (set == null) {
            set = new HashSet<Object>();
            this.keys.put(category, set);
        }
        set.add(key);
    }

    @Override
    public void setGeneralBoundsProvider(String category, IBoundsProvider boundsProvider) {
        this.generalBoundsProviders.put(category, boundsProvider);
    }

    @Override
    public void setBoundsProvider(Object key, IBoundsProvider boundsProvider) {
        this.boundsProvideres.put(key, boundsProvider);
    }

    @Override
    public void setDefaultBoundsProvider(IBoundsProvider boundsProvider) {
        this.defaultBoundsProvider = boundsProvider == null ? DEFAULT_BOUNDS_PROVIDER : boundsProvider;
    }

    @Override
    public Rectangle getSolvedBounds(Object key) {
        return this.getPrefBounds(key, this.getSolvedPosition(key));
    }

    protected Rectangle getPrefBounds(Object key, Point position) {
        return this.getBoundsProvider(key).getPrefBounds(key, position);
    }

    @Override
    public Point getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Point origin) {
        this.origin.setLocation(origin);
    }

    @Override
    public void setOrigin(int x, int y) {
        this.origin.setLocation(x, y);
    }
}

