/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.IBranchDoubleClickSupport;
import org.xmind.ui.branch.IBranchMoveSupport;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.spreadsheet.RowHeadEditTool;
import org.xmind.ui.internal.spreadsheet.structures.Cell2;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetColumnStructure
extends AbstractBranchStructure
implements IBranchDoubleClickSupport,
IBranchMoveSupport {
    private Set<IBranchPart> invalidatingBranches = null;

    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof Chart2;
    }

    protected Object createStructureData(IBranchPart branch) {
        return new Chart2(branch);
    }

    public Chart2 getChart(IBranchPart branch) {
        return (Chart2)((Object)super.getStructureData(branch));
    }

    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        if (!plusMinus.getFigure().isVisible()) {
            info.put(plusMinus.getFigure(), info.createInitBounds());
            return;
        }
        Point ref = info.getReference();
        int y = ref.y;
        Rectangle topicBounds = info.getCheckedClientArea();
        int x = topicBounds.right();
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        Rectangle r = new Rectangle(x, y - size.height / 2, size.width, size.height);
        info.put(pmFigure, r);
    }

    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        int majorSpacing = this.getMajorSpacing(branch);
        int minorSpacing = this.getMinorSpacing(branch);
        int halfMinorSpacing1 = minorSpacing / 2;
        int halfMinorSpacing2 = minorSpacing - halfMinorSpacing1;
        int halfMajorSpacing1 = majorSpacing / 2;
        int halfMajorSpacing2 = majorSpacing - halfMajorSpacing1;
        Rectangle area = info.getCheckedClientArea();
        int chartHeight = area.height;
        Chart2 chart = this.getChart(branch);
        int lineWidth = chart.getLineWidth();
        int x = area.x + lineWidth;
        x = chart.hasRows() ? (x += chart.getRowHeadWidth() + lineWidth + minorSpacing) : (x += lineWidth + majorSpacing);
        int y = area.bottom() + halfMinorSpacing1 + lineWidth;
        IInsertion ins = this.getCurrentInsertion(branch);
        int i = 0;
        while (i < subBranches.size()) {
            if (ins != null && i == ins.getIndex()) {
                Rectangle insArea = new Rectangle(x + halfMinorSpacing1, y, ins.getSize().width, chartHeight);
                info.add(insArea);
                x += insArea.width + minorSpacing + lineWidth;
            }
            IBranchPart subBranch = subBranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Dimension size = subBranchFigure.getPreferredSize();
            Rectangle r = new Rectangle((x += halfMinorSpacing1) + halfMajorSpacing1, y, size.width, size.height);
            info.put(subBranchFigure, r);
            x += size.width + halfMinorSpacing2;
            ++i;
        }
        if (ins != null && ins.getIndex() == subBranches.size()) {
            Rectangle insArea = new Rectangle(x, y, ins.getSize().width, chartHeight);
            info.add(insArea);
        }
        info.addMargins(lineWidth + halfMajorSpacing2, lineWidth + halfMinorSpacing2, lineWidth + halfMajorSpacing1, lineWidth + halfMinorSpacing1);
    }

    protected void invalidateBranch(IBranchPart branch) {
        super.invalidateBranch(branch);
        if (!this.isInvalidatingBranch(branch)) {
            this.addInvalidatingBranch(branch);
            for (IBranchPart sub : branch.getSubBranches()) {
                Object flag = MindMapUtils.getCache((IPart)sub, (String)"org.xmind.ui.spreadsheet.cache.invalidating");
                if (!(flag instanceof Boolean) || !((Boolean)flag).booleanValue()) {
                    this.invalidateChild(sub);
                }
                MindMapUtils.flushCache((IPart)sub, (String)"org.xmind.ui.spreadsheet.cache.invalidating");
            }
            this.removeInvalidatingBranch(branch);
        }
    }

    private void invalidateChild(IBranchPart sub) {
        sub.getFigure().invalidate();
    }

    private void removeInvalidatingBranch(IBranchPart branch) {
        this.invalidatingBranches.remove(branch);
        if (this.invalidatingBranches.isEmpty()) {
            this.invalidatingBranches = null;
        }
    }

    private void addInvalidatingBranch(IBranchPart branch) {
        if (this.invalidatingBranches == null) {
            this.invalidatingBranches = new HashSet<IBranchPart>();
        }
        this.invalidatingBranches.add(branch);
    }

    private boolean isInvalidatingBranch(IBranchPart branch) {
        return this.invalidatingBranches != null && this.invalidatingBranches.contains(branch);
    }

    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if ("navigate_up".equals(navReqType)) {
            int sourceIndex = sourceChild.getBranchIndex();
            if (!sequential && sourceIndex == 0) {
                return branch.getTopicPart();
            }
            return this.getSubTopicPart(branch, sourceIndex - 1);
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        Point pos = key.getCursorPos();
        IFigure branchFigure = branch.getFigure();
        Chart2 chart = this.getChart(branch);
        int height = chart.getColHeadHeight();
        Point topLeft = branch.getTopicPart().getFigure().getBounds().getBottomLeft();
        Rectangle r = new Rectangle(topLeft.x, topLeft.y, branchFigure.getBounds().right() - topLeft.x, height);
        if (!branch.getSubBranches().isEmpty() && !branch.isFolded() && r.contains(pos)) {
            return 1;
        }
        Point childLoc = key.getFigure().getBounds().getLocation();
        if (r.x < pos.x && r.right() > pos.x && childLoc.y > r.y && childLoc.y < r.bottom()) {
            return 1;
        }
        return -1;
    }

    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        int newIndex = this.calcInsIndex(branch, key, true);
        Dimension newSize = this.calcInsSize(key.getFigure());
        return new Insertion(branch, newIndex, newSize);
    }

    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        Point pos = key.getCursorPos();
        Chart2 chart = this.getChart(branch);
        int lineWidth = chart.getLineWidth();
        int majorSpacing = chart.getMajorSpacing();
        int minorSpacing = chart.getMinorSpacing();
        int x = branch.getFigure().getBounds().x + lineWidth * 2;
        if (!chart.getRows().isEmpty()) {
            x += chart.getRowHeadWidth() + majorSpacing;
        }
        Dimension insSize = this.calcInsSize(key.getFigure());
        int insWidth = insSize.width + lineWidth + minorSpacing;
        List subbranches = branch.getSubBranches();
        int num = subbranches.size();
        int ret = 0;
        for (IBranchPart subBranch : branch.getSubBranches()) {
            IFigure subFigure = subBranch.getFigure();
            int w = subFigure.getSize().width + lineWidth + minorSpacing;
            int hint = x + (w + insWidth) / 2;
            if (pos.x < hint) {
                return ret;
            }
            if (withDisabled || subFigure.isEnabled()) {
                ++ret;
            }
            x += w;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IReferencedFigure child) {
        return child.getSize().scale(0.8);
    }

    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 16;
    }

    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return 4;
    }

    public int getSourceOrientation(IBranchPart branch) {
        return 0;
    }

    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return 0;
    }

    public boolean handleDoubleClick(IBranchPart branch, Point pos) {
        Chart2 chart = this.getChart(branch);
        Cell2 cell = chart.findCell(pos);
        if (cell != null) {
            this.handleDoubleClickInCell(cell);
        } else {
            RowHead rowHead = chart.findRowHead(pos);
            if (rowHead != null) {
                this.handleDoubleClickInColumnHead(chart, rowHead);
            }
        }
        return true;
    }

    private void handleDoubleClickInColumnHead(Chart2 chart, RowHead rowHead) {
        ITool tool;
        IBranchPart chartBranch = chart.getTitle();
        EditDomain domain = chartBranch.getSite().getDomain();
        if (domain != null && (tool = domain.getTool("org.xmind.ui.spreadsheet.tool.rowHeadEditTool")) != null && tool instanceof RowHeadEditTool) {
            RowHeadEditTool editTool = (RowHeadEditTool)tool;
            editTool.setTargetViewer(chartBranch.getSite().getViewer());
            domain.setActiveTool("org.xmind.ui.spreadsheet.tool.rowHeadEditTool");
            if (domain.getActiveTool() == editTool) {
                domain.handleRequest(new Request("edit").setPrimaryTarget((IPart)chartBranch).setViewer(chartBranch.getSite().getViewer()).setParameter("chart", (Object)chart).setParameter("rowHead", (Object)rowHead).setParameter("row", (Object)chart.findRow(rowHead)));
            }
        }
    }

    private void handleDoubleClickInCell(Cell2 cell) {
        IBranchPart rowBranch = cell.getOwnedColumn().getHead();
        ITopicPart rowTopic = rowBranch.getTopicPart();
        if (rowTopic == null) {
            return;
        }
        EditDomain domain = rowTopic.getSite().getDomain();
        if (domain == null) {
            return;
        }
        Request request = new Request("create_child");
        request.setDomain(domain);
        request.setViewer(rowTopic.getSite().getViewer());
        request.setPrimaryTarget((IPart)rowTopic);
        request.setParameter("withAnimation", (Object)Boolean.TRUE);
        request.setParameter("property.labels", cell.getOwnedRow().getHead().getLabels());
        domain.handleRequest(request);
    }

    public boolean canMove(IBranchPart branch, MouseDragEvent me) {
        Chart2 chart = this.getChart(branch);
        RowHead rowHead = chart.findRowHead(me.startingLocation);
        if (rowHead != null) {
            MindMapUtils.setCache((IPart)branch, (String)"org.xmind.ui.spreadsheet.cache.moveSourceRowHead", (Object)rowHead);
            return true;
        }
        return false;
    }

    public String getMoveTool(IBranchPart branch, MouseDragEvent me) {
        return "org.xmind.ui.spreadsheet.tool.moveRow";
    }

    public int calcRowInsertionIndex(IBranchPart branch, Point pos) {
        Chart2 chart = this.getChart(branch);
        IInsertion rowIns = (IInsertion)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.spreadsheet.cache.rowInsertion");
        int insHeight = rowIns == null ? 0 : rowIns.getSize().height + chart.getMinorSpacing();
        List<Row2> rows = chart.getRows();
        int lineWidth = chart.getLineWidth();
        int y = chart.getTitle().getFigure().getBounds().y + chart.getTitleAreaHeight() + lineWidth + chart.getColHeadHeight() + chart.getMajorSpacing();
        int index = 0;
        while (index < rows.size()) {
            Row2 row = rows.get(index);
            int colHeight = row.getHeight();
            int h = colHeight + insHeight / (rows.size() + 1);
            if (pos.y < y + h / 2) {
                return index;
            }
            y += h + lineWidth;
            ++index;
        }
        return rows.size();
    }

    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 16) {
            return 1;
        }
        if (direction == 8) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List subBranches = branch.getSubBranches();
        int index = this.calcInsIndex(branch, key, true);
        IBranchPart sub = index == subBranches.size() ? (IBranchPart)subBranches.get(subBranches.size() - 1) : (IBranchPart)subBranches.get(index);
        int deltaX = 0;
        deltaX = index == subBranches.size() ? (key.getInvent().getSize().width + sub.getFigure().getSize().width) / 2 + this.getMinorSpacing(branch) : (key.getInvent().getSize().width - sub.getFigure().getSize().width) / 2 - key.getFigure().getSize().scale((double)0.8).width - this.getMinorSpacing(branch);
        return this.getFigureLocation(sub.getFigure()).getTranslated(deltaX, (key.getFigure().getSize().height - sub.getTopicPart().getFigure().getSize().height) / 2);
    }

    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List subBranches = branch.getSubBranches();
        List disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        Dimension inventSize = key.getInvent().getSize();
        if (index == oldIndex) {
            return this.getFigureLocation(((IBranchPart)subBranches.get(index)).getFigure()).getTranslated((inventSize.width - ((IBranchPart)subBranches.get((int)index)).getTopicPart().getFigure().getSize().width) / 2, 0);
        }
        return this.calcInsertPosition(branch, child, key);
    }
}

