/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.style.IStyled;
import org.xmind.gef.command.Command;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.properties.IPropertyPartContainer;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyStyleCommand;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.e4models.ViewModelFolderRenderer;
import org.xmind.ui.internal.e4models.ViewModelPart;
import org.xmind.ui.internal.properties.PropertySectionContributorManager;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;

public class PropertiesPart
extends ViewModelPart
implements ISelectionChangedListener,
IPropertyPartContainer,
IContributedContentsView {
    private static final int DEFAULT_SECTION_WIDTH = 200;
    private IGraphicalEditor sourceEditor;
    private static PropertySectionContributorManager manager = PropertySectionContributorManager.getInstance();
    private List<SectionRecord> sections = new ArrayList<SectionRecord>();
    private CTabItem ti;
    private String modeLabel;
    private Composite composite;
    private PageBook viewerStack;
    private Control defaultPage;
    private Composite contentComposite;
    private WidgetFactory widgetFactory;
    private ScrolledForm form;
    private String title;
    private Hyperlink resetStyleControl;
    private ResourceManager resources;

    protected void init() {
        super.init();
        EModelService modelService = (EModelService)this.getAdapter(EModelService.class);
        MApplication application = (MApplication)this.getAdapter(MApplication.class);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("Editor");
        tags.add("active");
        List editors = modelService.findElements((MUIElement)application, "org.eclipse.e4.ui.compatibility.editor", MPart.class, tags);
        if (editors != null && !editors.isEmpty()) {
            MPart editor = (MPart)editors.get(0);
            this.handlePartActivated(editor);
        }
        this.initContent();
    }

    private void initContent() {
        ISelectionProvider selectionProvider;
        for (SectionRecord rec : this.sections) {
            rec.section.init((IPropertyPartContainer)this, this.getContributedEditor());
        }
        if (this.sourceEditor != null && this.sourceEditor != null && (selectionProvider = this.sourceEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            final ISelection selection = selectionProvider.getSelection();
            if (selection != null && !selection.isEmpty()) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PropertiesPart.this.selectionChanged(new SelectionChangedEvent(selectionProvider, selection));
                    }
                });
            }
        }
    }

    protected void createContent(Composite parent) {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ShowFormatPartCount");
        CTabFolder ctf = new CTabFolder(parent, 2048);
        ctf.setRenderer((CTabFolderRenderer)new ViewModelFolderRenderer(ctf));
        ctf.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ti = new CTabItem(ctf, 0);
        MPart partModel = (MPart)this.getAdapter(MPart.class);
        this.modeLabel = partModel.getLocalizedLabel();
        this.ti.setText(this.modeLabel);
        ctf.setSelection(this.ti);
        Composite contentContainer = new Composite((Composite)ctf, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        contentContainer.setLayout((Layout)layout);
        this.ti.setControl((Control)contentContainer);
        Control content = this.doCreateContent(contentContainer);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addTopRight(ctf, true);
        this.adjustViewMenuBar(true);
    }

    protected Control doCreateContent(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerStack = new PageBook(composite, 0);
        this.viewerStack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPage = this.createDefaultPage((Composite)this.viewerStack);
        this.contentComposite = new Composite((Composite)this.viewerStack, 0);
        GridLayout contantLayout = new GridLayout();
        contantLayout.marginWidth = 0;
        contantLayout.marginHeight = 0;
        contantLayout.verticalSpacing = 0;
        contantLayout.horizontalSpacing = 0;
        this.contentComposite.setLayout((Layout)contantLayout);
        this.contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.widgetFactory = new WidgetFactory(this.contentComposite.getDisplay());
        this.form = this.widgetFactory.createScrolledForm(this.contentComposite);
        this.addHorizontalScrollSupport(this.form);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.setMinWidth(200);
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PropertiesPart.this.widgetFactory != null) {
                    PropertiesPart.this.widgetFactory.dispose();
                    PropertiesPart.this.widgetFactory = null;
                }
            }
        });
        this.createSectionControls(this.form, this.form.getBody());
        Composite internalComposite = new Composite(this.form.getBody(), 0);
        internalComposite.setBackground(this.form.getBody().getBackground());
        internalComposite.setLayout((Layout)new GridLayout(1, false));
        internalComposite.setLayoutData((Object)new GridData(4, 1024, true, true));
        this.createExtendSectionControls(this.widgetFactory, internalComposite);
        this.form.reflow(true);
        this.viewerStack.showPage((Control)(this.sourceEditor == null ? this.defaultPage : this.contentComposite));
        this.composite = composite;
        return composite;
    }

    private void addHorizontalScrollSupport(final ScrolledForm form) {
        if (Util.isWindows()) {
            form.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!form.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point origin = form.getOrigin();
                        form.setOrigin(origin.x + offset, origin.y);
                    }
                }
            });
        }
    }

    private Composite createDefaultPage(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        page.setLayout((Layout)gridLayout);
        Label label = new Label(page, 16448);
        label.setText(MindMapMessages.PropertiesPart_DefaultPage_message);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        return page;
    }

    protected boolean postConfiguration(IWorkbenchPart workbenchPart, MPart part) {
        super.postConfiguration(workbenchPart, part);
        IWorkbenchPartSite site = workbenchPart.getSite();
        IGraphicalEditor editor = this.getContributedEditor();
        if (site instanceof IViewSite && editor != null) {
            IActionBars sourceActionBars = editor.getEditorSite().getActionBars();
            IActionBars targetActionBars = ((IViewSite)site).getActionBars();
            if (sourceActionBars == null || targetActionBars == null) {
                return false;
            }
            IServiceLocator serviceLocator = targetActionBars.getServiceLocator();
            if (serviceLocator == null) {
                return false;
            }
            IEclipseContext eclipseContext = (IEclipseContext)serviceLocator.getService(IEclipseContext.class);
            eclipseContext.set(ECommandService.class, (Object)((ECommandService)serviceLocator.getService(ECommandService.class)));
            eclipseContext.set(EHandlerService.class, (Object)((EHandlerService)serviceLocator.getService(EHandlerService.class)));
            this.retargetAction(sourceActionBars, targetActionBars, ActionFactory.UNDO.getId());
            this.retargetAction(sourceActionBars, targetActionBars, ActionFactory.REDO.getId());
            return true;
        }
        return false;
    }

    private void retargetAction(IActionBars sourceActionBars, IActionBars targetActionBars, String actionId) {
        IAction handler = sourceActionBars.getGlobalActionHandler(actionId);
        if (handler != null) {
            targetActionBars.setGlobalActionHandler(actionId, handler);
        }
    }

    private void setEditor(IGraphicalEditor editor) {
        ISelectionProvider selectionProvider;
        if (this.sourceEditor == editor) {
            return;
        }
        if (this.sourceEditor != null && (selectionProvider = this.sourceEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.sourceEditor = editor;
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            if (this.sourceEditor != null) {
                if (this.contentComposite != null && !this.contentComposite.isDisposed()) {
                    this.initContent();
                    this.viewerStack.showPage((Control)this.contentComposite);
                }
            } else if (this.defaultPage != null && !this.defaultPage.isDisposed()) {
                this.viewerStack.showPage(this.defaultPage);
            }
        }
    }

    public IGraphicalEditor getContributedEditor() {
        return this.sourceEditor;
    }

    private void addSection(String id, IPropertySectionPart section) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)section);
        this.removeSection(id);
        SectionRecord rec = new SectionRecord(id, section);
        this.sections.add(rec);
        section.init((IPropertyPartContainer)this, this.sourceEditor);
        if (this.form != null && !this.form.isDisposed()) {
            this.createSectionControl(this.form.getBody(), rec);
        }
    }

    private void removeSection(String id) {
        SectionRecord rec = this.getRec(id);
        if (rec == null) {
            return;
        }
        if (this.sections.remove(rec)) {
            rec.section.dispose();
            if (rec.control != null && !rec.control.isDisposed()) {
                rec.control.dispose();
            }
        }
    }

    private List<String> getSectionIds() {
        ArrayList<String> list = new ArrayList<String>(this.sections.size());
        for (SectionRecord rec : this.sections) {
            list.add(rec.id);
        }
        return list;
    }

    private List<String> getVisibleSectionIds() {
        ArrayList<String> list = new ArrayList<String>(this.sections.size());
        for (SectionRecord rec : this.sections) {
            if (!rec.visible) continue;
            list.add(rec.id);
        }
        return list;
    }

    private void setSectionVisible(String id, boolean visible) {
        SectionRecord rec = this.getRec(id);
        if (rec == null || rec.visible == visible) {
            return;
        }
        rec.visible = visible;
        if (rec.control != null && !rec.control.isDisposed()) {
            GridData gd = (GridData)rec.control.getLayoutData();
            gd.exclude = !visible;
            rec.control.setVisible(visible);
        }
    }

    private void reflow() {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
            this.form.getParent().layout();
        }
    }

    private void moveSectionFirst(SectionRecord rec) {
        if (rec.control != null && !rec.control.isDisposed()) {
            rec.control.moveAbove(null);
            rec.control.getParent().layout();
        }
    }

    private void moveSectionAfter(String id, String lastId) {
        SectionRecord rec = this.getRec(id);
        if (rec == null) {
            return;
        }
        SectionRecord lastRec = this.getRec(lastId);
        if (lastRec == null) {
            this.moveSectionFirst(rec);
        } else if (rec.control != null && !rec.control.isDisposed() && lastRec.control != null && !lastRec.control.isDisposed()) {
            rec.control.moveBelow((Control)lastRec.control);
            rec.control.getParent().layout();
        }
    }

    private SectionRecord getRec(String id) {
        if (id == null) {
            return null;
        }
        for (SectionRecord rec : this.sections) {
            if (!id.equals(rec.id)) continue;
            return rec;
        }
        return null;
    }

    private void createExtendSectionControls(WidgetFactory widgetFactory, Composite parent) {
        this.createResetStyleControl(widgetFactory, parent);
    }

    private void createResetStyleControl(WidgetFactory widgetFactory, Composite parent) {
        this.resetStyleControl = widgetFactory.createHyperlink(parent, MindMapMessages.MindMapPropertySheetPage_ResetStyle_text, 0);
        this.resetStyleControl.setUnderlined(false);
        this.resetStyleControl.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.resetStyleControl.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
                PropertiesPart.this.resetStyleControl.setUnderlined(false);
            }

            public void linkEntered(HyperlinkEvent e) {
                PropertiesPart.this.resetStyleControl.setUnderlined(true);
            }

            public void linkActivated(HyperlinkEvent e) {
                PropertiesPart.this.resetStyles();
            }
        });
        this.resetStyleControl.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().increaseHeight(-1)));
        this.resetStyleControl.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
    }

    private boolean shouldHasResetStyleControl(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        boolean result = true;
        Object[] resetedStyleds = ((StructuredSelection)selection).toArray();
        if (resetedStyleds != null) {
            Object[] objectArray = resetedStyleds;
            int n = resetedStyleds.length;
            int n2 = 0;
            while (n2 < n) {
                Object styled = objectArray[n2];
                if (!(styled instanceof IStyled)) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private void resetStyles() {
        IGraphicalEditor editor = this.getContributedEditor();
        if (editor == null) {
            return;
        }
        IGraphicalEditorPage activePageInstance = editor.getActivePageInstance();
        if (activePageInstance == null) {
            return;
        }
        ISelectionProvider selectionProvider = activePageInstance.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object[] resetedStyleds = ((StructuredSelection)selection).toArray();
        if (resetedStyleds != null) {
            Object[] objectArray = resetedStyleds;
            int n = resetedStyleds.length;
            int n2 = 0;
            while (n2 < n) {
                Object styled = objectArray[n2];
                if (styled instanceof IStyled) {
                    IStyled resetedStyled = (IStyled)styled;
                    ModifyStyleCommand modifyStyleCommand = new ModifyStyleCommand(resetedStyled, null);
                    modifyStyleCommand.setLabel(CommandMessages.Command_ModifyStyle);
                    editor.getCommandStack().execute((Command)modifyStyleCommand);
                }
                ++n2;
            }
        }
    }

    private void createSectionControls(final ScrolledForm form, final Composite formBody) {
        GridLayout layout = new GridLayout(1, true);
        formBody.setLayout((Layout)layout);
        for (SectionRecord rec : this.sections) {
            this.createSectionControl(formBody, rec);
        }
        form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                PropertiesPart.this.relayout(form, formBody);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void relayout(ScrolledForm form, Composite formBody) {
        boolean change;
        Rectangle area = form.getClientArea();
        GridLayout layout = (GridLayout)formBody.getLayout();
        int newNumColumns = Math.max(1, area.width / 200);
        boolean bl = change = newNumColumns != layout.numColumns && newNumColumns >= 0 && newNumColumns <= formBody.getChildren().length;
        if (change) {
            layout.numColumns = newNumColumns;
            formBody.layout();
        }
    }

    private void createSectionControl(Composite parent, SectionRecord rec) {
        rec.control = this.widgetFactory.createSection(parent, 2304);
        Composite client = this.widgetFactory.createComposite((Composite)rec.control, 524352);
        rec.control.setClient((Control)client);
        GridData data = new GridData(768);
        data.verticalAlignment = 1;
        data.widthHint = 200;
        rec.control.setLayoutData((Object)data);
        rec.section.createControl(client);
        rec.visible = true;
        this.updateSectionTitle(rec);
    }

    public void updateSectionTitle(IPropertySectionPart section) {
        SectionRecord rec = this.findRecord(section);
        if (rec != null) {
            this.updateSectionTitle(rec);
        }
    }

    private SectionRecord findRecord(IPropertySectionPart section) {
        for (SectionRecord rec : this.sections) {
            if (rec.section != section) continue;
            return rec;
        }
        return null;
    }

    private void updateSectionTitle(SectionRecord rec) {
        if (rec.control == null || rec.control.isDisposed()) {
            return;
        }
        String title = rec.section.getTitle();
        if (title == null) {
            title = "";
        }
        rec.control.setText(title);
    }

    public Control getControl() {
        return this.composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.selectionChanged(selection);
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setRedraw(false);
        }
        this.setSelectionToSections(selection);
        if (this.form != null && !this.form.isDisposed()) {
            this.refresh();
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setRedraw(true);
        }
    }

    private void selectionChanged(ISelection selection) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(false);
        }
        if (this.resetStyleControl != null && !this.resetStyleControl.isDisposed()) {
            boolean resetStyleControlVisible = this.shouldHasResetStyleControl(selection);
            GridData gd = (GridData)this.resetStyleControl.getLayoutData();
            gd.exclude = !resetStyleControlVisible;
            this.resetStyleControl.setVisible(resetStyleControlVisible);
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List<String> newVisibleSectionIds = manager.getApplicableSectionIds(ss.toArray());
            List<String> oldVisibleSectionIds = this.getVisibleSectionIds();
            if (!PropertiesPart.equalsList(oldVisibleSectionIds, newVisibleSectionIds)) {
                List<String> oldSectionIds = this.getSectionIds();
                ArrayList<String> toAdd = new ArrayList<String>(newVisibleSectionIds);
                toAdd.removeAll(oldSectionIds);
                for (String id : toAdd) {
                    this.addSection(id, newVisibleSectionIds, oldSectionIds);
                    oldSectionIds = this.getSectionIds();
                }
                ArrayList<String> toHide = new ArrayList<String>(oldSectionIds);
                toHide.removeAll(newVisibleSectionIds);
                for (String id : oldSectionIds) {
                    this.setSectionVisible(id, !toHide.contains(id));
                }
                this.reflow();
            }
            this.ti.setText(String.valueOf(this.calcTitle(ss.toArray())) + " " + this.modeLabel);
        } else {
            this.ti.setText(this.modeLabel);
        }
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(true);
        }
    }

    private void addSection(String id, List<String> newVisibleSectionIds, List<String> oldSectionIds) {
        this.addSection(id, manager.createSection(id));
        String aboveId = this.findAboveId(id, oldSectionIds, newVisibleSectionIds);
        this.moveSectionAfter(id, aboveId);
    }

    private String findAboveId(String id, List<String> oldSectionIds, List<String> newSectionIds) {
        int index = newSectionIds.indexOf(id);
        int i = index - 1;
        while (i >= 0) {
            String aboveId = newSectionIds.get(i);
            if (oldSectionIds.contains(aboveId)) {
                return aboveId;
            }
            --i;
        }
        return null;
    }

    private static boolean equalsList(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            String s2;
            String s1 = list1.get(i);
            if (!s1.equals(s2 = list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String calcTitle(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        String category = this.getCategoryName(objects);
        return category;
    }

    private String getCategoryName(Object[] objects) {
        ICategoryManager typeManager = MindMapUI.getCategoryManager();
        ICategoryAnalyzation result = typeManager.analyze(objects);
        return typeManager.getCategoryName(result.getMainCategory());
    }

    private void setSelectionToSections(ISelection selection) {
        for (SectionRecord rec : this.sections) {
            if (!rec.visible) continue;
            rec.section.setSelection(selection);
            this.updateSectionTitle(rec);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void refresh() {
        for (SectionRecord rec : this.sections) {
            if (!rec.visible) continue;
            rec.section.refresh();
        }
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
        }
    }

    public void dispose() {
        ISelectionProvider selectionProvider;
        if (this.sourceEditor != null && (selectionProvider = this.sourceEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        for (SectionRecord rec : this.sections) {
            rec.section.dispose();
            rec.visible = false;
            rec.control = null;
        }
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
        this.form = null;
        this.title = null;
        super.dispose();
    }

    protected void handlePartActivated(MPart part) {
        IWorkbenchWindow window;
        IEditorPart editorPart;
        super.handlePartActivated(part);
        Object partObject = part.getObject();
        if (partObject instanceof CompatibilityPart) {
            MPart partModel;
            Object wp;
            IWorkbenchPart editorPart2 = ((CompatibilityPart)partObject).getPart();
            if (editorPart2 instanceof IGraphicalEditor) {
                this.setEditor((IGraphicalEditor)editorPart2);
            }
            if ((wp = (partModel = (MPart)this.getAdapter(MPart.class)).getTransientData().get("e4Wrapper")) instanceof E4PartWrapper) {
                this.postConfiguration((IWorkbenchPart)wp, partModel);
            }
        } else if (this.sourceEditor == null && (editorPart = (window = (IWorkbenchWindow)this.getAdapter(IWorkbenchWindow.class)).getActivePage().getActiveEditor()) instanceof IGraphicalEditor) {
            this.setEditor((IGraphicalEditor)editorPart);
        }
    }

    public IPageSite getContainerSite() {
        return null;
    }

    public IWorkbenchPart getContributingPart() {
        return this.sourceEditor;
    }

    private static class SectionRecord {
        String id;
        IPropertySectionPart section;
        Section control;
        boolean visible;

        public SectionRecord(String id, IPropertySectionPart section) {
            this.id = id;
            this.section = section;
        }
    }
}

