/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteSliderUI
extends BasicSliderUI {
    private static final float[] enabledStops = new float[]{0.0f, 0.35f, 0.35f, 1.0f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xF3F3F3), new Color(0xCCCCCC), new Color(0xBABABA), new Color(0xF3F3F3)};
    private static final float[] disabledStops = new float[]{0.0f, 0.35f, 0.35f, 1.0f};
    private static final Color[] disabledStopColors = new Color[]{new Color(0xF3F3F3), new Color(0xEEEEEE), new Color(0xCACACA), new Color(0xF3F3F3)};
    private static final float[] selectedStops = new float[]{0.0f, 0.2f, 1.0f};
    private static final Color[] selectedStopColors = new Color[]{new Color(0x999999), new Color(0xAAAAAA), new Color(0x666666)};

    public static ComponentUI createUI(JComponent b) {
        return new PaletteSliderUI((JSlider)b);
    }

    public PaletteSliderUI(JSlider slider) {
        super(slider);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        PaletteLookAndFeel laf = PaletteLookAndFeel.getInstance();
        PaletteLookAndFeel.installBorder(slider, "Slider.border");
        PaletteLookAndFeel.installColors(slider, "Slider.background", "Slider.foreground");
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        Dimension horizDim = (Dimension)PaletteLookAndFeel.getInstance().get("Slider.horizontalSize");
        if (horizDim == null) {
            horizDim = new Dimension(100, 21);
        }
        return horizDim;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        Dimension vertDim = (Dimension)PaletteLookAndFeel.getInstance().get("Slider.verticalSize");
        if (vertDim == null) {
            vertDim = new Dimension(21, 100);
        }
        return vertDim;
    }

    @Override
    public void paint(Graphics gr, JComponent c) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paint(g, c);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int pad;
            int cx = pad = this.trackBuffer;
            int cy = trackBounds.height / 2 - 2;
            int cw = trackBounds.width;
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.setColor(this.getShadowColor());
            g.drawLine(0, 0, cw - 1, 0);
            g.drawLine(0, 1, 0, 2);
            g.setColor(this.getHighlightColor());
            g.drawLine(0, 3, cw, 3);
            g.drawLine(cw, 0, cw, 3);
            g.setColor(Color.black);
            g.drawLine(1, 1, cw - 2, 1);
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int pad = this.trackBuffer;
            int cx = trackBounds.width / 2 - 2;
            int cy = pad;
            int ch = trackBounds.height;
            g.setColor(new Color(this.slider.isEnabled() ? 0x888888 : 0xAAAAAA));
            g.drawRoundRect(trackBounds.x + cx, trackBounds.y, 5, ch, 5, 5);
        }
    }

    @Override
    public void paintThumb(Graphics gr) {
        Color[] stopColors;
        float[] stops;
        Graphics2D g = (Graphics2D)gr;
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getBackground());
            if (this.slider.getModel().getValueIsAdjusting()) {
                stops = selectedStops;
                stopColors = selectedStopColors;
            } else {
                stops = enabledStops;
                stopColors = enabledStopColors;
            }
        } else {
            g.setColor(this.slider.getBackground().darker());
            stops = enabledStops;
            stopColors = enabledStopColors;
        }
        Boolean paintThumbArrowShape = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        if (!this.slider.getPaintTicks() && paintThumbArrowShape == null || paintThumbArrowShape == Boolean.FALSE) {
            LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Float(2.0f, 2.0f), new Point2D.Float(2.0f, 2 + h - 4), stops, stopColors, MultipleGradientPaint.REPEAT, MultipleGradientPaint.LINEAR_RGB);
            g.setPaint(lgp);
            g.fillOval(2, 2, w - 4, h - 4);
            g.setColor(new Color(0x444444));
            g.drawOval(1, 1, w - 3, h - 3);
        } else if (this.slider.getOrientation() == 0) {
            int cw = w / 2;
            g.fillRect(1, 1, w - 3, h - 1 - cw);
            Polygon p = new Polygon();
            p.addPoint(1, h - cw);
            p.addPoint(cw - 1, h - 1);
            p.addPoint(w - 2, h - 1 - cw);
            g.fillPolygon(p);
            g.setColor(this.getHighlightColor());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 1 - cw);
            g.drawLine(0, h - cw, cw - 1, h - 1);
            g.setColor(Color.black);
            g.drawLine(w - 1, 0, w - 1, h - 2 - cw);
            g.drawLine(w - 1, h - 1 - cw, w - 1 - cw, h - 1);
            g.setColor(this.getShadowColor());
            g.drawLine(w - 2, 1, w - 2, h - 2 - cw);
            g.drawLine(w - 2, h - 1 - cw, w - 1 - cw, h - 2);
        } else {
            int cw = h / 2;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                g.fillRect(1, 1, w - 1 - cw, h - 3);
                Polygon p = new Polygon();
                p.addPoint(w - cw - 1, 0);
                p.addPoint(w - 1, cw);
                p.addPoint(w - 1 - cw, h - 2);
                g.fillPolygon(p);
                g.setColor(this.getHighlightColor());
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(1, 0, w - 1 - cw, 0);
                g.drawLine(w - cw - 1, 0, w - 1, cw);
                g.setColor(Color.black);
                g.drawLine(0, h - 1, w - 2 - cw, h - 1);
                g.drawLine(w - 1 - cw, h - 1, w - 1, h - 1 - cw);
                g.setColor(this.getShadowColor());
                g.drawLine(1, h - 2, w - 2 - cw, h - 2);
                g.drawLine(w - 1 - cw, h - 2, w - 2, h - cw - 1);
            } else {
                g.fillRect(5, 1, w - 1 - cw, h - 3);
                Polygon p = new Polygon();
                p.addPoint(cw, 0);
                p.addPoint(0, cw);
                p.addPoint(cw, h - 2);
                g.fillPolygon(p);
                g.setColor(this.getHighlightColor());
                g.drawLine(cw - 1, 0, w - 2, 0);
                g.drawLine(0, cw, cw, 0);
                g.setColor(Color.black);
                g.drawLine(0, h - 1 - cw, cw, h - 1);
                g.drawLine(cw, h - 1, w - 1, h - 1);
                g.setColor(this.getShadowColor());
                g.drawLine(cw, h - 2, w - 2, h - 2);
                g.drawLine(w - 1, 1, w - 1, h - 2);
            }
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = 15;
            size.height = 15;
        } else {
            size.width = 15;
            size.height = 15;
        }
        return size;
    }
}

