/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.engine.currency.CurrencyPair;
import org.yccheok.jstock.engine.currency.ExchangeRate;
import org.yccheok.jstock.engine.currency.ExchangeRateMonitor;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.file.UserDataDirectory;
import org.yccheok.jstock.file.UserDataFile;
import org.yccheok.jstock.gui.BuyPortfolioChartJDialog;
import org.yccheok.jstock.gui.GUIOptions;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.NewBuyTransactionJDialog;
import org.yccheok.jstock.gui.NewSellTransactionJDialog;
import org.yccheok.jstock.gui.SellPortfolioChartJDialog;
import org.yccheok.jstock.gui.TableColumnSelectionPopupListener;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.InvestmentFlowChartJDialog;
import org.yccheok.jstock.gui.portfolio.CommentJDialog;
import org.yccheok.jstock.gui.portfolio.DepositSummaryJDialog;
import org.yccheok.jstock.gui.portfolio.DepositSummaryTableModel;
import org.yccheok.jstock.gui.portfolio.DividendSummaryBarChartJDialog;
import org.yccheok.jstock.gui.portfolio.DividendSummaryJDialog;
import org.yccheok.jstock.gui.portfolio.DividendSummaryTableModel;
import org.yccheok.jstock.gui.portfolio.RenameStockJDialog;
import org.yccheok.jstock.gui.portfolio.SplitJDialog;
import org.yccheok.jstock.gui.portfolio.ToolTipHighlighter;
import org.yccheok.jstock.gui.treetable.AbstractPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.BuyPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.DoubleWithCurrency;
import org.yccheok.jstock.gui.treetable.SellPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.SortableTreeTable;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlace;
import org.yccheok.jstock.portfolio.Deposit;
import org.yccheok.jstock.portfolio.DepositSummary;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class PortfolioManagementJPanel
extends JPanel {
    private static final Log log = LogFactory.getLog(PortfolioManagementJPanel.class);
    private int dividerLocation = -1;
    private DepositSummary depositSummary = new DepositSummary();
    private DividendSummary dividendSummary = new DividendSummary();
    private RealTimeStockMonitor realTimeStockMonitor = null;
    private ExchangeRateMonitor exchangeRateMonitor = null;
    private final Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> realTimeStockMonitorObserver = this.getRealTimeStockMonitorObserver();
    private final Observer<ExchangeRateMonitor, List<ExchangeRate>> exchangeRateMonitorObserver = this.getExchangeRateMonitorObserver();
    private PortfolioRealTimeInfo portfolioRealTimeInfo = new PortfolioRealTimeInfo();
    private SortableTreeTable buyTreeTable;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private SortableTreeTable sellTreeTable;

    public PortfolioManagementJPanel() {
        this.initComponents();
        this.initPortfolio();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.buyTreeTable = new SortableTreeTable((TreeTableModel)new BuyPortfolioTreeTableModelEx());
        ((TableColumnExt)this.buyTreeTable.getColumn(GUIBundle.getString("PortfolioManagementJPanel_Comment"))).setVisible(false);
        this.jScrollPane2 = new JScrollPane();
        this.sellTreeTable = new SortableTreeTable((TreeTableModel)new SellPortfolioTreeTableModelEx());
        ((TableColumnExt)this.sellTreeTable.getColumn(GUIBundle.getString("PortfolioManagementJPanel_Comment"))).setVisible(false);
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PortfolioManagementJPanel.this.formMouseClicked(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Portfolio Management"));
        this.jPanel1.setLayout(new BorderLayout(0, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jLabel1.setText(this.getShareLabel());
        this.jPanel3.add(this.jLabel1);
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jPanel3.add(this.jLabel2);
        this.jLabel3.setText(this.getCashLabel());
        this.jPanel3.add(this.jLabel3);
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jPanel3.add(this.jLabel4);
        this.jPanel4.add((Component)this.jPanel3, "West");
        this.jLabel5.setText(this.getPaperProfitLabel());
        this.jPanel5.add(this.jLabel5);
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jPanel5.add(this.jLabel6);
        this.jLabel7.setText(this.getRealizedProfitLabel());
        this.jPanel5.add(this.jLabel7);
        this.jLabel8.setFont(this.jLabel8.getFont().deriveFont(this.jLabel8.getFont().getStyle() | 1));
        this.jPanel5.add(this.jLabel8);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(bundle.getString("PortfolioManagementJPanel_Buy")));
        this.buyTreeTable.setAutoResizeMode(0);
        this.buyTreeTable.setRootVisible(true);
        this.buyTreeTable.setAutoCreateColumnsFromModel(false);
        this.buyTreeTable.addMouseListener(new BuyTableRowPopupListener());
        this.buyTreeTable.addKeyListener(new TableKeyEventListener());
        Highlighter highlighter0 = HighlighterFactory.createSimpleStriping((Color)new Color(245, 245, 220));
        this.buyTreeTable.addHighlighter(highlighter0);
        this.buyTreeTable.addHighlighter((Highlighter)new ToolTipHighlighter());
        this.initTreeTableDefaultRenderer(this.buyTreeTable);
        JTableHeader oldBuyTableHeader = this.buyTreeTable.getTableHeader();
        JXTableHeader newBuyTableHeader = new JXTableHeader(oldBuyTableHeader.getColumnModel());
        this.buyTreeTable.setTableHeader((JTableHeader)newBuyTableHeader);
        this.buyTreeTable.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(1, new String[]{GUIBundle.getString("PortfolioManagementJPanel_Comment")}));
        this.buyTreeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PortfolioManagementJPanel.this.buyTreeTableValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)((Object)this.buyTreeTable));
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder(bundle.getString("PortfolioManagementJPanel_Sell")));
        this.sellTreeTable.setAutoResizeMode(0);
        this.sellTreeTable.setRootVisible(true);
        this.sellTreeTable.setAutoCreateColumnsFromModel(false);
        this.sellTreeTable.addMouseListener(new SellTableRowPopupListener());
        this.sellTreeTable.addKeyListener(new TableKeyEventListener());
        Highlighter highlighter1 = HighlighterFactory.createSimpleStriping((Color)new Color(245, 245, 220));
        this.sellTreeTable.addHighlighter(highlighter1);
        this.sellTreeTable.addHighlighter((Highlighter)new ToolTipHighlighter());
        this.initTreeTableDefaultRenderer(this.sellTreeTable);
        JTableHeader oldSellTableHeader = this.sellTreeTable.getTableHeader();
        JXTableHeader newSellTableHeader = new JXTableHeader(oldSellTableHeader.getColumnModel());
        this.sellTreeTable.setTableHeader((JTableHeader)newSellTableHeader);
        this.sellTreeTable.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(1, new String[]{GUIBundle.getString("PortfolioManagementJPanel_Comment")}));
        this.sellTreeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PortfolioManagementJPanel.this.sellTreeTableValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)((Object)this.sellTreeTable));
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/inbox.png")));
        this.jButton1.setText(bundle.getString("PortfolioManagementJPanel_Buy..."));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/outbox.png")));
        this.jButton3.setText(bundle.getString("PortfolioManagementJPanel_Sell..."));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/money.png")));
        this.jButton4.setText(bundle.getString("PortfolioManagementJPanel_Cash..."));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/money2.png")));
        this.jButton5.setText(bundle.getString("PortfolioManagementJPanel_Dividen..."));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton5);
        this.add((Component)this.jPanel2, "South");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        List<StockInfo> stockInfos = this.getSelectedStockInfos();
        if (stockInfos.size() == 1) {
            this.showNewBuyTransactionJDialog(stockInfos.get(0), this.getStockPrice(stockInfos.get((int)0).code), true);
        } else {
            this.showNewBuyTransactionJDialog(null, 0.0, true);
        }
    }

    private void initTreeTableDefaultRenderer(JXTreeTable treeTable) {
        final TableCellRenderer doubleOldTableCellRenderer = treeTable.getDefaultRenderer(Double.class);
        treeTable.setDefaultRenderer(Double.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = doubleOldTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String UNITS = GUIBundle.getString("PortfolioManagementJPanel_Units");
                if (!UNITS.equals(table.getColumnName(column))) {
                    if (value != null && c instanceof JLabel) {
                        if (value instanceof DoubleWrapper) {
                            DoubleWrapper v = (DoubleWrapper)value;
                            ((JLabel)c).setText(org.yccheok.jstock.portfolio.Utils.toCurrency(v.decimalPlace, v.value));
                        } else if (value instanceof DoubleWithCurrency) {
                            DoubleWithCurrency v = (DoubleWithCurrency)value;
                            Currency currency = v.currency();
                            String content = org.yccheok.jstock.portfolio.Utils.toCurrency(v.decimalPlace(), v.Double());
                            if (currency == null) {
                                ((JLabel)c).setText(content);
                            } else {
                                String prefix = currency.toString();
                                if ("GBX".equals(prefix)) {
                                    prefix = "GBP";
                                } else if ("ZAC".equals(prefix)) {
                                    prefix = "ZAR";
                                }
                                ((JLabel)c).setText(prefix + " " + content);
                            }
                        } else {
                            ((JLabel)c).setText(org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlace.Four, value));
                        }
                    }
                } else if (value != null && c instanceof JLabel) {
                    ((JLabel)c).setText(org.yccheok.jstock.portfolio.Utils.toUnits(value));
                }
                return c;
            }
        });
        treeTable.setDefaultRenderer(SimpleDate.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && c instanceof JLabel) {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    SimpleDate simpleDate = (SimpleDate)value;
                    ((JLabel)c).setText(dateFormat.format(simpleDate.getTime()));
                }
                return c;
            }
        });
    }

    private boolean isValidTreeTableNode(TreeTableModel treeTableModel, Object node) {
        boolean result = false;
        Object root = treeTableModel.getRoot();
        if (node instanceof TreeTableNode) {
            for (TreeTableNode ttn = (TreeTableNode)node; !result && ttn != null; ttn = ttn.getParent()) {
                result = ttn == root;
            }
        }
        return result;
    }

    private String getSelectedFirstColumnString(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return null;
        }
        if (treePaths.length == 1) {
            return treePaths[0].getLastPathComponent().toString();
        }
        return null;
    }

    private Commentable getSelectedCommentable(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return null;
        }
        if (treePaths.length == 1 && treePaths[0].getLastPathComponent() instanceof Commentable) {
            return (Commentable)treePaths[0].getLastPathComponent();
        }
        return null;
    }

    public boolean openAsExcelFile(File file) {
        List<Statements> statementsList = Statements.newInstanceFromExcelFile(file);
        boolean status = true;
        for (Statements statements : statementsList) {
            status &= this.openAsStatements(statements, file);
        }
        return status;
    }

    public boolean openAsCSVFile(File file) {
        Statements statements = Statements.newInstanceFromCSVFile(file);
        return this.openAsStatements(statements, file);
    }

    /*
     * Unable to fully structure code
     */
    public boolean openAsStatements(Statements statements, File file) {
        block69: {
            block68: {
                if (!PortfolioManagementJPanel.$assertionsDisabled && statements == null) {
                    throw new AssertionError();
                }
                if (statements.getType() != Statement.Type.PortfolioManagementBuy && statements.getType() != Statement.Type.PortfolioManagementSell && statements.getType() != Statement.Type.PortfolioManagementDeposit && statements.getType() != Statement.Type.PortfolioManagementDividend) break block68;
                guiBundleWrapper = statements.getGUIBundleWrapper();
                dateFormat = null;
                size = statements.size();
                switch (49.$SwitchMap$org$yccheok$jstock$file$Statement$Type[statements.getType().ordinal()]) {
                    case 1: {
                        transactions = new ArrayList<Transaction>();
                        for (i = 0; i < size; ++i) {
                            statement = statements.get(i);
                            _code = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                            _symbol = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                            _date = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            units = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Units"));
                            purchasePrice = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"));
                            broker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"));
                            clearingFee = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"));
                            stampDuty = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"));
                            _comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            stockInfo = null;
                            if (_code.length() <= 0 || _symbol.length() <= 0) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected empty stock. Ignore");
                                continue;
                            }
                            stockInfo = StockInfo.newInstance(Code.newInstance(_code), Symbol.newInstance(_symbol));
                            date = null;
                            if (dateFormat != null) ** GOTO lbl39
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(_date);
                                    ** GOTO lbl44
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl44
lbl39:
                            // 1 sources

                            try {
                                date = dateFormat.parse(_date);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl44:
                            // 4 sources

                            if (date == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date. Ignore");
                                continue;
                            }
                            if (units == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong units. Ignore");
                                continue;
                            }
                            if (purchasePrice == null || broker == null || clearingFee == null || stampDuty == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong purchasePrice/broker/clearingFee/stampDuty. Ignore");
                                continue;
                            }
                            simpleDate = new SimpleDate(date);
                            type = Contract.Type.Buy;
                            builder = new Contract.ContractBuilder(stockInfo, simpleDate);
                            contract = builder.type(type).quantity(units).price(purchasePrice).build();
                            t = new Transaction(contract, broker, stampDuty, clearingFee);
                            t.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(_comment));
                            transactions.add(t);
                        }
                        if (this.getBuyTransactionSize() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_buy_portfolio_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_load_file_for_buy_portfolio"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.buyTreeTable.setTreeTableModel((TreeTableModel)new BuyPortfolioTreeTableModelEx());
                        buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
                        buyPortfolioTreeTableModel.bind(this.portfolioRealTimeInfo);
                        buyPortfolioTreeTableModel.bind(this);
                        metadatas = statements.getMetadatas();
                        for (Transaction transaction : transactions) {
                            code = transaction.getStockInfo().code;
                            transactionSummary = this.addBuyTransaction(transaction);
                            if (transactionSummary == null || (comment = metadatas.get(code.toString())) == null) continue;
                            transactionSummary.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                        }
                        this.initGUIOptions();
                        this.expandTreeTable(this.buyTreeTable);
                        this.updateRealTimeStockMonitorAccordingToPortfolioTreeTableModels();
                        this.updateExchangeRateMonitorAccordingToPortfolioTreeTableModels();
                        this.refreshStatusBarExchangeRateVisibility();
                        break;
                    }
                    case 2: {
                        transactions = new ArrayList<Transaction>();
                        for (i = 0; i < size; ++i) {
                            statement = statements.get(i);
                            _code = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                            _symbol = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                            _referenceDate = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate"));
                            purchaseBroker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseBroker"));
                            if (purchaseBroker == null && (purchaseBroker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseFee"))) == null) {
                                purchaseBroker = new Double(0.0);
                            }
                            if ((purchaseClearingFee = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseClearingFee"))) == null) {
                                purchaseClearingFee = new Double(0.0);
                            }
                            if ((purchaseStampDuty = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseStampDuty"))) == null) {
                                purchaseStampDuty = new Double(0.0);
                            }
                            _date = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            units = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Units"));
                            sellingPrice = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice"));
                            purchasePrice = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"));
                            broker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"));
                            clearingFee = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"));
                            stampDuty = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"));
                            _comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            stockInfo = null;
                            if (_code.length() <= 0 || _symbol.length() <= 0) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected empty stock. Ignore");
                                continue;
                            }
                            stockInfo = StockInfo.newInstance(Code.newInstance(_code), Symbol.newInstance(_symbol));
                            date = null;
                            referenceDate = null;
                            if (dateFormat != null) ** GOTO lbl127
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(_date);
                                    referenceDate = dateFormat.parse(_referenceDate);
                                    ** GOTO lbl133
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    referenceDate = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl133
lbl127:
                            // 1 sources

                            try {
                                date = dateFormat.parse(_date);
                                referenceDate = dateFormat.parse(_referenceDate);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl133:
                            // 4 sources

                            if (date == null || referenceDate == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date/referenceDate. Ignore");
                                continue;
                            }
                            if (units == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong units. Ignore");
                                continue;
                            }
                            if (purchasePrice == null || broker == null || clearingFee == null || stampDuty == null || sellingPrice == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong purchasePrice/broker/clearingFee/stampDuty/sellingPrice. Ignore");
                                continue;
                            }
                            simpleDate = new SimpleDate(date);
                            simpleReferenceDate = new SimpleDate(referenceDate);
                            type = Contract.Type.Sell;
                            builder = new Contract.ContractBuilder(stockInfo, simpleDate);
                            contract = builder.type(type).quantity(units).price(sellingPrice).referencePrice(purchasePrice).referenceDate(simpleReferenceDate).referenceBroker(purchaseBroker).referenceClearingFee(purchaseClearingFee).referenceStampDuty(purchaseStampDuty).build();
                            t = new Transaction(contract, broker, stampDuty, clearingFee);
                            t.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(_comment));
                            transactions.add(t);
                        }
                        if (this.getSellTransactionSize() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_sell_portfolio_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_load_file_for_sell_portfolio"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.sellTreeTable.setTreeTableModel((TreeTableModel)new SellPortfolioTreeTableModelEx());
                        sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
                        sellPortfolioTreeTableModel.bind(this.portfolioRealTimeInfo);
                        sellPortfolioTreeTableModel.bind(this);
                        metadatas = statements.getMetadatas();
                        for (Transaction transaction : transactions) {
                            code = transaction.getStockInfo().code;
                            transactionSummary = this.addSellTransaction(transaction);
                            if (transactionSummary == null || (comment = metadatas.get(code.toString())) == null) continue;
                            transactionSummary.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                        }
                        this.initGUIOptions();
                        this.expandTreeTable(this.sellTreeTable);
                        this.updateExchangeRateMonitorAccordingToPortfolioTreeTableModels();
                        this.refreshStatusBarExchangeRateVisibility();
                        break;
                    }
                    case 3: {
                        deposits = new ArrayList<Deposit>();
                        for (i = 0; i < size; ++i) {
                            date = null;
                            statement = statements.get(i);
                            object0 = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            if (!PortfolioManagementJPanel.$assertionsDisabled && object0 == null) {
                                throw new AssertionError();
                            }
                            if (dateFormat != null) ** GOTO lbl193
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(object0);
                                    ** GOTO lbl198
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl198
lbl193:
                            // 1 sources

                            try {
                                date = dateFormat.parse(object0);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl198:
                            // 4 sources

                            if (date == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date. Ignore");
                                continue;
                            }
                            cash = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Cash"));
                            if (cash == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong cash. Ignore");
                                continue;
                            }
                            deposit = new Deposit(cash, new SimpleDate(date));
                            comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            if (comment != null) {
                                deposit.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                            }
                            deposits.add(deposit);
                        }
                        if (this.depositSummary.size() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_cash_deposit_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_load_file_for_cash_deposit"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.depositSummary = new DepositSummary();
                        for (Deposit deposit : deposits) {
                            this.depositSummary.add(deposit);
                        }
                        break;
                    }
                    case 4: {
                        dividends = new ArrayList<Dividend>();
                        for (i = 0; i < size; ++i) {
                            date = null;
                            stockInfo = null;
                            statement = statements.get(i);
                            object0 = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            if (!PortfolioManagementJPanel.$assertionsDisabled && object0 == null) {
                                throw new AssertionError();
                            }
                            if (dateFormat != null) ** GOTO lbl244
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(object0);
                                    ** GOTO lbl249
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl249
lbl244:
                            // 1 sources

                            try {
                                date = dateFormat.parse(object0);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl249:
                            // 4 sources

                            if (date == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date. Ignore");
                                continue;
                            }
                            dividend = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Dividend"));
                            if (dividend == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong dividend. Ignore");
                                continue;
                            }
                            codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                            symbolStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                            if (codeStr.isEmpty() || symbolStr.isEmpty()) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong stock. Ignore");
                                continue;
                            }
                            stockInfo = StockInfo.newInstance(Code.newInstance(codeStr), Symbol.newInstance(symbolStr));
                            if (!PortfolioManagementJPanel.$assertionsDisabled && stockInfo == null) {
                                throw new AssertionError();
                            }
                            if (!PortfolioManagementJPanel.$assertionsDisabled && dividend == null) {
                                throw new AssertionError();
                            }
                            if (!PortfolioManagementJPanel.$assertionsDisabled && date == null) {
                                throw new AssertionError();
                            }
                            d = new Dividend(stockInfo, dividend, new SimpleDate(date));
                            comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            if (comment != null) {
                                d.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                            }
                            dividends.add(d);
                        }
                        if (this.dividendSummary.size() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_dividend_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_load_file_for_dividend"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.dividendSummary = new DividendSummary();
                        for (Dividend dividend : dividends) {
                            this.dividendSummary.add(dividend);
                        }
                        break;
                    }
                    default: {
                        if (!PortfolioManagementJPanel.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                break block69;
            }
            if (statements.getType() == Statement.Type.RealtimeInfo) {
                return JStock.instance().openAsStatements(statements, file);
            }
            return false;
        }
        this.updateWealthHeader();
        return true;
    }

    private List<StockInfo> getSelectedStockInfos() {
        List<StockInfo> stockInfos0 = this.getSelectedStockInfos(this.buyTreeTable);
        List<StockInfo> stockInfos1 = this.getSelectedStockInfos(this.sellTreeTable);
        HashSet<Code> c = new HashSet<Code>();
        ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
        for (StockInfo stockInfo : stockInfos0) {
            if (c.contains(stockInfo.code)) continue;
            c.add(stockInfo.code);
            stockInfos.add(stockInfo);
        }
        for (StockInfo stockInfo : stockInfos1) {
            if (c.contains(stockInfo.code)) continue;
            c.add(stockInfo.code);
            stockInfos.add(stockInfo);
        }
        return Collections.unmodifiableList(stockInfos);
    }

    public double getStockPrice(Code code) {
        Double price = this.portfolioRealTimeInfo.stockPrices.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    private void showNewSellTransactionJDialog(List<Transaction> buyTransactions) {
        JStock mainFrame = JStock.instance();
        NewSellTransactionJDialog newSellTransactionJDialog = new NewSellTransactionJDialog((Frame)mainFrame, true);
        if (buyTransactions.size() > 1) {
            String template = GUIBundle.getString("PortfolioManagementJPanel_BatchSell_template");
            newSellTransactionJDialog.setTitle(MessageFormat.format(template, newSellTransactionJDialog.getTitle(), buyTransactions.size()));
        }
        newSellTransactionJDialog.setLocationRelativeTo(this);
        newSellTransactionJDialog.setBuyTransactions(buyTransactions);
        newSellTransactionJDialog.setVisible(true);
        List<Transaction> newSellTransactions = newSellTransactionJDialog.getTransactions();
        for (int i = 0; i < newSellTransactions.size(); ++i) {
            Transaction newSellTransaction = newSellTransactions.get(i);
            Transaction buyTransaction = buyTransactions.get(i);
            double remain = buyTransaction.getQuantity() - newSellTransaction.getQuantity();
            assert (remain >= 0.0);
            this.addSellTransaction(newSellTransaction);
            BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
            if (remain <= 0.0) {
                portfolioTreeTableModel.removeTransaction(buyTransaction);
                continue;
            }
            double newBroker = buyTransaction.getBroker() - newSellTransaction.getReferenceBroker();
            double newStampDuty = buyTransaction.getStampDuty() - newSellTransaction.getReferenceStampDuty();
            double newClearingFee = buyTransaction.getClearingFee() - newSellTransaction.getReferenceClearingFee();
            this.editBuyTransaction(buyTransaction.deriveWithQuantity(remain).deriveWithBroker(newBroker).deriveWithStampDuty(newStampDuty).deriveWithClearingFee(newClearingFee), buyTransaction);
        }
        this.updateWealthHeader();
    }

    private void showEditTransactionJDialog(Transaction transaction) {
        JStock mainFrame = JStock.instance();
        if (transaction.getType() == Contract.Type.Buy) {
            NewBuyTransactionJDialog newTransactionJDialog = new NewBuyTransactionJDialog((Frame)mainFrame, true);
            newTransactionJDialog.setStockSelectionEnabled(false);
            newTransactionJDialog.setTransaction(transaction);
            String template = GUIBundle.getString("PortfolioManagementJPanel_EditBuy_template");
            newTransactionJDialog.setTitle(MessageFormat.format(template, transaction.getStockInfo().symbol));
            newTransactionJDialog.setLocationRelativeTo(this);
            newTransactionJDialog.setVisible(true);
            Transaction newTransaction = newTransactionJDialog.getTransaction();
            if (newTransaction != null) {
                this.editBuyTransaction(newTransaction, transaction);
                this.updateWealthHeader();
            }
        } else {
            assert (transaction.getType() == Contract.Type.Sell);
            NewSellTransactionJDialog newTransactionJDialog = new NewSellTransactionJDialog((Frame)mainFrame, true);
            newTransactionJDialog.setSellTransaction(transaction);
            String template = GUIBundle.getString("PortfolioManagementJPanel_EditSell_template");
            newTransactionJDialog.setTitle(MessageFormat.format(template, transaction.getStockInfo().symbol));
            newTransactionJDialog.setLocationRelativeTo(this);
            newTransactionJDialog.setVisible(true);
            List<Transaction> transactions = newTransactionJDialog.getTransactions();
            for (Transaction newTransaction : transactions) {
                this.editSellTransaction(newTransaction, transaction);
                this.updateWealthHeader();
            }
        }
    }

    public void showNewBuyTransactionJDialog(StockInfo stockInfo, double lastPrice, boolean JComboBoxEnabled) {
        JStock mainFrame = JStock.instance();
        StockInfoDatabase stockInfoDatabase = mainFrame.getStockInfoDatabase();
        if (stockInfoDatabase == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("info_message_we_havent_connected_to_stock_server"), MessagesBundle.getString("info_title_we_havent_connected_to_stock_server"), 1);
            return;
        }
        NewBuyTransactionJDialog newTransactionJDialog = new NewBuyTransactionJDialog((Frame)mainFrame, true);
        newTransactionJDialog.setLocationRelativeTo(this);
        newTransactionJDialog.setStockInfo(stockInfo);
        newTransactionJDialog.setPrice(lastPrice);
        newTransactionJDialog.setJComboBoxEnabled(JComboBoxEnabled);
        newTransactionJDialog.setStockInfoDatabase(stockInfoDatabase);
        if (mainFrame.getSelectedComponent() != this) {
            JStockOptions jStockOptions = mainFrame.getJStockOptions();
            String title = newTransactionJDialog.getTitle() + " (" + jStockOptions.getPortfolioName() + ")";
            newTransactionJDialog.setTitle(title);
        }
        newTransactionJDialog.setVisible(true);
        Transaction transaction = newTransactionJDialog.getTransaction();
        if (transaction != null) {
            this.addBuyTransaction(transaction);
            this.refreshStatusBarExchangeRateVisibility();
            this.updateWealthHeader();
        }
    }

    public void clearTableSelection() {
        this.buyTreeTable.getSelectionModel().clearSelection();
        this.sellTreeTable.getSelectionModel().clearSelection();
    }

    private boolean deleteSelectedTreeTableRow(JXTreeTable treeTable) {
        AbstractPortfolioTreeTableModelEx portfolioTreeTableModel = (AbstractPortfolioTreeTableModelEx)treeTable.getTreeTableModel();
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        boolean atLeastOnce = false;
        for (TreePath treePath : treePaths) {
            Object o = treePath.getLastPathComponent();
            if (portfolioTreeTableModel.getRoot() == o) continue;
            MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)o;
            if (!this.isValidTreeTableNode((TreeTableModel)portfolioTreeTableModel, mutableTreeTableNode)) {
                portfolioTreeTableModel.fireTreeTableNodeChanged((TreeTableNode)mutableTreeTableNode);
                continue;
            }
            if (o instanceof Transaction) {
                portfolioTreeTableModel.removeTransaction((Transaction)o);
                atLeastOnce = true;
                continue;
            }
            if (!(o instanceof TransactionSummary)) continue;
            portfolioTreeTableModel.removeTransactionSummary((TransactionSummary)o);
            atLeastOnce = true;
        }
        return atLeastOnce;
    }

    private void deteleSelectedTreeTableRow() {
        boolean refreshStatusBarExchangeRateVisibility = false;
        if (this.deleteSelectedTreeTableRow(this.buyTreeTable)) {
            refreshStatusBarExchangeRateVisibility = true;
        }
        if (this.deleteSelectedTreeTableRow(this.sellTreeTable)) {
            refreshStatusBarExchangeRateVisibility = true;
        }
        if (refreshStatusBarExchangeRateVisibility) {
            this.refreshStatusBarExchangeRateVisibility();
        }
        this.updateWealthHeader();
    }

    private void buyTreeTableValueChanged(TreeSelectionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PortfolioManagementJPanel.this.buyTreeTable.getSelectedRowCount() > 0) {
                    PortfolioManagementJPanel.this.sellTreeTable.clearSelection();
                }
            }
        });
    }

    private void sellTreeTableValueChanged(TreeSelectionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PortfolioManagementJPanel.this.sellTreeTable.getSelectedRowCount() > 0) {
                    PortfolioManagementJPanel.this.buyTreeTable.clearSelection();
                }
            }
        });
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clearTableSelection();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        List<StockInfo> stockInfos = this.getSelectedStockInfos(this.buyTreeTable);
        if (stockInfos.size() != 1) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_you_need_to_select_only_single_stock_from_buy_portfolio_to_perform_sell_transaction"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_you_need_to_select_only_single_stock_from_buy_portfolio_to_perform_sell_transaction"), 1);
            return;
        }
        List<Transaction> transactions = this.getSelectedTransactions(this.buyTreeTable);
        this.showNewSellTransactionJDialog(transactions);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.showDepositSummaryJDialog();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.showDividendSummaryJDialog();
    }

    private List<Transaction> getSelectedTransactions(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        if (treePaths == null) {
            return Collections.unmodifiableList(transactions);
        }
        for (TreePath treePath : treePaths) {
            Object o = treePath.getLastPathComponent();
            if (o instanceof Transaction) {
                Transaction transaction = (Transaction)o;
                if (transactions.contains(transaction)) continue;
                transactions.add(transaction);
                continue;
            }
            if (!(o instanceof TransactionSummary)) continue;
            TransactionSummary transactionSummary = (TransactionSummary)o;
            int count = transactionSummary.getChildCount();
            for (int i = 0; i < count; ++i) {
                Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
                if (transactions.contains(transaction)) continue;
                transactions.add(transaction);
            }
        }
        return Collections.unmodifiableList(transactions);
    }

    private boolean isOnlyTreeTableRootBeingSelected(JXTreeTable treeTable) {
        if (treeTable.getSelectedRowCount() != 1) {
            return false;
        }
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        Object o = treePaths[0].getLastPathComponent();
        AbstractPortfolioTreeTableModelEx portfolioTreeTableModel = (AbstractPortfolioTreeTableModelEx)treeTable.getTreeTableModel();
        return portfolioTreeTableModel.getRoot() == o;
    }

    private void showDividendSummaryJDialog() {
        JStock mainFrame = JStock.instance();
        DividendSummaryJDialog dividendSummaryJDialog = new DividendSummaryJDialog((Frame)mainFrame, true, this.getDividendSummary(), this);
        dividendSummaryJDialog.setLocationRelativeTo(this);
        List<StockInfo> stockInfos = this.getSelectedStockInfos();
        if (stockInfos.size() == 1) {
            dividendSummaryJDialog.addNewDividend(stockInfos.get(0));
        }
        dividendSummaryJDialog.setVisible(true);
        DividendSummary _dividendSummary = dividendSummaryJDialog.getDividendSummaryAfterPressingOK();
        if (_dividendSummary != null) {
            this.dividendSummary = _dividendSummary;
            this.updateWealthHeader();
        }
    }

    private void showRenameStockJDialog(StockInfo originalStockInfo) {
        JStock mainFrame = JStock.instance();
        RenameStockJDialog renameStockJDialog = new RenameStockJDialog((Frame)mainFrame, true, originalStockInfo, this);
        renameStockJDialog.setLocationRelativeTo(this);
        renameStockJDialog.setVisible(true);
    }

    private void showSplitOrMergeJDialog(StockInfo stockInfo) {
        JStock mainFrame = JStock.instance();
        SplitJDialog splitOrMergeJDialog = new SplitJDialog((Frame)mainFrame, true, stockInfo);
        splitOrMergeJDialog.pack();
        splitOrMergeJDialog.setLocationRelativeTo(this);
        splitOrMergeJDialog.setVisible(true);
        if (splitOrMergeJDialog.getRatio() == null) {
            return;
        }
        double ratio = splitOrMergeJDialog.getRatio();
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        portfolioTreeTableModel.split(stockInfo, ratio);
        this.updateWealthHeader();
    }

    private void showDepositSummaryJDialog() {
        JStock mainFrame = JStock.instance();
        DepositSummaryJDialog depositSummaryJDialog = new DepositSummaryJDialog((Frame)mainFrame, true, this.getDepositSummary());
        depositSummaryJDialog.setLocationRelativeTo(this);
        depositSummaryJDialog.setVisible(true);
        DepositSummary _depositSummary = depositSummaryJDialog.getDepositSummaryAfterPressingOK();
        if (_depositSummary != null) {
            this.depositSummary = _depositSummary;
            this.updateWealthHeader();
        }
    }

    private void showCommentJDialog(Commentable commentable, String title) {
        if (commentable == null) {
            return;
        }
        JStock mainFrame = JStock.instance();
        CommentJDialog commentJDialog = new CommentJDialog((Frame)mainFrame, true, commentable);
        commentJDialog.setTitle(title);
        commentJDialog.setLocationRelativeTo(this);
        commentJDialog.setVisible(true);
    }

    public DepositSummary getDepositSummary() {
        return this.depositSummary;
    }

    public DividendSummary getDividendSummary() {
        return this.dividendSummary;
    }

    private ImageIcon getImageIcon(String imageIcon) {
        return new ImageIcon(this.getClass().getResource(imageIcon));
    }

    private void showBuyPortfolioChartJDialog() {
        JStock m = JStock.instance();
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        BuyPortfolioChartJDialog buyPortfolioChartJDialog = new BuyPortfolioChartJDialog(m, false, buyPortfolioTreeTableModel, this.portfolioRealTimeInfo, this.getDividendSummary());
        buyPortfolioChartJDialog.setVisible(true);
    }

    private void showChashFlowChartJDialog() {
        JStock m = JStock.instance();
        InvestmentFlowChartJDialog cashFlowChartJDialog = new InvestmentFlowChartJDialog((Frame)m, false, this);
        cashFlowChartJDialog.setVisible(true);
    }

    private void showSellPortfolioChartJDialog() {
        JStock m = JStock.instance();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        SellPortfolioChartJDialog sellPortfolioChartJDialog = new SellPortfolioChartJDialog(m, false, sellPortfolioTreeTableModel, this.portfolioRealTimeInfo, this.getDividendSummary());
        sellPortfolioChartJDialog.setVisible(true);
    }

    private JPopupMenu getSellTreeTablePopupMenu() {
        final List<Transaction> transactions = this.getSelectedTransactions(this.sellTreeTable);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = null;
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_Cash..."), this.getImageIcon("/images/16x16/money.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDepositSummaryJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Dividend..."), this.getImageIcon("/images/16x16/money2.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryJDialog();
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        if (transactions.size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Edit..."), this.getImageIcon("/images/16x16/edit.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
                }
            });
            popup.add(menuItem);
        }
        final Commentable commentable = this.getSelectedCommentable(this.sellTreeTable);
        final String tmp = this.getSelectedFirstColumnString(this.sellTreeTable);
        if (commentable != null && tmp != null) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Note..."), this.getImageIcon("/images/16x16/sticky.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String template = GUIBundle.getString("PortfolioManagementJPanel_NoteFor_template");
                    String title = MessageFormat.format(template, tmp);
                    PortfolioManagementJPanel.this.showCommentJDialog(commentable, title);
                }
            });
            popup.add(menuItem);
            popup.addSeparator();
        } else if (transactions.size() == 1) {
            popup.addSeparator();
        }
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_InvestmentChart..."), this.getImageIcon("/images/16x16/graph.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showChashFlowChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_DividendChart"), this.getImageIcon("/images/16x16/chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryBarChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Summary..."), this.getImageIcon("/images/16x16/pie_chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showSellPortfolioChartJDialog();
            }
        });
        popup.add(menuItem);
        if (!this.isOnlyTreeTableRootBeingSelected(this.sellTreeTable) && this.sellTreeTable.getSelectedRow() > 0) {
            final JStock m = JStock.instance();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List stockInfos = PortfolioManagementJPanel.this.getSelectedStockInfos(PortfolioManagementJPanel.this.sellTreeTable);
                    for (StockInfo stockInfo : stockInfos) {
                        m.displayHistoryChart(stockInfo);
                    }
                }
            });
            popup.addSeparator();
            popup.add(menuItem);
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_News..."), this.getImageIcon("/images/16x16/news.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List stockInfos = PortfolioManagementJPanel.this.getSelectedStockInfos(PortfolioManagementJPanel.this.sellTreeTable);
                    for (StockInfo stockInfo : stockInfos) {
                        m.displayStockNews(stockInfo);
                    }
                }
            });
            popup.add(menuItem);
            final List<StockInfo> selectedSellStockInfos = this.getSelectedStockInfos(this.sellTreeTable);
            if (selectedSellStockInfos.size() == 1) {
                popup.addSeparator();
                menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Rename..."), null);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PortfolioManagementJPanel.this.showRenameStockJDialog((StockInfo)selectedSellStockInfos.get(0));
                    }
                });
                popup.add(menuItem);
            }
            popup.addSeparator();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.deteleSelectedTreeTableRow();
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private void showDividendSummaryBarChartJDialog() {
        JStock m = JStock.instance();
        DividendSummaryBarChartJDialog dividendSummaryBarChartJDialog = new DividendSummaryBarChartJDialog((Frame)m, false, this.getDividendSummary());
        dividendSummaryBarChartJDialog.setVisible(true);
    }

    private JPopupMenu getBuyTreeTablePopupMenu() {
        List<StockInfo> selectedStockInfos;
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Buy..."), this.getImageIcon("/images/16x16/inbox.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                List stockInfos = PortfolioManagementJPanel.this.getSelectedStockInfos();
                if (stockInfos.size() == 1) {
                    PortfolioManagementJPanel.this.showNewBuyTransactionJDialog((StockInfo)stockInfos.get(0), PortfolioManagementJPanel.this.getStockPrice(((StockInfo)stockInfos.get((int)0)).code), true);
                } else {
                    PortfolioManagementJPanel.this.showNewBuyTransactionJDialog(StockInfo.newInstance(Code.newInstance(""), Symbol.newInstance("")), 0.0, true);
                }
            }
        });
        popup.add(menuItem);
        final List<Transaction> transactions = this.getSelectedTransactions(this.buyTreeTable);
        List<StockInfo> stockInfos = this.getSelectedStockInfos(this.buyTreeTable);
        if (transactions.size() > 0 && stockInfos.size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Sell..."), this.getImageIcon("/images/16x16/outbox.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showNewSellTransactionJDialog(transactions);
                }
            });
            popup.add(menuItem);
        }
        popup.addSeparator();
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_Cash..."), this.getImageIcon("/images/16x16/money.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDepositSummaryJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Dividend..."), this.getImageIcon("/images/16x16/money2.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryJDialog();
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        boolean needToAddSeperator = false;
        if (transactions.size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Edit..."), this.getImageIcon("/images/16x16/edit.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
                }
            });
            popup.add(menuItem);
            needToAddSeperator = true;
        }
        final Commentable commentable = this.getSelectedCommentable(this.buyTreeTable);
        final String tmp = this.getSelectedFirstColumnString(this.buyTreeTable);
        if (commentable != null && tmp != null) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Note..."), this.getImageIcon("/images/16x16/sticky.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String template = GUIBundle.getString("PortfolioManagementJPanel_NoteFor_template");
                    String title = MessageFormat.format(template, tmp);
                    PortfolioManagementJPanel.this.showCommentJDialog(commentable, title);
                }
            });
            popup.add(menuItem);
            needToAddSeperator = true;
        }
        if ((selectedStockInfos = this.getSelectedStockInfos()).size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_SplitOrMerge"), this.getImageIcon("/images/16x16/merge.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showSplitOrMergeJDialog((StockInfo)selectedStockInfos.get(0));
                }
            });
            popup.add(menuItem);
            needToAddSeperator = true;
        }
        if (needToAddSeperator) {
            popup.addSeparator();
        }
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_InvestmentChart..."), this.getImageIcon("/images/16x16/graph.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showChashFlowChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_DividendChart"), this.getImageIcon("/images/16x16/chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryBarChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Summary..."), this.getImageIcon("/images/16x16/pie_chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showBuyPortfolioChartJDialog();
            }
        });
        popup.add(menuItem);
        if (!this.isOnlyTreeTableRootBeingSelected(this.buyTreeTable) && this.buyTreeTable.getSelectedRow() > 0) {
            final JStock m = JStock.instance();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List stockInfos = PortfolioManagementJPanel.this.getSelectedStockInfos(PortfolioManagementJPanel.this.buyTreeTable);
                    for (StockInfo stockInfo : stockInfos) {
                        m.displayHistoryChart(stockInfo);
                    }
                }
            });
            popup.addSeparator();
            popup.add(menuItem);
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_News..."), this.getImageIcon("/images/16x16/news.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List stockInfos = PortfolioManagementJPanel.this.getSelectedStockInfos(PortfolioManagementJPanel.this.buyTreeTable);
                    for (StockInfo stockInfo : stockInfos) {
                        m.displayStockNews(stockInfo);
                    }
                }
            });
            popup.add(menuItem);
            final List<StockInfo> selectedBuyStockInfos = this.getSelectedStockInfos(this.buyTreeTable);
            if (selectedBuyStockInfos.size() == 1) {
                popup.addSeparator();
                menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Rename..."), null);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PortfolioManagementJPanel.this.showRenameStockJDialog((StockInfo)selectedBuyStockInfos.get(0));
                    }
                });
                popup.add(menuItem);
            }
            popup.addSeparator();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.deteleSelectedTreeTableRow();
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private void editSellTransaction(Transaction newTransaction, Transaction oldTransaction) {
        assert (newTransaction.getType() == Contract.Type.Sell);
        assert (oldTransaction.getType() == Contract.Type.Sell);
        SellPortfolioTreeTableModelEx portfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        portfolioTreeTableModel.editTransaction(newTransaction, oldTransaction);
    }

    private void editBuyTransaction(Transaction newTransaction, Transaction oldTransaction) {
        assert (newTransaction.getType() == Contract.Type.Buy);
        assert (oldTransaction.getType() == Contract.Type.Buy);
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        portfolioTreeTableModel.editTransaction(newTransaction, oldTransaction);
    }

    private Set<Code> getCodes(SortableTreeTable treeTable) {
        HashSet<Code> codes = new HashSet<Code>();
        AbstractPortfolioTreeTableModelEx portfolioTreeTableModelEx = (AbstractPortfolioTreeTableModelEx)treeTable.getTreeTableModel();
        Portfolio portfolio = (Portfolio)portfolioTreeTableModelEx.getRoot();
        Enumeration transactionSummaries = portfolio.children();
        while (transactionSummaries.hasMoreElements()) {
            TransactionSummary transactionSummary = (TransactionSummary)transactionSummaries.nextElement();
            Enumeration transactions = transactionSummary.children();
            if (!transactions.hasMoreElements()) continue;
            Transaction transaction = (Transaction)transactionSummary.children().nextElement();
            StockInfo stockInfo = transaction.getStockInfo();
            codes.add(stockInfo.code);
        }
        return codes;
    }

    private Set<Code> getBuyCodes() {
        return this.getCodes(this.buyTreeTable);
    }

    private Set<Code> getSellCodes() {
        return this.getCodes(this.sellTreeTable);
    }

    private Set<Code> getCodes() {
        Set<Code> codes = this.getBuyCodes();
        codes.addAll(this.getSellCodes());
        return codes;
    }

    private Set<CurrencyPair> getCurrencyPairs() {
        Currency localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency();
        if (localCurrency == null) {
            return Collections.emptySet();
        }
        HashSet<CurrencyPair> currencyPairs = new HashSet<CurrencyPair>();
        Set<Code> codes = this.getCodes();
        for (Code code : codes) {
            Currency stockCurrency = org.yccheok.jstock.portfolio.Utils.getStockCurrency(this.portfolioRealTimeInfo, code);
            if (stockCurrency.equals(localCurrency)) continue;
            CurrencyPair currencyPair = CurrencyPair.create(stockCurrency, localCurrency);
            currencyPairs.add(currencyPair);
        }
        return currencyPairs;
    }

    private int getBuyTransactionSize() {
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        return portfolioTreeTableModel.getTransactionSize();
    }

    private int getSellTransactionSize() {
        SellPortfolioTreeTableModelEx portfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        return portfolioTreeTableModel.getTransactionSize();
    }

    public boolean rename(StockInfo newStockInfo, StockInfo oldStockInfo) {
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModelEx = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModelEx = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        if (!buyPortfolioTreeTableModelEx.isRenameOk(newStockInfo)) {
            String output = MessageFormat.format(MessagesBundle.getString("warning_message_unable_to_rename_buy_template"), newStockInfo.code.toString());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("warning_title_unable_to_rename"), 2);
            return false;
        }
        if (!sellPortfolioTreeTableModelEx.isRenameOk(newStockInfo)) {
            String output = MessageFormat.format(MessagesBundle.getString("warning_message_unable_to_rename_sell_template"), newStockInfo.code.toString());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("warning_title_unable_to_rename"), 2);
            return false;
        }
        if (!this.dividendSummary.isRenameOk(newStockInfo)) {
            String output = MessageFormat.format(MessagesBundle.getString("warning_message_unable_to_rename_dividend_template"), newStockInfo.code.toString());
            JOptionPane.showMessageDialog(this, output, MessagesBundle.getString("warning_title_unable_to_rename"), 2);
            return false;
        }
        buyPortfolioTreeTableModelEx.rename(newStockInfo, oldStockInfo);
        sellPortfolioTreeTableModelEx.rename(newStockInfo, oldStockInfo);
        this.dividendSummary.rename(newStockInfo, oldStockInfo);
        this.updateRealTimeStockMonitorAccordingToPortfolioTreeTableModels();
        this.updateExchangeRateMonitorAccordingToPortfolioTreeTableModels();
        return true;
    }

    private TransactionSummary addBuyTransaction(Transaction transaction) {
        Currency stockCurrency;
        Currency localCurrency;
        ExchangeRateMonitor _exchangeRateMonitor;
        assert (transaction.getType() == Contract.Type.Buy);
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        TransactionSummary transactionSummary = portfolioTreeTableModel.addTransaction(transaction);
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.addStockCode(transaction.getStockInfo().code);
            _realTimeStockMonitor.startNewThreadsIfNecessary();
            _realTimeStockMonitor.refresh();
        }
        if ((_exchangeRateMonitor = this.exchangeRateMonitor) != null && (localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency()) != null && !(stockCurrency = org.yccheok.jstock.portfolio.Utils.getStockCurrency(this.portfolioRealTimeInfo, transaction.getStockInfo().code)).equals(localCurrency)) {
            _exchangeRateMonitor.addCurrencyPair(CurrencyPair.create(stockCurrency, localCurrency));
            _exchangeRateMonitor.startNewThreadsIfNecessary();
            _exchangeRateMonitor.refresh();
        }
        return transactionSummary;
    }

    public List<TransactionSummary> getTransactionSummariesFromPortfolios() {
        int i;
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        Portfolio buyPortfolio = (Portfolio)buyPortfolioTreeTableModel.getRoot();
        Portfolio sellPortfolio = (Portfolio)sellPortfolioTreeTableModel.getRoot();
        ArrayList<TransactionSummary> summaries = new ArrayList<TransactionSummary>();
        int count = buyPortfolio.getChildCount();
        for (i = 0; i < count; ++i) {
            summaries.add((TransactionSummary)buyPortfolio.getChildAt(i));
        }
        count = sellPortfolio.getChildCount();
        for (i = 0; i < count; ++i) {
            summaries.add((TransactionSummary)sellPortfolio.getChildAt(i));
        }
        return summaries;
    }

    public List<StockInfo> getStockInfosFromPortfolios() {
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        Portfolio buyPortfolio = (Portfolio)buyPortfolioTreeTableModel.getRoot();
        Portfolio sellPortfolio = (Portfolio)sellPortfolioTreeTableModel.getRoot();
        HashSet<Code> codes = new HashSet<Code>();
        ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
        int count = buyPortfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            transactionSummary = (TransactionSummary)buyPortfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            StockInfo stockInfo = transaction.getStockInfo();
            if (codes.contains(stockInfo.code)) continue;
            codes.add(stockInfo.code);
            stockInfos.add(stockInfo);
        }
        int count2 = sellPortfolio.getChildCount();
        transactionSummary = null;
        for (int i = 0; i < count2; ++i) {
            transactionSummary = (TransactionSummary)sellPortfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            StockInfo stockInfo = transaction.getStockInfo();
            if (codes.contains(stockInfo.code)) continue;
            codes.add(stockInfo.code);
            stockInfos.add(stockInfo);
        }
        return stockInfos;
    }

    private TransactionSummary addSellTransaction(Transaction transaction) {
        Currency stockCurrency;
        Currency localCurrency;
        assert (transaction.getType() == Contract.Type.Sell);
        SellPortfolioTreeTableModelEx portfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        TransactionSummary transactionSummary = portfolioTreeTableModel.addTransaction(transaction);
        ExchangeRateMonitor _exchangeRateMonitor = this.exchangeRateMonitor;
        if (_exchangeRateMonitor != null && (localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency()) != null && !(stockCurrency = org.yccheok.jstock.portfolio.Utils.getStockCurrency(this.portfolioRealTimeInfo, transaction.getStockInfo().code)).equals(localCurrency)) {
            _exchangeRateMonitor.addCurrencyPair(CurrencyPair.create(stockCurrency, localCurrency));
            _exchangeRateMonitor.startNewThreadsIfNecessary();
            _exchangeRateMonitor.refresh();
        }
        return transactionSummary;
    }

    private void updateExchangeRateMonitorAccordingToPortfolioTreeTableModels() {
        ExchangeRateMonitor _exchangeRateMonitor = this.exchangeRateMonitor;
        if (_exchangeRateMonitor == null) {
            return;
        }
        _exchangeRateMonitor.clearCurrencyPairs();
        Set<CurrencyPair> currencyPairs = this.getCurrencyPairs();
        for (CurrencyPair currencyPair : currencyPairs) {
            _exchangeRateMonitor.addCurrencyPair(currencyPair);
        }
        _exchangeRateMonitor.startNewThreadsIfNecessary();
        _exchangeRateMonitor.refresh();
    }

    private void updateRealTimeStockMonitorAccordingToPortfolioTreeTableModels() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor == null) {
            return;
        }
        _realTimeStockMonitor.clearStockCodes();
        for (Code code : this.getBuyCodes()) {
            _realTimeStockMonitor.addStockCode(code);
        }
        for (Code code : this.getSellCodes()) {
            if (this.portfolioRealTimeInfo.currencies.containsKey(code)) continue;
            _realTimeStockMonitor.addStockCode(code);
        }
        _realTimeStockMonitor.startNewThreadsIfNecessary();
        _realTimeStockMonitor.refresh();
    }

    private List<StockInfo> getSelectedStockInfos(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
        HashSet<Code> c = new HashSet<Code>();
        if (treePaths == null) {
            return Collections.unmodifiableList(stockInfos);
        }
        for (TreePath treePath : treePaths) {
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof TransactionSummary) {
                TransactionSummary transactionSummary = (TransactionSummary)lastPathComponent;
                assert (transactionSummary.getChildCount() > 0);
                Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
                StockInfo stockInfo = transaction.getStockInfo();
                Code code = stockInfo.code;
                if (c.contains(code)) continue;
                stockInfos.add(stockInfo);
                c.add(code);
                continue;
            }
            if (!(lastPathComponent instanceof Transaction)) continue;
            Transaction transaction = (Transaction)lastPathComponent;
            StockInfo stockInfo = transaction.getStockInfo();
            Code code = stockInfo.code;
            if (c.contains(code)) continue;
            stockInfos.add(stockInfo);
            c.add(code);
        }
        return Collections.unmodifiableList(stockInfos);
    }

    private boolean initCSVPortfolio() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        List<String> availablePortfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        if (availablePortfolioNames.size() <= 0) {
            org.yccheok.jstock.portfolio.Utils.createEmptyPortfolio(org.yccheok.jstock.portfolio.Utils.getDefaultPortfolioName());
            availablePortfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        }
        assert (!availablePortfolioNames.isEmpty());
        if (!availablePortfolioNames.contains(jStockOptions.getPortfolioName())) {
            jStockOptions.setPortfolioName(availablePortfolioNames.get(0));
        }
        this.buyTreeTable.setTreeTableModel((TreeTableModel)new BuyPortfolioTreeTableModelEx());
        this.sellTreeTable.setTreeTableModel((TreeTableModel)new SellPortfolioTreeTableModelEx());
        this.depositSummary = new DepositSummary();
        this.dividendSummary = new DividendSummary();
        File buyPortfolioFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "buyportfolio.csv");
        File sellPortfolioFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "sellportfolio.csv");
        File depositSummaryFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "depositsummary.csv");
        File dividendSummaryFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "dividendsummary.csv");
        File portfolioRealTimeInfoFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioRealTimeInfoFilepath());
        PortfolioRealTimeInfo _portfolioRealTimeInfo = new PortfolioRealTimeInfo();
        boolean status = _portfolioRealTimeInfo.load(portfolioRealTimeInfoFile);
        if (!status) {
            Pair<HashMap<Code, Double>, Long> csvStockPrices = org.yccheok.jstock.portfolio.Utils.getCSVStockPrices();
            _portfolioRealTimeInfo.stockPrices.putAll((Map)csvStockPrices.first);
            _portfolioRealTimeInfo.stockPricesTimestamp = (Long)csvStockPrices.second;
            _portfolioRealTimeInfo.stockPricesDirty = !_portfolioRealTimeInfo.stockPrices.isEmpty();
        }
        this.portfolioRealTimeInfo = _portfolioRealTimeInfo;
        if (!this.openAsCSVFile(buyPortfolioFile) && buyPortfolioFile.exists()) {
            return false;
        }
        if (!this.openAsCSVFile(sellPortfolioFile) && sellPortfolioFile.exists()) {
            return false;
        }
        if (!this.openAsCSVFile(dividendSummaryFile) && dividendSummaryFile.exists()) {
            return false;
        }
        if (!this.openAsCSVFile(depositSummaryFile) && depositSummaryFile.exists()) {
            return false;
        }
        this.refershGUIAfterInitPortfolio((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), this.dividendSummary, this.depositSummary);
        return true;
    }

    public void refreshGUIAfterOptionsJDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._refreshGUIAfterOptionsJDialog();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this._refreshGUIAfterOptionsJDialog();
                }
            });
        }
    }

    private void _refreshGUIAfterOptionsJDialog() {
        this.buyTreeTable.repaint();
        this.sellTreeTable.repaint();
        this.updateWealthHeader();
    }

    public void refreshGUIAfterFeeCalculationEnabledOptionsChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._refreshGUIAfterFeeCalculationEnabledOptionsChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this._refreshGUIAfterFeeCalculationEnabledOptionsChanged();
                }
            });
        }
    }

    public void _refreshGUIAfterFeeCalculationEnabledOptionsChanged() {
        this.buyTreeTable.repaint();
        this.sellTreeTable.repaint();
        this.updateWealthHeader();
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        JTable[] tables = new JTable[]{this.sellTreeTable, this.buyTreeTable};
        String[] names = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty")};
        for (JTable table : tables) {
            for (String name : names) {
                if (jStockOptions.isFeeCalculationEnabled()) {
                    int columnCount = table.getColumnCount();
                    JTableUtilities.insertTableColumnFromModel(table, name, columnCount);
                    continue;
                }
                JTableUtilities.removeTableColumn(table, name);
            }
        }
    }

    private void _refershGUIAfterInitPortfolio(BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, DividendSummary _dividendSummary, DepositSummary _depositSummary) {
        if (this.buyTreeTable.getTreeTableModel() != buyPortfolioTreeTableModel) {
            this.buyTreeTable.setTreeTableModel((TreeTableModel)buyPortfolioTreeTableModel);
        }
        if (this.sellTreeTable.getTreeTableModel() != sellPortfolioTreeTableModel) {
            this.sellTreeTable.setTreeTableModel((TreeTableModel)sellPortfolioTreeTableModel);
        }
        this.depositSummary = _depositSummary;
        this.dividendSummary = _dividendSummary;
        this.updateRealTimeStockMonitorAccordingToPortfolioTreeTableModels();
        this.updateExchangeRateMonitorAccordingToPortfolioTreeTableModels();
        this.updateWealthHeader();
        this.initGUIOptions();
        this.updateTitledBorder();
        this.refreshCurrencySymbol();
        this.expandTreeTable(this.buyTreeTable);
        this.expandTreeTable(this.sellTreeTable);
    }

    private void expandTreeTable(JXTreeTable treeTable) {
        if (treeTable.isExpanded(0)) {
            treeTable.collapseRow(0);
        }
        treeTable.expandRow(0);
    }

    private void refershGUIAfterInitPortfolio(final BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, final SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, final DividendSummary _dividendSummary, final DepositSummary _depositSummary) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._refershGUIAfterInitPortfolio(buyPortfolioTreeTableModel, sellPortfolioTreeTableModel, _dividendSummary, _depositSummary);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this._refershGUIAfterInitPortfolio(buyPortfolioTreeTableModel, sellPortfolioTreeTableModel, _dividendSummary, _depositSummary);
                }
            });
        }
    }

    public final void initPortfolio() {
        this.initCSVPortfolio();
    }

    public void updateTitledBorder() {
        final JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        if (SwingUtilities.isEventDispatchThread()) {
            TitledBorder titledBorder = (TitledBorder)this.jPanel1.getBorder();
            titledBorder.setTitle(jStockOptions.getPortfolioName());
            this.jPanel1.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TitledBorder titledBorder = (TitledBorder)PortfolioManagementJPanel.this.jPanel1.getBorder();
                    titledBorder.setTitle(jStockOptions.getPortfolioName());
                    PortfolioManagementJPanel.this.jPanel1.repaint();
                }
            });
        }
    }

    private boolean saveCSVPortfolio(String directory, PortfolioRealTimeInfo portfolioRealTimeInfo) {
        int count;
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel;
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel;
        int count2;
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        assert (directory.endsWith(File.separator));
        File buyPortfolioFile = new File(directory + "buyportfolio.csv");
        File sellPortfolioFile = new File(directory + "sellportfolio.csv");
        File dividendSummaryFile = new File(directory + "dividendsummary.csv");
        File depositSummaryFile = new File(directory + "depositsummary.csv");
        Utils.FileEx buyPortfolioFileEx = new Utils.FileEx(buyPortfolioFile, Statement.Type.PortfolioManagementBuy);
        Utils.FileEx sellPortfolioFileEx = new Utils.FileEx(sellPortfolioFile, Statement.Type.PortfolioManagementSell);
        Utils.FileEx dividendSummaryFileEx = new Utils.FileEx(dividendSummaryFile, Statement.Type.PortfolioManagementDividend);
        Utils.FileEx depositSummaryFileEx = new Utils.FileEx(depositSummaryFile, Statement.Type.PortfolioManagementDeposit);
        if (!this.saveAsCSVFile(buyPortfolioFileEx, true) && (count2 = (buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel()).getRoot().getChildCount()) > 0) {
            buyPortfolioFileEx.file.delete();
            return false;
        }
        if (!this.saveAsCSVFile(sellPortfolioFileEx, true) && (count2 = (sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel()).getRoot().getChildCount()) > 0) {
            sellPortfolioFileEx.file.delete();
            buyPortfolioFileEx.file.delete();
            return false;
        }
        if (!this.saveAsCSVFile(dividendSummaryFileEx, true) && (count = this.dividendSummary.size()) > 0) {
            dividendSummaryFileEx.file.delete();
            depositSummaryFileEx.file.delete();
            sellPortfolioFileEx.file.delete();
            buyPortfolioFileEx.file.delete();
            return false;
        }
        if (!this.saveAsCSVFile(depositSummaryFileEx, true) && (count = this.depositSummary.size()) > 0) {
            depositSummaryFileEx.file.delete();
            sellPortfolioFileEx.file.delete();
            buyPortfolioFileEx.file.delete();
            return false;
        }
        boolean status = this.savePortfolioRealTimeInfo(directory, portfolioRealTimeInfo);
        if (status) {
            File stockPricesFile = new File(org.yccheok.jstock.portfolio.Utils.getStockPricesFilepathViaDirectory(directory));
            stockPricesFile.delete();
        }
        return status;
    }

    private boolean saveCSVPortfolio() {
        return this.saveCSVPortfolio(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory(), this.portfolioRealTimeInfo);
    }

    private boolean savePortfolioRealTimeInfo(String directory, PortfolioRealTimeInfo portfolioRealTimeInfo) {
        PortfolioRealTimeInfo _portfolioRealTimeInfo = new PortfolioRealTimeInfo(portfolioRealTimeInfo);
        HashMap<Code, Double> goodStockPrices = new HashMap<Code, Double>();
        HashMap<Code, Double> goodChangePrices = new HashMap<Code, Double>();
        HashMap<Code, Double> goodChangePricePercentages = new HashMap<Code, Double>();
        HashMap<Code, Currency> goodCurrencies = new HashMap<Code, Currency>();
        HashMap<CurrencyPair, Double> goodExchangeRates = new HashMap<CurrencyPair, Double>();
        for (Code code : this.getBuyCodes()) {
            Double price = _portfolioRealTimeInfo.stockPrices.get(code);
            Double changePrice = _portfolioRealTimeInfo.changePrices.get(code);
            Double changePricePercentage = _portfolioRealTimeInfo.changePricePercentages.get(code);
            if (price == null) {
                goodStockPrices.put(code, 0.0);
            } else {
                goodStockPrices.put(code, price);
            }
            if (changePrice == null) {
                goodChangePrices.put(code, 0.0);
            } else {
                goodChangePrices.put(code, changePrice);
            }
            if (changePricePercentage == null) {
                goodChangePricePercentages.put(code, 0.0);
                continue;
            }
            goodChangePricePercentages.put(code, changePricePercentage);
        }
        for (Code code : this.getCodes()) {
            Currency currency = _portfolioRealTimeInfo.currencies.get(code);
            if (currency == null) continue;
            goodCurrencies.put(code, currency);
        }
        for (CurrencyPair currencyPair : this.getCurrencyPairs()) {
            Double rate = _portfolioRealTimeInfo.exchangeRates.get(currencyPair);
            if (rate == null) continue;
            goodExchangeRates.put(currencyPair, rate);
        }
        _portfolioRealTimeInfo.stockPrices.clear();
        _portfolioRealTimeInfo.currencies.clear();
        _portfolioRealTimeInfo.exchangeRates.clear();
        _portfolioRealTimeInfo.changePrices.clear();
        _portfolioRealTimeInfo.changePricePercentages.clear();
        _portfolioRealTimeInfo.stockPrices.putAll(goodStockPrices);
        _portfolioRealTimeInfo.currencies.putAll(goodCurrencies);
        _portfolioRealTimeInfo.exchangeRates.putAll(goodExchangeRates);
        _portfolioRealTimeInfo.changePrices.putAll(goodChangePrices);
        _portfolioRealTimeInfo.changePricePercentages.putAll(goodChangePricePercentages);
        File stockPricesFile = new File(directory + "portfolio-real-time-info.json");
        return _portfolioRealTimeInfo.save(stockPricesFile);
    }

    public boolean savePortfolio() {
        return this.saveCSVPortfolio();
    }

    private void refreshStatusBarExchangeRateVisibility() {
        Country country;
        JStock mainFrame = JStock.instance();
        JStockOptions jStockOptions = mainFrame.getJStockOptions();
        boolean currencyExchangeEnable = jStockOptions.isCurrencyExchangeEnable(country = jStockOptions.getCountry());
        if (!currencyExchangeEnable) {
            mainFrame.setStatusBarExchangeRateVisible(false);
            mainFrame.setStatusBarExchangeRateToolTipText(null);
            return;
        }
        Set<CurrencyPair> currencyPairs = this.getCurrencyPairs();
        currencyPairs.remove(CurrencyPair.create("GBX", "GBP"));
        currencyPairs.remove(CurrencyPair.create("ZAC", "ZAR"));
        if (currencyPairs.isEmpty()) {
            mainFrame.setStatusBarExchangeRateVisible(false);
            mainFrame.setStatusBarExchangeRateToolTipText(null);
            return;
        }
        int size = currencyPairs.size();
        if (size > 1) {
            mainFrame.setStatusBarExchangeRateVisible(false);
            mainFrame.setStatusBarExchangeRateToolTipText(null);
            return;
        }
        if (size == 1) {
            CurrencyPair currencyPair = currencyPairs.iterator().next();
            Currency fromCurrency = currencyPair.from();
            Currency toCurrency = currencyPair.to();
            String text = MessageFormat.format(GUIBundle.getString("MyJXStatusBar_CurrencyExchangeRateFor"), fromCurrency.toString(), toCurrency.toString());
            mainFrame.setStatusBarExchangeRateVisible(true);
            mainFrame.setStatusBarExchangeRateToolTipText(text);
            Double rate = this.portfolioRealTimeInfo.exchangeRates.get(currencyPair);
            if (rate != null) {
                if (currencyPair.from().isGBX() || currencyPair.from().isZAC()) {
                    rate = rate * 100.0;
                }
                if (rate == 1.0) {
                    mainFrame.setStatusBarExchangeRate(null);
                } else {
                    mainFrame.setStatusBarExchangeRate(rate);
                }
            } else {
                mainFrame.setStatusBarExchangeRate(null);
            }
            return;
        }
    }

    public void initExchangeRateMonitor() {
        JStock jstock = JStock.instance();
        JStockOptions jStockOptions = jstock.getJStockOptions();
        Country country = jStockOptions.getCountry();
        boolean currencyExchangeEnable = jStockOptions.isCurrencyExchangeEnable(country);
        this.refreshStatusBarExchangeRateVisibility();
        final ExchangeRateMonitor oldExchangeRateMonitor = this.exchangeRateMonitor;
        if (oldExchangeRateMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldExchangeRateMonitor + "..."));
                    oldExchangeRateMonitor.dettachAll();
                    oldExchangeRateMonitor.stop();
                    log.info((Object)("Shut down " + oldExchangeRateMonitor + " peacefully."));
                }
            });
        }
        if (!currencyExchangeEnable) {
            this.exchangeRateMonitor = null;
            if (oldExchangeRateMonitor != null) {
                this.updateWealthHeader();
            }
            return;
        }
        assert (currencyExchangeEnable);
        this.exchangeRateMonitor = new ExchangeRateMonitor(4, 20, jStockOptions.getScanningSpeed());
        this.exchangeRateMonitor.attach(this.exchangeRateMonitorObserver);
        this.updateExchangeRateMonitorAccordingToPortfolioTreeTableModels();
    }

    public void initRealTimeStockMonitor() {
        final RealTimeStockMonitor oldRealTimeStockMonitor = this.realTimeStockMonitor;
        if (oldRealTimeStockMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeStockMonitor + "..."));
                    oldRealTimeStockMonitor.clearStockCodes();
                    oldRealTimeStockMonitor.dettachAll();
                    oldRealTimeStockMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeStockMonitor + " peacefully."));
                }
            });
        }
        this.realTimeStockMonitor = new RealTimeStockMonitor(4, 20, JStock.instance().getJStockOptions().getScanningSpeed());
        this.realTimeStockMonitor.attach(this.realTimeStockMonitorObserver);
        this.updateRealTimeStockMonitorAccordingToPortfolioTreeTableModels();
    }

    private Observer<ExchangeRateMonitor, List<ExchangeRate>> getExchangeRateMonitorObserver() {
        return new Observer<ExchangeRateMonitor, List<ExchangeRate>>(){

            @Override
            public void update(ExchangeRateMonitor subject, List<ExchangeRate> exchangeRates) {
                final ExchangeRateMonitor _exchangeRateMonitor = PortfolioManagementJPanel.this.exchangeRateMonitor;
                if (_exchangeRateMonitor != null) {
                    final ConcurrentHashMap<CurrencyPair, Double> exchangeRatesMap = ((PortfolioManagementJPanel)PortfolioManagementJPanel.this).portfolioRealTimeInfo.exchangeRates;
                    Set currencyPairs = PortfolioManagementJPanel.this.getCurrencyPairs();
                    for (ExchangeRate exchangeRate : exchangeRates) {
                        final CurrencyPair currencyPair = exchangeRate.currencyPair();
                        if (!currencyPairs.contains(currencyPair)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!PortfolioManagementJPanel.this.getCurrencyPairs().contains(currencyPair)) {
                                        _exchangeRateMonitor.removeCurrencyPair(currencyPair);
                                        exchangeRatesMap.remove(currencyPair);
                                    }
                                }
                            });
                        } else {
                            double rate = exchangeRate.rate();
                            exchangeRatesMap.put(currencyPair, rate);
                        }
                        ((PortfolioManagementJPanel)PortfolioManagementJPanel.this).portfolioRealTimeInfo.exchangeRatesDirty = true;
                    }
                    ((PortfolioManagementJPanel)PortfolioManagementJPanel.this).portfolioRealTimeInfo.exchangeRatesTimestamp = System.currentTimeMillis();
                }
                PortfolioManagementJPanel.this.refreshStatusBarExchangeRateVisibility();
                PortfolioManagementJPanel.this.updateWealthHeader();
                BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)PortfolioManagementJPanel.this.buyTreeTable.getTreeTableModel();
                SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)PortfolioManagementJPanel.this.sellTreeTable.getTreeTableModel();
                buyPortfolioTreeTableModel.refreshRoot();
                sellPortfolioTreeTableModel.refreshRoot();
            }
        };
    }

    private Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result>(){

            @Override
            public void update(RealTimeStockMonitor monitor, RealTimeStockMonitor.Result result) {
                PortfolioManagementJPanel.this.update(monitor, result);
            }
        };
    }

    private double getNonZeroPriceIfPossible(Stock stock) {
        double lastPrice = stock.getLastPrice();
        if (lastPrice > 0.0) {
            return lastPrice;
        }
        double openPrice = stock.getOpenPrice();
        if (openPrice > 0.0) {
            return openPrice;
        }
        double prevPrice = stock.getPrevPrice();
        return Math.max(0.0, prevPrice);
    }

    private void update(RealTimeStockMonitor monitor, RealTimeStockMonitor.Result result) {
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        ConcurrentHashMap<Code, Double> stockPrices = this.portfolioRealTimeInfo.stockPrices;
        ConcurrentHashMap<Code, Currency> currencies = this.portfolioRealTimeInfo.currencies;
        ConcurrentHashMap<Code, Double> changePrices = this.portfolioRealTimeInfo.changePrices;
        ConcurrentHashMap<Code, Double> changePricePercentages = this.portfolioRealTimeInfo.changePricePercentages;
        Set<Code> buyCodes = this.getBuyCodes();
        Set<Code> sellCodes = this.getSellCodes();
        for (Stock stock : result.stocks) {
            CurrencyPair currencyPair;
            Currency localCurrency;
            final Code code = stock.code;
            Currency currency = stock.getCurrency();
            boolean needBuyRefresh = false;
            boolean needSellRefresh = false;
            if (buyCodes.contains(code)) {
                Currency oldCurrency;
                Double oldPrice;
                Double price = this.getNonZeroPriceIfPossible(stock);
                if (!price.equals(oldPrice = stockPrices.put(code, price))) {
                    this.portfolioRealTimeInfo.stockPricesDirty = true;
                    needBuyRefresh = true;
                }
                if (currency != null && !currency.equals(oldCurrency = currencies.put(code, currency))) {
                    this.portfolioRealTimeInfo.currenciesDirty = true;
                    needBuyRefresh = true;
                    if (sellCodes.contains(code)) {
                        needSellRefresh = true;
                    }
                }
                double changePrice = stock.getChangePrice();
                double changePricePercentage = stock.getChangePricePercentage();
                Double oldChangePrice = (Double)changePrices.get(code);
                changePrices.put(code, changePrice);
                if (oldChangePrice == null || oldChangePrice != changePrice) {
                    this.portfolioRealTimeInfo.changePricesDirty = true;
                }
                Double oldChangePricePercentage = (Double)changePricePercentages.get(code);
                changePricePercentages.put(code, changePricePercentage);
                if (oldChangePricePercentage == null || oldChangePricePercentage != changePricePercentage) {
                    this.portfolioRealTimeInfo.changePricePercentagesDirty = true;
                }
            } else if (sellCodes.contains(code)) {
                if (currency != null) {
                    Currency oldCurrency = currencies.put(code, currency);
                    if (!currency.equals(oldCurrency)) {
                        this.portfolioRealTimeInfo.currenciesDirty = true;
                        needSellRefresh = true;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Set buyCodes = PortfolioManagementJPanel.this.getBuyCodes();
                            if (!buyCodes.contains(code)) {
                                PortfolioManagementJPanel.this.realTimeStockMonitor.removeStockCode(code);
                            }
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Set codes = PortfolioManagementJPanel.this.getCodes();
                        if (!codes.contains(code)) {
                            PortfolioManagementJPanel.this.realTimeStockMonitor.removeStockCode(code);
                        }
                    }
                });
                continue;
            }
            if (needBuyRefresh) {
                buyPortfolioTreeTableModel.refresh(code);
            }
            if (needSellRefresh) {
                sellPortfolioTreeTableModel.refresh(code);
            }
            ExchangeRateMonitor _exchangeRateMonitor = this.exchangeRateMonitor;
            if (currency == null || _exchangeRateMonitor == null || (localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency()) == null || currency.equals(localCurrency) || !_exchangeRateMonitor.addCurrencyPair(currencyPair = CurrencyPair.create(currency, localCurrency))) continue;
            _exchangeRateMonitor.startNewThreadsIfNecessary();
            _exchangeRateMonitor.refresh();
        }
        this.updateWealthHeader();
        this.portfolioRealTimeInfo.stockPricesTimestamp = System.currentTimeMillis();
        JStock.instance().updateStatusBarWithLastUpdateDateMessageIfPossible();
    }

    public long getTimestamp() {
        return this.portfolioRealTimeInfo.stockPricesTimestamp;
    }

    private void initGUIOptions() {
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.PortfolioManagementJPanelXml.get());
        GUIOptions guiOptions = Utils.fromXML(GUIOptions.class, f);
        if (guiOptions == null) {
            return;
        }
        if (guiOptions.getJTableOptionsSize() <= 1) {
            return;
        }
        JXTreeTable[] treeTables = new JXTreeTable[]{this.buyTreeTable, this.sellTreeTable};
        for (int tableIndex = 0; tableIndex < treeTables.length; ++tableIndex) {
            JXTreeTable treeTable = treeTables[tableIndex];
            JTableHeader jTableHeader = treeTable.getTableHeader();
            JTable jTable = jTableHeader.getTable();
            JTableUtilities.setJTableOptions(jTable, guiOptions.getJTableOptions(tableIndex));
        }
        if (guiOptions.getDividerLocationSize() > 0) {
            this.dividerLocation = guiOptions.getDividerLocation(0);
        }
    }

    public void updateDividerLocation() {
        if (this.dividerLocation > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this.jSplitPane1.setDividerLocation(PortfolioManagementJPanel.this.dividerLocation);
                }
            });
        }
    }

    public boolean saveGUIOptions() {
        JXTreeTable[] treeTables;
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(UserDataDirectory.Config.get())) {
            return false;
        }
        GUIOptions guiOptions = new GUIOptions();
        for (JXTreeTable treeTable : treeTables = new JXTreeTable[]{this.buyTreeTable, this.sellTreeTable}) {
            JTableHeader jTableHeader = treeTable.getTableHeader();
            JTable jTable = jTableHeader.getTable();
            GUIOptions.JTableOptions jTableOptions = new GUIOptions.JTableOptions();
            int count = jTable.getColumnCount();
            for (int i = 0; i < count; ++i) {
                String name = jTable.getColumnName(i);
                TableColumn column = jTable.getColumnModel().getColumn(i);
                jTableOptions.addColumnOption(GUIOptions.JTableOptions.ColumnOption.newInstance(name, column.getWidth()));
            }
            guiOptions.addJTableOptions(jTableOptions);
        }
        guiOptions.addDividerLocation(this.jSplitPane1.getDividerLocation());
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.PortfolioManagementJPanelXml.get());
        return Utils.toXML((Object)guiOptions, f);
    }

    public boolean saveAsExcelFile(File file, boolean languageIndependent) {
        Statements statements0 = Statements.newInstanceFromBuyPortfolioTreeTableModel((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), this.portfolioRealTimeInfo, languageIndependent);
        Statements statements1 = Statements.newInstanceFromSellPortfolioTreeTableModel((SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), this.portfolioRealTimeInfo, languageIndependent);
        Statements statements2 = Statements.newInstanceFromTableModel(new DividendSummaryTableModel(this.dividendSummary), languageIndependent);
        Statements statements3 = Statements.newInstanceFromTableModel(new DepositSummaryTableModel(this.depositSummary), languageIndependent);
        Statements.StatementsEx statementsEx0 = new Statements.StatementsEx(statements0, GUIBundle.getString("PortfolioManagementJPanel_BuyPortfolio"));
        Statements.StatementsEx statementsEx1 = new Statements.StatementsEx(statements1, GUIBundle.getString("PortfolioManagementJPanel_SellPortfolio"));
        Statements.StatementsEx statementsEx2 = new Statements.StatementsEx(statements2, GUIBundle.getString("PortfolioManagementJPanel_DividendPortfolio"));
        Statements.StatementsEx statementsEx3 = new Statements.StatementsEx(statements3, GUIBundle.getString("PortfolioManagementJPanel_CashDepositPortfolio"));
        List<Statements.StatementsEx> statementsExs = Arrays.asList(statementsEx0, statementsEx1, statementsEx2, statementsEx3);
        return Statements.saveAsExcelFile(file, statementsExs);
    }

    public boolean saveAsCSVFile(Utils.FileEx fileEx, boolean languageIndependent) {
        Statements statements = null;
        if (fileEx.type == Statement.Type.PortfolioManagementBuy) {
            statements = Statements.newInstanceFromBuyPortfolioTreeTableModel((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), this.portfolioRealTimeInfo, languageIndependent);
        } else if (fileEx.type == Statement.Type.PortfolioManagementSell) {
            statements = Statements.newInstanceFromSellPortfolioTreeTableModel((SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), this.portfolioRealTimeInfo, languageIndependent);
        } else if (fileEx.type == Statement.Type.PortfolioManagementDividend) {
            statements = Statements.newInstanceFromTableModel(new DividendSummaryTableModel(this.dividendSummary), languageIndependent);
        } else if (fileEx.type == Statement.Type.PortfolioManagementDeposit) {
            statements = Statements.newInstanceFromTableModel(new DepositSummaryTableModel(this.depositSummary), languageIndependent);
        }
        return statements.saveAsCSVFile(fileEx.file);
    }

    private void updateWealthHeader() {
        double realizedProfitPercentage;
        double paperProfitPercentage;
        double realizedProfit;
        double paperProfit;
        double cash;
        double dividend;
        double deposit;
        double _cash;
        double exchangeRate;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        Currency localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency();
        final double share = buyPortfolioTreeTableModel.getCurrentValue(localCurrency);
        Country country = jStockOptions.getCountry();
        if (isFeeCalculationEnabled) {
            exchangeRate = org.yccheok.jstock.portfolio.Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, country.stockCurrency);
            _cash = sellPortfolioTreeTableModel.getNetSellingValue(localCurrency) - ((Portfolio)sellPortfolioTreeTableModel.getRoot()).getNetReferenceTotal(localCurrency) - buyPortfolioTreeTableModel.getNetPurchaseValue(localCurrency);
            deposit = this.getDepositSummary().getTotal() * exchangeRate;
            if (country.stockCurrency.isGBX() || country.stockCurrency.isZAC()) {
                deposit *= 100.0;
            }
            dividend = this.getDividendSummary().getTotal(this.portfolioRealTimeInfo, localCurrency);
            _cash += deposit;
            cash = _cash += dividend;
            paperProfit = buyPortfolioTreeTableModel.getNetGainLossValue(localCurrency);
            realizedProfit = sellPortfolioTreeTableModel.getNetGainLossValue(localCurrency);
        } else {
            exchangeRate = org.yccheok.jstock.portfolio.Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, country.stockCurrency);
            _cash = sellPortfolioTreeTableModel.getSellingValue(localCurrency) - ((Portfolio)sellPortfolioTreeTableModel.getRoot()).getReferenceTotal(localCurrency) - buyPortfolioTreeTableModel.getPurchaseValue(localCurrency);
            deposit = this.getDepositSummary().getTotal() * exchangeRate;
            if (country.stockCurrency.isGBX() || country.stockCurrency.isZAC()) {
                deposit *= 100.0;
            }
            dividend = this.getDividendSummary().getTotal(this.portfolioRealTimeInfo, localCurrency);
            _cash += deposit;
            cash = _cash += dividend;
            paperProfit = buyPortfolioTreeTableModel.getGainLossValue(localCurrency);
            realizedProfit = sellPortfolioTreeTableModel.getGainLossValue(localCurrency);
        }
        if (isFeeCalculationEnabled) {
            paperProfitPercentage = buyPortfolioTreeTableModel.getNetGainLossPercentage(localCurrency);
            realizedProfitPercentage = sellPortfolioTreeTableModel.getNetGainLossPercentage(localCurrency);
        } else {
            paperProfitPercentage = buyPortfolioTreeTableModel.getGainLossPercentage(localCurrency);
            realizedProfitPercentage = sellPortfolioTreeTableModel.getGainLossPercentage(localCurrency);
        }
        DecimalPlace decimalPlace = jStockOptions.getDecimalPlace();
        final String _share = org.yccheok.jstock.portfolio.Utils.toCurrency(decimalPlace, share);
        final String _cash2 = org.yccheok.jstock.portfolio.Utils.toCurrency(decimalPlace, cash);
        final String _paperProfit = org.yccheok.jstock.portfolio.Utils.toCurrency(decimalPlace, paperProfit);
        final String _paperProfitPercentage = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlace.Two, paperProfitPercentage);
        final String _realizedProfit = org.yccheok.jstock.portfolio.Utils.toCurrency(decimalPlace, realizedProfit);
        final String _realizedProfitPercentage = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlace.Two, realizedProfitPercentage);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PortfolioManagementJPanel.this.jLabel2.setText(_share);
                PortfolioManagementJPanel.this.jLabel4.setText(_cash2);
                PortfolioManagementJPanel.this.jLabel6.setText(_paperProfit + " (" + _paperProfitPercentage + "%)");
                PortfolioManagementJPanel.this.jLabel8.setText(_realizedProfit + " (" + _realizedProfitPercentage + "%)");
                PortfolioManagementJPanel.this.jLabel2.setForeground(Utils.getColor(share, 0.0));
                PortfolioManagementJPanel.this.jLabel4.setForeground(Utils.getColor(cash, 0.0));
                PortfolioManagementJPanel.this.jLabel6.setForeground(Utils.getColor(paperProfit, 0.0));
                PortfolioManagementJPanel.this.jLabel8.setForeground(Utils.getColor(realizedProfit, 0.0));
            }
        });
    }

    public void resumeRealTimeStockMonitor() {
        if (this.realTimeStockMonitor == null) {
            return;
        }
        this.realTimeStockMonitor.resume();
    }

    public void suspendRealTimeStockMonitor() {
        if (this.realTimeStockMonitor == null) {
            return;
        }
        this.realTimeStockMonitor.suspend();
    }

    public void refreshCurrencySymbol() {
        this.jLabel1.setText(this.getShareLabel());
        this.jLabel3.setText(this.getCashLabel());
        this.jLabel5.setText(this.getPaperProfitLabel());
        this.jLabel7.setText(this.getRealizedProfitLabel());
    }

    private String getShareLabel() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_ShareLabel"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    private String getCashLabel() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_CashLabel_template"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    private String getPaperProfitLabel() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_PaperProfitLabel_template"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    private String getRealizedProfitLabel() {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_RealizedProfitLabel_template"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    public void refreshExchangeRateMonitor() {
        ExchangeRateMonitor _exchangeRateMonitor = this.exchangeRateMonitor;
        if (_exchangeRateMonitor != null) {
            _exchangeRateMonitor.refresh();
        }
    }

    public void refreshRealTimeStockMonitor() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.refresh();
        }
    }

    public void rebuildRealTimeStockMonitor() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.rebuild();
        }
    }

    public PortfolioRealTimeInfo getPortfolioRealTimeInfo() {
        return this.portfolioRealTimeInfo;
    }

    public boolean shouldDisplayCurrencyForValue(Code code) {
        Currency countryStockCurrency;
        Country country;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        boolean isCurrencyExchangeEnable = jStockOptions.isCurrencyExchangeEnable(country = jStockOptions.getCountry());
        if (!isCurrencyExchangeEnable) {
            return false;
        }
        Currency stockCurrency = org.yccheok.jstock.portfolio.Utils.getStockCurrency(this.portfolioRealTimeInfo, code);
        return false == stockCurrency.equals(countryStockCurrency = country.stockCurrency);
    }

    private class SellTableRowPopupListener
    extends MouseAdapter {
        private SellTableRowPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            List transactions;
            if (evt.getClickCount() == 2 && (transactions = PortfolioManagementJPanel.this.getSelectedTransactions(PortfolioManagementJPanel.this.sellTreeTable)).size() == 1) {
                PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JPopupMenu popupMenu;
            if (e.isPopupTrigger() && (popupMenu = PortfolioManagementJPanel.this.getSellTreeTablePopupMenu()) != null) {
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class BuyTableRowPopupListener
    extends MouseAdapter {
        private BuyTableRowPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            List transactions;
            if (evt.getClickCount() == 2 && (transactions = PortfolioManagementJPanel.this.getSelectedTransactions(PortfolioManagementJPanel.this.buyTreeTable)).size() == 1) {
                PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PortfolioManagementJPanel.this.getBuyTreeTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class TableKeyEventListener
    extends KeyAdapter {
        private TableKeyEventListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            PortfolioManagementJPanel.this.clearTableSelection();
        }
    }
}

