/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine.currency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.engine.currency.CurrencyPair;
import org.yccheok.jstock.engine.currency.ExchangeRate;

public class ExchangeRateMonitor
extends Subject<ExchangeRateMonitor, List<ExchangeRate>> {
    private final Map<Code, CurrencyPair> currencyPairMapping = new ConcurrentHashMap<Code, CurrencyPair>();
    private final RealTimeStockMonitor realTimeStockMonitor;

    public ExchangeRateMonitor(int maxThread, int maxBucketSize, long delay) {
        this.realTimeStockMonitor = new RealTimeStockMonitor(maxThread, maxBucketSize, delay);
        this.realTimeStockMonitor.attach(this.getRealTimeStockMonitorObserver());
    }

    private Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result>(){

            @Override
            public void update(RealTimeStockMonitor subject, RealTimeStockMonitor.Result result) {
                ArrayList<ExchangeRate> exchangeRates = new ArrayList<ExchangeRate>();
                Set centOrPenceCurrencyPairs = ExchangeRateMonitor.this.getCentOrPenceCurrencyPairs();
                for (Stock stock : result.stocks) {
                    CurrencyPair currencyPair;
                    double lastPrice = stock.getLastPrice();
                    if (lastPrice > 0.0 && (currencyPair = (CurrencyPair)ExchangeRateMonitor.this.currencyPairMapping.get(stock.code)) != null) {
                        ExchangeRate exchangeRate = new ExchangeRate(currencyPair, lastPrice);
                        exchangeRates.add(exchangeRate);
                    }
                    if (!(lastPrice > 0.0)) continue;
                    for (CurrencyPair centOrPenceCurrencyPair : centOrPenceCurrencyPairs) {
                        boolean fromIsCentOrPence;
                        CurrencyPair realTimeMonitorCurrencyPair = ExchangeRateMonitor.this.toCurrencyPairForRealTimeStockMonitor(centOrPenceCurrencyPair);
                        Code realTimeMonitorCode = ExchangeRateMonitor.this.toCode(realTimeMonitorCurrencyPair);
                        if (!stock.code.equals(realTimeMonitorCode)) continue;
                        double revisedLastPrice = lastPrice;
                        boolean toIsCentOrPence = centOrPenceCurrencyPair.to().isGBX() || centOrPenceCurrencyPair.to().isZAC() || centOrPenceCurrencyPair.to().isILA();
                        boolean bl = fromIsCentOrPence = centOrPenceCurrencyPair.from().isGBX() || centOrPenceCurrencyPair.from().isZAC() || centOrPenceCurrencyPair.from().isILA();
                        if (fromIsCentOrPence && !toIsCentOrPence) {
                            revisedLastPrice = lastPrice / 100.0;
                        } else if (!fromIsCentOrPence && toIsCentOrPence) {
                            revisedLastPrice = lastPrice * 100.0;
                        } else if (fromIsCentOrPence && toIsCentOrPence) {
                            revisedLastPrice = lastPrice;
                        }
                        ExchangeRate exchangeRate = new ExchangeRate(centOrPenceCurrencyPair, revisedLastPrice);
                        exchangeRates.add(exchangeRate);
                    }
                }
                if (!exchangeRates.isEmpty()) {
                    ExchangeRateMonitor.this.notify(ExchangeRateMonitor.this, exchangeRates);
                }
            }
        };
    }

    private Set<CurrencyPair> getCentOrPenceCurrencyPairs() {
        HashSet<CurrencyPair> currencyPairs = new HashSet<CurrencyPair>();
        for (Map.Entry<Code, CurrencyPair> entry : this.currencyPairMapping.entrySet()) {
            CurrencyPair currencyPair = entry.getValue();
            if (!currencyPair.from().isGBX() && !currencyPair.from().isZAC() && !currencyPair.from().isILA() && !currencyPair.to().isGBX() && !currencyPair.to().isZAC() && !currencyPair.to().isILA()) continue;
            currencyPairs.add(currencyPair);
        }
        return currencyPairs;
    }

    private CurrencyPair toCurrencyPairForRealTimeStockMonitor(CurrencyPair currencyPair) {
        String from = currencyPair.from().name();
        String to = currencyPair.to().name();
        if (currencyPair.from().isGBX()) {
            from = "GBP";
        } else if (currencyPair.from().isZAC()) {
            from = "ZAR";
        } else if (currencyPair.from().isILA()) {
            from = "ILS";
        }
        if (currencyPair.to().isGBX()) {
            to = "GBP";
        } else if (currencyPair.to().isZAC()) {
            to = "ZAR";
        } else if (currencyPair.to().isILA()) {
            to = "ILS";
        }
        if (from.equals(currencyPair.from().name()) && to.equals(currencyPair.to().name())) {
            return currencyPair;
        }
        return CurrencyPair.create(from, to);
    }

    private Code toCode(CurrencyPair currencyPair) {
        Currency from = currencyPair.from();
        Currency to = currencyPair.to();
        String fromCurrencyCode = from.name();
        String toCurrencyCode = to.name();
        return Code.newInstance(fromCurrencyCode + toCurrencyCode + "=X");
    }

    public synchronized boolean addCurrencyPair(CurrencyPair currencyPair) {
        Code code = this.toCode(currencyPair);
        if (this.currencyPairMapping.containsKey(code)) {
            return false;
        }
        this.currencyPairMapping.put(code, currencyPair);
        CurrencyPair realTimeMonitorCurrencyPair = this.toCurrencyPairForRealTimeStockMonitor(currencyPair);
        Code realTimeMonitorCode = this.toCode(realTimeMonitorCurrencyPair);
        this.realTimeStockMonitor.addStockCode(realTimeMonitorCode);
        return true;
    }

    public synchronized boolean isEmpty() {
        return this.realTimeStockMonitor.isEmpty();
    }

    public synchronized boolean clearCurrencyPairs() {
        this.currencyPairMapping.clear();
        return this.realTimeStockMonitor.clearStockCodes();
    }

    public synchronized boolean removeCurrencyPair(CurrencyPair currencyPair) {
        Code code = this.toCode(currencyPair);
        if (null == this.currencyPairMapping.remove(code)) {
            return false;
        }
        CurrencyPair realTimeMonitorCurrencyPair = this.toCurrencyPairForRealTimeStockMonitor(currencyPair);
        Code realTimeMonitorCode = this.toCode(realTimeMonitorCurrencyPair);
        if (this.currencyPairMapping.containsKey(realTimeMonitorCode)) {
            return true;
        }
        return this.realTimeStockMonitor.removeStockCode(realTimeMonitorCode);
    }

    public synchronized void resume() {
        this.realTimeStockMonitor.resume();
    }

    public synchronized void suspend() {
        this.realTimeStockMonitor.suspend();
    }

    public synchronized void startNewThreadsIfNecessary() {
        this.realTimeStockMonitor.startNewThreadsIfNecessary();
    }

    public synchronized void rebuild() {
        this.realTimeStockMonitor.rebuild();
    }

    public synchronized void stop() {
        this.realTimeStockMonitor.stop();
    }

    public synchronized void refresh() {
        this.realTimeStockMonitor.refresh();
    }

    public synchronized void setDelay(int delay) {
        this.realTimeStockMonitor.setDelay(delay);
    }
}

