/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.sequences;

import java.util.Stack;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.sequences.AbstractSequence;

public class FilteredTreeSequence<E>
extends AbstractSequence<E> {
    private Sequence<? extends E> seq;
    private Navigator<E> navigator;
    private Filter<E> filter;
    private Stack<Sequence<? extends E>> stack = new Stack();

    public FilteredTreeSequence(Sequence<? extends E> seq, Navigator<E> navigator, Filter<E> filter) {
        this.seq = seq;
        this.navigator = navigator;
        this.filter = filter;
        this._reset();
    }

    @Override
    protected E findNext() {
        while (!this.stack.isEmpty()) {
            E elem = this.stack.peek().next();
            if (elem == null) {
                this.stack.pop();
                continue;
            }
            if (this.filter.select(elem)) {
                return elem;
            }
            this.stack.push(this.navigator.children(elem));
        }
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this._reset();
    }

    private void _reset() {
        this.stack.clear();
        this.seq.reset();
        this.stack.push(this.seq);
    }

    @Override
    public FilteredTreeSequence<E> copy() {
        return new FilteredTreeSequence<E>(this.seq.copy(), this.navigator, this.filter);
    }
}

