# This is Makefile for Debian maintainer tasks
#
# 1. cd <package-N-N>/
# 2. make -f debian/debian.mk <target>

MYBUILD		     = $$(pwd)/../build-area
MYBUILD_LOG_SVN	     = $(MYBUILD)/pkg-svn-build.log
MYBUILD_LOG_PBUILDER = $(MYBUILD)/pkg-pbuilder.log
MYBUILD_LOG_LINTIAN  = $(MYBUILD)/pkg-lintian.log
MYBUILD_CHANGES      = $$(ls -1t $(MYBUILD) | egrep '$(PACKAGE).*changes' | head -1)
MYBUILD_IGNORE       = '(\.svn|\.bzr|\.hg|CVS|RCS|\.o|\.ko)'

doit: 
	echo "Nothing to do. See <targets> in Makefile"

my-build-dir:
	mkdir -p $(MYBUILD)

dput-local: my-build-dir
	file=$(MYBUILD_CHANGES); \
	dput --force localhost $(MYBUILD)/$$file

svn-build: my-build-dir
	+svn-buildpackage --svn-ignore-new -us -uc -rfakeroot 2>&1 \
	| tee $(MYBUILD_LOG_SVN)

svn-pbuilder: my-build-dir
	CC=gcc CXX=g++ svn-buildpackage \
	--svn-builder="pdebuild --buildresult $(MYBUILD)" 2>&1 \
	| tee $(MYBUILD_LOG_PBUILDER)

svn-build-ls: my-build-dir
	deb=$$( ls -t $(MYBUILD)/*.deb | head -1 ) ; \
	echo "FILE: $$deb"; \
	dpkg --info $$deb; \
	dpkg --contents $$deb; \
	ls -la $$deb

pbuilder:
	mkdir -p /tmp/
	dsc=$$(cd ..; ls ../*.dsc | sort -r | head -1 ); \
	echo [NOTE] pbuilding with: $$dsc; \
	CC=gcc CXX=g++ pdebuild --buildresult /tmp/pdebuild \
		--buildsourceroot fakeroot \
		$$dsc \
		-- -uc -us

deb:
	echo $(CXX)
	+debuild --lintian --linda -rfakeroot \
		-uc -us \
		-i$(MYBUILD_IGNORE)

deb-ls:
	ls -1t .. | egrep '$(PACKAGE)' | head 

deb-bin:
	+debuild --lintian --linda -rfakeroot \
		-uc -us \
		-sa -b -i$(MYBUILD_IGNORE)

deb-src:
	+debuild --lintian --linda -rfakeroot \
		-uc -us \
		-sa -S -i$(MYBUILD_IGNORE)

deb-bin-sig:
	+debuild --lintian --linda -rfakeroot \
		-tc -pgpg -sgpg -k$(GPGKEY) \
		-sa -b -i$(MYBUILD_IGNORE)

deb-src-sig:
	+debuild --lintian --linda -rfakeroot \
		-tc -pgpg -sgpg -k$(GPGKEY) \
		-sa -S -i$(MYBUILD_IGNORE)

lintian: my-build-dir
	lintian $(MYBUILD)/$(MYBUILD_CHANGES) 2>&1 | tee $(MYBUILD_LOG_LINTIAN)

# End of file
