/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicInteger;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;

public class Convert {
    public static final byte[] toByte(short s) {
        byte[] byArray = new byte[2];
        for (int n = 0; n <= 1; n = (int)((byte)(n + 1))) {
            byArray[n] = (byte)(s >>> (1 - n) * 8);
        }
        return byArray;
    }

    public static final byte[] toByte(int n) {
        byte[] byArray = new byte[4];
        for (int n2 = 0; n2 <= 3; n2 = (int)((byte)(n2 + 1))) {
            byArray[n2] = (byte)(n >>> (3 - n2) * 8);
        }
        return byArray;
    }

    public static final byte[] toByte(long l) {
        byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)(l >>> 0)};
        return byArray;
    }

    public static final byte[] toByte(float f) {
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putFloat(f);
        return byArray;
    }

    public static final byte[] toByte(double d) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putDouble(d);
        return byArray;
    }

    public static final void toByte(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >>> 8);
        byArray[1 + n] = (byte)s;
    }

    public static final void toByte(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[1 + n2] = (byte)(n >>> 16);
        byArray[2 + n2] = (byte)(n >>> 8);
        byArray[3 + n2] = (byte)n;
    }

    public static final void toByte(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56);
        byArray[1 + n] = (byte)(l >>> 48);
        byArray[2 + n] = (byte)(l >>> 40);
        byArray[3 + n] = (byte)(l >>> 32);
        byArray[4 + n] = (byte)(l >>> 24);
        byArray[5 + n] = (byte)(l >>> 16);
        byArray[6 + n] = (byte)(l >>> 8);
        byArray[7 + n] = (byte)l;
    }

    public static final byte[] toByte(String string) {
        if (string == null) {
            return "null".getBytes();
        }
        return string.getBytes();
    }

    public static final byte[] toByteWithLen(String string) {
        byte[] byArray = string == null ? "null".getBytes() : string.getBytes();
        int n = byArray.length;
        if (n <= 127) {
            byte[] byArray2 = new byte[n + 1];
            byArray2[0] = (byte)n;
            System.arraycopy(byArray, 0, byArray2, 1, n);
            return byArray2;
        }
        if (n <= 16383) {
            byte[] byArray3 = new byte[n + 2];
            byte[] byArray4 = Convert.toByte((short)n);
            byArray3[0] = (byte)(byArray4[0] << 1);
            byArray3[1] = byArray4[1];
            byArray3[0] = (byte)(byArray3[0] | 0x80);
            if (Convert.isBitSet(byArray3[1], 7)) {
                byArray3[0] = Convert.setBit(byArray3[0], (byte)0, true);
            }
            byArray3[1] = Convert.setBit(byArray3[1], (byte)7, false);
            System.arraycopy(byArray, 0, byArray3, 2, n);
            return byArray3;
        }
        byte[] byArray5 = new byte[n + 4];
        byte[] byArray6 = Convert.toByte(n);
        byArray5[0] = byArray6[0];
        byArray5[0] = (byte)(byArray5[0] << 1);
        byArray5[0] = (byte)(byArray5[0] | 0x80);
        if (Convert.isBitSet(byArray5[1], 7)) {
            byArray5[0] = Convert.setBit(byArray5[0], (byte)0, true);
        }
        byArray5[1] = byArray6[1];
        byArray5[1] = (byte)(byArray5[1] | 0x80);
        byArray5[2] = byArray6[2];
        byArray5[3] = byArray6[3];
        System.arraycopy(byArray, 0, byArray5, 4, n);
        return byArray5;
    }

    public static final long toLong(byte[] byArray, int n) {
        return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[1 + n] & 0xFFL) << 48 | ((long)byArray[2 + n] & 0xFFL) << 40 | ((long)byArray[3 + n] & 0xFFL) << 32 | ((long)byArray[4 + n] & 0xFFL) << 24 | ((long)byArray[5 + n] & 0xFFL) << 16 | ((long)byArray[6 + n] & 0xFFL) << 8 | (long)byArray[7 + n] & 0xFFL;
    }

    public static final int toInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[1 + n] & 0xFF) << 16 | (byArray[2 + n] & 0xFF) << 8 | byArray[3 + n] & 0xFF;
    }

    public static final short toShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[1 + n] & 0xFF);
    }

    public static final float toFloat(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, 4);
        return byteBuffer.getFloat();
    }

    public static final double toDouble(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, 8);
        return byteBuffer.getDouble();
    }

    public static final String toString(byte[] byArray, int n, int n2) {
        return new String(byArray, n2, n);
    }

    public static final String toStringWithLen(byte[] byArray, int n) {
        int n2;
        int n3 = byArray[n] >> 7 & 1;
        int n4 = n;
        if (n3 == 0) {
            n2 = byArray[n];
            ++n4;
        } else {
            int n5 = byArray[n + 1] >> 7 & 1;
            if (n5 == 1) {
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, n, byArray2, 0, 4);
                byArray2[0] = (byte)(byArray2[0] & 0xFFFFFF7F);
                byArray2[1] = (byte)(byArray2[1] & 0xFFFFFF7F);
                byArray2[1] = (byte)(byArray2[1] | (byArray2[0] & 1) << 7);
                byArray2[0] = (byte)(byArray2[0] >> 1);
                n2 = Convert.toInt(byArray2, 0);
                n4 += 4;
            } else {
                byte[] byArray3 = new byte[]{(byte)(byArray[n] & 0xFFFFFF7F), (byte)(byArray[n + 1] | (byArray[n] & 1) << 7)};
                byArray3[0] = (byte)(byArray3[0] >> 1);
                n2 = Convert.toShort(byArray3, 0);
                n4 += 2;
            }
        }
        return Convert.toString(byArray, n2, n4);
    }

    public static final String toStringWithLen(byte[] byArray, AtomicInteger atomicInteger) {
        int n;
        int n2 = atomicInteger.get();
        int n3 = byArray[n2] >> 7 & 1;
        if (n3 == 0) {
            n = byArray[n2];
            ++n2;
        } else {
            int n4 = byArray[n2 + 1] >> 7 & 1;
            if (n4 == 1) {
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, n2, byArray2, 0, 4);
                byArray2[0] = (byte)(byArray2[0] & 0xFFFFFF7F);
                byArray2[1] = (byte)(byArray2[1] & 0xFFFFFF7F);
                byArray2[1] = (byte)(byArray2[1] | (byArray2[0] & 1) << 7);
                byArray2[0] = (byte)(byArray2[0] >> 1);
                n = Convert.toInt(byArray2, 0);
                n2 += 4;
            } else {
                byte[] byArray3 = new byte[]{(byte)(byArray[n2] & 0xFFFFFF7F), (byte)(byArray[n2 + 1] | (byArray[n2] & 1) << 7)};
                byArray3[0] = (byte)(byArray3[0] >> 1);
                n = Convert.toShort(byArray3, 0);
                n2 += 2;
            }
        }
        atomicInteger.set(n2 + n);
        return Convert.toString(byArray, n, n2);
    }

    public static final BigDecimal toBigDecimal(byte[] byArray, int n, int n2) throws SQLException {
        String string = new String(byArray, n2, n);
        try {
            return new BigDecimal(string);
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("Convert.BigDecimalError") + string + " " + exception + " Value: " + string + " Len: " + n);
        }
    }

    public static boolean isBitSet(byte by, int n) {
        return (by >> n & 1) == 1;
    }

    public static byte setBit(byte by, byte by2, boolean bl) {
        if (bl) {
            return (byte)(by | (byte)(1 << by2));
        }
        return (byte)(by & (byte)(~(1 << by2)));
    }

    public static byte[] convertRowToBytes(Relation relation, ResultSet resultSet) throws SQLException {
        int n = relation.getNumAttributes();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            objectArray[i] = resultSet.getObject(i + 1);
        }
        byte[] byArray = Tuple.convertToBytes(objectArray, relation);
        return byArray;
    }

    public static Object convertStringToObject(String string, int n, String string2, String string3, String string4) throws Exception {
        switch (n) {
            case 12: {
                return string;
            }
            case 8: {
                return Double.parseDouble(string);
            }
            case 4: {
                return Integer.parseInt(string);
            }
            case 91: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                return new Date(simpleDateFormat.parse(string).getTime());
            }
            case 92: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                return new Date(simpleDateFormat.parse(string).getTime());
            }
            case 93: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
                return new Timestamp(simpleDateFormat.parse(string).getTime());
            }
        }
        return string;
    }

    public static Object convertStringToDate(String string, String string2) throws Exception {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        return simpleDateFormat.parse(string);
    }
}

