/*
 * Decompiled with CFR 0.152.
 */
package com.unityjdbc.sourcebuilder;

import com.unityjdbc.sourcebuilder.AnnotatedExtractor;
import com.unityjdbc.sourcebuilder.ExtractStatus;
import java.sql.SQLException;
import unity.annotation.AnnotatedSourceDatabase;

public class ExtractThread
extends Thread {
    private ExtractStatus status;
    private String driverName;
    private String url;
    private String user;
    private String password;
    private String dbName;
    private String schemaName;
    private AnnotatedSourceDatabase database;
    private String tableInc;
    private String catalogInc;
    private String tableExc;
    private int statsType;

    public ExtractThread(ExtractStatus extractStatus, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n) {
        this.status = extractStatus;
        this.driverName = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
        this.dbName = string5;
        this.schemaName = string6;
        this.tableInc = string7;
        this.tableExc = string8;
        this.catalogInc = string9;
        this.statsType = n;
    }

    @Override
    public void run() {
        this.status.addMessage("Preparing to add data source...\n");
        try {
            Class.forName(this.driverName);
            AnnotatedExtractor annotatedExtractor = new AnnotatedExtractor(this.status);
            if (this.dbName != null && this.dbName.equals("")) {
                this.dbName = null;
            }
            if (this.schemaName != null && this.schemaName.equals("")) {
                this.schemaName = null;
            }
            this.database = annotatedExtractor.extract(this.driverName, this.url, this.user, this.password, null, this.dbName, this.schemaName, this.tableInc, this.tableExc, this.catalogInc, this.statsType);
            if (this.user != null && !this.user.equals("")) {
                this.database.setUserId(this.user);
                this.database.setPassword(this.password);
            }
            this.status.addMessage("Success.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.status.addMessage("ClassNotFoundException for Driver: " + classNotFoundException.getMessage() + "\n");
            this.status.addMessage("Make sure driver is in your classpath.\n");
            this.status.setError("ClassNotFoundException for Driver: " + classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            this.status.addMessage("SQLException during extract: " + sQLException.getMessage() + "\n");
            this.status.setError("SQLException during extract: " + sQLException.getMessage());
        }
        catch (Exception exception) {
            this.status.addMessage("Exception during extract: " + exception + "\n");
            this.status.setError("Exception during extract: " + exception);
        }
        catch (Throwable throwable) {
            this.status.addMessage("Exception during extract: " + throwable + "\n");
            this.status.setError("Exception during extract: " + throwable);
        }
        this.status.setComplete(true);
    }

    public AnnotatedSourceDatabase getDatabase() {
        return this.database;
    }

    public ExtractStatus getStatus() {
        return this.status;
    }

    public void setDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.database = annotatedSourceDatabase;
    }
}

