/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DuplicateConsecutiveValuesInColumnsHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Point, Color> _colorByCell;
    private Point _cellBuf = new Point();

    public DuplicateConsecutiveValuesInColumnsHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._colorByCell = null;
                return;
            }
            this._colorByCell = new HashMap();
            DataSetViewerTableModel dataSetViewerTableModel = this._dataSetViewerTable.getDataSetViewerTableModel();
            if (dataSetViewerTableModel.getRowCount() < 2) {
                return;
            }
            TreeMap<Integer, Integer> modelIndexByViewIndex = this.createModelIndexByViewIndexTreeMap(dataSetViewerTableModel);
            for (ExtTableColumn tableColumn : DataSetViewerTablePanelUtil.getTableColumns(this._dataSetViewerTable)) {
                int columnModelIndex = tableColumn.getModelIndex();
                Color curColor = SquirrelConstants.DUPLICATE_COLOR;
                int lastColoredViewRow = -100;
                for (int viewIx = 1; viewIx < modelIndexByViewIndex.size(); ++viewIx) {
                    Object thisVal;
                    Object formerVal = dataSetViewerTableModel.getValueAt(modelIndexByViewIndex.get(viewIx - 1), columnModelIndex);
                    if (Utilities.equalsRespectNull(formerVal, thisVal = dataSetViewerTableModel.getValueAt(modelIndexByViewIndex.get(viewIx), columnModelIndex))) {
                        this._colorByCell.put(new Point(tableColumn.getModelIndex(), viewIx - 1), curColor);
                        this._colorByCell.put(new Point(tableColumn.getModelIndex(), viewIx), curColor);
                        lastColoredViewRow = viewIx;
                        continue;
                    }
                    if (lastColoredViewRow != viewIx - 1) continue;
                    curColor = SquirrelConstants.DUPLICATE_COLOR == curColor ? SquirrelConstants.DUPLICATE_COLOR_DARKER : SquirrelConstants.DUPLICATE_COLOR;
                }
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    private TreeMap<Integer, Integer> createModelIndexByViewIndexTreeMap(DataSetViewerTableModel dataSetViewerTableModel) {
        TreeMap<Integer, Integer> modelIndexByViewIndex = new TreeMap<Integer, Integer>();
        SortableTableModel sortableTableModel = this._dataSetViewerTable.getSortableTableModel();
        for (int viewIx = 0; viewIx < dataSetViewerTableModel.getRowCount(); ++viewIx) {
            modelIndexByViewIndex.put(viewIx, sortableTableModel.transformToModelRow(viewIx));
        }
        return modelIndexByViewIndex;
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_VALUES_IN_COLUMNS;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._colorByCell) {
            return null;
        }
        int columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(column).getModelIndex();
        if (-42 == columnModelIndex) {
            return null;
        }
        this._cellBuf.x = column;
        this._cellBuf.y = row;
        return this._colorByCell.get(this._cellBuf);
    }
}

