/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.Arrays;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.gui.SortedListModel;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;

public class AliasesListModel
extends SortedListModel {
    private IApplication _app;
    private boolean _isBeingSortedForListImpl = false;

    public AliasesListModel(IApplication app) {
        this._app = app;
        this.load();
        this._app.getDataCache().addAliasesListener(new MyAliasesListener());
    }

    private void load() {
        Iterator<ISQLAlias> it = this._app.getDataCache().aliases();
        while (it.hasNext()) {
            this.addAlias(it.next());
        }
    }

    private void addAlias(ISQLAlias alias) {
        this.addElement(alias);
    }

    private void removeAlias(ISQLAlias alias) {
        this.removeElement(alias);
    }

    public void sortAliasesForListImpl() {
        try {
            this._isBeingSortedForListImpl = true;
            Object[] aliases = this.toArray();
            Arrays.sort(aliases);
            this.clear();
            for (int i = 0; i < aliases.length; ++i) {
                this.addElement(aliases[i]);
            }
        }
        finally {
            this._isBeingSortedForListImpl = false;
        }
    }

    public int getIndex(SQLAlias alias) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(alias)) continue;
            return i;
        }
        return -1;
    }

    public SQLAlias getAlias(IIdentifier aliasIdentifier) {
        for (int i = 0; i < this.size(); ++i) {
            SQLAlias alias = (SQLAlias)this.get(i);
            if (!aliasIdentifier.equals(alias.getIdentifier())) continue;
            return alias;
        }
        return null;
    }

    public boolean isBeingSortedForListImpl() {
        return this._isBeingSortedForListImpl;
    }

    private class MyAliasesListener
    implements IObjectCacheChangeListener {
        private MyAliasesListener() {
        }

        @Override
        public void objectAdded(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLAlias) {
                AliasesListModel.this.addAlias((ISQLAlias)obj);
            }
        }

        @Override
        public void objectRemoved(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLAlias) {
                AliasesListModel.this.removeAlias((ISQLAlias)obj);
            }
        }
    }
}

