/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.ImportClauseNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class ImportNode
extends Node {
    private final LiteralNode<String> moduleSpecifier;
    private final ImportClauseNode importClause;
    private final FromNode from;

    public ImportNode(long l, int n, int n2, LiteralNode<String> literalNode) {
        this(l, n, n2, literalNode, null, null);
    }

    public ImportNode(long l, int n, int n2, ImportClauseNode importClauseNode, FromNode fromNode) {
        this(l, n, n2, null, importClauseNode, fromNode);
    }

    private ImportNode(long l, int n, int n2, LiteralNode<String> literalNode, ImportClauseNode importClauseNode, FromNode fromNode) {
        super(l, n, n2);
        this.moduleSpecifier = literalNode;
        this.importClause = importClauseNode;
        this.from = fromNode;
    }

    private ImportNode(ImportNode importNode, LiteralNode<String> literalNode, ImportClauseNode importClauseNode, FromNode fromNode) {
        super(importNode);
        this.moduleSpecifier = literalNode;
        this.importClause = importClauseNode;
        this.from = fromNode;
    }

    public LiteralNode<String> getModuleSpecifier() {
        return this.moduleSpecifier;
    }

    public ImportClauseNode getImportClause() {
        return this.importClause;
    }

    public FromNode getFrom() {
        return this.from;
    }

    public ImportNode setModuleSpecifier(LiteralNode<String> literalNode) {
        if (this.moduleSpecifier == literalNode) {
            return this;
        }
        return new ImportNode(this, literalNode, this.importClause, this.from);
    }

    public ImportNode setImportClause(ImportClauseNode importClauseNode) {
        if (this.importClause == importClauseNode) {
            return this;
        }
        return new ImportNode(this, this.moduleSpecifier, importClauseNode, this.from);
    }

    public ImportNode setFrom(FromNode fromNode) {
        if (this.from == fromNode) {
            return this;
        }
        return new ImportNode(this, this.moduleSpecifier, this.importClause, fromNode);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterImportNode(this)) {
            LiteralNode literalNode = this.moduleSpecifier == null ? null : (LiteralNode)this.moduleSpecifier.accept(nodeVisitor);
            ImportClauseNode importClauseNode = this.importClause == null ? null : (ImportClauseNode)this.importClause.accept(nodeVisitor);
            FromNode fromNode = this.from == null ? null : (FromNode)this.from.accept(nodeVisitor);
            return nodeVisitor.leaveImportNode(this.setModuleSpecifier(literalNode).setImportClause(importClauseNode).setFrom(fromNode));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterImportNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("import");
        stringBuilder.append(' ');
        if (this.moduleSpecifier != null) {
            this.moduleSpecifier.toString(stringBuilder, bl);
        } else {
            this.importClause.toString(stringBuilder, bl);
            stringBuilder.append(' ');
            this.from.toString(stringBuilder, bl);
        }
        stringBuilder.append(';');
    }
}

