/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Source;
import com.oracle.js.parser.TokenKind;
import com.oracle.js.parser.TokenType;

public final class Token {
    public static final int LENGTH_MASK = 0xFFFFFFF;
    private static final int LENGTH_SHIFT = 8;
    private static final int POSITION_SHIFT = 36;

    private Token() {
    }

    public static long toDesc(TokenType tokenType, int n, int n2) {
        assert (n <= 0xFFFFFFF && n2 <= 0xFFFFFFF);
        return (long)n << 36 | (long)n2 << 8 | (long)tokenType.ordinal();
    }

    public static int descPosition(long l) {
        return (int)(l >>> 36);
    }

    public static long withDelimiter(long l) {
        TokenType tokenType = Token.descType(l);
        switch (tokenType) {
            case STRING: 
            case ESCSTRING: 
            case EXECSTRING: 
            case TEMPLATE: 
            case TEMPLATE_TAIL: {
                int n = Token.descPosition(l) - 1;
                int n2 = Token.descLength(l) + 2;
                return Token.toDesc(tokenType, n, n2);
            }
            case TEMPLATE_HEAD: 
            case TEMPLATE_MIDDLE: {
                int n = Token.descPosition(l) - 1;
                int n3 = Token.descLength(l) + 3;
                return Token.toDesc(tokenType, n, n3);
            }
        }
        return l;
    }

    public static int descLength(long l) {
        return (int)(l >>> 8 & 0xFFFFFFFL);
    }

    public static TokenType descType(long l) {
        return TokenType.getValues()[(int)l & 0xFF];
    }

    public static long recast(long l, TokenType tokenType) {
        return l & 0xFFFFFFFFFFFFFF00L | (long)tokenType.ordinal();
    }

    public static String toString(Source source, long l, boolean bl) {
        TokenType tokenType = Token.descType(l);
        String string = source != null && tokenType.getKind() == TokenKind.LITERAL ? source.getString(l) : tokenType.getNameOrType();
        if (bl) {
            int n = Token.descPosition(l);
            int n2 = Token.descLength(l);
            string = string + " (" + n + ", " + n2 + ")";
        }
        return string;
    }

    public static String toString(Source source, long l) {
        return Token.toString(source, l, false);
    }

    public static String toString(long l) {
        return Token.toString(null, l, false);
    }
}

