/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

class PathLookup
extends Lookup {
    private final Lookup delegate;
    private final String path;

    PathLookup(String path) {
        this.delegate = Lookups.forPath((String)path);
        this.path = path;
    }

    public <T> T lookup(Class<T> clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return (T)(item == null ? null : item.getInstance());
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return new PathLookupResult(template.getType(), this.delegate.lookup(template), this.path);
    }

    public <T> Lookup.Result<T> lookupResult(Class<T> clazz) {
        return new PathLookupResult<T>(clazz, this.delegate.lookupResult(clazz), this.path);
    }

    static class PathLookupResult<T>
    extends Lookup.Result<T> {
        private static final List ORIG_ITEMS = new ArrayList(0);
        private final Class<T> clazz;
        private final Lookup.Result<T> orig;
        private Collection<Lookup.Item<T>> items;
        private final String path;
        private final LookupListener ll = new PathLookupListener();
        private final List<LookupListener> listeners = new ArrayList<LookupListener>();

        PathLookupResult(Class<T> clazz, Lookup.Result<T> orig, String path) {
            this.clazz = clazz;
            this.orig = orig;
            this.path = path;
            orig.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.ll, orig));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener l) {
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(l)) {
                    this.listeners.add(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener l) {
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }

        private static <T> List<Lookup.Item<T>> itemsJustForPath(Class<T> clazz, Lookup.Result<T> result, String path) {
            int l = path.length() + 1;
            Collection allItems = result.allItems();
            ArrayList<Lookup.Item<T>> pathItems = new ArrayList<Lookup.Item<T>>(allItems.size());
            for (Lookup.Item it : allItems) {
                Object io;
                FileObject fo;
                String filePath = it.getId();
                assert (filePath.startsWith(path)) : "File path '" + filePath + "' does not start with searched path '" + path + "'";
                if (filePath.indexOf(47, l) >= l || clazz.isInterface() && (fo = FileUtil.getConfigFile((String)(filePath + ".instance"))) != null && (io = fo.getAttribute("instanceOf")) != null && ((String)io).indexOf(clazz.getName()) < 0) continue;
                pathItems.add(it);
            }
            if (pathItems.size() == allItems.size()) {
                return ORIG_ITEMS;
            }
            return pathItems;
        }

        private synchronized Collection<Lookup.Item<T>> getItems() {
            if (this.items == null) {
                this.items = PathLookupResult.itemsJustForPath(this.clazz, this.orig, this.path);
            }
            return this.items;
        }

        public Collection<? extends T> allInstances() {
            Collection<Lookup.Item<T>> items = this.getItems();
            if (items == ORIG_ITEMS) {
                return this.orig.allInstances();
            }
            ArrayList<Object> list = new ArrayList<Object>(items.size());
            for (Lookup.Item<T> item : items) {
                Object obj = item.getInstance();
                if (!this.clazz.isInstance(obj)) continue;
                list.add(obj);
            }
            return Collections.unmodifiableList(list);
        }

        public Set<Class<? extends T>> allClasses() {
            Collection<Lookup.Item<T>> items = this.getItems();
            if (items == ORIG_ITEMS) {
                return this.orig.allClasses();
            }
            HashSet<Class<T>> s = new HashSet();
            for (Lookup.Item<T> item : items) {
                Class clazz = item.getType();
                if (clazz == null) continue;
                s.add(clazz);
            }
            s = Collections.unmodifiableSet(s);
            return s;
        }

        public Collection<? extends Lookup.Item<T>> allItems() {
            Collection<Lookup.Item<T>> items = this.getItems();
            if (items == ORIG_ITEMS) {
                return this.orig.allItems();
            }
            return items;
        }

        private class PathLookupListener
        implements LookupListener {
            private PathLookupListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                ArrayList lls;
                PathLookupResult pathLookupResult = PathLookupResult.this;
                synchronized (pathLookupResult) {
                    PathLookupResult.this.items = null;
                }
                List list = PathLookupResult.this.listeners;
                synchronized (list) {
                    if (PathLookupResult.this.listeners.isEmpty()) {
                        return;
                    }
                    lls = new ArrayList(PathLookupResult.this.listeners);
                }
                LookupEvent lev = new LookupEvent((Lookup.Result)PathLookupResult.this);
                for (LookupListener ll : lls) {
                    ll.resultChanged(lev);
                }
            }
        }
    }
}

