/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class CPUTableView
extends CPUView {
    private CPUTableModel tableModel;
    private ProfilerTable table;
    private FlatProfileContainer data;
    private Map<Integer, ClientUtils.SourceCodeSelection> idMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private boolean sampled = true;
    private boolean twoTimeStamps;
    private boolean hitsVisible = false;
    private boolean invocationsVisible = true;
    private HideableBarRenderer[] renderers;

    public CPUTableView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
    }

    void setData(FlatProfileContainer newData, Map<Integer, ClientUtils.SourceCodeSelection> newIdMap, boolean _sampled, boolean _diff) {
        boolean structureChange = this.sampled != _sampled;
        this.sampled = _sampled;
        this.twoTimeStamps = newData == null ? false : newData.isCollectingTwoTimeStamps();
        this.idMap = newIdMap;
        if (this.tableModel != null) {
            long[] maxTimes;
            this.data = newData;
            if (_diff) {
                maxTimes = new long[4];
                long[] minTimes = new long[4];
                int maxInvocations = 0;
                int minInvocations = 0;
                for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                    maxTimes[0] = Math.max(maxTimes[0], this.data.getTimeInMcs0AtRow(row));
                    minTimes[0] = Math.min(minTimes[0], this.data.getTimeInMcs0AtRow(row));
                    if (this.twoTimeStamps) {
                        maxTimes[1] = Math.max(maxTimes[1], this.data.getTimeInMcs1AtRow(row));
                        minTimes[1] = Math.min(minTimes[1], this.data.getTimeInMcs1AtRow(row));
                    }
                    maxTimes[2] = Math.max(maxTimes[2], this.data.getTotalTimeInMcs0AtRow(row));
                    minTimes[2] = Math.min(minTimes[2], this.data.getTotalTimeInMcs0AtRow(row));
                    if (this.twoTimeStamps) {
                        maxTimes[3] = Math.max(maxTimes[3], this.data.getTotalTimeInMcs1AtRow(row));
                        minTimes[3] = Math.min(minTimes[3], this.data.getTotalTimeInMcs1AtRow(row));
                    }
                    maxInvocations = Math.max(maxInvocations, this.data.getNInvocationsAtRow(row));
                    minInvocations = Math.min(minInvocations, this.data.getNInvocationsAtRow(row));
                }
                this.renderers[0].setMaxValue(Math.max(Math.abs(maxTimes[0]), Math.abs(minTimes[0])));
                this.renderers[1].setMaxValue(Math.max(Math.abs(maxTimes[1]), Math.abs(minTimes[1])));
                this.renderers[2].setMaxValue(Math.max(Math.abs(maxTimes[2]), Math.abs(minTimes[2])));
                this.renderers[3].setMaxValue(Math.max(Math.abs(maxTimes[3]), Math.abs(minTimes[3])));
                this.renderers[4].setMaxValue(Math.max(Math.abs(maxInvocations), Math.abs(minInvocations)));
            } else {
                maxTimes = new long[4];
                int maxInvocations = 0;
                for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                    maxTimes[0] = maxTimes[0] + this.data.getTimeInMcs0AtRow(row);
                    if (this.twoTimeStamps) {
                        maxTimes[1] = maxTimes[1] + this.data.getTimeInMcs1AtRow(row);
                    }
                    maxTimes[2] = maxTimes[2] + this.data.getTotalTimeInMcs0AtRow(row);
                    if (this.twoTimeStamps) {
                        maxTimes[3] = maxTimes[3] + this.data.getTotalTimeInMcs1AtRow(row);
                    }
                    maxInvocations += this.data.getNInvocationsAtRow(row);
                }
                this.renderers[0].setMaxValue(maxTimes[0]);
                this.renderers[1].setMaxValue(maxTimes[1]);
                this.renderers[2].setMaxValue(maxTimes[2]);
                this.renderers[3].setMaxValue(maxTimes[3]);
                this.renderers[4].setMaxValue(maxInvocations);
            }
            this.renderers[0].setDiffMode(_diff);
            this.renderers[1].setDiffMode(_diff);
            this.renderers[2].setDiffMode(_diff);
            this.renderers[3].setDiffMode(_diff);
            this.renderers[4].setDiffMode(_diff);
            this.tableModel.fireTableDataChanged();
        }
        if (structureChange) {
            int col = this.table.convertColumnIndexToView(this.selection == null ? 5 : 6);
            String colN = this.tableModel.getColumnName(this.selection == null ? 5 : 6);
            if (this.sampled) {
                this.invocationsVisible = this.table.isColumnVisible(col);
            } else {
                this.hitsVisible = this.table.isColumnVisible(col);
            }
            this.table.getColumnModel().getColumn(col).setHeaderValue(colN);
            this.table.setColumnVisibility(col, this.sampled ? this.hitsVisible : this.invocationsVisible);
            this.setToolTips();
            this.repaint();
        }
        if (newData != null && !this.twoTimeStamps) {
            int totalColumn;
            int selfColumn = this.selection == null ? 2 : 3;
            int n = totalColumn = this.selection == null ? 4 : 5;
            if (this.table.isColumnVisible(selfColumn)) {
                this.table.setColumnVisibility(selfColumn, false);
                this.table.setColumnVisibility(selfColumn - 1, true);
            }
            if (this.table.isColumnVisible(totalColumn)) {
                this.table.setColumnVisibility(totalColumn, false);
                this.table.setColumnVisibility(totalColumn - 1, true);
            }
        }
    }

    public void resetData() {
        this.setData(null, null, this.sampled, false);
    }

    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_HOTSPOTS);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_HOTSPOTS);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        int w;
        this.tableModel = new CPUTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return CPUTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                CPUTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                CPUTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                CPUTableView.this.popupHidden();
            }
        };
        this.setToolTips();
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        int offset = this.selection == null ? -1 : 0;
        this.table.setMainColumn(1 + offset);
        this.table.setFitWidthColumn(1 + offset);
        this.table.setSortColumn(3 + offset);
        this.table.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.table.setColumnVisibility(2 + offset, false);
        this.table.setColumnVisibility(4 + offset, false);
        this.table.setColumnVisibility(6 + offset, false);
        this.renderers = new HideableBarRenderer[5];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[2] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[3] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer()));
        this.renderers[4] = new HideableBarRenderer(new NumberRenderer());
        long refTime = 123456L;
        this.renderers[0].setMaxValue(refTime);
        this.renderers[1].setMaxValue(refTime);
        this.renderers[2].setMaxValue(refTime);
        this.renderers[3].setMaxValue(refTime);
        this.renderers[4].setMaxValue(refTime);
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object value, int row) {
                    this.visible = CPUTableView.isSelectable((ClientUtils.SourceCodeSelection)CPUTableView.this.idMap.get(CPUTableView.this.data.getMethodIdAtRow(row)));
                    if (this.visible) {
                        super.setValue(value, row);
                    }
                }

                @Override
                public void paint(Graphics g) {
                    if (this.visible) {
                        super.paint(g);
                    } else {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.table.setColumnRenderer(1 + offset, new JavaNameRenderer(Icons.getIcon((String)"ProfilerIcons.NodeLeaf")));
        this.table.setColumnRenderer(2 + offset, this.renderers[0]);
        this.table.setColumnRenderer(3 + offset, this.renderers[1]);
        this.table.setColumnRenderer(4 + offset, this.renderers[2]);
        this.table.setColumnRenderer(5 + offset, this.renderers[3]);
        this.table.setColumnRenderer(6 + offset, this.renderers[4]);
        if (this.selection != null) {
            w = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, w + 15);
        }
        this.table.setDefaultColumnWidth(2 + offset, this.renderers[0].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(3 + offset, this.renderers[1].getOptimalWidth());
        this.table.setDefaultColumnWidth(4 + offset, this.renderers[2].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(5 + offset, this.renderers[3].getMaxNoBarWidth());
        this.sampled = !this.sampled;
        w = new JLabel((String)this.table.getColumnName((int)(6 + offset))).getPreferredSize().width;
        this.sampled = !this.sampled;
        w = Math.max(w, new JLabel((String)this.table.getColumnName((int)(6 + offset))).getPreferredSize().width);
        this.table.setDefaultColumnWidth(6 + offset, Math.max(this.renderers[4].getNoBarWidth(), w + 15));
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    private void setToolTips() {
        String[] stringArray;
        if (this.selection == null) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = SELF_TIME_COLUMN_TOOLTIP;
            stringArray2[2] = SELF_TIME_CPU_COLUMN_TOOLTIP;
            stringArray2[3] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray2[4] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[5] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[7];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = SELF_TIME_COLUMN_TOOLTIP;
            stringArray3[3] = SELF_TIME_CPU_COLUMN_TOOLTIP;
            stringArray3[4] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray3[5] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[6] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        if (this.data == null || row == -1) {
            return null;
        }
        if (row >= this.tableModel.getRowCount()) {
            return null;
        }
        row = this.table.convertRowIndexToModel(row);
        return this.idMap.get(this.data.getMethodIdAtRow(row));
    }

    static boolean isSelectable(ClientUtils.SourceCodeSelection method) {
        return !method.getMethodName().endsWith("[native]");
    }

    private class CPUTableModel
    extends AbstractTableModel {
        private CPUTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (CPUTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return CPUView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return CPUView.COLUMN_SELFTIME;
            }
            if (columnIndex == 3) {
                return CPUView.COLUMN_SELFTIME_CPU;
            }
            if (columnIndex == 4) {
                return CPUView.COLUMN_TOTALTIME;
            }
            if (columnIndex == 5) {
                return CPUView.COLUMN_TOTALTIME_CPU;
            }
            if (columnIndex == 6) {
                return CPUTableView.this.sampled ? CPUView.COLUMN_HITS : CPUView.COLUMN_INVOCATIONS;
            }
            if (columnIndex == 0) {
                return CPUView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (CPUTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 6) {
                return Integer.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return CPUTableView.this.data == null ? 0 : CPUTableView.this.data.getNRows();
        }

        @Override
        public int getColumnCount() {
            return CPUTableView.this.selection == null ? 6 : 7;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (CPUTableView.this.data == null) {
                return null;
            }
            if (CPUTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return CPUTableView.this.data.getMethodNameAtRow(rowIndex);
            }
            if (columnIndex == 2) {
                return CPUTableView.this.data.getTimeInMcs0AtRow(rowIndex);
            }
            if (columnIndex == 3) {
                return CPUTableView.this.twoTimeStamps ? CPUTableView.this.data.getTimeInMcs1AtRow(rowIndex) : 0L;
            }
            if (columnIndex == 4) {
                return CPUTableView.this.data.getTotalTimeInMcs0AtRow(rowIndex);
            }
            if (columnIndex == 5) {
                return CPUTableView.this.twoTimeStamps ? CPUTableView.this.data.getTotalTimeInMcs1AtRow(rowIndex) : 0L;
            }
            if (columnIndex == 6) {
                return CPUTableView.this.data.getNInvocationsAtRow(rowIndex);
            }
            if (columnIndex == 0) {
                if (CPUTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return CPUTableView.this.selection.contains(CPUTableView.this.idMap.get(CPUTableView.this.data.getMethodIdAtRow(rowIndex)));
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (CPUTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                int methodId = CPUTableView.this.data.getMethodIdAtRow(rowIndex);
                if (Boolean.TRUE.equals(aValue)) {
                    CPUTableView.this.selection.add((ClientUtils.SourceCodeSelection)CPUTableView.this.idMap.get(methodId));
                } else {
                    CPUTableView.this.selection.remove(CPUTableView.this.idMap.get(methodId));
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (CPUTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex != 0) {
                return false;
            }
            return CPUTableView.isSelectable((ClientUtils.SourceCodeSelection)CPUTableView.this.idMap.get(CPUTableView.this.data.getMethodIdAtRow(rowIndex)));
        }
    }
}

