/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.data;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.openide.util.Exceptions;

public class PayaraPlatformVersion
implements PayaraPlatformVersionAPI,
Comparable<PayaraPlatformVersionAPI> {
    private static final Logger LOGGER = Logger.getLogger(PayaraPlatformVersion.class.getName());
    private static final String DOWNLOAD_URL = "fish/payara/distributions/payara/%s/payara-%s.zip";
    public static final String DEFAULT_REPOSITORY_URL = "https://repo1.maven.org/maven2/";
    private static final String METADATA_URL = "fish/payara/distributions/payara/maven-metadata.xml";
    private static final String LOCAL_METADATA_URL = "fish/payara/distributions/payara/maven-metadata-local.xml";
    private static final String CDDL_LICENSE = "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt";
    public static final PayaraPlatformVersionAPI EMPTY = new PayaraPlatformVersion(0, 0, 0, 0, "", "", "");
    private static PayaraPlatformVersionAPI latestVersion;
    private static final Map<String, PayaraPlatformVersionAPI> versions;
    private final short major;
    private final short minor;
    private final short update;
    private final short build;
    private final String uriFragment;
    private final String indirectUrl;
    private final String directUrl;
    private final String value;

    public static PayaraPlatformVersionAPI getLatestVersion() {
        if (!PayaraPlatformVersion.getVersions().isEmpty()) {
            return latestVersion;
        }
        return null;
    }

    public static Map<String, PayaraPlatformVersionAPI> getVersionMap() {
        if (!PayaraPlatformVersion.getVersions().isEmpty()) {
            return Collections.unmodifiableMap(versions);
        }
        return Collections.emptyMap();
    }

    public static List<PayaraPlatformVersionAPI> getVersions() {
        if (versions.isEmpty()) {
            boolean readDefaultRepo;
            URL metadata;
            String repository = DEFAULT_REPOSITORY_URL;
            try {
                metadata = new URL(repository + METADATA_URL);
                readDefaultRepo = PayaraPlatformVersion.readVersions(repository, metadata);
            }
            catch (UnknownHostException ex) {
                readDefaultRepo = false;
                LOGGER.log(Level.INFO, repository, ex);
            }
            catch (Exception ex) {
                readDefaultRepo = false;
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!readDefaultRepo) {
                for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                    try {
                        repository = info.getRepositoryUrl();
                        if (repository != null) {
                            metadata = new URL(repository + METADATA_URL);
                        } else {
                            repository = new File(info.getRepositoryPath() + File.separator).toURI().toString();
                            if (!new File(repository + LOCAL_METADATA_URL).exists()) continue;
                            metadata = new URL(repository + LOCAL_METADATA_URL);
                        }
                        if (!PayaraPlatformVersion.readVersions(repository, metadata)) continue;
                        break;
                    }
                    catch (UnknownHostException ex) {
                        LOGGER.log(Level.INFO, repository, ex);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return new ArrayList<PayaraPlatformVersionAPI>(versions.values());
    }

    private static boolean readVersions(String repository, URL metadata) throws Exception {
        try (InputStream input = metadata.openStream();){
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            Metadata data = reader.read((Reader)new InputStreamReader(input));
            versions.clear();
            for (String version : data.getVersioning().getVersions()) {
                if (version.contains("Alpha") || version.contains("Beta") || version.contains("SNAPSHOT")) continue;
                PayaraPlatformVersionAPI payaraVersion = PayaraPlatformVersion.toValue(repository, version);
                versions.put(version, payaraVersion);
                if (!version.equals(data.getVersioning().getLatest())) continue;
                latestVersion = payaraVersion;
            }
            if (!versions.isEmpty()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static List<PayaraPlatformVersionAPI> getVersions(String repository) {
        return new ArrayList<PayaraPlatformVersionAPI>(versions.values());
    }

    @CheckForNull
    public static PayaraPlatformVersionAPI toValue(@NonNull String versionStr) {
        return PayaraPlatformVersion.toValue(DEFAULT_REPOSITORY_URL, versionStr);
    }

    @CheckForNull
    public static PayaraPlatformVersionAPI toValue(@NonNull String repository, @NonNull String versionStr) {
        if (versionStr.trim().isEmpty()) {
            return EMPTY;
        }
        PayaraPlatformVersionAPI version = versions.get(versionStr.toUpperCase(Locale.ENGLISH));
        if (version == null) {
            String[] versionComps = versionStr.split("\\.");
            short major = Short.valueOf(versionComps[0]);
            short minor = Short.valueOf(versionComps[1]);
            short update = 0;
            short build = 0;
            if (versionComps.length > 2) {
                update = Short.valueOf(versionComps[2]);
            }
            if (versionComps.length > 3) {
                build = Short.valueOf(versionComps[3]);
            }
            version = new PayaraPlatformVersion(major, minor, update, build, major >= 5 ? "deployer:pfv5ee8" : "deployer:pfv4ee7", repository, versionStr);
        }
        return version;
    }

    private PayaraPlatformVersion(short major, short minor, short update, short build, String uriFragment, String repository, String value) {
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.build = build;
        this.uriFragment = uriFragment;
        this.value = value;
        this.indirectUrl = null;
        this.directUrl = repository + String.format(DOWNLOAD_URL, value, value);
    }

    @Override
    public short getMajor() {
        return this.major;
    }

    @Override
    public short getMinor() {
        return this.minor;
    }

    @Override
    public short getUpdate() {
        return this.update;
    }

    @Override
    public short getBuild() {
        return this.build;
    }

    @Override
    public String getUriFragment() {
        return this.uriFragment;
    }

    @Override
    public String getDirectUrl() {
        return this.directUrl;
    }

    @Override
    public String getIndirectUrl() {
        return this.indirectUrl;
    }

    @Override
    public String getLicenseUrl() {
        return CDDL_LICENSE;
    }

    @Override
    public boolean isMinimumSupportedVersion() {
        return this.major >= 4;
    }

    @Override
    public boolean isEE7Supported() {
        return this.major >= 4;
    }

    @Override
    public boolean isEE8Supported() {
        return this.major >= 5;
    }

    @Override
    public boolean equalsMajorMinor(PayaraPlatformVersionAPI version) {
        if (version == null) {
            return false;
        }
        return this.major == version.getMajor() && this.minor == version.getMinor();
    }

    @Override
    public boolean equals(PayaraPlatformVersionAPI version) {
        if (version == null) {
            return false;
        }
        return this.major == version.getMajor() && this.minor == version.getMinor() && this.update == version.getUpdate() && this.build == version.getBuild();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String toFullString() {
        StringBuilder sb = new StringBuilder(8);
        sb.append(Integer.toString(this.major));
        sb.append('.');
        sb.append(Integer.toString(this.minor));
        sb.append('.');
        sb.append(Integer.toString(this.update));
        sb.append('.');
        sb.append(Integer.toString(this.build));
        return sb.toString();
    }

    @Override
    public int compareTo(PayaraPlatformVersionAPI o) {
        return Comparator.comparing(PayaraPlatformVersionAPI::getMajor).thenComparing(PayaraPlatformVersionAPI::getMinor).thenComparingInt(PayaraPlatformVersionAPI::getUpdate).thenComparingInt(PayaraPlatformVersionAPI::getBuild).compare(this, o);
    }

    static {
        versions = new TreeMap<String, PayaraPlatformVersionAPI>();
    }
}

