/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.nodes;

import java.awt.Image;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.nodes.Bundle;
import org.netbeans.modules.gradle.spi.nodes.AbstractGradleNodeList;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public final class SourcesNodeFactory
implements NodeFactory {
    private static final String WARNING_BADGE = "org/netbeans/modules/gradle/resources/warning-badge.png";

    public NodeList<?> createNodes(Project project) {
        return new NList(project);
    }

    private static class ResourcesFolderNode
    extends FilterNode {
        final SourceGroup group;

        private ResourcesFolderNode(SourceGroup group, Node original) {
            super(original);
            this.group = group;
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return this.group.getDisplayName();
        }

        static Node createResourcesFolderNode(SourceGroup group) {
            try {
                DataObject root = DataObject.find((FileObject)group.getRootFolder());
                return new ResourcesFolderNode(group, root.getNodeDelegate());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }
    }

    private static class NList
    extends AbstractGradleNodeList<SourceGroup>
    implements ChangeListener {
        private static final RequestProcessor RP = new RequestProcessor(NList.class);
        private final Project project;

        private NList(Project prj) {
            this.project = prj;
        }

        public List<SourceGroup> keys() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            ArrayList<SourceGroup> ret = new ArrayList<SourceGroup>();
            ret.addAll(Arrays.asList(srcs.getSourceGroups("java")));
            ret.addAll(Arrays.asList(srcs.getSourceGroups("kotlin")));
            ret.addAll(Arrays.asList(srcs.getSourceGroups("resources")));
            ret.addAll(Arrays.asList(srcs.getSourceGroups("generated")));
            ret.sort(Comparator.comparing(SourceGroup::getName));
            return ret;
        }

        public Node node(SourceGroup group) {
            Object ret;
            String name;
            Project owner = FileOwnerQuery.getOwner((FileObject)group.getRootFolder());
            if (owner == null) {
                Logger.getLogger(SourcesNodeFactory.class.getName()).log(Level.INFO, "Cannot find a project owner for folder {0}", group.getRootFolder());
                return null;
            }
            switch (name = group.getName()) {
                case "42gatling.data": 
                case "43gatling.bodies": 
                case "49gatling.resources": {
                    ret = ResourcesFolderNode.createResourcesFolderNode(group);
                    break;
                }
                default: {
                    ret = PackageView.createPackageView((SourceGroup)group);
                }
            }
            Path projectPath = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).toPath();
            Path groupPath = FileUtil.toFile((FileObject)group.getRootFolder()).toPath();
            String relPath = projectPath.relativize(groupPath).toString();
            ret.setShortDescription(relPath);
            if (owner != this.project) {
                ret = new FilterNode((Node)ret){

                    public Image getIcon(int type) {
                        Image warn = ImageUtilities.loadImage((String)SourcesNodeFactory.WARNING_BADGE);
                        return ImageUtilities.mergeImages((Image)super.getIcon(type), (Image)warn, (int)8, (int)0);
                    }

                    public Image getOpenedIcon(int type) {
                        return this.getIcon(type);
                    }
                };
                String prjText = ProjectUtils.getInformation((Project)owner).getDisplayName();
                ret.setShortDescription(Bundle.ERR_WrongSG(relPath, prjText, NbGradleProject.class.getClassLoader().getResource(SourcesNodeFactory.WARNING_BADGE)));
            }
            return ret;
        }

        public void addNotify() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            srcs.addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            srcs.removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            RP.post(() -> ((NList)this).fireChange());
        }
    }
}

