/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;

public class GradleProjectErrorNotifications {
    private final Set<Notification> notifictions = new HashSet<Notification>();

    public synchronized void openNotification(String title, String problem, String details) {
        String[] lines;
        StringBuilder sb = new StringBuilder(details.length());
        sb.append("<html>");
        for (String line : lines = details.split("\n")) {
            sb.append(line).append("<br/>");
        }
        Notification ntn = NotificationDisplayer.getDefault().notify(title, NbGradleProject.getWarningIcon(), (JComponent)new JLabel(problem), (JComponent)new JLabel(sb.toString()), NotificationDisplayer.Priority.LOW, NotificationDisplayer.Category.WARNING);
        this.notifictions.add(ntn);
    }

    public synchronized void clear() {
        Iterator<Notification> it = this.notifictions.iterator();
        while (it.hasNext()) {
            it.next().clear();
            it.remove();
        }
    }

    public static String bulletedList(Collection<? extends Object> elements) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (Object object : elements) {
            sb.append("<li>");
            String[] lines = String.valueOf(object).split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                sb.append(GradleProjectErrorNotifications.lineWrap(line, 78));
                if (i >= lines.length - 1) continue;
                sb.append("<br/>");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private static String lineWrap(String line, int maxCol) {
        StringBuilder sb = new StringBuilder(line.length());
        String[] parts = line.split(" ");
        int col = 0;
        String delim = "";
        for (String part : parts) {
            if (sb.length() > 0 && col + part.length() > maxCol) {
                sb.append("<br/>").append(part);
                col = part.length();
                continue;
            }
            sb.append(delim).append(part);
            col += delim.length() + part.length();
            delim = " ";
        }
        return sb.toString();
    }
}

