/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.groovy.support.debug.Context;

public class GroovyBreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap<LineBreakpoint, Object> breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(propertyName.equals("condition") || propertyName.equals("url") || propertyName.equals("lineNumber") || propertyName.equals("enabled"))) {
            return;
        }
        LineBreakpoint b = (LineBreakpoint)e.getSource();
        this.annotate(b);
    }

    public void breakpointAdded(Breakpoint b) {
        if (b instanceof LineBreakpoint) {
            ((LineBreakpoint)b).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((LineBreakpoint)b);
        }
    }

    public void breakpointRemoved(Breakpoint b) {
        if (b instanceof LineBreakpoint) {
            ((LineBreakpoint)b).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((LineBreakpoint)b);
        }
    }

    private void annotate(LineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.get(b);
        if (annotation != null) {
            Context.removeAnnotation(annotation);
        }
        if (b.isHidden()) {
            return;
        }
        annotation = Context.annotate(b);
        if (annotation == null) {
            return;
        }
        this.breakpointToAnnotation.put(b, annotation);
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object timeStamp = null;
        if (de != null) {
            timeStamp = de.lookupFirst(null, JPDADebugger.class);
        }
        this.update(b, timeStamp);
    }

    public void updateGroovyLineBreakpoints() {
        for (LineBreakpoint lb : this.breakpointToAnnotation.keySet()) {
            this.update(lb, null);
        }
    }

    private void update(LineBreakpoint b, Object timeStamp) {
        Object annotation = this.breakpointToAnnotation.get(b);
        if (annotation == null) {
            return;
        }
        int ln = Context.getLineNumber(annotation, timeStamp);
        this.listen = false;
        b.setLineNumber(ln);
        this.listen = true;
    }

    private void removeAnnotation(LineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.remove(b);
        if (annotation != null) {
            Context.removeAnnotation(annotation);
        }
    }
}

