/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryQuery;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class HookImpl {
    private HookPanel panel;
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final VCSHooksConfig config;
    private final String[] supportedIssueInfoVariables;
    private final String[] supportedRevisionVariables;

    HookImpl(VCSHooksConfig config, String[] supportedIssueInfoVariables, String[] supportedRevisionVariables) {
        this.config = config;
        this.supportedIssueInfoVariables = supportedIssueInfoVariables;
        this.supportedRevisionVariables = supportedRevisionVariables;
    }

    public String beforeCommit(File[] files, String msg) throws IOException {
        if (files.length == 0) {
            LOG.warning("calling beforeCommit for zero files");
            return null;
        }
        File file = files[0];
        LOG.log(Level.FINE, "beforeCommit start for {0}", file);
        if (this.isLinkSelected()) {
            VCSHooksConfig.Format format = this.config.getIssueInfoTemplate();
            String formatString = format.getFormat();
            formatString = HookUtils.prepareFormatString(formatString, this.supportedIssueInfoVariables);
            Issue issue = this.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for {0}", file);
                return null;
            }
            String issueInfo = new MessageFormat(formatString).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " commit hook issue info ''{0}''", issueInfo);
            msg = format.isAbove() ? issueInfo + "\n" + msg : msg + "\n" + issueInfo;
            return msg;
        }
        return null;
    }

    public void afterCommit(File[] files, String author, String revision, Date date, String message, String hookUsageName, boolean applyPush) {
        if (this.panel == null) {
            LOG.fine("no settings for afterCommit");
            return;
        }
        if (files.length == 0) {
            LOG.warning("calling afterCommit for zero files");
            return;
        }
        File file = files[0];
        LOG.log(Level.FINE, "afterCommit start for {0}", file);
        Issue issue = this.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for {0}", file);
            return;
        }
        this.config.setLink(this.isLinkSelected());
        this.config.setResolve(this.isResolveSelected());
        this.config.setAfterCommit(this.isCommitSelected());
        if (!this.isLinkSelected() && !this.isResolveSelected()) {
            LOG.log(Level.FINER, " nothing to do in afterCommit for {0}", file);
            return;
        }
        String msg = null;
        if (this.isLinkSelected()) {
            String formatString = this.config.getRevisionTemplate().getFormat();
            formatString = HookUtils.prepareFormatString(formatString, this.supportedRevisionVariables);
            msg = new MessageFormat(formatString).format(new Object[]{revision, author, date != null ? CC_DATE_FORMAT.format(date) : "", message}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " afterCommit message ''{0}''", msg);
        }
        LOG.log(Level.FINER, " commit hook message ''{0}'', resolved {1}", new Object[]{msg, this.isResolveSelected()});
        if ((this.isLinkSelected() || this.isResolveSelected()) && this.isCommitSelected()) {
            issue.addComment(msg, this.isResolveSelected());
            issue.open();
        } else if (applyPush) {
            LOG.log(Level.FINER, " commit hook message will be set after push");
            this.config.setPushAction(revision, new VCSHooksConfig.PushOperation(issue.getID(), msg, this.isResolveSelected()));
            LOG.log(Level.FINE, "schedulig issue {0} for file {1}", new Object[]{issue.getID(), file});
        }
        LOG.log(Level.FINE, "afterCommit end for {0}", file);
        VCSHooksConfig.logHookUsage(hookUsageName, this.getSelectedRepository());
    }

    public void afterPush(File[] files, String[] changesets, String hookUsageName) {
        if (files.length == 0) {
            LOG.warning("calling after push for zero files");
            return;
        }
        File file = files[0];
        LOG.log(Level.FINE, "push hook start for {0}", file);
        Repository repo = null;
        for (String changeset : changesets) {
            VCSHooksConfig.PushOperation operation = this.config.popPushAction(changeset);
            if (operation == null) {
                LOG.log(Level.FINE, " no push hook scheduled for {0}", file);
                continue;
            }
            if (repo == null && (repo = RepositoryQuery.getRepository((FileObject)FileUtil.toFileObject((File)file), (boolean)true)) == null) {
                LOG.log(Level.WARNING, " could not find issue tracker for {0}", file);
                break;
            }
            Issue[] issues = repo.getIssues(new String[]{operation.getIssueID()});
            if (issues == null || issues.length == 0) {
                LOG.log(Level.FINE, " no issue found with id {0}", operation.getIssueID());
                continue;
            }
            issues[0].addComment(operation.getMsg(), operation.isClose());
        }
        LOG.log(Level.FINE, "push hook end for {0}", file);
        VCSHooksConfig.logHookUsage(hookUsageName, this.getSelectedRepository());
    }

    public void afterChangesetReplace(File[] files, Map<String, String> changesets, String hookUsageName) {
        if (files.length == 0) {
            LOG.warning("calling afterChangesetReplace for zero files");
            return;
        }
        File file = files[0];
        LOG.log(Level.FINE, "afterChangesetReplace hook start for {0}", file);
        for (Map.Entry<String, String> changesetMapping : changesets.entrySet()) {
            String original = changesetMapping.getKey();
            String replace = changesetMapping.getValue();
            VCSHooksConfig.PushOperation operation = this.config.popPushAction(original);
            if (operation == null) continue;
            if (replace == null) {
                LOG.log(Level.FINE, "afterChangesetReplace hook found a deleted changeset {0}", original);
                this.config.setPushAction(original, operation);
                continue;
            }
            LOG.log(Level.FINE, "afterChangesetReplace hook found a replaced changeset {0}->{1}", new Object[]{original, replace});
            this.config.setPushAction(replace, new VCSHooksConfig.PushOperation(operation.getIssueID(), operation.getMsg().replaceAll(original, replace), operation.isClose()));
        }
        LOG.log(Level.FINE, "afterChangesetReplace hook end for {0}", file);
    }

    public HookPanel createComponent(File[] files) {
        return this.createComponent(files, null);
    }

    public HookPanel createComponent(File[] files, Boolean afterCommit) {
        File referenceFile;
        LOG.finer("HookImpl.createComponent()");
        if (files.length == 0) {
            referenceFile = null;
            LOG.warning("creating hook component for zero files");
        } else {
            referenceFile = files[0];
        }
        this.panel = new HookPanel(FileUtil.toFileObject((File)referenceFile), this.config.getLink(), this.config.getResolve(), afterCommit != null ? afterCommit.booleanValue() : this.config.getAfterCommit());
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HookImpl.this.onShowFormat();
            }
        });
        return this.panel;
    }

    private void onShowFormat() {
        FormatPanel p = new FormatPanel(this.config.getRevisionTemplate(), this.config.getDefaultRevisionTemplate(), this.supportedRevisionVariables, this.config.getIssueInfoTemplate(), this.config.getDefaultIssueInfoTemplate(), this.supportedIssueInfoVariables);
        if (HookUtils.show(p, NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"), new HelpCtx(this.panel.getClass()))) {
            this.config.setRevisionTemplate(p.getIssueFormat());
            this.config.setIssueInfoTemplate(p.getCommitFormat());
        }
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private boolean isCommitSelected() {
        return this.panel != null && this.panel.commitRadioButton.isSelected();
    }

    private Repository getSelectedRepository() {
        return this.panel != null ? this.panel.getSelectedRepository() : null;
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }
}

