/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class TaskSchedulingManager {
    public static final String PROPERTY_SCHEDULED_TASKS_CHANGED = "TaskSchedulingManager.scheduledTasksChanged";
    private static TaskSchedulingManager instance;
    private final Map<IssueImpl, IssueScheduleInfo> scheduledTasks;
    private final Map<String, Set<String>> persistedTasks;
    private final Set<String> initializedRepositories;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final String SEP = "###";
    private static final String PREF_SCHEDULED = "TaskSchedulingManager.scheduledTasks.";
    private boolean initializing;
    private static final RequestProcessor RP;
    private final Set<IssueImpl> issuesToHandle;
    private final Set<IssueImpl> deletedIssues;
    private final RequestProcessor.Task handleTask;

    private TaskSchedulingManager() {
        this.initializedRepositories = Collections.synchronizedSet(new HashSet());
        this.scheduledTasks = Collections.synchronizedMap(new WeakHashMap());
        this.persistedTasks = new HashMap<String, Set<String>>();
        this.issuesToHandle = new LinkedHashSet<IssueImpl>();
        this.deletedIssues = new LinkedHashSet<IssueImpl>();
        this.handleTask = RP.create((Runnable)new HandleTask());
        this.loadTasks();
        RepositoryRegistry.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("bugtracking.repositories.changed".equals(evt.getPropertyName())) {
                    TaskSchedulingManager.this.repositoriesChanged(evt);
                }
            }
        });
    }

    public static synchronized TaskSchedulingManager getInstance() {
        if (instance == null) {
            instance = new TaskSchedulingManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTask(IssueImpl task) {
        boolean schedule;
        Set<IssueImpl> set = this.issuesToHandle;
        synchronized (set) {
            schedule = this.issuesToHandle.add(task);
        }
        if (schedule) {
            this.handleTask.schedule(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskDeleted(IssueImpl task) {
        boolean schedule;
        Set<IssueImpl> set = this.deletedIssues;
        synchronized (set) {
            schedule = this.deletedIssues.add(task);
        }
        if (schedule) {
            this.handleTask.schedule(500);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public IssueImpl[] getScheduledTasks(RepositoryImpl ... repositories) {
        return this.getScheduledTasks((IssueScheduleInfo)null, repositories);
    }

    public IssueImpl[] getScheduledTasks(IssueScheduleInfo restrictionInterval, RepositoryImpl ... repositories) {
        HashSet<String> repositoryIds = new HashSet<String>(repositories.length);
        for (RepositoryImpl repo : repositories) {
            repositoryIds.add(repo.getId());
        }
        this.initializeTasks(repositoryIds);
        this.handleIssues();
        HashSet<IssueImpl> allTasks = new HashSet<IssueImpl>(Arrays.asList(this.scheduledTasks.keySet().toArray(new IssueImpl[0])));
        Iterator it = allTasks.iterator();
        while (it.hasNext()) {
            IssueImpl issue = (IssueImpl)it.next();
            if (repositoryIds.contains(issue.getRepositoryImpl().getId()) && this.isInInterval(issue.getSchedule(), restrictionInterval)) continue;
            it.remove();
        }
        return allTasks.toArray(new IssueImpl[allTasks.size()]);
    }

    public boolean isInInterval(IssueScheduleInfo schedule, IssueScheduleInfo restrictionInterval) {
        boolean yearIsHigher;
        boolean yearIsLower;
        if (restrictionInterval == null) {
            return true;
        }
        Calendar scheduleStart = Calendar.getInstance();
        scheduleStart.setTime(schedule.getDate());
        Calendar scheduleEnd = Calendar.getInstance();
        scheduleEnd.setTime(schedule.getDate());
        scheduleEnd.add(5, schedule.getInterval());
        Calendar intervalStart = Calendar.getInstance();
        intervalStart.setTime(restrictionInterval.getDate());
        Calendar intervaEnd = Calendar.getInstance();
        intervaEnd.setTime(restrictionInterval.getDate());
        intervaEnd.add(5, restrictionInterval.getInterval());
        boolean bl = yearIsLower = intervalStart.get(1) < scheduleStart.get(1);
        boolean start = yearIsLower ? yearIsLower : intervalStart.get(1) == scheduleStart.get(1) && intervalStart.get(6) <= scheduleStart.get(6);
        boolean bl2 = yearIsHigher = intervaEnd.get(1) > scheduleEnd.get(1);
        boolean end = yearIsHigher ? yearIsHigher : intervaEnd.get(1) == scheduleEnd.get(1) && intervaEnd.get(6) >= scheduleEnd.get(6);
        return start && end;
    }

    private void fireChange() {
        this.support.firePropertyChange(PROPERTY_SCHEDULED_TASKS_CHANGED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        HashMap<String, String> toPersist = new HashMap<String, String>();
        Map<String, Set<String>> map = this.persistedTasks;
        synchronized (map) {
            for (Map.Entry<String, Set<String>> e : this.persistedTasks.entrySet()) {
                StringBuilder sb = new StringBuilder();
                for (String taskId : e.getValue()) {
                    sb.append(taskId);
                    sb.append(SEP);
                }
                toPersist.put(e.getKey(), sb.toString());
            }
        }
        for (Map.Entry entry : toPersist.entrySet()) {
            if (((String)entry.getValue()).isEmpty()) {
                NbPreferences.forModule(TaskSchedulingManager.class).remove(PREF_SCHEDULED + (String)entry.getKey());
                continue;
            }
            NbPreferences.forModule(TaskSchedulingManager.class).put(PREF_SCHEDULED + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void repositoriesChanged(PropertyChangeEvent evt) {
        List oldRepositories = (List)(evt.getOldValue() == null ? Collections.emptyList() : evt.getOldValue());
        List newRepositories = (List)(evt.getNewValue() == null ? Collections.emptyList() : evt.getNewValue());
        HashSet removed = new HashSet(oldRepositories);
        removed.removeAll(newRepositories);
        if (!removed.isEmpty()) {
            boolean changed = false;
            for (IssueImpl impl : this.getScheduledTasks(new RepositoryImpl[0])) {
                if (!removed.contains(impl.getRepositoryImpl()) || null == this.scheduledTasks.remove(impl)) continue;
                changed = true;
            }
            if (changed) {
                this.fireChange();
            }
        }
    }

    private void loadTasks() {
        Preferences pref = NbPreferences.forModule(TaskSchedulingManager.class);
        try {
            for (String key : pref.keys()) {
                if (!key.startsWith(PREF_SCHEDULED)) continue;
                String repositoryId = key.substring(PREF_SCHEDULED.length());
                String tasks = pref.get(key, "");
                for (String taskId : tasks.split(SEP)) {
                    if (taskId.isEmpty()) continue;
                    this.getRepositoryTasks(repositoryId).add(taskId);
                }
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(TaskSchedulingManager.class.getName()).log(Level.INFO, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRepositoryTasks(String repositoryId) {
        Map<String, Set<String>> map = this.persistedTasks;
        synchronized (map) {
            Set<String> tasks = this.persistedTasks.get(repositoryId);
            if (tasks == null) {
                tasks = Collections.synchronizedSet(new HashSet());
                this.persistedTasks.put(repositoryId, tasks);
            }
            return tasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTasks(Set<String> repositories) {
        boolean fireChange = false;
        try {
            this.initializing = true;
            String[] stringArray = this.persistedTasks;
            synchronized (this.persistedTasks) {
                String[] repositoryIds = this.persistedTasks.keySet().toArray(new String[this.persistedTasks.size()]);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                for (String repositoryId : repositoryIds) {
                    Set<String> set = this.initializedRepositories;
                    synchronized (set) {
                        if (!this.initializedRepositories.contains(repositoryId) && repositories.contains(repositoryId) && this.initializeTasks(repositoryId)) {
                            fireChange = true;
                        }
                    }
                }
            }
        }
        finally {
            this.initializing = false;
            if (fireChange) {
                this.fireChange();
            }
        }
        {
            return;
        }
    }

    private boolean initializeTasks(String repositoryId) {
        RepositoryImpl repository = null;
        for (RepositoryImpl repo : RepositoryRegistry.getInstance().getKnownRepositories(false, true)) {
            if (!repositoryId.equals(repo.getId())) continue;
            repository = repo;
            break;
        }
        if (repository == null) {
            return false;
        }
        this.initializeTasks(repository);
        return true;
    }

    private void initializeTasks(RepositoryImpl repository) {
        this.initializedRepositories.add(repository.getId());
        String[] taskIds = this.getRepositoryTasks(repository.getId()).toArray(new String[0]);
        if (taskIds.length > 0) {
            Collection<IssueImpl> issues = repository.getIssueImpls(taskIds);
            for (IssueImpl impl : issues) {
                this.handleSingleIssue(impl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSingleIssue(IssueImpl issue) {
        IssueScheduleInfo info = issue.getSchedule();
        boolean changed = false;
        Set<String> set = this.initializedRepositories;
        synchronized (set) {
            if (info == null) {
                if (this.scheduledTasks.remove(issue) != null) {
                    changed = true;
                }
                if (this.getRepositoryTasks(issue.getRepositoryImpl().getId()).remove(issue.getID())) {
                    this.persist();
                }
            } else {
                IssueScheduleInfo oldInfo = this.scheduledTasks.put(issue, info);
                if (!info.equals(oldInfo)) {
                    changed = true;
                }
                if (this.getRepositoryTasks(issue.getRepositoryImpl().getId()).add(issue.getID())) {
                    this.persist();
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDeletedIssue(IssueImpl issue) {
        boolean changed = false;
        Set<String> set = this.initializedRepositories;
        synchronized (set) {
            if (this.scheduledTasks.remove(issue) != null) {
                changed = true;
            }
            if (this.getRepositoryTasks(issue.getRepositoryImpl().getId()).remove(issue.getID())) {
                this.persist();
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIssues() {
        IssueImpl[] issues;
        Set<IssueImpl> set = this.issuesToHandle;
        synchronized (set) {
            issues = this.issuesToHandle.toArray(new IssueImpl[this.issuesToHandle.size()]);
            this.issuesToHandle.clear();
        }
        boolean changed = false;
        for (IssueImpl issue : issues) {
            changed |= this.handleSingleIssue(issue);
        }
        Set<IssueImpl> set2 = this.deletedIssues;
        synchronized (set2) {
            issues = this.deletedIssues.toArray(new IssueImpl[this.deletedIssues.size()]);
            this.deletedIssues.clear();
        }
        for (IssueImpl issue : issues) {
            changed |= this.handleDeletedIssue(issue);
        }
        if (changed && !this.initializing) {
            this.fireChange();
        }
    }

    static {
        RP = new RequestProcessor("TaskSchedulingManager");
    }

    private class HandleTask
    implements Runnable {
        private HandleTask() {
        }

        @Override
        public void run() {
            TaskSchedulingManager.this.handleIssues();
        }
    }
}

