/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.CRC32;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class TransformerUtils {
    public static final String JAX_WS_XML_PATH = "nbproject/jax-ws.xml";
    public static final String JAXWS_BUILD_XML_PATH = "nbproject/jaxws-build.xml";
    static final String GENFILES_PROPERTIES_PATH = "nbproject/genfiles.properties";
    static final String KEY_SUFFIX_JAXWS_BUILD_CRC = ".stylesheet.CRC32";
    static final String JAXWS_20_LIB = "jaxws20lib";
    static final String JAXWS_VERSION = "jaxwsversion";
    static final String XJC_ENCODING = "xjcencoding";

    public static void transformClients(FileObject projectDirectory, String jaxws_stylesheet_resource) throws IOException {
        TransformerUtils.transformClients(projectDirectory, jaxws_stylesheet_resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformClients(FileObject projectDirectory, String jaxws_stylesheet_resource, boolean setJaxWsVersion) throws IOException {
        byte[] resultData;
        byte[] stylesheetData;
        byte[] projectXmlData;
        final FileObject jaxws_xml = projectDirectory.getFileObject(JAX_WS_XML_PATH);
        if (jaxws_xml == null) {
            return;
        }
        final FileObject jaxWsBuildScriptXml = FileUtil.createData((FileObject)projectDirectory, (String)JAXWS_BUILD_XML_PATH);
        try {
            projectXmlData = (byte[])ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<byte[]>(){

                public byte[] run() throws IOException {
                    try (InputStream is = jaxws_xml.getInputStream();){
                        byte[] byArray = TransformerUtils.load(is);
                        return byArray;
                    }
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        URL stylesheet = TransformerUtils.class.getResource(jaxws_stylesheet_resource);
        try (InputStream is = stylesheet.openStream();){
            stylesheetData = TransformerUtils.load(is);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheetData), stylesheet.toExternalForm());
            Transformer t = tf.newTransformer(stylesheetSource);
            if (setJaxWsVersion && !TransformerUtils.isJAXWS21(projectDirectory)) {
                t.setParameter(JAXWS_VERSION, JAXWS_20_LIB);
            }
            if (TransformerUtils.hasEncoding(FileOwnerQuery.getOwner((FileObject)projectDirectory))) {
                t.setParameter(XJC_ENCODING, Boolean.TRUE.toString());
            }
            File jaxws_xml_F = FileUtil.toFile((FileObject)jaxws_xml);
            assert (jaxws_xml_F != null);
            StreamSource jaxWsSource = new StreamSource(new ByteArrayInputStream(projectXmlData), jaxws_xml_F.toURI().toString());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            t.transform(jaxWsSource, new StreamResult(result));
            resultData = result.toByteArray();
        }
        catch (TransformerException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    FileLock lock1 = jaxWsBuildScriptXml.lock();
                    OutputStream os = null;
                    try {
                        os = jaxWsBuildScriptXml.getOutputStream(lock1);
                        os.write(resultData);
                    }
                    finally {
                        lock1.releaseLock();
                        if (os != null) {
                            os.close();
                        }
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    static byte[] load(InputStream is) throws IOException {
        int read;
        int size = Math.max(1024, is.available());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[size];
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    private static boolean isJAXWS21(FileObject projectDirectory) {
        String version;
        JAXWSVersionProvider jvp;
        Project project = FileOwnerQuery.getOwner((FileObject)projectDirectory);
        return project == null || (jvp = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class)) == null || (version = jvp.getJAXWSVersion()) == null || TransformerUtils.isVersionOK(version, "2.1");
    }

    private static boolean hasEncoding(Project project) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        boolean hasXjc = false;
        if (srcGroups != null) {
            for (SourceGroup group : srcGroups) {
                ClassPath classpath = ClassPath.getClassPath((FileObject)group.getRootFolder(), (String)"classpath/compile");
                if (classpath != null && classpath.findResource("com/sun/tools/xjc/XJCTask.class") != null) {
                    hasXjc = true;
                }
                if (classpath == null) {
                    return false;
                }
                FileObject fo = classpath.findResource("com/sun/tools/xjc/generator/bean/field/MessageBundle_it.properties");
                if (fo == null) continue;
                return true;
            }
        }
        if (hasXjc) {
            return false;
        }
        String jaxWs21 = PropertyUtils.getGlobalProperties().getProperty("libs.jaxws21.classpath");
        ClassPath classPath = ClassPathSupport.createClassPath((String)jaxWs21);
        FileObject fo = classPath.findResource("com/sun/tools/xjc/generator/bean/field/MessageBundle_it.properties");
        return fo != null;
    }

    static String getCrc32(InputStream is) throws IOException {
        return TransformerUtils.computeCrc32(is);
    }

    private static String computeCrc32(InputStream is) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = is.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        int val = (int)crc.getValue();
        String hex = Integer.toHexString(val);
        while (hex.length() < 8) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static boolean isVersionOK(String version, String requiredVersion) {
        int len1 = version.length();
        int len2 = requiredVersion.length();
        for (int i = 0; i < Math.min(len1, len2); ++i) {
            if (version.charAt(i) < requiredVersion.charAt(i)) {
                return false;
            }
            if (version.charAt(i) <= requiredVersion.charAt(i)) continue;
            return true;
        }
        if (len1 > len2) {
            return true;
        }
        return len1 >= len2;
    }
}

