/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.validation;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.htmlparser.common.CharacterHandler;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.io.DataUri;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.messages.BufferingRootNamespaceSniffer;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.messages.RootNamespaceSniffer;
import nu.validator.messages.TooManyErrorsException;
import nu.validator.messages.ValidationTransaction;
import nu.validator.servlet.ParserMode;
import nu.validator.source.SourceCode;
import nu.validator.spec.html5.Html5SpecBuilder;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.AttributesPermutingXMLReaderWrapper;
import nu.validator.xml.BaseUriTracker;
import nu.validator.xml.CombineContentHandler;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.DataUriEntityResolver;
import nu.validator.xml.IdFilter;
import nu.validator.xml.NamespaceDroppingXMLReaderWrapper;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.SystemErrErrorHandler;
import nu.validator.xml.TypedInputSource;
import nu.validator.xml.WiretapXMLReaderWrapper;
import nu.validator.xml.dataattributes.DataAttributeDroppingSchemaWrapper;
import nu.validator.xml.langattributes.XmlLangAttributeDroppingSchemaWrapper;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.validation.CharacterHandlerReader;
import org.netbeans.modules.html.validation.LinesMapper;
import org.netbeans.modules.html.validation.NbMessageEmitter;
import org.netbeans.modules.html.validation.ProblemDescriptionFilter;
import org.netbeans.modules.html.validation.ProblemsHandler;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class NbValidationTransaction
extends ValidationTransaction {
    private static final Logger LOGGER = Logger.getLogger(NbValidationTransaction.class.getCanonicalName());
    private static final Pattern SPACE = Pattern.compile("\\s+");
    private static boolean INITIALIZED = false;
    private static String INTERNAL_ERROR_MSG_SEE_LOG = NbBundle.getMessage(NbValidationTransaction.class, (String)"MSG_Unexpected_Validator_Error_See_IDE_Log");
    private static String INTERNAL_ERROR_MSG = NbBundle.getMessage(NbValidationTransaction.class, (String)"MSG_Unexpected_Validator_Error");
    protected String document = null;
    ParserMode parser = ParserMode.AUTO;
    private boolean laxType = false;
    protected final AttributesImpl attrs = new AttributesImpl();
    private String schemaUrls = null;
    protected SAXParser xmlParser = null;
    private CharacterHandlerReader sourceReader;
    protected TypedInputSource documentInput;
    protected DataUriEntityResolver dataRes;
    protected ContentTypeParser contentTypeParser;
    private boolean checkNormalization = false;
    private SourceCode sourceCode = new SourceCode();
    private boolean showSource;
    private BaseUriTracker baseUriTracker = null;
    private String charsetOverride = null;
    private Set<String> filteredNamespaces = new LinkedHashSet<String>();
    private Reader codeToValidate;
    private long validationTime;
    private ProblemsHandler problemsHandler = new ProblemsHandler();
    private LinesMapper linesMapper = new LinesMapper();
    private HtmlVersion version;
    private String encoding;
    private static final Set<Marker> REPORTED_RUNTIME_EXCEPTIONS = new HashSet<Marker>();
    static int PATTERN_LEN_LIMIT = 10;

    public static void enableDebug() {
        LOGGER.setLevel(Level.FINE);
        LOGGER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.out.println(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    public static synchronized NbValidationTransaction create(HtmlVersion version) {
        return new NbValidationTransaction(version);
    }

    private static void initializeLocalEntities_HACK() {
    }

    private static synchronized void initialize() {
        if (INITIALIZED) {
            return;
        }
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NbValidationTransaction.class, (String)"MSG_InitHTMLValidation"));
        progress.start();
        progress.switchToIndeterminate();
        NbValidationTransaction.initializeLocalEntities_HACK();
        try {
            int i;
            int i2;
            String line;
            LOGGER.fine("Starting initialization.");
            BufferedReader r = new BufferedReader(new InputStreamReader(LocalCacheEntityResolver.getPresetsAsStream(), "UTF-8"));
            LinkedList<String> doctypes = new LinkedList<String>();
            LinkedList<String> namespaces = new LinkedList<String>();
            LinkedList<String> labels = new LinkedList<String>();
            LinkedList<String> urls = new LinkedList<String>();
            LOGGER.fine("Starting to loop over config file lines.");
            while ((line = r.readLine()) != null && !"".equals(line.trim())) {
                String[] s = line.split("\t");
                doctypes.add(s[0]);
                namespaces.add(s[1]);
                labels.add(s[2]);
                urls.add(s[3]);
            }
            LOGGER.fine("Finished reading config.");
            String[] presetDoctypesAsStrings = doctypes.toArray(new String[0]);
            presetNamespaces = namespaces.toArray(new String[0]);
            presetLabels = labels.toArray(new String[0]);
            presetUrls = urls.toArray(new String[0]);
            LOGGER.fine("Converted config to arrays.");
            for (i2 = 0; i2 < presetNamespaces.length; ++i2) {
                String str = presetNamespaces[i2];
                NbValidationTransaction.presetNamespaces[i2] = "-".equals(str) ? null : presetNamespaces[i2].intern();
            }
            LOGGER.fine("Prepared namespace array.");
            presetDoctypes = new int[presetDoctypesAsStrings.length];
            for (i2 = 0; i2 < presetDoctypesAsStrings.length; ++i2) {
                NbValidationTransaction.presetDoctypes[i2] = Integer.parseInt(presetDoctypesAsStrings[i2]);
            }
            LOGGER.fine("Parsed doctype numbers into ints.");
            SystemErrErrorHandler eh = new SystemErrErrorHandler();
            LocalCacheEntityResolver er = new LocalCacheEntityResolver((EntityResolver)new NullEntityResolver());
            er.setAllowRnc(true);
            PropertyMapBuilder pmb = new PropertyMapBuilder();
            pmb.put(ValidateProperty.ERROR_HANDLER, eh);
            pmb.put(ValidateProperty.ENTITY_RESOLVER, er);
            pmb.put(ValidateProperty.XML_READER_CREATOR, new XMLReaderCreatorImpl((ErrorHandler)eh, (EntityResolver)er));
            RngProperty.CHECK_ID_IDREF.add(pmb);
            PropertyMap pMap = pmb.toPropertyMap();
            LOGGER.fine("Parsing set up. Starting to read schemas.");
            TreeMap<String, Object> schemaMap = new TreeMap<String, Object>();
            schemaMap.put("http://c.validator.nu/table/", CheckerSchema.TABLE_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/table/", CheckerSchema.TABLE_CHECKER);
            schemaMap.put("http://c.validator.nu/nfc/", CheckerSchema.NORMALIZATION_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/nfc/", CheckerSchema.NORMALIZATION_CHECKER);
            schemaMap.put("http://c.validator.nu/debug/", CheckerSchema.DEBUG_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/debug/", CheckerSchema.DEBUG_CHECKER);
            schemaMap.put("http://c.validator.nu/text-content/", CheckerSchema.TEXT_CONTENT_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/text-content/", CheckerSchema.TEXT_CONTENT_CHECKER);
            schemaMap.put("http://c.validator.nu/usemap/", CheckerSchema.USEMAP_CHECKER);
            schemaMap.put("http://n.validator.nu/checkers/usemap/", CheckerSchema.USEMAP_CHECKER);
            schemaMap.put("http://c.validator.nu/unchecked/", CheckerSchema.UNCHECKED_SUBTREE_WARNER);
            schemaMap.put("http://s.validator.nu/html5/assertions.sch", CheckerSchema.ASSERTION_SCH);
            schemaMap.put("http://c.validator.nu/obsolete/", CheckerSchema.CONFORMING_BUT_OBSOLETE_WARNER);
            schemaMap.put("http://c.validator.nu/xml-pi/", CheckerSchema.XML_PI_CHECKER);
            for (i = 0; i < presetUrls.length; ++i) {
                String[] urls1 = SPACE.split(presetUrls[i]);
                for (int j = 0; j < urls1.length; ++j) {
                    String url = urls1[j];
                    if (schemaMap.get(url) != null || NbValidationTransaction.isCheckerUrl(url)) continue;
                    Schema sch = NbValidationTransaction.proxySchemaByUrl((String)url, (EntityResolver)er, (PropertyMap)pMap);
                    schemaMap.put(url, sch);
                }
            }
            LOGGER.fine("Schemas read.");
            preloadedSchemaUrls = new String[schemaMap.size()];
            preloadedSchemas = new Schema[schemaMap.size()];
            i = 0;
            for (Map.Entry entry : schemaMap.entrySet()) {
                NbValidationTransaction.preloadedSchemaUrls[i] = ((String)entry.getKey()).intern();
                Schema s = (Schema)entry.getValue();
                String u = (String)entry.getKey();
                if (NbValidationTransaction.isDataAttributeDroppingSchema(u)) {
                    s = new DataAttributeDroppingSchemaWrapper(s);
                }
                if (NbValidationTransaction.isXmlLangAllowingSchema(u)) {
                    s = new XmlLangAttributeDroppingSchemaWrapper(s);
                }
                NbValidationTransaction.preloadedSchemas[i] = s;
                ++i;
            }
            LOGGER.fine("Reading spec.");
            html5spec = Html5SpecBuilder.parseSpec((InputStream)LocalCacheEntityResolver.getHtml5SpecAsStream());
            LOGGER.fine("Spec read.");
            LOGGER.fine("Initialization complete.");
            INITIALIZED = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            progress.finish();
        }
    }

    private static boolean isDataAttributeDroppingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key) || "http://s.validator.nu/w3c-xhtml5.rnc".equals(key) || "http://s.validator.nu/w3c-html5.rnc".equals(key) || "http://s.validator.nu/w3c-xhtml5-microdata-rdfalite.rnc".equals(key) || "http://s.validator.nu/w3c-xhtml5-microdata-rdfa.rnc".equals(key) || "http://s.validator.nu/w3c-html5-microdata-rdfalite.rnc".equals(key) || "http://s.validator.nu/w3c-html5-microdata-rdfa.rnc".equals(key);
    }

    private static boolean isXmlLangAllowingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key) || "http://s.validator.nu/w3c-xhtml5.rnc".equals(key) || "http://s.validator.nu/w3c-html5.rnc".equals(key) || "http://s.validator.nu/w3c-xhtml5-microdata-rdfalite.rnc".equals(key) || "http://s.validator.nu/w3c-xhtml5-microdata-rdfa.rnc".equals(key) || "http://s.validator.nu/w3c-html5-microdata-rdfalite.rnc".equals(key) || "http://s.validator.nu/w3c-html5-microdata-rdfa.rnc".equals(key);
    }

    private static boolean isCheckerUrl(String url) {
        if ("http://c.validator.nu/all/".equals(url) || "http://hsivonen.iki.fi/checkers/all/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/all-html4/".equals(url) || "http://hsivonen.iki.fi/checkers/all-html4/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/base/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/rdfalite/".equals(url)) {
            return true;
        }
        for (int i = 0; i < ALL_CHECKERS.length; ++i) {
            if (!ALL_CHECKERS[i].equals(url)) continue;
            return true;
        }
        return false;
    }

    public NbValidationTransaction(HtmlVersion version) {
        this.version = version;
        NbValidationTransaction.initialize();
    }

    public List<ProblemDescription> getFoundProblems() {
        return this.problemsHandler.getProblems();
    }

    public List<ProblemDescription> getFoundProblems(int ofThisTypeAndMoreSevere) {
        return this.getFoundProblems(new ProblemDescriptionFilter.SeverityFilter(ofThisTypeAndMoreSevere));
    }

    public List<ProblemDescription> getFoundProblems(ProblemDescriptionFilter filter) {
        ArrayList<ProblemDescription> filtered = new ArrayList<ProblemDescription>();
        for (ProblemDescription pd : this.getFoundProblems()) {
            if (!filter.accepts(pd)) continue;
            filtered.add(pd);
        }
        return filtered;
    }

    public long getValidationTime() {
        return this.validationTime;
    }

    public void validateCode(Reader code, String sourceURI, Set<String> filteredNamespaces, String encoding) throws SAXException {
        long from = System.currentTimeMillis();
        this.codeToValidate = code;
        this.document = sourceURI;
        this.parser = this.htmlVersion2ParserMode(this.version);
        LOGGER.fine(String.format("Using %s parser.", this.parser.name()));
        this.encoding = encoding;
        this.filteredNamespaces = filteredNamespaces;
        if (!filteredNamespaces.isEmpty()) {
            StringBuilder fns = new StringBuilder();
            for (String ns : filteredNamespaces) {
                fns.append(ns).append(", ");
            }
            LOGGER.fine(String.format("Filtering following namespaces: %s", fns));
        }
        int lineOffset = 0;
        this.errorHandler = new MessageEmitterAdapter(null, this.sourceCode, this.showSource, null, lineOffset, false, (MessageEmitter)new NbMessageEmitter(this.problemsHandler, this.linesMapper, true));
        this.errorHandler.setLoggingOk(true);
        this.errorHandler.setErrorsOnly(false);
        this.validate();
        this.validationTime = System.currentTimeMillis() - from;
    }

    public boolean isSuccess() {
        return this.getFoundProblems(1).isEmpty();
    }

    private ParserMode htmlVersion2ParserMode(HtmlVersion version) {
        if (version.isXhtml()) {
            return ParserMode.XML_NO_EXTERNAL_ENTITIES;
        }
        switch (version) {
            case HTML41_STRICT: 
            case HTML41_TRANSATIONAL: 
            case HTML41_FRAMESET: {
                return ParserMode.AUTO;
            }
            case HTML5: {
                return ParserMode.HTML;
            }
        }
        return ParserMode.AUTO;
    }

    private boolean isHtmlUnsafePreset() {
        if ("".equals(this.schemaUrls)) {
            return false;
        }
        boolean preset = false;
        for (int i = 0; i < presetUrls.length; ++i) {
            if (!presetUrls[i].equals(this.schemaUrls)) continue;
            preset = true;
            break;
        }
        if (!preset) {
            return false;
        }
        return !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-basic.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-strict.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-transitional.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-frameset.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5/html5full.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5/html5full-aria.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-aria-svg-mathml.rnc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate() throws SAXException {
        this.entityResolver = new LocalCacheEntityResolver((EntityResolver)new NullEntityResolver());
        this.setAllowRnc(true);
        try {
            ContentHandler recorder;
            this.errorHandler.start(this.document);
            PropertyMapBuilder pmb = new PropertyMapBuilder();
            pmb.put(ValidateProperty.ERROR_HANDLER, this.errorHandler);
            pmb.put(ValidateProperty.ENTITY_RESOLVER, this.entityResolver);
            pmb.put(ValidateProperty.XML_READER_CREATOR, new XMLReaderCreatorImpl((ErrorHandler)this.errorHandler, (EntityResolver)this.entityResolver));
            pmb.put(ValidateProperty.SCHEMA_RESOLVER, (Object)this);
            RngProperty.CHECK_ID_IDREF.add(pmb);
            this.jingPropertyMap = pmb.toPropertyMap();
            this.setAllowRnc(false);
            this.loadDocAndSetupParser();
            if (this.htmlParser != null) {
                this.setErrorProfile();
            }
            this.reader.setErrorHandler((ErrorHandler)this.errorHandler);
            this.contentType = this.documentInput.getType();
            this.sourceCode.initialize((InputSource)this.documentInput);
            WiretapXMLReaderWrapper wiretap = new WiretapXMLReaderWrapper(this.reader);
            boolean isXhtml = this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION || this.parser == ParserMode.XML_NO_EXTERNAL_ENTITIES;
            ContentHandler contentHandler = recorder = isXhtml ? new XercesInaccurateLocatorWorkaround(this.sourceCode.getLocationRecorder(), this.linesMapper) : this.sourceCode.getLocationRecorder();
            if (this.baseUriTracker == null) {
                wiretap.setWiretapContentHander(recorder);
            } else {
                wiretap.setWiretapContentHander((ContentHandler)new CombineContentHandler(recorder, (ContentHandler)this.baseUriTracker));
            }
            wiretap.setWiretapLexicalHandler((LexicalHandler)((Object)recorder));
            this.reader = wiretap;
            if (this.htmlParser != null) {
                this.htmlParser.addCharacterHandler((CharacterHandler)this.linesMapper);
                this.htmlParser.addCharacterHandler((CharacterHandler)this.sourceCode);
                this.htmlParser.setMappingLangToXmlLang(true);
                this.htmlParser.setErrorHandler(this.errorHandler.getExactErrorHandler());
                this.htmlParser.setTreeBuilderErrorHandlerOverride((ErrorHandler)this.errorHandler);
                this.errorHandler.setHtml(true);
            } else if (this.xmlParser != null) {
                if (!this.filteredNamespaces.isEmpty()) {
                    this.reader = new NamespaceDroppingXMLReaderWrapper(this.reader, this.filteredNamespaces);
                }
                this.xmlParser.getXMLReader().setErrorHandler(this.errorHandler.getExactErrorHandler());
                this.sourceReader.addCharacterHandler(this.linesMapper);
            } else {
                throw new RuntimeException("Bug. Unreachable.");
            }
            this.reader = new AttributesPermutingXMLReaderWrapper(this.reader);
            if (this.charsetOverride != null) {
                String charset = this.documentInput.getEncoding();
                if (charset == null) {
                    this.errorHandler.warning(new SAXParseException("Overriding document character encoding from none to \u201c" + this.charsetOverride + "\u201d.", null));
                } else {
                    this.errorHandler.warning(new SAXParseException("Overriding document character encoding from \u201c" + charset + "\u201d to \u201c" + this.charsetOverride + "\u201d.", null));
                }
                this.documentInput.setEncoding(this.charsetOverride);
            }
            this.reader.parse((InputSource)this.documentInput);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.INFO, this.getDocumentErrorMsg(), e);
            this.errorHandler.internalError((Throwable)e, INTERNAL_ERROR_MSG_SEE_LOG);
        }
        catch (TooManyErrorsException e) {
            LOGGER.log(Level.FINE, this.getDocumentErrorMsg(), e);
            this.errorHandler.fatalError((SAXParseException)((Object)e));
        }
        catch (SAXException e) {
            LOGGER.log(Level.FINE, this.getDocumentErrorMsg(), e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, this.getDocumentErrorMsg(), e);
            this.errorHandler.ioError(e);
        }
        catch (IncorrectSchemaException e) {
            LOGGER.log(Level.INFO, this.getDocumentErrorMsg(), e);
            this.errorHandler.schemaError((Exception)e);
        }
        catch (RuntimeException e) {
            String message = this.reportRuntimeExceptionOnce(e) ? INTERNAL_ERROR_MSG_SEE_LOG : INTERNAL_ERROR_MSG;
            this.errorHandler.internalError((Throwable)e, message);
        }
        catch (Error e) {
            LOGGER.log(Level.INFO, this.getDocumentInternalErrorMsg(), e);
            this.errorHandler.internalError((Throwable)e, INTERNAL_ERROR_MSG_SEE_LOG);
        }
        finally {
            this.errorHandler.end(this.successMessage(), this.failureMessage(), null);
        }
    }

    private boolean reportRuntimeExceptionOnce(RuntimeException e) {
        int hash = this.document.hashCode();
        hash = 21 * hash + e.getClass().hashCode();
        if (e.getMessage() != null) {
            hash = 21 * hash + e.getMessage().hashCode();
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            hash = 21 * hash + sw.toString().hashCode();
        }
        Level level = NbValidationTransaction.isKnownProblem(e) ? Level.FINE : Level.INFO;
        Marker marker = new Marker(hash);
        if (REPORTED_RUNTIME_EXCEPTIONS.add(marker)) {
            LOGGER.log(level, this.getDocumentInternalErrorMsg(), e);
        }
        return LOGGER.isLoggable(level);
    }

    private static boolean isKnownProblem(RuntimeException e) {
        Class<?> eClass = e.getClass();
        if (eClass.equals(StringIndexOutOfBoundsException.class)) {
            StackTraceElement[] stelements = e.getStackTrace();
            if (stelements.length >= 1 && stelements[1].getClassName().equals("com.thaiopensource.validate.schematron.OutputHandler") && stelements[1].getMethodName().equals("startElement")) {
                return true;
            }
        } else if (eClass.equals(IllegalStateException.class)) {
            String msg = "Two cells in effect cannot start on the same column, so this should never happen!";
            return e.getMessage() != null && e.getMessage().indexOf(msg) != -1;
        }
        return false;
    }

    private String getDocumentErrorMsg() {
        return "An error occurred during validation of " + this.document;
    }

    private String getDocumentInternalErrorMsg() {
        return "An internal error occurred during validation of " + this.document;
    }

    protected String successMessage() throws SAXException {
        return "The document validates according to the specified schema(s).";
    }

    protected String failureMessage() throws SAXException {
        return "There were errors.";
    }

    protected void tryToSetupValidator() throws SAXException, IOException, IncorrectSchemaException {
        this.validator = this.validatorByUrls(this.schemaUrls);
    }

    protected void setErrorProfile() {
        HashMap profileMap = new HashMap();
        this.htmlParser.setErrorProfile(profileMap);
    }

    protected void loadDocAndSetupParser() throws SAXException, IOException, IncorrectSchemaException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        switch (this.parser) {
            case HTML: {
                int schemaId;
                DoctypeExpectation doctypeExpectation;
                if (this.isHtmlUnsafePreset()) {
                    String message = "The chosen preset schema is not appropriate for HTML.";
                    SAXException se = new SAXException(message);
                    this.errorHandler.schemaError((Exception)se);
                    throw se;
                }
                this.setAllowGenericXml(false);
                this.setAllowHtml(true);
                this.setAcceptAllKnownXmlTypes(false);
                this.setAllowXhtml(false);
                this.loadDocumentInput(false);
                this.newHtmlParser();
                switch (this.parser) {
                    case HTML: {
                        doctypeExpectation = DoctypeExpectation.HTML;
                        schemaId = 3;
                        break;
                    }
                    default: {
                        doctypeExpectation = DoctypeExpectation.AUTO;
                        schemaId = 0;
                    }
                }
                this.htmlParser.setDoctypeExpectation(doctypeExpectation);
                this.htmlParser.setDocumentModeHandler((DocumentModeHandler)this);
                this.reader = this.htmlParser;
                if (this.validator == null) {
                    LOGGER.fine(String.format("Using following schemas: %s", this.getSchemasForDoctypeId(schemaId)));
                    this.validator = this.validatorByDoctype(schemaId);
                }
                if (this.validator == null) break;
                this.reader.setContentHandler(this.validator.getContentHandler());
                break;
            }
            case XML_NO_EXTERNAL_ENTITIES: 
            case XML_EXTERNAL_ENTITIES_NO_VALIDATION: {
                this.setAllowGenericXml(true);
                this.setAllowHtml(false);
                this.setAcceptAllKnownXmlTypes(true);
                this.setAllowXhtml(true);
                this.loadDocumentInput(true);
                if (this.version != null) {
                    int schemaId;
                    switch (this.version) {
                        case XHTML10_TRANSATIONAL: {
                            schemaId = 1;
                            break;
                        }
                        case XHTML10_STICT: {
                            schemaId = 2;
                            break;
                        }
                        case XHTML10_FRAMESET: {
                            schemaId = 4;
                            break;
                        }
                        default: {
                            schemaId = 0;
                        }
                    }
                    if (schemaId != 0) {
                        this.validator = this.validatorByDoctype(schemaId);
                        LOGGER.fine(String.format("Using following schemas: %s", this.getSchemasForDoctypeId(schemaId)));
                    }
                }
                this.setupXmlParser();
                break;
            }
            default: {
                this.setAllowGenericXml(true);
                this.setAllowHtml(true);
                this.setAcceptAllKnownXmlTypes(true);
                this.setAllowXhtml(true);
                this.loadDocumentInput(false);
                if ("text/html".equals(this.documentInput.getType())) {
                    if (this.isHtmlUnsafePreset()) {
                        String message = "The Content-Type was \u201ctext/html\u201d, but the chosen preset schema is not appropriate for HTML.";
                        SAXException se = new SAXException(message);
                        this.errorHandler.schemaError((Exception)se);
                        throw se;
                    }
                    this.errorHandler.info("The Content-Type was \u201ctext/html\u201d. Using the HTML parser.");
                    this.newHtmlParser();
                    this.htmlParser.setDoctypeExpectation(DoctypeExpectation.AUTO);
                    this.htmlParser.setDocumentModeHandler((DocumentModeHandler)this);
                    this.reader = this.htmlParser;
                    if (this.validator == null) break;
                    this.reader.setContentHandler(this.validator.getContentHandler());
                    break;
                }
                this.errorHandler.info("The Content-Type was \u201c" + this.documentInput.getType() + "\u201d. Using the XML parser (not resolving external entities).");
                this.setupXmlParser();
            }
        }
    }

    protected void newHtmlParser() {
        this.htmlParser = new HtmlParser();
        this.htmlParser.setCommentPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentSpacePolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        this.htmlParser.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setMappingLangToXmlLang(true);
        this.htmlParser.setHtml4ModeCompatibleWithXhtml1Schemata(true);
        this.htmlParser.setHeuristics(Heuristics.ALL);
        this.htmlParser.setEntityResolver((EntityResolver)this.entityResolver);
    }

    protected void setupXmlParser() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        this.xmlParser = factory.newSAXParser();
        this.sourceReader.addCharacterHandler((CharacterHandler)this.sourceCode);
        this.reader = new IdFilter(this.xmlParser.getXMLReader());
        if (this.lexicalHandler != null) {
            this.xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        this.reader.setFeature("http://xml.org/sax/features/string-interning", true);
        this.reader.setFeature("http://xml.org/sax/features/external-general-entities", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        this.reader.setFeature("http://xml.org/sax/features/external-parameter-entities", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        if (this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION) {
            this.reader.setEntityResolver((EntityResolver)this.entityResolver);
        } else {
            this.reader.setEntityResolver((EntityResolver)new NullEntityResolver());
        }
        if (this.validator == null) {
            this.bufferingRootNamespaceSniffer = new BufferingRootNamespaceSniffer((ValidationTransaction)this);
            this.reader.setContentHandler((ContentHandler)this.bufferingRootNamespaceSniffer);
        } else {
            this.reader.setContentHandler((ContentHandler)new RootNamespaceSniffer((ValidationTransaction)this, this.validator.getContentHandler()));
            this.reader.setDTDHandler(this.validator.getDTDHandler());
        }
    }

    protected String shortenDataUri(String uri) {
        if (DataUri.startsWithData((String)uri)) {
            return "data:\u2026";
        }
        return uri;
    }

    protected void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
    }

    protected void setAllowGenericXml(boolean allowGenericXml) {
    }

    protected void setAllowHtml(boolean allowHtml) {
    }

    protected void setAllowRnc(boolean allowRnc) {
        this.entityResolver.setAllowRnc(allowRnc);
    }

    protected void setAllowXhtml(boolean allowXhtml) {
    }

    public void loadDocumentInput(boolean xhtmlContent) {
        Reader reader;
        assert (this.codeToValidate != null);
        if (xhtmlContent) {
            this.sourceReader = new CharacterHandlerReader(this.codeToValidate);
            reader = this.sourceReader;
        } else {
            reader = this.codeToValidate;
        }
        Reader readerImpl = reader;
        this.documentInput = new TypedInputSource(readerImpl);
        this.documentInput.setType("text/html");
        this.documentInput.setEncoding(this.encoding);
    }

    private String getSchemasForDoctypeId(int schemaId) {
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return presetUrls[i];
        }
        return null;
    }

    static int findBackwardDiff(CharSequence text, int tlen, char[] pattern, int pstart, int plen) {
        assert (text.length() >= tlen);
        assert (plen > 0);
        int pend = pstart + plen - 1;
        int limitedpstart = plen - PATTERN_LEN_LIMIT > 0 ? pstart + (plen - PATTERN_LEN_LIMIT) : pstart;
        int pidx = pend;
        int point = tlen;
        boolean inp = false;
        for (int i = tlen - 1; i >= 0; --i) {
            char patternChar;
            char textChar = text.charAt(i);
            if (textChar != (patternChar = pattern[pidx--])) {
                pidx = pend;
                if (inp) {
                    i = point - 1;
                    inp = false;
                }
                point = i;
                continue;
            }
            if (limitedpstart == pidx + 1 || pidx == 0) break;
            inp = true;
        }
        return tlen - point;
    }

    private static final class Marker {
        private final int hashCode;

        public Marker(int hashCode) {
            this.hashCode = hashCode;
        }

        public boolean equals(Object o) {
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class XercesInaccurateLocatorWorkaround
    implements ContentHandler,
    LexicalHandler {
        private ContentHandler contentHandler;
        private LexicalHandler lexicalHandler;
        private LinesMapper mapper;
        private ColumnAdjustingLocator locator;
        private Locator originalLocator;

        public XercesInaccurateLocatorWorkaround(Object source, LinesMapper mapper) {
            this.contentHandler = (ContentHandler)source;
            this.lexicalHandler = (LexicalHandler)source;
            this.mapper = mapper;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.originalLocator = locator;
            this.locator = new ColumnAdjustingLocator(locator);
            this.contentHandler.setDocumentLocator(this.locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.contentHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.contentHandler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.contentHandler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.contentHandler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            assert (this.locator != null);
            int line = this.originalLocator.getLineNumber();
            int column = this.originalLocator.getColumnNumber();
            int offset = this.mapper.getSourceOffsetForLocation(line - 1, column);
            int diff = NbValidationTransaction.findBackwardDiff(this.mapper.getSourceText(), offset, ch, start, length);
            this.locator.setColumnNumberDiff(-diff);
            this.contentHandler.characters(ch, start, length);
            this.locator.setColumnNumberDiff(0);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.contentHandler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }

        @Override
        public void endDTD() throws SAXException {
            this.lexicalHandler.endDTD();
        }

        @Override
        public void startEntity(String name) throws SAXException {
            this.lexicalHandler.startEntity(name);
        }

        @Override
        public void endEntity(String name) throws SAXException {
            this.lexicalHandler.endEntity(name);
        }

        @Override
        public void startCDATA() throws SAXException {
            this.lexicalHandler.startCDATA();
        }

        @Override
        public void endCDATA() throws SAXException {
            this.lexicalHandler.endCDATA();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.lexicalHandler.comment(ch, start, length);
        }

        private static class ColumnAdjustingLocator
        implements Locator {
            private Locator delegate;
            private int diff;

            public ColumnAdjustingLocator(Locator delegate) {
                this.delegate = delegate;
            }

            public void setColumnNumberDiff(int diff) {
                this.diff = diff;
            }

            @Override
            public String getPublicId() {
                return this.delegate.getPublicId();
            }

            @Override
            public String getSystemId() {
                return this.delegate.getSystemId();
            }

            @Override
            public int getLineNumber() {
                return this.delegate.getLineNumber();
            }

            @Override
            public int getColumnNumber() {
                return this.delegate.getColumnNumber() + this.diff;
            }
        }
    }

    private static class XMLReaderCreatorImpl
    implements XMLReaderCreator {
        private ErrorHandler errorHandler;
        private EntityResolver entityResolver;

        public XMLReaderCreatorImpl(ErrorHandler errorHandler, EntityResolver entityResolver) {
            this.errorHandler = errorHandler;
            this.entityResolver = entityResolver;
        }

        @Override
        public XMLReader createXMLReader() throws SAXException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                XMLReader r = factory.newSAXParser().getXMLReader();
                r.setFeature("http://xml.org/sax/features/external-general-entities", true);
                r.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                r.setEntityResolver(this.entityResolver);
                r.setErrorHandler(this.errorHandler);
                return r;
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException("Cannot create XMLReader instance", ex);
            }
        }
    }
}

