/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DbNodeActionRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String action;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"dbNodeId", "action", "opcRetryToken", "ifMatch"})
    DbNodeActionRequest(String dbNodeId, String action, String opcRetryToken, String ifMatch) {
        this.dbNodeId = dbNodeId;
        this.action = action;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId).action(this.action).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DbNodeActionRequest(super=" + super.toString() + ", dbNodeId=" + this.getDbNodeId() + ", action=" + this.getAction() + ", opcRetryToken=" + this.getOpcRetryToken() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbNodeActionRequest)) {
            return false;
        }
        DbNodeActionRequest other = (DbNodeActionRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbNodeId = this.getDbNodeId();
        String other$dbNodeId = other.getDbNodeId();
        if (this$dbNodeId == null ? other$dbNodeId != null : !this$dbNodeId.equals(other$dbNodeId)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        if (this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbNodeActionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbNodeId = this.getDbNodeId();
        result = result * 59 + ($dbNodeId == null ? 43 : $dbNodeId.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getAction() {
        return this.action;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DbNodeActionRequest, Void> {
        private String dbNodeId;
        private String action;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DbNodeActionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.action(o.getAction());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DbNodeActionRequest build() {
            DbNodeActionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DbNodeActionRequest buildWithoutInvocationCallback() {
            return new DbNodeActionRequest(this.dbNodeId, this.action, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "DbNodeActionRequest.Builder(dbNodeId=" + this.dbNodeId + ", action=" + this.action + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

