/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDbPreviewVersionSummary {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="timePreviewBegin")
    private final Date timePreviewBegin;
    @JsonProperty(value="timePreviewEnd")
    private final Date timePreviewEnd;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="details")
    private final String details;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().version(this.version).timePreviewBegin(this.timePreviewBegin).timePreviewEnd(this.timePreviewEnd).dbWorkload(this.dbWorkload).details(this.details);
    }

    public String getVersion() {
        return this.version;
    }

    public Date getTimePreviewBegin() {
        return this.timePreviewBegin;
    }

    public Date getTimePreviewEnd() {
        return this.timePreviewEnd;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public String getDetails() {
        return this.details;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutonomousDbPreviewVersionSummary)) {
            return false;
        }
        AutonomousDbPreviewVersionSummary other = (AutonomousDbPreviewVersionSummary)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Date this$timePreviewBegin = this.getTimePreviewBegin();
        Date other$timePreviewBegin = other.getTimePreviewBegin();
        if (this$timePreviewBegin == null ? other$timePreviewBegin != null : !((Object)this$timePreviewBegin).equals(other$timePreviewBegin)) {
            return false;
        }
        Date this$timePreviewEnd = this.getTimePreviewEnd();
        Date other$timePreviewEnd = other.getTimePreviewEnd();
        if (this$timePreviewEnd == null ? other$timePreviewEnd != null : !((Object)this$timePreviewEnd).equals(other$timePreviewEnd)) {
            return false;
        }
        DbWorkload this$dbWorkload = this.getDbWorkload();
        DbWorkload other$dbWorkload = other.getDbWorkload();
        if (this$dbWorkload == null ? other$dbWorkload != null : !((Object)((Object)this$dbWorkload)).equals((Object)other$dbWorkload)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Date $timePreviewBegin = this.getTimePreviewBegin();
        result = result * 59 + ($timePreviewBegin == null ? 43 : ((Object)$timePreviewBegin).hashCode());
        Date $timePreviewEnd = this.getTimePreviewEnd();
        result = result * 59 + ($timePreviewEnd == null ? 43 : ((Object)$timePreviewEnd).hashCode());
        DbWorkload $dbWorkload = this.getDbWorkload();
        result = result * 59 + ($dbWorkload == null ? 43 : ((Object)((Object)$dbWorkload)).hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "AutonomousDbPreviewVersionSummary(version=" + this.getVersion() + ", timePreviewBegin=" + this.getTimePreviewBegin() + ", timePreviewEnd=" + this.getTimePreviewEnd() + ", dbWorkload=" + (Object)((Object)this.getDbWorkload()) + ", details=" + this.getDetails() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"version", "timePreviewBegin", "timePreviewEnd", "dbWorkload", "details"})
    @Deprecated
    public AutonomousDbPreviewVersionSummary(String version, Date timePreviewBegin, Date timePreviewEnd, DbWorkload dbWorkload, String details) {
        this.version = version;
        this.timePreviewBegin = timePreviewBegin;
        this.timePreviewEnd = timePreviewEnd;
        this.dbWorkload = dbWorkload;
        this.details = details;
    }

    public static enum DbWorkload {
        Oltp("OLTP"),
        Dw("DW"),
        Ajd("AJD"),
        Apex("APEX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DbWorkload', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DbWorkload.class);
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="timePreviewBegin")
        private Date timePreviewBegin;
        @JsonProperty(value="timePreviewEnd")
        private Date timePreviewEnd;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="details")
        private String details;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder timePreviewBegin(Date timePreviewBegin) {
            this.timePreviewBegin = timePreviewBegin;
            this.__explicitlySet__.add("timePreviewBegin");
            return this;
        }

        public Builder timePreviewEnd(Date timePreviewEnd) {
            this.timePreviewEnd = timePreviewEnd;
            this.__explicitlySet__.add("timePreviewEnd");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public AutonomousDbPreviewVersionSummary build() {
            AutonomousDbPreviewVersionSummary __instance__ = new AutonomousDbPreviewVersionSummary(this.version, this.timePreviewBegin, this.timePreviewEnd, this.dbWorkload, this.details);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(AutonomousDbPreviewVersionSummary o) {
            Builder copiedBuilder = this.version(o.getVersion()).timePreviewBegin(o.getTimePreviewBegin()).timePreviewEnd(o.getTimePreviewEnd()).dbWorkload(o.getDbWorkload()).details(o.getDetails());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "AutonomousDbPreviewVersionSummary.Builder(version=" + this.version + ", timePreviewBegin=" + this.timePreviewBegin + ", timePreviewEnd=" + this.timePreviewEnd + ", dbWorkload=" + (Object)((Object)this.dbWorkload) + ", details=" + this.details + ")";
        }
    }
}

