/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Warner;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class InferenceContext {
    List<Type> undetvars;
    List<Type> inferencevars;
    Map<Infer.FreeTypeListener, List<Type>> freeTypeListeners = new LinkedHashMap<Infer.FreeTypeListener, List<Type>>();
    Types types;
    Infer infer;
    Map<JCTree, Type> captureTypeCache = new HashMap<JCTree, Type>();

    Type update(Type t) {
        return t;
    }

    public InferenceContext(Infer infer, List<Type> inferencevars) {
        this(infer, inferencevars, inferencevars.map(infer.fromTypeVarFun));
    }

    public InferenceContext(Infer infer, List<Type> inferencevars, List<Type> undetvars) {
        this.inferencevars = inferencevars;
        this.undetvars = undetvars;
        this.infer = infer;
        this.types = infer.types;
    }

    void addVar(Type.TypeVar t) {
        this.undetvars = this.undetvars.prepend(this.infer.fromTypeVarFun.apply(t));
        this.inferencevars = this.inferencevars.prepend(t);
    }

    List<Type> inferenceVars() {
        return this.inferencevars;
    }

    public List<Type> undetVars() {
        return this.undetvars;
    }

    List<Type> restvars() {
        return this.filterVars(uv -> uv.getInst() == null);
    }

    List<Type> instvars() {
        return this.filterVars(uv -> uv.getInst() != null);
    }

    final List<Type> boundedVars() {
        return this.filterVars(uv -> uv.getBounds(Type.UndetVar.InferenceBound.UPPER).diff(uv.getDeclaredBounds()).appendList(uv.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)).nonEmpty());
    }

    private List<Type> filterVars(Predicate<Type.UndetVar> fu) {
        ListBuffer<Type> res = new ListBuffer<Type>();
        for (Type t : this.undetvars) {
            Type.UndetVar uv = (Type.UndetVar)t;
            if (!fu.test(uv)) continue;
            res.append(uv.qtype);
        }
        return res.toList();
    }

    final boolean free(Type t) {
        return t.containsAny(this.inferencevars);
    }

    final boolean free(List<Type> ts) {
        for (Type t : ts) {
            if (!this.free(t)) continue;
            return true;
        }
        return false;
    }

    final List<Type> freeVarsIn(Type t) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type iv : this.inferenceVars()) {
            if (!t.contains(iv)) continue;
            buf.add(iv);
        }
        return buf.toList();
    }

    final List<Type> freeVarsIn(List<Type> ts) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type t : ts) {
            buf.appendList(this.freeVarsIn(t));
        }
        ListBuffer<Type> buf2 = new ListBuffer<Type>();
        for (Type t : buf) {
            if (buf2.contains(t)) continue;
            buf2.add(t);
        }
        return buf2.toList();
    }

    public final Type asUndetVar(Type t) {
        return this.types.subst(t, this.inferencevars, this.undetvars);
    }

    final List<Type> asUndetVars(List<Type> ts) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type t : ts) {
            buf.append(this.asUndetVar(t));
        }
        return buf.toList();
    }

    List<Type> instTypes() {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type t : this.undetvars) {
            Type.UndetVar uv = (Type.UndetVar)t;
            buf.append(uv.getInst() != null ? uv.getInst() : uv.qtype);
        }
        return buf.toList();
    }

    Type asInstType(Type t) {
        return this.types.subst(t, this.inferencevars, this.instTypes());
    }

    List<Type> asInstTypes(List<Type> ts) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type t : ts) {
            buf.append(this.asInstType(t));
        }
        return buf.toList();
    }

    void addFreeTypeListener(List<Type> types, Infer.FreeTypeListener ftl) {
        this.freeTypeListeners.put(ftl, this.freeVarsIn(types));
    }

    void notifyChange() {
        this.notifyChange(this.inferencevars.diff(this.restvars()));
    }

    void notifyChange(List<Type> inferredVars) {
        Infer.InferenceException thrownEx = null;
        for (Map.Entry<Infer.FreeTypeListener, List<Type>> entry : new LinkedHashMap<Infer.FreeTypeListener, List<Type>>(this.freeTypeListeners).entrySet()) {
            if (Type.containsAny(entry.getValue(), this.inferencevars.diff(inferredVars))) continue;
            try {
                entry.getKey().typesInferred(this);
                this.freeTypeListeners.remove(entry.getKey());
            }
            catch (Infer.InferenceException ex) {
                if (thrownEx != null) continue;
                thrownEx = ex;
            }
        }
        if (thrownEx != null) {
            throw thrownEx;
        }
    }

    public List<Type> save() {
        ListBuffer<Type.UndetVar> buf = new ListBuffer<Type.UndetVar>();
        for (Type t : this.undetvars) {
            buf.add(((Type.UndetVar)t).dup(this.infer.types));
        }
        return buf.toList();
    }

    public void rollback(List<Type> saved_undet) {
        Assert.check(saved_undet != null);
        ListBuffer<Type.UndetVar> newUndetVars = new ListBuffer<Type.UndetVar>();
        ListBuffer<Type> newInferenceVars = new ListBuffer<Type>();
        while (saved_undet.nonEmpty() && this.undetvars.nonEmpty()) {
            Type.UndetVar uv = (Type.UndetVar)this.undetvars.head;
            Type.UndetVar uv_saved = (Type.UndetVar)saved_undet.head;
            if (uv.qtype == uv_saved.qtype) {
                uv_saved.dupTo(uv, this.types);
                this.undetvars = this.undetvars.tail;
                saved_undet = saved_undet.tail;
                newUndetVars.add(uv);
                newInferenceVars.add(uv.qtype);
                continue;
            }
            this.undetvars = this.undetvars.tail;
        }
        this.undetvars = newUndetVars.toList();
        this.inferencevars = newInferenceVars.toList();
    }

    void dupTo(InferenceContext that) {
        this.dupTo(that, false);
    }

    void dupTo(InferenceContext that, boolean clone) {
        that.inferencevars = that.inferencevars.appendList(this.inferencevars.diff(that.inferencevars));
        List<Type> undetsToPropagate = clone ? this.save() : this.undetvars;
        that.undetvars = that.undetvars.appendList(undetsToPropagate.diff(that.undetvars));
        for (Type t : this.inferencevars) {
            that.freeTypeListeners.put(inferenceContext -> this.notifyChange(), List.of(t));
        }
    }

    InferenceContext min(List<Type> roots, boolean shouldSolve, Warner warn) {
        if (roots.length() == this.inferencevars.length()) {
            return this;
        }
        ReachabilityVisitor rv = new ReachabilityVisitor();
        rv.scan(roots);
        if (rv.min.size() == this.inferencevars.length()) {
            return this;
        }
        List<Type> minVars = List.from(rv.min);
        List<Type> redundantVars = this.inferencevars.diff(minVars);
        ListBuffer<Type.UndetVar> minUndetVars = new ListBuffer<Type.UndetVar>();
        for (Type type : minVars) {
            Type.UndetVar uv = (Type.UndetVar)this.asUndetVar(type);
            Assert.check(uv.incorporationActions.isEmpty());
            Type.UndetVar uv2 = uv.dup(this.types);
            for (Type.UndetVar.InferenceBound ib : Type.UndetVar.InferenceBound.values()) {
                List<Type> newBounds = uv.getBounds(ib).stream().filter(b -> !redundantVars.contains(b)).collect(List.collector());
                uv2.setBounds(ib, newBounds);
            }
            minUndetVars.add(uv2);
        }
        InferenceContext minContext = new InferenceContext(this.infer, minVars, minUndetVars.toList());
        for (Type t : minContext.inferencevars) {
            minContext.addFreeTypeListener(List.of(t), inferenceContext -> {
                Type instType = inferenceContext.asInstType(t);
                for (Type eq : rv.minMap.get(t)) {
                    ((Type.UndetVar)this.asUndetVar(eq)).setInst(instType);
                }
                this.infer.doIncorporation(this, warn);
                this.notifyChange();
            });
        }
        if (shouldSolve) {
            List<Type> list = redundantVars.diff(List.from(rv.equiv));
            minContext.addFreeTypeListener(minVars, inferenceContext -> {
                this.solve(unreachableVars, warn);
                this.notifyChange();
            });
        }
        return minContext;
    }

    private void solve(Infer.GraphStrategy ss, Warner warn) {
        Infer infer = this.infer;
        Objects.requireNonNull(infer);
        Infer.GraphSolver s = infer.new Infer.GraphSolver(this, warn);
        s.solve(ss);
    }

    public void solve(Warner warn) {
        this.solve(new Infer.LeafSolver(this.infer){

            @Override
            public boolean done() {
                return InferenceContext.this.restvars().isEmpty();
            }
        }, warn);
    }

    public void solve(final List<Type> vars, Warner warn) {
        Infer infer = this.infer;
        Objects.requireNonNull(infer);
        this.solve(new Infer.BestLeafSolver(infer, vars){
            {
                Infer infer = x0;
                Objects.requireNonNull(infer);
                super(varsToSolve);
            }

            @Override
            public boolean done() {
                return !InferenceContext.this.free(InferenceContext.this.asInstTypes(vars));
            }
        }, warn);
    }

    public void solveAny(List<Type> varsToSolve, Warner warn) {
        Infer infer = this.infer;
        Objects.requireNonNull(infer);
        this.solve(new Infer.BestLeafSolver(infer, varsToSolve.intersect(this.restvars())){
            {
                Infer infer = x0;
                Objects.requireNonNull(infer);
                super(varsToSolve);
            }

            @Override
            public boolean done() {
                return InferenceContext.this.instvars().intersect(this.varsToSolve).nonEmpty();
            }
        }, warn);
    }

    private List<Type> solveBasic(EnumSet<Infer.InferenceStep> steps) {
        return this.solveBasic(this.inferencevars, steps);
    }

    List<Type> solveBasic(List<Type> varsToSolve, EnumSet<Infer.InferenceStep> steps) {
        ListBuffer<Type> solvedVars = new ListBuffer<Type>();
        block0: for (Type t : varsToSolve.intersect(this.restvars())) {
            Type.UndetVar uv = (Type.UndetVar)this.asUndetVar(t);
            for (Infer.InferenceStep step : steps) {
                if (!step.accepts(uv, this)) continue;
                uv.setInst(step.solve(uv, this));
                solvedVars.add(uv.qtype);
                continue block0;
            }
        }
        return solvedVars.toList();
    }

    public void solveLegacy(boolean partial, Warner warn, EnumSet<Infer.InferenceStep> steps) {
        block0: while (true) {
            List<Type> solvedVars = this.solveBasic(steps);
            if (this.restvars().isEmpty() || partial) break;
            if (solvedVars.isEmpty()) {
                this.infer.instantiateAsUninferredVars(this.restvars(), this);
                break;
            }
            Iterator<Type> iterator = this.undetvars.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Type t = iterator.next();
                Type.UndetVar uv = (Type.UndetVar)t;
                uv.substBounds(solvedVars, this.asInstTypes(solvedVars), this.types);
            }
            break;
        }
        this.infer.doIncorporation(this, warn);
    }

    public String toString() {
        return "Inference vars: " + this.inferencevars + '\n' + "Undet vars: " + this.undetvars;
    }

    Type cachedCapture(JCTree tree, Type t, boolean readOnly) {
        Type captured = this.captureTypeCache.get(tree);
        if (captured != null) {
            return captured;
        }
        Type result = this.types.capture(t);
        if (result != t && !readOnly) {
            this.captureTypeCache.put(tree, result);
        }
        return result;
    }

    class ReachabilityVisitor
    extends Types.UnaryVisitor<Void> {
        Set<Type> equiv = new LinkedHashSet<Type>();
        Set<Type> min = new LinkedHashSet<Type>();
        Map<Type, Set<Type>> minMap = new LinkedHashMap<Type, Set<Type>>();

        ReachabilityVisitor() {
        }

        void scan(List<Type> roots) {
            roots.stream().forEach(this::visit);
        }

        @Override
        public Void visitType(Type t, Void _unused) {
            return null;
        }

        @Override
        public Void visitUndetVar(Type.UndetVar t, Void _unused) {
            if (this.min.add(t.qtype)) {
                Set deps = this.minMap.getOrDefault(t.qtype, new LinkedHashSet<Type>(Collections.singleton(t.qtype)));
                for (Type.UndetVar.InferenceBound boundKind : Type.UndetVar.InferenceBound.values()) {
                    for (Type b : t.getBounds(boundKind)) {
                        Type undet = InferenceContext.this.asUndetVar(b);
                        if (!undet.hasTag(TypeTag.UNDETVAR)) {
                            this.visit(undet);
                            continue;
                        }
                        if (this.isEquiv(t, b, boundKind)) {
                            deps.add(b);
                            this.equiv.add(b);
                            continue;
                        }
                        this.visit(undet);
                    }
                }
                this.minMap.put(t.qtype, deps);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType t, Void _unused) {
            return (Void)this.visit(t.type);
        }

        @Override
        public Void visitTypeVar(Type.TypeVar t, Void aVoid) {
            Type undet = InferenceContext.this.asUndetVar(t);
            if (undet.hasTag(TypeTag.UNDETVAR)) {
                this.visitUndetVar((Type.UndetVar)undet, null);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType t, Void _unused) {
            return (Void)this.visit(t.elemtype);
        }

        @Override
        public Void visitClassType(Type.ClassType t, Void _unused) {
            this.visit(t.getEnclosingType());
            for (Type targ : t.getTypeArguments()) {
                this.visit(targ);
            }
            return null;
        }

        boolean isEquiv(Type.UndetVar from, Type t, Type.UndetVar.InferenceBound boundKind) {
            Type.UndetVar uv = (Type.UndetVar)InferenceContext.this.asUndetVar(t);
            for (Type.UndetVar.InferenceBound ib : Type.UndetVar.InferenceBound.values()) {
                List<Type> b1 = from.getBounds(ib);
                if (ib == boundKind) {
                    b1 = b1.diff(List.of(t));
                }
                List<Type> b2 = uv.getBounds(ib);
                if (ib == boundKind.complement()) {
                    b2 = b2.diff(List.of(from.qtype));
                }
                if (b1.containsAll(b2) && b2.containsAll(b1)) continue;
                return false;
            }
            return true;
        }
    }
}

