/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryCategory;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryDefinition;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryRepository;

public final class OQLSupport {
    private static final String SAVED_OQL_QUERIES_FILENAME = "oqlqueries";
    private static final String SNAPSHOT_VERSION = "oqlqueries_version_1";
    private static final String PROP_QUERY_NAME_KEY = "query-name";
    private static final String PROP_QUERY_DESCR_KEY = "query-descr";
    private static final String PROP_QUERY_SCRIPT_KEY = "query-script";

    public static OQLTreeModel createModel() {
        return new OQLTreeModel();
    }

    public static void loadModel(OQLTreeModel model) {
        RootNode root = (RootNode)model.getRoot();
        try {
            Properties p = new Properties();
            ProfilerStorage.loadGlobalProperties((Properties)p, (String)SAVED_OQL_QUERIES_FILENAME);
            if (!p.isEmpty()) {
                OQLSupport.propertiesToModel(p, model);
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        List categories = OQLQueryRepository.getInstance().listCategories();
        for (OQLQueryCategory category : categories) {
            OQLCategoryNode cnode = new OQLCategoryNode(category);
            root.add(cnode);
            List queries = category.listQueries();
            for (OQLQueryDefinition query : queries) {
                cnode.add(new OQLQueryNode(new Query(query)));
            }
        }
        model.reload();
    }

    public static void saveModel(OQLTreeModel model) {
        Object lock = null;
        try {
            Properties p = OQLSupport.modelToProperties(model);
            if (!p.isEmpty()) {
                ProfilerStorage.saveGlobalProperties((Properties)p, (String)SAVED_OQL_QUERIES_FILENAME);
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private static void propertiesToModel(Properties properties, OQLTreeModel model) {
        OQLCategoryNode custom = model.customCategory;
        int i = -1;
        while (properties.containsKey("query-name-" + ++i)) {
            String name = properties.getProperty("query-name-" + i).trim();
            String description = properties.getProperty("query-descr-" + i, "").trim();
            String script = properties.getProperty("query-script-" + i, "").trim();
            if (name == null || script == null) continue;
            custom.add(new OQLQueryNode(new Query(script, name, description)));
        }
    }

    private static Properties modelToProperties(OQLTreeModel model) {
        Properties properties = new Properties();
        if (model.hasCustomQueries()) {
            int i = -1;
            Enumeration<TreeNode> queries = model.customCategory.children();
            while (queries.hasMoreElements()) {
                Query q = (Query)((OQLQueryNode)queries.nextElement()).getUserObject();
                properties.put("query-name-" + ++i, q.getName().trim());
                properties.put("query-script-" + i, q.getScript().trim());
                if (q.getDescription() == null) continue;
                properties.put("query-descr-" + i, q.getDescription().trim());
            }
        }
        return properties;
    }

    public static final class Query {
        private String script;
        private String name;
        private String description;

        public Query(OQLQueryDefinition qdef) {
            this(qdef.getContent(), qdef.getName(), qdef.getDescription());
        }

        public Query(String script, String name, String description) {
            this.setScript(script);
            this.setName(name);
            this.setDescription(description);
        }

        public void setScript(String script) {
            if (script == null) {
                throw new IllegalArgumentException("Script cannot be null");
            }
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }

        public void setName(String name) {
            this.name = Query.normalizeString(name);
            if (this.name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = Query.normalizeString(description);
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private static String normalizeString(String string) {
            String normalizedString = null;
            if (string != null && (normalizedString = string.trim()).length() == 0) {
                normalizedString = null;
            }
            return normalizedString;
        }
    }

    private static class NoCustomQueriesNode
    extends SpecialNode {
        private NoCustomQueriesNode() {
        }

        @Override
        public String toString() {
            return Bundle.OQLSupport_NoCustomQueryName();
        }

        @Override
        public String getDescription() {
            return Bundle.OQLSupport_NoCustomQueryDescr();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private static class RootNode
    extends SpecialNode {
        private RootNode() {
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class OQLQueryNode
    extends OQLNode<Query> {
        public OQLQueryNode(Query query) {
            super(query);
        }

        @Override
        public boolean supportsOpen() {
            return true;
        }

        @Override
        public boolean supportsDelete() {
            return this.isCustomQuery();
        }

        @Override
        public boolean isReadOnly() {
            return !this.isCustomQuery();
        }

        @Override
        public String toString() {
            return ((Query)this.getUserObject()).getName();
        }

        @Override
        public String getCaption() {
            return Bundle.OQLSupport_QueryCaption();
        }

        @Override
        public String getDescription() {
            return ((Query)this.getUserObject()).getDescription();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        private boolean isCustomQuery() {
            return this.getParent() instanceof CustomCategoryNode;
        }
    }

    private static class CustomCategoryNode
    extends OQLCategoryNode {
        private CustomCategoryNode() {
            super(null);
        }

        @Override
        public String toString() {
            return Bundle.OQLSupport_CustomCategoryName();
        }

        @Override
        public String getDescription() {
            return Bundle.OQLSupport_CustomCategoryDescr();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class OQLCategoryNode
    extends OQLNode<OQLQueryCategory> {
        private final NoCustomQueriesNode noQueries = new NoCustomQueriesNode();

        public OQLCategoryNode(OQLQueryCategory category) {
            super(category);
            super.insert(this.noQueries, 0);
        }

        @Override
        public String toString() {
            return ((OQLQueryCategory)this.getUserObject()).getName();
        }

        @Override
        public String getCaption() {
            return Bundle.OQLSupport_CategoryCaption();
        }

        @Override
        public String getDescription() {
            return ((OQLQueryCategory)this.getUserObject()).getDescription();
        }

        @Override
        public boolean supportsProperties() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            if (this.isNodeChild(this.noQueries)) {
                super.remove(0);
            }
        }

        @Override
        public void remove(int childIndex) {
            super.remove(childIndex);
            if (this.getChildCount() == 0) {
                super.insert(this.noQueries, 0);
            }
        }
    }

    private static abstract class SpecialNode
    extends OQLNode<Object> {
        public SpecialNode() {
            super(null);
        }

        @Override
        public boolean supportsProperties() {
            return false;
        }
    }

    public static abstract class OQLNode<T>
    extends DefaultMutableTreeNode {
        public OQLNode(T userObject) {
            super(userObject);
        }

        public final T getUserObject() {
            return (T)super.getUserObject();
        }

        public String getDescription() {
            return null;
        }

        public String getCaption() {
            return "";
        }

        public boolean supportsProperties() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        public boolean supportsDelete() {
            return false;
        }

        public boolean supportsOpen() {
            return false;
        }
    }

    public static final class OQLTreeModel
    extends DefaultTreeModel {
        private final OQLCategoryNode customCategory = new CustomCategoryNode();

        public OQLTreeModel() {
            super(new RootNode());
            this.root().add(this.customCategory);
        }

        public boolean hasCustomQueries() {
            return this.customCategory.getChildCount() > 1 || !(this.customCategory.getChildAt(0) instanceof NoCustomQueriesNode);
        }

        public boolean hasDefinedCategories() {
            return this.root.getChildCount() > 1 || !(this.root.getChildAt(0) instanceof CustomCategoryNode);
        }

        public OQLCategoryNode customCategory() {
            return this.customCategory;
        }

        private OQLNode root() {
            return (OQLNode)this.root;
        }
    }
}

